/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;

public class CheckDecomposeUtils {
    public static CheckDecomposeUtils get() {
        return new CheckDecomposeUtils();
    }

    public boolean checkParent(Long modelId, Long dimensionId, Long viewId, Set<Long> memberIds) {
        Object[] memberArray;
        SqlBuilder sql;
        block35: {
            if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || IDUtils.isNull((Long)viewId) || CollectionUtils.isEmpty(memberIds)) {
                return false;
            }
            sql = new SqlBuilder();
            sql.append("select fid, fsource from t_eb_dimensionview where fid = ?", new Object[]{viewId});
            memberArray = memberIds.toArray();
            sql = new SqlBuilder();
            sql.append("select fmemberid, fnumber from t_eb_viewmember where fmodelid = ? and fdimensionid = ? and fviewid = ? and ", new Object[]{modelId, dimensionId, viewId}).appendIn("fmemberid", memberArray);
            try (DataSet ds = DB.queryDataSet((String)"queryMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds == null) break block35;
                for (Object row : ds) {
                    String number = row.getString("fnumber");
                    if (number == null || !number.endsWith("._inv")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        sql = new SqlBuilder();
        sql.append("select fmemberid, fnumber, fparentid from t_eb_viewmember where fmodelid = ? and fdimensionid = ? and fviewid = ?", new Object[]{modelId, dimensionId, viewId});
        sql.append(" and fparentid in (select fparentid from t_eb_viewmember where fmodelid = ? and fdimensionid = ? and fviewid = ? and ", new Object[]{modelId, dimensionId, viewId});
        sql.appendIn("fmemberid", memberArray).append(")", new Object[0]);
        LinkedHashMap childrenMap = Maps.newLinkedHashMap();
        DataSet ds = DB.queryDataSet((String)"queryMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Iterator iterator = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    Map children = childrenMap.computeIfAbsent(row.getLong("fparentid"), f -> Maps.newLinkedHashMap());
                    children.put(row.getLong(0), row.getString(1));
                }
            }
        }
        catch (Throwable row) {
            iterator = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)((Object)iterator)).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!childrenMap.isEmpty()) {
            childrenMap.values().forEach(_children -> memberIds.forEach(_children::remove));
            HashSet hasCosmic = Sets.newHashSetWithExpectedSize((int)childrenMap.size());
            for (Map.Entry entry : childrenMap.entrySet()) {
                HashSet removes = new HashSet(((Map)entry.getValue()).size());
                for (Map.Entry child : ((Map)entry.getValue()).entrySet()) {
                    if (child.getValue() == null || !((String)child.getValue()).endsWith("._inv")) continue;
                    removes.add(child.getKey());
                    hasCosmic.add(entry.getKey());
                }
                if (removes.isEmpty()) continue;
                removes.forEach(_id -> {
                    String cfr_ignored_0 = (String)((Map)entry.getValue()).remove(_id);
                });
            }
            for (Map.Entry entry : childrenMap.entrySet()) {
                if (!hasCosmic.contains(entry.getKey()) || !((Map)entry.getValue()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

