/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;

public class CheckOffsetUtils {
    public static CheckOffsetUtils get() {
        return new CheckOffsetUtils();
    }

    public boolean checkParent(Long modelId, Long dimensionId, Set<Long> memberIds) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || memberIds == null || memberIds.isEmpty()) {
            return false;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_structofent where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
        sql.append(" and fid in (select fparentid from t_eb_structofent where fmodelid = ? and fdimensionid = ? and ", new Object[]{modelId, dimensionId}).appendIn("fid", memberIds.toArray());
        sql.append(") and fmergernode = '1'", new Object[0]);
        LinkedHashSet parentIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryParnet", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Object row : ds) {
                    parentIds.add(row.getLong("fid"));
                }
            }
        }
        if (!parentIds.isEmpty()) {
            Object row;
            sql = new SqlBuilder();
            sql.append("select fid, fparentid from t_eb_structofent where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
            sql.append(" and ", new Object[0]).appendIn("fparentid", parentIds.toArray());
            sql.append(" and fisoffsetentry = '0'", new Object[0]);
            LinkedHashMap childrenMap = Maps.newLinkedHashMap();
            DataSet ds = DB.queryDataSet((String)"queryChildren", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            row = null;
            try {
                if (ds != null) {
                    for (Row row2 : ds) {
                        Set childrenIds = childrenMap.computeIfAbsent(row2.getLong("fparentid"), f -> Sets.newLinkedHashSet());
                        childrenIds.add(row2.getLong("fid"));
                    }
                }
            }
            catch (Throwable throwable) {
                row = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (row != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)row).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            childrenMap.values().forEach(_children -> _children.removeAll(memberIds));
            for (Set _children2 : childrenMap.values()) {
                if (!_children2.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

