/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteShrekDataCheck;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.formplugin.dimension.utils.CheckAdjustUtils;
import kd.epm.eb.formplugin.dimension.utils.CheckApplyUtils;
import kd.epm.eb.formplugin.dimension.utils.CheckControlUtils;
import kd.epm.eb.formplugin.dimension.utils.CheckMemberDisableUtils;

public class MemberCheckUtils {
    private static final Log log = LogFactory.getLog(MemberCheckUtils.class);

    public static MemberCheckUtils get() {
        return new MemberCheckUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIsLeaf(Long modelId, Long dimensionId, Long viewId, Set<Long> memberIds) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || memberIds == null || memberIds.isEmpty()) {
            return true;
        }
        LogStats stats = new LogStats("member-log:");
        stats.addInfo("begin-checkIsLeaf.");
        try {
            boolean bl = this.$checkIsLeaf(modelId, dimensionId, viewId, memberIds, stats);
            return bl;
        }
        finally {
            stats.add("end-checkIsLeaf.");
            log.info(stats.toString());
        }
    }

    private boolean $checkIsLeaf(Long modelId, Long dimensionId, Long viewId, Set<Long> memberIds, LogStats stats) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || memberIds == null || memberIds.isEmpty()) {
            return true;
        }
        Object[] destIdsAry = memberIds.toArray();
        HashSet<Long> busModelIds = new HashSet<Long>(BusinessModelServiceHelper.getInstance().getBusModelIdsByViewId(viewId));
        Set<Long> datasetIds = Collections.emptySet();
        if (CollectionUtils.isNotEmpty(busModelIds)) {
            datasetIds = new HashSet(DatasetServiceHelper.getDataSetIdByBusModelIds(busModelIds));
        }
        boolean re = CheckMemberDisableUtils.get().checkDisableMember(modelId, dimensionId, destIdsAry);
        stats.add("end-check-disable.");
        if (re) {
            return false;
        }
        CheckQuote checkQuote = new CheckQuote(modelId, dimensionId, viewId, memberIds, MemberTypeEnum.MEMBER);
        checkQuote.setBusModelIds(busModelIds);
        Set checkMemberIds = QuoteShrekDataCheck.get().checkQuote(checkQuote);
        re = checkMemberIds != null && !checkMemberIds.isEmpty();
        stats.add("end-check-quote.");
        if (re) {
            return false;
        }
        re = CheckAdjustUtils.get().checkAdjustBill(modelId, busModelIds, destIdsAry);
        stats.add("end-check-adjustBill.");
        if (re) {
            return false;
        }
        re = CheckApplyUtils.get().checkApplyTemplate(modelId, dimensionId, datasetIds, destIdsAry);
        stats.add("end-check-applyTemplate.");
        if (re) {
            return false;
        }
        CheckControlUtils controlUtils = CheckControlUtils.get();
        re = controlUtils.checkControlMapping(modelId, busModelIds, destIdsAry);
        stats.add("end-check-controlMapping.");
        if (re) {
            return false;
        }
        re = controlUtils.checkControlRecord(modelId, busModelIds, destIdsAry);
        stats.add("end-check-controlRecord.");
        return !re;
    }

    public boolean checkIsAllLeaf(Long modelId, Long dimensionId, Long viewId, Set<Long> memberIds) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId) || memberIds == null || memberIds.isEmpty()) {
            return false;
        }
        DynamicObject view = null;
        if (IDUtils.isNotNull((Long)viewId)) {
            view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview");
        }
        SqlBuilder sql = new SqlBuilder();
        HashSet leafIds = Sets.newHashSetWithExpectedSize((int)memberIds.size());
        if (view == null) {
            sql.append("select fid from t_eb_structofent where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
            sql.append(" and ", new Object[0]).appendIn("fid", memberIds.toArray());
            sql.append(" and fisleaf = '1'", new Object[0]);
        } else {
            sql.append("select fmemberid as fid from t_eb_viewmember where fmodelid = ? and fdimensionid = ? and fviewId = ?", new Object[]{modelId, dimensionId, viewId});
            sql.append(" and ", new Object[0]).appendIn("fmemberid", memberIds.toArray());
            sql.append(" and fisleaf = '1'", new Object[0]);
        }
        try (DataSet ds = DB.queryDataSet((String)"queryLeafMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    leafIds.add(row.getLong("fid"));
                }
            }
        }
        if (!leafIds.isEmpty()) {
            sql = new SqlBuilder();
            if (view == null) {
                sql.append("select top 1 fmemberid from t_eb_viewmember where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
                sql.append(" and fviewid in (select fid from t_eb_dimensionview where fmodelid = ? and fdimensionid = ? and fparentid = 0)", new Object[]{modelId, dimensionId});
                sql.append(" and ", new Object[0]).appendIn("fmemberid", leafIds.toArray());
                sql.append(" and fisleaf = '1'", new Object[0]);
            } else {
                sql.append("select top 1 fid from t_eb_structofent where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
                sql.append(" and ", new Object[0]).appendIn("fid", leafIds.toArray());
                sql.append(" and fisleaf = '1'", new Object[0]);
            }
            ds = DB.queryDataSet((String)"queryLeafMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var9_9 = null;
            try {
                if (ds != null && ds.hasNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var9_9 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return false;
    }
}

