/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class AppScenarioListPlugin
extends MainSubAbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TOOLBARAP = "toolbarap";
    private static final String MODEL = "model";
    private static final String ADD_CLOSECALLBACK = "add_closecallback";
    private static final String BILLLIST = "billlistap";
    private static final Set<String> PRESET_NUMBER = new HashSet<String>(Arrays.asList("001", "002", "Target_sys"));

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit dataEdit = (BasedataEdit)this.getView().getControl(MODEL);
        dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addHyperClickListener(this::hyperClick);
    }

    protected void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getqFilter());
    }

    protected QFilter getqFilter() {
        Long modelIdLong = 0L;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(MODEL))) {
            modelIdLong = this.getModelId();
        }
        return new QFilter(MODEL, "=", (Object)modelIdLong);
    }

    public void hyperClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        BillList billList = (BillList)e.getSource();
        long id = (Long)billList.getFocusRowPkId();
        this.hyperLink(String.valueOf(id));
    }

    public void hyperLink(String id) {
        boolean exists = QueryServiceHelper.exists((String)"eb_applicationscenario", (Object)id);
        if (exists) {
            this.openAddPage(id);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AppScenarioListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AppScenarioListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshBillList();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("add".equals(key)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"AppScenarioListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openAddPage(null);
        } else if ("delete".equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection lists = billList.getSelectedRows();
            if (lists == null || lists.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AppScenarioListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Set collect = lists.stream().map(m -> m.getNumber()).collect(Collectors.toSet());
            collect.retainAll(PRESET_NUMBER);
            if (collect.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AppScenarioListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u5e94\u7528\u573a\u666f\uff1f", (String)"AppScenarioListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
        } else if ("refresh".equals(key)) {
            this.refreshBillList();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        if ("delete_comfirm".equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && this.deleteValidate()) {
            return;
        }
        super.confirmCallBack(messageBoxClosedEvent);
        if ("delete_comfirm".equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.delete();
        }
    }

    private boolean deleteValidate() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection lists = billList.getSelectedRows();
        HashSet<Long> ids = new HashSet<Long>(lists.size());
        for (ListSelectedRow list : lists) {
            Long id = (Long)list.getPrimaryKeyValue();
            ids.add(id);
        }
        ids.removeAll(this.getQutoIds());
        int afterSize = ids.size();
        if (afterSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5e94\u7528\u573a\u666f\u5df2\u88ab\u5f15\u7528\u3002", (String)"AppScenarioListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void delete() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection lists = billList.getSelectedRows();
        HashSet<Long> ids = new HashSet<Long>(lists.size());
        for (ListSelectedRow list : lists) {
            Long id = (Long)list.getPrimaryKeyValue();
            ids.add(id);
        }
        int beforeSize = ids.size();
        ids.removeAll(this.getQutoIds());
        int afterSize = ids.size();
        try {
            DeleteServiceHelper.delete((String)"eb_applicationscenario", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (beforeSize != afterSize) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002\u5df2\u8df3\u8fc7\u88ab\u5f15\u7528\u7684\u5e94\u7528\u573a\u666f\u3002", (String)"AppScenarioListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AppScenarioListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5e94\u7528\u573a\u666f\u5220\u9664", "AppScenarioListPlugin_91", "epm-eb-formplugin");
            this.writeLog(null, "delete", opName, null, null);
        }
        catch (Exception e) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5e94\u7528\u573a\u666f\u5220\u9664", "AppScenarioListPlugin_91", "epm-eb-formplugin");
            this.writeLog(null, "delete", opName, null, null, false);
            throw new KDBizException(e.getMessage());
        }
        this.refreshBillList();
    }

    private Set<Long> getQutoIds() {
        HashSet<Long> quotIds = new HashSet<Long>();
        QFilter modelQf = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection bizModel = QueryServiceHelper.query((String)"epm_datatypemembertree", (String)"bizmodel", (QFilter[])modelQf.toArray());
        for (DynamicObject dynamicObject : bizModel) {
            quotIds.add(dynamicObject.getLong("bizmodel"));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"scenarioentry.appscenario", (QFilter[])new QFilter[]{modelQf});
        if (dynamicObjects.size() == 0) {
            return quotIds;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            quotIds.add(dynamicObject.getLong("scenarioentry.appscenario"));
        }
        return quotIds;
    }

    private void openAddPage(String id) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_applicationscenario");
        showParameter.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u573a\u666f", (String)"AppScenarioListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ADD_CLOSECALLBACK.equals(key)) {
            this.refreshBillList();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key) && this.getControl(MODEL) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
        }
    }
}

