/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BizModelSelectPlugin
extends AbstractFormPlugin {
    private static final String PRE = "pre";
    private static final String NEXT = "next";
    private static final String rowlist = "rowlist";
    private static final String rowseq = "rowseq";
    private static final String MODEL = "model";
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PRE, NEXT});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                DynamicObjectCollection dynamicObjects = BizModelSelectPlugin.this.getModel().getEntryEntity(BizModelSelectPlugin.ENTRYENTITY);
                if (dynamicObjects == null || dynamicObjects.size() == 0) {
                    BizModelSelectPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"BizModelSelectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    BizModelSelectPlugin.this.Search(var1.getText().toLowerCase().trim(), dynamicObjects);
                } else {
                    BizModelSelectPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"BizModelSelectPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"type"});
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"BizModelSelectPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(MODEL, modelId);
        this.getModel().setValue(MODEL, (Object)modelId);
        this.refreshEntity(modelId);
    }

    private void refreshEntity(String modelId) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        String appNumber = (String)this.getView().getFormShowParameter().getCustomParam("appNumber");
        String selects = "id,number,issyspreset,scenarioentry.appscenario.number,scenarioentry.appscenario.name";
        QFilter modelQf = new QFilter(MODEL, "=", (Object)IDUtils.toLong((Object)modelId));
        if ("targetSchemeBizmodelSelect".equals(appNumber)) {
            QFilter qFilter = new QFilter("scenarioentry.appscenario.number", "=", (Object)"Target_sys");
            modelQf.and(qFilter);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)selects, (QFilter[])new QFilter[]{modelQf});
            ArrayList<Long> bizIds = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                bizIds.add(dynamicObject.getLong("id"));
            }
            modelQf = new QFilter("id", "in", bizIds).and(MODEL, "=", (Object)IDUtils.toLong((Object)modelId));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)selects, (QFilter[])new QFilter[]{modelQf});
        Map<String, DynamicObject> toMap = dynamicObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e, (v1, v2) -> v1));
        Map bizCtrlGroupMap = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString("number"), LinkedHashMap::new, Collectors.toList()));
        if (!CollectionUtils.isEmpty((Map)bizCtrlGroupMap)) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, bizCtrlGroupMap.size());
            int index = 0;
            for (Map.Entry entry : bizCtrlGroupMap.entrySet()) {
                DynamicObject obj = toMap.get(entry.getKey());
                int row = rows[index];
                this.getModel().setValue("number", (Object)obj.getString("number"), row);
                this.getModel().setValue("businessmodel", (Object)obj.getString("id"), row);
                this.getModel().setValue("type", (Object)obj.getString("issyspreset"), row);
                String appscenariotext = ((List)entry.getValue()).stream().map(e -> e.getString("scenarioentry.appscenario.name")).distinct().collect(Collectors.joining(","));
                this.getModel().setValue("appscenariotext", (Object)appscenariotext, row);
                ++index;
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("confirm".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BizModelSelectPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            int row = rows[0];
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("businessmodel", row);
            String id = dynamicObject.getString("id");
            this.getView().returnDataToParent((Object)id);
            this.getView().close();
        }
    }

    private void Search(String text, DynamicObjectCollection dynamicObjects) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject == null || !dynamicObject.getString("number").toLowerCase().contains(text) && !dynamicObject.getString("businessmodel.name").toLowerCase().contains(text)) continue;
            map.put(dynamicObject.getInt("seq") - 1, dynamicObject.getString("businessmodel.id"));
        }
        if (map.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"BizModelSelectPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            entryGrid.selectRows(0);
            return;
        }
        ArrayList rowList = new ArrayList(map.values());
        this.getPageCache().put(rowlist, SerializationUtils.toJsonString(rowList));
        String focusID = (String)rowList.get(0);
        int focusrow = 0;
        this.getPageCache().put(rowseq, "0");
        for (Map.Entry entryset : map.entrySet()) {
            if (!focusID.equals(entryset.getValue())) continue;
            focusrow = (Integer)entryset.getKey();
            break;
        }
        entryGrid.selectRows(focusrow);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRE.equals(key) || NEXT.equals(key)) {
            this.searchPreOrNext(key);
        }
    }

    private void searchPreOrNext(String actionId) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        String rowcache = this.getPageCache().get(rowlist);
        if (rowcache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u76f8\u5173\u5185\u5bb9", (String)"BizModelSelectPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
        int rowSeq = Integer.parseInt(this.getPageCache().get(rowseq));
        if (PRE.equals(actionId)) {
            if (0 == rowSeq) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"BizModelSelectPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(rowseq, String.valueOf(--rowSeq));
            String focusID = (String)rowList.get(rowSeq);
            int focusRow = this.getRowIndex(focusID);
            entryGrid.selectRows(focusRow);
        } else {
            if (rowList.size() - 1 == rowSeq) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"BizModelSelectPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(rowseq, String.valueOf(++rowSeq));
            String focusID = (String)rowList.get(rowSeq);
            int focusRow = this.getRowIndex(focusID);
            entryGrid.selectRows(focusRow);
        }
    }

    private int getRowIndex(String id) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        int i = -1;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!id.equals(dynamicObject.getString("businessmodel.id"))) continue;
            i = dynamicObject.getInt("seq") - 1;
            break;
        }
        return i;
    }
}

