/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.DataSetPresetDimEnum;
import kd.epm.eb.common.enums.DimensionViewGroupEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BusinessModelEditPlugin
extends MainSubAbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String TOOLBARAP = "toolbarap";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String APP_SCENARIOTEXT = "appscenariotext";
    private static final String VIEW_ENTRY = "entryentity";
    private static final String SCENARIO_ENTRY = "entryentity1";
    private static final String APPSCENARIOT = "appscenario";
    private static final String DIMENSION = "dimension";
    private static final String VIEW = "view";
    private static final String ADD = "btn_adddim";
    private static final String DEL = "btn_deldim";
    private static final String NUMBERLIST = "numberlist";
    private static final String CONFIRM = "btn_confirm";
    private static final String ADD_CLOSECALLBACK = "add_appScenario";
    private static final String SELECT_DIM = "select_dim";
    private static final String VIEW_GROUP = "viewgroup";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getView().getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getView().getControl(DIMENSION);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit viewGroup = (BasedataEdit)this.getView().getControl(VIEW_GROUP);
        viewGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP, TOOLBARAP});
        TextEdit appscenariotext = (TextEdit)this.getControl(APP_SCENARIOTEXT);
        appscenariotext.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)modelId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ADD, DEL, APP_SCENARIOTEXT});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4f53\u7cfb\u5931\u8d25", (String)"BusinessModelEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getPageCache().put(MODEL, modelId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW});
        List<String> numbers = this.getAllDimNumber(modelId);
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id)) {
            DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_businessmodel");
            if (bizModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BusinessModelEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("id", id);
            this.setPageValue(bizModel, id);
        } else {
            List presetDims = DataSetPresetDimEnum.getAllNumber();
            Map<String, String> dimMap = this.queryDimIdByNumber(modelId, presetDims);
            this.setEntity(dimMap);
        }
        this.getPageCache().put(NUMBERLIST, SerializationUtils.toJsonString(numbers));
    }

    private void setEntity(Map<String, String> dimMap) {
        this.getModel().deleteEntryData(VIEW_ENTRY);
        if (dimMap.size() == 0) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(VIEW_ENTRY, dimMap.size());
        int index = 0;
        Map<String, Long> presetViewGroup = this.getPresetViewGroup();
        for (Map.Entry<String, String> entry : dimMap.entrySet()) {
            this.getView().setEnable(Boolean.valueOf(false), rows[index], new String[]{DIMENSION});
            String dimId = entry.getValue();
            this.getModel().setValue(DIMENSION, (Object)dimId, rows[index]);
            String dimNumber = entry.getKey();
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) || SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                if (presetViewGroup.containsKey(dimId)) {
                    this.getModel().setValue(VIEW_GROUP, (Object)presetViewGroup.get(dimId), rows[index]);
                }
            } else if (View.NoViewDimNums.contains(dimNumber)) {
                this.getView().setEnable(Boolean.valueOf(false), rows[index], new String[]{VIEW_GROUP});
            }
            ++index;
        }
    }

    private Map<String, Long> getPresetViewGroup() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter qFilter1 = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{DimensionViewGroupEnum.ENTITY_VIEW_GROUP.getNumber(), DimensionViewGroupEnum.CT_VIEW_GROUP.getNumber(), DimensionViewGroupEnum.INTERNAL_COMPANY_VIEW_GROUP.getNumber()}));
        HashMap<String, Long> presetViewMap = new HashMap<String, Long>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id,dimension", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long dimension = dynamicObject.getLong(DIMENSION);
                presetViewMap.put(IDUtils.toString((Object)dimension), dynamicObject.getLong("id"));
            }
        }
        return presetViewMap;
    }

    private Map<String, String> queryDimIdByNumber(String modelId, List<String> numbers) {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)Long.parseLong(modelId));
        QFilter qFilter1 = new QFilter("number", "in", numbers);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"dseq asc");
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getString("number"), dynamicObject.getString("id"));
        }
        return map;
    }

    private void setPageValue(DynamicObject bizModel, String id) {
        DynamicObjectCollection scenarioentry;
        List datasetIds;
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        IDataModel dataModel = this.getModel();
        dataModel.setValue("number", (Object)bizModel.getString("number"));
        dataModel.setValue("name", bizModel.get("name"));
        DynamicObjectCollection dynamicObjects = bizModel.getDynamicObjectCollection("viewentry");
        boolean quto = false;
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id) && (datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(Long.valueOf(id))) != null && datasetIds.size() > 0) {
            quto = true;
        }
        if (dynamicObjects.size() > 0) {
            int[] rows = dataModel.batchCreateNewEntryRow(VIEW_ENTRY, dynamicObjects.size());
            int index = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                int row = rows[index];
                dataModel.setValue(DIMENSION, (Object)dynamicObject.getString("dimension.id"), row);
                if (quto) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{VIEW_GROUP});
                } else if (View.NoViewDimNums.contains(dynamicObject.getString("dimension.number"))) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{VIEW_GROUP});
                }
                dataModel.setValue(VIEW_GROUP, (Object)dynamicObject.getString("viewgroup.id"), row);
                ++index;
            }
        }
        if ((scenarioentry = bizModel.getDynamicObjectCollection("scenarioentry")).size() > 0) {
            LinkedHashSet<String> sc_names = new LinkedHashSet<String>();
            int[] scRows = dataModel.batchCreateNewEntryRow(SCENARIO_ENTRY, scenarioentry.size());
            int i = 0;
            BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_applicationscenario"));
            for (DynamicObject dynamicObject : scenarioentry) {
                int row = scRows[i];
                dataModel.setValue(APPSCENARIOT, (Object)dynamicObject.getString("appscenario.id"), row);
                if ((DynamicObject)this.getModel().getValue(APPSCENARIOT, row) != null) {
                    sc_names.add(((DynamicObject)this.getModel().getValue(APPSCENARIOT, row)).getString("name"));
                }
                ++i;
            }
            dataModel.setValue(APP_SCENARIOTEXT, (Object)String.join((CharSequence)",", sc_names));
        }
        this.getView().updateView(VIEW_ENTRY);
        this.getView().updateView(SCENARIO_ENTRY);
    }

    private void setEntryLock(boolean isAll) {
        DynamicObjectCollection docs = this.getModel().getEntryEntity(VIEW_ENTRY);
        if (docs == null || docs.size() == 0) {
            return;
        }
        if (isAll) {
            for (DynamicObject doc : docs) {
                int index = doc.getInt("seq") - 1;
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{VIEW_GROUP});
            }
        } else {
            for (DynamicObject doc : docs) {
                if (!View.NoViewDimNums.contains(doc.getString("dimension.number"))) continue;
                int index = doc.getInt("seq") - 1;
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{VIEW_GROUP});
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (ADD.equals(key)) {
            String msg = this.beforeSaveCheck();
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
            } else {
                this.openDimSelect();
            }
        } else if (DEL.equals(key)) {
            List datasetIds;
            EntryGrid entryGrid = (EntryGrid)this.getControl(VIEW_ENTRY);
            int[] rows = entryGrid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BusinessModelEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = this.getPageCache().get("id");
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION, rows[0]);
            if (dimension != null) {
                List list = DataSetPresetDimEnum.getAllNumber();
                if (list.contains(dimension.getString("number"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ef4\u5ea6\u4e0d\u53ef\u5220\u9664\u3002", (String)"BusinessModelEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (id != null) {
                    Long bizModelId = Long.valueOf(this.getPageCache().get("id"));
                    Long dimensionId = dimension.getLong("id");
                    if (BusinessModelServiceHelper.getInstance().queryDimIdByBizModelId(bizModelId, dimensionId)) {
                        Set ids = BusinessModelServiceHelper.getInstance().queryDimIdByBizModelId(bizModelId);
                        if (ids.contains(dimensionId)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u6570\u636e\u96c6\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        CheckQuote checkQuote = QuoteBuilder.build((Long)this.getModelId(), (Long)dimensionId, (Long)dimensionId, (MemberTypeEnum)MemberTypeEnum.DIMENSION);
                        checkQuote.setDatasetId(bizModelId);
                        checkQuote.addExclude(MemberQuoteResourceEnum.BusinessModel);
                        checkQuote.addExclude(MemberQuoteResourceEnum.DimView);
                        QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
                        if (check.isHasQuote()) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DimDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
                            return;
                        }
                        long modelid = (Long)this.getValue(MODEL, "id");
                        QFBuilder qf = new QFBuilder(MODEL, "=", (Object)modelid);
                        qf.add("entryentity.dimensionid", "=", (Object)dimension.getLong("id"));
                        qf.add("businessmodel", "=", (Object)Long.parseLong(id));
                        if (QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])qf.toArrays())) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u63a7\u5236\u7ef4\u5ea6\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelid);
                        qFilter.and("bizmodel", "=", (Object)bizModelId);
                        qFilter.and(DIMENSION, "=", (Object)dimensionId);
                        DynamicObjectCollection parameters = QueryServiceHelper.query((String)VariableTypeEnum.Parameter.getMetadata(), (String)"id", (QFilter[])new QFilter[]{qFilter});
                        Set paramIds = parameters.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        checkQuote = new CheckQuote(this.getModelId(), Long.valueOf(0L), paramIds, VariableTypeEnum.Parameter.getRefMemberType());
                        QuoteCheckResult quoteCheckResult = QuoteCheck.get().checkQuoteResult(checkQuote);
                        if (quoteCheckResult.isHasQuote()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5206\u6790\u62a5\u544a\u6a21\u677f\u4e2d\u7684\u53c2\u6570\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
            boolean quto = false;
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id) && (datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(Long.valueOf(id))) != null && datasetIds.size() > 0) {
                quto = true;
            }
            this.getModel().deleteEntryRow(VIEW_ENTRY, rows[0]);
            this.setEntryLock(quto);
        } else if (CONFIRM.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"BusinessModelEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = (String)this.getModel().getValue("number");
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (!CheckStringsUtil.checkAllowNumStart((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7f16\u7801\uff0c\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u3002", (String)"BusinessModelEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u540d\u79f0\u540e\u91cd\u8bd5\u3002", (String)"BusinessModelEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkNumberExist(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u7f16\u7801\u7684\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BusinessModelEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String msg = this.beforeSaveCheck();
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            this.save();
        }
    }

    private void openDimSelect() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_seldimension");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_DIM);
        List numbers = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(NUMBERLIST), List.class);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(VIEW_ENTRY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject == null || dynamicObject.get(DIMENSION) == null) continue;
            numbers.remove(dynamicObject.getString("dimension.number"));
        }
        QFilter numberQf = new QFilter("number", "in", (Object)numbers);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(numberQf);
        showParameter.setCustomParam("Qflters", (Object)SerializationUtils.serializeToBase64(qFilters));
        showParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u9009\u62e9", (String)"BusinessModelEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private String beforeSaveCheck() {
        String msg = "";
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(VIEW_ENTRY);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u7ef4\u5ea6\u89c6\u56fe\u7ec4\u3002", (String)"BusinessModelEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return msg;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get(DIMENSION) != null) {
                DynamicObject dimension = dynamicObject.getDynamicObject(DIMENSION);
                if (View.NoViewDimNums.contains(dimension.getString("number")) || dynamicObject.get(VIEW_GROUP) != null) continue;
                msg = ResManager.loadResFormat((String)"\u201c%1\u201d\u7ef4\u5ea6\u89c6\u56fe\u7ec4\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"BusinessModelEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getString("name")});
                break;
            }
            msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"BusinessModelEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            break;
        }
        return msg;
    }

    private boolean checkNumberExist(String number) {
        String id = this.getPageCache().get("id");
        QFilter modelQf = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter numberQf = new QFilter("number", "=", (Object)number);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id)) {
            numberQf.and(new QFilter("id", "!=", (Object)Long.valueOf(id)));
        }
        return QueryServiceHelper.exists((String)"eb_businessmodel", (QFilter[])new QFilter[]{modelQf, numberQf});
    }

    private void save() {
        long bizModelId;
        String id = this.getPageCache().get("id");
        DynamicObject bizModel = null;
        IDataModel dataModel = this.getModel();
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)id)) {
            bizModel = BusinessDataServiceHelper.newDynamicObject((String)"eb_businessmodel");
            bizModelId = GlobalIdUtil.genGlobalLongId();
            bizModel.set("id", (Object)bizModelId);
            bizModel.set("issyspreset", (Object)0);
        } else {
            bizModel = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_businessmodel");
            bizModelId = bizModel.getLong("id");
        }
        DynamicObject model = (DynamicObject)dataModel.getValue(MODEL);
        String number = (String)dataModel.getValue("number");
        OrmLocaleValue name = (OrmLocaleValue)dataModel.getValue("name");
        Long userId = UserUtils.getUserId();
        bizModel.set(MODEL, (Object)model.getString("id"));
        bizModel.set("number", (Object)number);
        bizModel.set("name", (Object)name);
        bizModel.set("modifier", (Object)userId);
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)id)) {
            bizModel.set("creater", (Object)userId);
            bizModel.set("createdate", (Object)TimeServiceHelper.now());
        }
        bizModel.set("modifydate", (Object)TimeServiceHelper.now());
        DynamicObjectCollection scenarioentry = bizModel.getDynamicObjectCollection("scenarioentry");
        scenarioentry.clear();
        this.fillAppScenario(scenarioentry);
        bizModel.set("scenarioentry", (Object)scenarioentry);
        DynamicObjectCollection newViewEntry = this.getModel().getEntryEntity(VIEW_ENTRY);
        DynamicObjectCollection viewEntry = bizModel.getDynamicObjectCollection("viewentry");
        Set<Long> changedDimId = this.checkDimViewGroupChangeForMembPerm(viewEntry, newViewEntry);
        viewEntry.clear();
        this.fillDimView(viewEntry, newViewEntry);
        bizModel.set("viewentry", (Object)viewEntry);
        DynamicObject[] dynamicObjects = new DynamicObject[]{bizModel};
        try {
            Map<Long, String> mapScanario = this.getScanarioEntityData(IDUtils.toLong((Object)id));
            Map<Long, List<Object>> mapDim = this.getDimEntityData(IDUtils.toLong((Object)id));
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            this.updateScenarioidSync(mapScanario);
            this.updateDimSync(mapDim);
            this.updateAnalyseRptParameter(id, bizModelId, newViewEntry);
            if (!changedDimId.isEmpty()) {
                Long modelId = model.getLong("id");
                MembPermRecordUtil.delPermRecordByBcrAndDim((Long)modelId, (Long)bizModel.getLong("id"), changedDimId);
                DimMembPermVerHelper.updateVer4refViewChanged((Long)bizModel.getLong("id"), changedDimId, (Long)modelId);
            }
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BusinessModelEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.writeLog(number, "save", new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessModelEditPlugin_13", "epm-eb-formplugin"), null, null);
        }
        catch (Exception e) {
            this.writeLog(number, "save", new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessModelEditPlugin_13", "epm-eb-formplugin"), null, null, false);
            throw new KDBizException(e.getMessage());
        }
        CubeUtils.get().checkBusModel(Long.valueOf(model.getLong("id")), Long.valueOf(bizModel.getLong("id")));
        this.getView().close();
    }

    private void updateAnalyseRptParameter(String id, long bizModelId, DynamicObjectCollection viewEntry) {
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)id)) {
            return;
        }
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        if (!QueryServiceHelper.exists((String)"eb_reportvariabletype", (QFilter[])new QFilter[]{qFilter})) {
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)VariableTypeEnum.Parameter.getMetadata(), (String)DIMENSION, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> dimIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : query) {
            dimIds.add(dynamicObject.getLong(DIMENSION));
        }
        HashSet<Long> curDimIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> toAddParameters = new ArrayList<DynamicObject>(16);
        Long userId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        for (DynamicObject entry : viewEntry) {
            DynamicObject dimension = entry.getDynamicObject(DIMENSION);
            long dimId = dimension.getLong("id");
            curDimIds.add(dimId);
            if (dimIds.contains(dimId)) continue;
            DynamicObject parameter = BusinessDataServiceHelper.newDynamicObject((String)VariableTypeEnum.Parameter.getMetadata());
            parameter.set(DIMENSION, (Object)dimId);
            parameter.set("number", (Object)dimension.getString("number"));
            parameter.set("name", (Object)dimension.getString("name"));
            parameter.set(MODEL, (Object)modelId);
            parameter.set("bizmodel", (Object)bizModelId);
            parameter.set("creater", (Object)userId);
            parameter.set("modifier", (Object)userId);
            parameter.set("createdate", (Object)time);
            parameter.set("modifydate", (Object)time);
            toAddParameters.add(parameter);
        }
        if (toAddParameters.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toAddParameters.toArray(new DynamicObject[0]));
        }
        dimIds.removeAll(curDimIds);
        if (dimIds.size() != 0) {
            qFilter.and(DIMENSION, "in", dimIds);
            DeleteServiceHelper.delete((String)VariableTypeEnum.Parameter.getMetadata(), (QFilter[])new QFilter[]{qFilter});
        }
    }

    private Set<Long> checkDimViewGroupChangeForMembPerm(DynamicObjectCollection oldViewEntry, DynamicObjectCollection newViewEntry) {
        HashMap dimViewGroups = new HashMap(newViewEntry.size());
        HashSet<Long> changedDimViewGroup = new HashSet<Long>(16);
        newViewEntry.forEach(dimView -> dimViewGroups.put(dimView.getLong("dimension.id"), dimView.getLong("viewgroup.id")));
        oldViewEntry.forEach(dimView -> {
            Long dimId = dimView.getLong("dimension.id");
            Long viewGroupId = dimView.getLong("viewgroup.id");
            Long oldViewGroupId = (Long)dimViewGroups.get(dimId);
            if (oldViewGroupId == null || !oldViewGroupId.equals(viewGroupId)) {
                changedDimViewGroup.add(dimId);
            }
        });
        return changedDimViewGroup;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (APP_SCENARIOTEXT.equals(key)) {
            this.openAppScenarioPage();
        }
    }

    private void openAppScenarioPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_scenarioselect");
        showParameter.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
        String id = this.getPageCache().get("id");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id)) {
            showParameter.setCustomParam("id", (Object)id);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u573a\u666f\u9009\u62e9", (String)"BusinessModelEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block7: {
            String key;
            block6: {
                super.closedCallBack(closedCallBackEvent);
                key = closedCallBackEvent.getActionId();
                if (!ADD_CLOSECALLBACK.equals(key)) break block6;
                if (closedCallBackEvent.getReturnData() == null) break block7;
                Map map = (Map)closedCallBackEvent.getReturnData();
                ArrayList names = new ArrayList();
                if (map == null || map.size() <= 0) break block7;
                this.getModel().deleteEntryData(SCENARIO_ENTRY);
                int[] rows = this.getModel().batchCreateNewEntryRow(SCENARIO_ENTRY, map.size());
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    this.getModel().setValue(APPSCENARIOT, entry.getKey(), rows[index]);
                    names.add(entry.getValue());
                    ++index;
                }
                this.getModel().setValue(APP_SCENARIOTEXT, (Object)String.join((CharSequence)",", names));
                break block7;
            }
            if (SELECT_DIM.equals(key) && closedCallBackEvent.getReturnData() != null) {
                List datasetIds;
                List dimIds = (List)closedCallBackEvent.getReturnData();
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                HashMap viewGroupMap = new HashMap(16);
                viewGroupMap.putAll(DimensionViewServiceHelper.getInstance().queryViewGroupIdByDimIds(dimIds));
                this.getModel().beginInit();
                int[] rows = this.getModel().batchCreateNewEntryRow(VIEW_ENTRY, dimIds.size());
                this.getModel().endInit();
                ArrayList<Integer> unLockRow = new ArrayList<Integer>();
                for (int i = 0; i < rows.length; ++i) {
                    Long dimId = (Long)dimIds.get(i);
                    Dimension dimension = modelCacheHelper.getDimension(dimId);
                    this.getModel().setValue(DIMENSION, (Object)dimId, rows[i]);
                    if (viewGroupMap.get(dimId) != null && (Long)viewGroupMap.get(dimId) != 0L) {
                        this.getModel().setValue(VIEW_GROUP, viewGroupMap.get(dimId), rows[i]);
                        unLockRow.add(rows[i]);
                        continue;
                    }
                    if (!View.NoViewDimNums.contains(dimension.getNumber())) continue;
                    unLockRow.add(rows[i]);
                }
                this.getView().updateView(VIEW_ENTRY);
                String id = this.getPageCache().get("id");
                boolean quto = false;
                if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id) && (datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(Long.valueOf(id))) != null && datasetIds.size() > 0) {
                    quto = true;
                }
                this.setEntryLock(quto);
                for (Integer integer : unLockRow) {
                    this.getView().setEnable(Boolean.valueOf(true), integer.intValue(), new String[]{VIEW_GROUP});
                }
            }
        }
    }

    private void fillAppScenario(DynamicObjectCollection scenarioentry) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(SCENARIO_ENTRY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject row = new DynamicObject(scenarioentry.getDynamicObjectType());
            row.set(APPSCENARIOT, (Object)dynamicObject.getLong("appscenario.id"));
            scenarioentry.add((Object)row);
        }
    }

    private void fillDimView(DynamicObjectCollection dimViewEntry, DynamicObjectCollection dynamicObjects) {
        int seq = 1;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject row = new DynamicObject(dimViewEntry.getDynamicObjectType());
            row.set("seq", (Object)seq);
            row.set(DIMENSION, dynamicObject.get("dimension.id"));
            row.set(VIEW_GROUP, dynamicObject.get("viewgroup.id"));
            dimViewEntry.add((Object)row);
            ++seq;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (DIMENSION.equals(key)) {
            QFilter dimQf = new QFilter(MODEL, "=", (Object)this.getModelId());
            List numbers = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(NUMBERLIST), List.class);
            numbers.remove(SysDimensionEnum.Account.getNumber());
            numbers.remove(SysDimensionEnum.Metric.getNumber());
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(VIEW_ENTRY);
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null || dynamicObject.get(DIMENSION) == null) continue;
                numbers.remove(dynamicObject.getString("dimension.number"));
            }
            QFilter numberQf = new QFilter("number", "in", (Object)numbers);
            qFilters.add(dimQf);
            qFilters.add(numberQf);
            this.setQfilters(beforeF7SelectEvent, qFilters);
        } else if (VIEW_GROUP.equals(key)) {
            int row = beforeF7SelectEvent.getRow();
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION, row);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"BusinessModelEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long dimensionId = dimension.getLong("id");
            QFilter modelQf = new QFilter(MODEL, "=", (Object)this.getModelId());
            QFilter dimQf = new QFilter(DIMENSION, "=", (Object)dimensionId);
            QFilter usageQf = new QFilter("type", "=", (Object)"1");
            QFilter defaultViewQf = new QFilter("defaultview", "is not null", (Object)"");
            defaultViewQf.and(new QFilter("defaultview", "!=", (Object)0L));
            qFilters.add(dimQf);
            qFilters.add(modelQf);
            qFilters.add(usageQf);
            qFilters.add(defaultViewQf);
            this.setQfilters(beforeF7SelectEvent, qFilters);
        }
    }

    private List<String> getAllDimNumber(String modelId) {
        ArrayList<String> numbers = new ArrayList<String>();
        QFilter modelQf = new QFilter(MODEL, "=", (Object)Long.parseLong(modelId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{modelQf});
        for (DynamicObject dynamicObject : dynamicObjects) {
            numbers.add(dynamicObject.getString("number"));
        }
        return numbers;
    }

    private void setQfilters(BeforeF7SelectEvent beforeF7SelectEvent, List<QFilter> qFilters) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(DIMENSION)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.addAll(qFilters);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        List dims = DataSetPresetDimEnum.getAllNumber();
        if (DIMENSION.equals(key)) {
            int row = changeData.getRowIndex();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            if (oldValue != null && dims.contains(oldValue.getString("number"))) {
                this.getModel().setValue(DIMENSION, (Object)oldValue.getString("id"), row);
                return;
            }
            this.getModel().setValue(VIEW_GROUP, null, row);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(DIMENSION, row);
            if (dynamicObject != null) {
                String number = dynamicObject.getString("number");
                if (View.NoViewDimNums.contains(number)) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{VIEW_GROUP});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), row, new String[]{VIEW_GROUP});
                }
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }

    private Map<Long, String> getScanarioEntityData(Long id) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        if (id != null && id != 0L) {
            String sql = "select fappscenarioid,fsyncstatus from t_eb_scenarioentry where fid = " + id;
            try (DataSet ds = DB.queryDataSet((String)"queryRef", (DBRoute)BgBaseConstant.epm, (String)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        if (!kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)row.getString("fsyncstatus"))) continue;
                        map.put(row.getLong("fappscenarioid"), row.getString("fsyncstatus"));
                    }
                }
            }
        }
        return map;
    }

    private void updateScenarioidSync(Map<Long, String> map) {
        if (map.size() > 0) {
            ArrayList<Object[]> adjObjs = new ArrayList<Object[]>(map.size());
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                Object[] obj = new Object[]{entry.getValue(), IDUtils.toLong((Object)this.getPageCache().get("id")), entry.getKey()};
                adjObjs.add(obj);
            }
            String sql = "update t_eb_scenarioentry set fsyncstatus = ? where fid = ? and fappscenarioid = ?";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, adjObjs);
        }
    }

    private Map<Long, List<Object>> getDimEntityData(Long id) {
        HashMap<Long, List<Object>> map = new HashMap<Long, List<Object>>(16);
        if (id != null && id != 0L) {
            String sql = "select fdimensionid,fviewgroupid,fsyncstatus from t_eb_viewentry where fid = " + id;
            try (DataSet ds = DB.queryDataSet((String)"queryRef", (DBRoute)BgBaseConstant.epm, (String)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        if (!kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)row.getString("fsyncstatus"))) continue;
                        ArrayList<String> list = new ArrayList<String>(4);
                        list.add(row.getString("fviewgroupid"));
                        list.add(row.getString("fsyncstatus"));
                        map.put(row.getLong("fdimensionid"), list);
                    }
                }
            }
        }
        return map;
    }

    private void updateDimSync(Map<Long, List<Object>> map) {
        if (map.size() > 0) {
            ArrayList<Object[]> adjObjs = new ArrayList<Object[]>(map.size());
            for (Map.Entry<Long, List<Object>> entry : map.entrySet()) {
                List<Object> list = entry.getValue();
                Object[] obj = new Object[3];
                obj[0] = list.get(1);
                obj[1] = entry.getKey();
                Object o = list.get(0);
                if (o == null) {
                    o = 0L;
                }
                obj[2] = IDUtils.toLong((Object)o);
                adjObjs.add(obj);
            }
            String sql = "update t_eb_viewentry set fsyncstatus = ? where fdimensionid = ? and fviewgroupid = ?";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, adjObjs);
        }
    }
}

