/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.dimension.dimensionrelation.BusinessRelationSyncStatusEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class BusinessModelListPlugin
extends MainSubAbstractListPlugin
implements HyperLinkClickListener,
CreateListDataProviderListener,
SetFilterListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BusinessModelListPlugin.class);
    private static final String TOOLBARAP = "toolbarap";
    private static final String MODEL = "model";
    private static final String ADD_CLOSECALLBACK = "addBusinessModel";
    private static final String PRE = "pre";
    private static final String NEXT = "next";
    private static final String rowlist = "rowlist";
    private static final String rowseq = "rowseq";
    private static final String BILLLIST = "billlistap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BusinessModelListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"upcube", "upcubelog", "relationshow", "relationstatus", "relationdate", "viewshow"});
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.refreshList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshList();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("add".equals(key)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BusinessModelListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openAddPage(null);
        } else if ("delete".equals(key)) {
            BillList list = (BillList)this.getControl(BILLLIST);
            Long pkId = (Long)list.getFocusRowPkId();
            if (pkId == null || pkId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BusinessModelListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = Long.valueOf(this.getPageCache().get(MODEL));
            String msg = this.checkQuote(pkId, modelId);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            msg = this.checkControl(pkId, modelId);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            msg = this.checkAnalyseReport(pkId, modelId);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u4f1a\u5220\u9664\u6240\u9009\u4e1a\u52a1\u6a21\u578b\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"BusinessModelListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
        } else if ("refresh".equals(key)) {
            this.refreshList();
        } else if ("upcube".equals(key)) {
            BillList list = (BillList)this.getControl(BILLLIST);
            Long pkId = (Long)list.getFocusRowPkId();
            if (pkId == null || pkId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BusinessModelListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u6a21\u578b\u7ef4\u5ea6\u5173\u7cfb\uff0c\u6267\u884c\u540e\u5c06\u4ec5\u5141\u8bb8\u5bf9\u4e1a\u52a1\u6a21\u578b\u7684\u6709\u6548\u7ef4\u5ea6\u7ec4\u5408\u8fdb\u884c\u8bfb\u5199\u5904\u7406\uff0c\u8bf7\u786e\u4fdd\u6709\u6570\u636e\u7684\u7ef4\u5ea6\u7ec4\u5408\u5728\u7ef4\u5ea6\u5173\u7cfb\u5df2\u6b63\u786e\u7ef4\u62a4\u3002", (String)"BusinessModelListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("upcube_comfirm", (IFormPlugin)this));
        } else if ("upcubelog".equals(key)) {
            // empty if block
        }
    }

    private String checkAnalyseReport(Long pkId, Long modelId) {
        String message = "";
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and("bizmodel", "=", (Object)pkId);
        DynamicObjectCollection parameters = QueryServiceHelper.query((String)VariableTypeEnum.Parameter.getMetadata(), (String)"id", (QFilter[])new QFilter[]{qFilter});
        Set paramIds = parameters.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        CheckQuote checkQuote = new CheckQuote(modelId, Long.valueOf(0L), paramIds, VariableTypeEnum.Parameter.getRefMemberType());
        QuoteCheckResult quoteCheckResult = QuoteCheck.get().checkQuoteResult(checkQuote);
        if (quoteCheckResult.isHasQuote()) {
            message = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u88ab\u5206\u6790\u62a5\u544a\u6a21\u677f\u4e2d\u7684\u53c2\u6570\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return message;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("delete_comfirm".equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.delete();
        }
        if (!"upcube_comfirm".equals(key) || MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            // empty if block
        }
        if ("buildRelationOlap_refresh".equals(key)) {
            BillList list = (BillList)this.getControl(BILLLIST);
            list.refresh();
            ThreadPools.executeOnce((String)"buildRelationOlap_refresh", () -> {
                try {
                    Thread.sleep(5000L);
                    FormView view = (FormView)this.getView();
                    boolean destory = view.isDestory();
                    if (!destory) {
                        BillList list1 = (BillList)this.getView().getControl(BILLLIST);
                        list1.refresh();
                    }
                }
                catch (InterruptedException e) {
                    KDBizException kdBizException = new KDBizException(e.getMessage());
                    kdBizException.initCause((Throwable)e);
                    throw kdBizException;
                }
            });
        }
    }

    private void delete() {
        BillList list = (BillList)this.getControl(BILLLIST);
        Long id = (Long)list.getFocusRowPkId();
        try {
            MembPermRecordUtil.delPermRecordByBcrAndDim((Long)this.getModelId(), (Long)id, null);
            DeleteServiceHelper.delete((String)"eb_businessmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            DeleteServiceHelper.delete((String)VariableTypeEnum.Parameter.getMetadata(), (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("bizmodel", "=", (Object)id)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BusinessModelListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "OperationLogUtil_1201", "epm-eb-common");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "OperationLogUtil_1202", "epm-eb-common");
            this.writeLog(null, "delete", opName, opDescription, null);
        }
        catch (Exception e) {
            log.error("delete-error", (Throwable)e);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "OperationLogUtil_1201", "epm-eb-common");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25\u3002", "OperationLogUtil_1203", "epm-eb-common");
            this.writeLog(null, "delete", opName, opDescription, null);
            throw new KDBizException(e.getMessage());
        }
        this.refreshList();
    }

    private String checkControl(Long bizModelId, Long modelId) {
        String message = "";
        QFilter modelQf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter datasetQf = new QFilter("bussmodel", "=", (Object)bizModelId);
        boolean quoteByDataset = QueryServiceHelper.exists((String)"eb_controlversion", (QFilter[])new QFilter[]{modelQf, datasetQf});
        if (quoteByDataset) {
            message = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u88ab\u201c\u63a7\u5236\u7248\u672c\u8bbe\u7f6e\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return message;
        }
        modelQf = new QFilter(MODEL, "=", (Object)modelId);
        datasetQf = new QFilter("businessmodel", "=", (Object)bizModelId);
        quoteByDataset = QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{modelQf, datasetQf});
        if (quoteByDataset) {
            message = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u88ab\u201c\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return message;
        }
        modelQf = new QFilter("cardentity.model", "=", (Object)modelId);
        datasetQf = new QFilter("cardentity.bussmodel", "=", (Object)bizModelId);
        quoteByDataset = QueryServiceHelper.exists((String)"eb_adddimmaterule", (QFilter[])new QFilter[]{modelQf, datasetQf});
        if (quoteByDataset) {
            message = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u88ab\u201c\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return message;
        }
        return message;
    }

    private String checkQuote(Long bizModelId, Long modelId) {
        QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)modelId, (Long)0L, (Long)bizModelId, (MemberTypeEnum)MemberTypeEnum.BUSINESS_MODEL));
        if (quote.isHasQuote()) {
            return quote.getMsg();
        }
        String message = "";
        QFilter modelQf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter datasetQf = new QFilter("businessmodel", "=", (Object)bizModelId);
        boolean quoteByDataset = QueryServiceHelper.exists((String)"eb_dataset", (QFilter[])new QFilter[]{modelQf, datasetQf});
        if (quoteByDataset) {
            message = ResManager.loadKDString((String)"\u6240\u9009\u4e1a\u52a1\u6a21\u578b\u5df2\u88ab\u6570\u636e\u96c6\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BusinessModelListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return message;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    private void refreshList() {
        BillList list = (BillList)this.getControl(BILLLIST);
        list.clearSelection();
        list.refresh();
    }

    private void openAddPage(String id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_addbusinessmodel");
        showParameter.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            showParameter.setCustomParam("id", (Object)id);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b", (String)"BusinessModelListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String key = hyperLinkClickEvent.getFieldName();
        if ("name".equals(key)) {
            BillList list = (BillList)this.getControl(BILLLIST);
            Long id = (Long)list.getFocusRowPkId();
            this.openAddPage(String.valueOf(id));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ADD_CLOSECALLBACK.equals(key)) {
            this.refreshList();
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        e.getCustomQFilters().add(this.getQfilter());
    }

    private QFilter getQfilter() {
        return new QFilter(MODEL, "=", (Object)this.getModelId());
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                ArrayList<Long> mainIds = new ArrayList<Long>();
                for (DynamicObject row2 : allRows) {
                    mainIds.add(Long.parseLong(row2.getString("id")));
                }
                QFilter qfOrg = new QFilter("id", "in", (Object)mainIds.toArray());
                DynamicObjectCollection rows = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,viewentry.dimension.name,viewentry.viewgroup.name", (QFilter[])new QFilter[]{qfOrg});
                HashMap showDim = new HashMap(16);
                HashMap showViewGroup = new HashMap(16);
                rows.forEach(row -> {
                    String entryentityId = row.getString("id");
                    String dimName = row.getString("viewentry.dimension.name");
                    String viewGroupName = row.getString("viewentry.viewgroup.name");
                    if (showDim.get(entryentityId) != null) {
                        showDim.put(entryentityId, (String)showDim.get(entryentityId) + "," + dimName);
                    } else {
                        showDim.put(entryentityId, dimName);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)row.getString("viewentry.viewgroup.name"))) {
                        if (showViewGroup.get(entryentityId) != null) {
                            showViewGroup.put(entryentityId, (String)showViewGroup.get(entryentityId) + "," + viewGroupName);
                        } else {
                            showViewGroup.put(entryentityId, viewGroupName);
                        }
                    }
                });
                QFilter qFilter = new QFilter("businessmodel.fbasedataid_id", "in", (Object)mainIds.toArray());
                DynamicObjectCollection relations = QueryServiceHelper.query((String)"epm_dimensionrelation", (String)"id,number,name,businessmodel.fbasedataid_id", (QFilter[])new QFilter[]{qFilter});
                HashMap<String, String> showRelation = new HashMap<String, String>(16);
                for (DynamicObject relation : relations) {
                    String businessmodelId = relation.getString("businessmodel.fbasedataid_id");
                    String name = relation.getString("name");
                    showRelation.merge(businessmodelId, name, (a, b) -> a + "," + b);
                }
                TextProp dimProp = null;
                TextProp viewGroupProp = null;
                TextProp relationProp = null;
                TextProp relationStatusProp = null;
                for (DynamicObject row3 : allRows) {
                    String entryentityId = row3.getString("id");
                    String dim = (String)showDim.get(entryentityId);
                    String viewGroup = (String)showViewGroup.get(entryentityId);
                    String relation = (String)showRelation.get(entryentityId);
                    if (dimProp == null) {
                        dimProp = new TextProp();
                        dimProp.setName("dimshow");
                        row3.getDataEntityType().getProperties().add((Object)dimProp);
                    }
                    if (viewGroupProp == null) {
                        viewGroupProp = new TextProp();
                        viewGroupProp.setName("viewgroupshow");
                        row3.getDataEntityType().getProperties().add((Object)viewGroupProp);
                    }
                    if (relationProp == null) {
                        relationProp = new TextProp();
                        relationProp.setName("relationshow");
                        row3.getDataEntityType().getProperties().add((Object)relationProp);
                    }
                    if (relationStatusProp == null) {
                        relationStatusProp = new TextProp();
                        relationStatusProp.setName("relationstatus");
                        row3.getDataEntityType().getProperties().add((Object)relationStatusProp);
                    }
                    row3.set("dimshow", (Object)dim);
                    row3.set("viewgroupshow", (Object)viewGroup);
                    row3.set("relationshow", (Object)relation);
                    String relationstatus = BusinessRelationSyncStatusEnum.getNameByNumber((String)row3.getString("relationstatus"));
                    row3.set("relationstatus", (Object)relationstatus);
                }
                return allRows;
            }
        });
    }

    @Override
    protected void addColumnKeysToHide(Set<String> colsToHide) {
        colsToHide.addAll(Lists.newArrayList((Object[])new String[]{"viewshow", "relationshow", "relationstatus", "relationdate"}));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key) && this.getControl(MODEL) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
        }
    }
}

