/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.DimensionViewConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.dimension.DimensionManagerList;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionView;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;

public class DimensionViewPlugin
extends AbstractBasePlugin
implements DimensionViewConstant,
BeforeF7SelectListener {
    private static final String BUTTON_OK = "button_ok";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
        BasedataEdit _f7View = (BasedataEdit)this.getView().getControl("viewgroup");
        if (_f7View != null) {
            _f7View.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            DimensionView dimensionView;
            IFormView view = this.getView();
            Long model = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("model"));
            Long dimensionId = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("dimensionId"));
            Long viewId = this.getViewId();
            Long groupViewId = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("viewGroup"));
            if (model == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u4f53\u7cfb\u5931\u8d25", (String)"OrganizationViewEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (dimensionId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ef4\u5ea6\u5931\u8d25", (String)"OrganizationViewEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("model", (Object)model);
            this.getModel().setValue("dimension", (Object)dimensionId);
            IDataModel dataModel = this.getModel();
            if (viewId != 0L) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
                if (dynamicObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"OrganizationViewEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewgroup"});
                dataModel.setValue("number", (Object)dynamicObject.getString("number"));
                dataModel.setValue("name", (Object)dynamicObject.getLocaleString("name"));
                dataModel.setValue("description", (Object)dynamicObject.getLocaleString("description"));
                DynamicObject viewGroup = dynamicObject.getDynamicObject("viewgroup");
                if (viewGroup != null) {
                    dataModel.setValue("viewgroup", viewGroup.get("id"));
                }
                dimensionView = DimensionView.of((DynamicObject)dynamicObject);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "usage"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewgroup"});
                dimensionView = new DimensionView();
                dimensionView.setName((ILocaleString)dataModel.getValue("name"));
                dimensionView.setNumber((String)dataModel.getValue("number"));
                dimensionView.setDimensionId(dimensionId);
                dimensionView.setDescription((ILocaleString)dataModel.getValue("description"));
                dimensionView.setViewGroupId(groupViewId);
                dimensionView.setModelId(model);
            }
            this.getPageCache().put("dimensionView", SerializationUtils.serializeToBase64((Object)dimensionView));
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private Long getViewId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("viewId"));
    }

    public void click(EventObject evt) {
        try {
            String key;
            super.click(evt);
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "button_ok": {
                    MultiLangEnumBridge opDesc;
                    MultiLangEnumBridge opName;
                    OperationStatus status = super.getView().getFormShowParameter().getStatus();
                    if (Objects.equals(OperationStatus.VIEW, status)) {
                        this.getView().close();
                        return;
                    }
                    String dimensionViewJson = this.getPageCache().get("dimensionView");
                    if (StringUtils.isEmpty((String)dimensionViewJson)) {
                        return;
                    }
                    DimensionView dimensionView = (DimensionView)SerializationUtils.deSerializeFromBase64((String)dimensionViewJson);
                    dimensionView.setNumber((String)this.getModel().getValue("number"));
                    dimensionView.setName((ILocaleString)this.getModel().getValue("name"));
                    dimensionView.setDescription((ILocaleString)this.getModel().getValue("description"));
                    DynamicObject viewgroup = (DynamicObject)this.getModel().getValue("viewgroup");
                    if (viewgroup != null) {
                        dimensionView.setViewGroupId(Long.valueOf(viewgroup.getLong("id")));
                    }
                    try (TXHandle th = TX.required((String)"saveView");){
                        try {
                            ViewGroupManager.getInstance().saveView(dimensionView);
                            if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
                                this.saveMember(dimensionView);
                                ViewGroupManager.getInstance().initDefaultView(dimensionView);
                            }
                        }
                        catch (Exception e) {
                            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u4fdd\u5b58", "ExamineCategoryAddPlugin_0", "epm-eb-formplugin");
                            MultiLangEnumBridge opDesc2 = new MultiLangEnumBridge("\u5206\u7c7b\u4fdd\u5b58\u5931\u8d25", "ExamineCategoryAddPlugin_1", "epm-eb-formplugin");
                            this.writeLog(dimensionView.getNumber(), "save", opName2, opDesc2, null, false);
                            th.markRollback();
                            throw e;
                        }
                    }
                    if (Objects.equals(OperationStatus.EDIT, status)) {
                        opName = new MultiLangEnumBridge("\u89c6\u56fe\u4fee\u6539", "DimensionViewPlugin_1", "epm-eb-formplugin");
                        opDesc = new MultiLangEnumBridge("\u89c6\u56fe\u4fee\u6539\u6210\u529f", "DimensionViewPlugin_2", "epm-eb-formplugin");
                        this.writeLog(dimensionView.getNumber(), "update", opName, opDesc, null);
                    } else {
                        opName = new MultiLangEnumBridge("\u89c6\u56fe\u65b0\u589e", "DimensionViewPlugin_3", "epm-eb-formplugin");
                        opDesc = new MultiLangEnumBridge("\u89c6\u56fe\u65b0\u589e\u6210\u529f", "DimensionViewPlugin_4", "epm-eb-formplugin");
                        this.writeLog(dimensionView.getNumber(), "addnew", opName, opDesc, null);
                    }
                    this.getModel().setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DimensionViewGroupEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getView().setReturnData((Object)"success");
                    this.getView().close();
                    break;
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void saveMember(DimensionView dimensionView) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Dimension dimension = orCreate.getDimension(dimensionView.getDimensionId());
        QFilter qFilter = new QFilter("model", "=", (Object)dimensionView.getModelId()).and("level", "=", (Object)1).and("dimension", "=", (Object)dimensionView.getDimensionId()).and("number", "=", (Object)dimension.getNumber());
        String memberTreemodelByNumber = SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getNumber());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)memberTreemodelByNumber, (QFilter[])qFilter.toArray());
        DimensionViewMember dimensionViewMember = ViewMemberManager.getInstance().buildViewMemberByOldMember(dynamicObject, dimensionView.getId(), Long.valueOf(0L), Boolean.valueOf(true));
        dimensionViewMember.setMemberId(null);
        dimensionViewMember.setIsLeaf(true);
        dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.PRESET.getIndex());
        ArrayList dimensionViewMembers = Lists.newArrayList((Object[])new DimensionViewMember[]{dimensionViewMember});
        dimensionViewMembers.addAll(this.getPersetMembers(dimension, dimensionView.getId(), dimensionViewMember.getNumber(), dimensionViewMember.getViewMemberId(), dimensionViewMember.getMemberId()));
        ViewMemberManager.getInstance().insertViewAndDimMember(dimensionView.getModelId().longValue(), dimension.getNumber(), dimensionView.getId(), (List)dimensionViewMembers);
    }

    protected List<DimensionViewMember> getPersetMembers(Dimension dimension, Long currViewId, String parentNumber, Long parentId, Long parentMemberId) {
        QFilter baseViewFilter = new QFilter("model", "=", (Object)this.getModelId()).and("dimension", "=", (Object)dimension.getId());
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
            baseViewFilter.and("number", "=", (Object)"IC_E001");
        } else {
            baseViewFilter.and(new QFilter("number", "=", (Object)(dimension.getShortNumber() + "001")).or("number", "=", (Object)(dimension.getNumber() + "001")));
        }
        DynamicObject baseView = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])baseViewFilter.toArray());
        if (baseView == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u4e0d\u5b58\u5728", (String)"BailOrgImportFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long baseViewId = baseView.getLong("id");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        boolean icInner = false;
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
            Set groupViews = ViewGroupManager.getInstance().getViewsByViewId(currViewId.longValue());
            groupViews.removeIf(e -> e.equals(currViewId));
            if (groupViews.isEmpty()) {
                qfBuilder.add(new QFilter("view.id", "=", (Object)baseViewId));
            } else {
                icInner = true;
                Long luckViewId = (Long)groupViews.iterator().next();
                qfBuilder.add(new QFilter("view.id", "=", (Object)luckViewId));
            }
        } else {
            qfBuilder.add(new QFilter("view.id", "=", (Object)baseViewId));
        }
        String selectFields = "id,name,number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level,view,refview,shownumber,dimension,memberid,aggoprt";
        ArrayList<DimensionViewMember> initMember = new ArrayList<DimensionViewMember>(16);
        boolean isCross = ViewGroupManager.getInstance().isCrossGroup(baseViewId.toString(), currViewId);
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
            DynamicObjectCollection query;
            if (isCross) {
                qfBuilder.add("number", "in", DimensionManagerList.CHANGETYPE_VIEW_ALL_PRESET);
            }
            if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"number,level")))) {
                return new ArrayList<DimensionViewMember>(16);
            }
            Map<Long, List<DynamicObject>> parentMap = query.stream().collect(Collectors.groupingBy(x -> x.getLong("parentid")));
            this.handInitMember(initMember, parentMap, (List<DynamicObject>)query, parentNumber, parentId, parentMemberId, false, isCross);
        } else if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
            DynamicObjectCollection query;
            if (isCross & !icInner) {
                qfBuilder.add("number", "in", DimensionManagerList.INTERNALCOMPANY_VIEW_ALL_PRESET);
            }
            if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"number,level")))) {
                return new ArrayList<DimensionViewMember>(16);
            }
            Map<Long, List<DynamicObject>> parentMap = query.stream().collect(Collectors.groupingBy(x -> x.getLong("parentid")));
            this.handInitMember(initMember, parentMap, (List<DynamicObject>)query, parentNumber, parentId, parentMemberId, false, isCross && !icInner);
        } else if ("epm_userdefinedmembertree".equals(dimension.getMemberModel())) {
            qfBuilder.add(new QFilter("number", "=", (Object)(dimension.getShortNumber() + "None")));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"number,level");
            if (CollectionUtils.isEmpty((Collection)query)) {
                return initMember;
            }
            for (DynamicObject dynamicObject : query) {
                DimensionViewMember dimensionViewMember = this.transDimensionViewMember(dynamicObject, parentNumber, parentId, parentMemberId, isCross, true);
                initMember.add(dimensionViewMember);
            }
        }
        if (!initMember.isEmpty()) {
            this.replaceId(initMember);
        }
        return initMember;
    }

    protected void replaceId(List<DimensionViewMember> dimensionViewMembers) {
        ArrayList<DimensionViewMember> tempObjs = new ArrayList<DimensionViewMember>(dimensionViewMembers);
        dimensionViewMembers.clear();
        LinkedHashMap<Integer, List> levelDynamicObjectMap = new LinkedHashMap<Integer, List>();
        for (DimensionViewMember toSaveObj : tempObjs) {
            List objs = levelDynamicObjectMap.computeIfAbsent(toSaveObj.getLevel(), k -> new LinkedList());
            objs.add(toSaveObj);
        }
        LinkedHashMap<Long, Long> idsMap = new LinkedHashMap<Long, Long>();
        List levels = levelDynamicObjectMap.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        int last = (Integer)levels.get(levels.size() - 1);
        for (int i = ((Integer)levels.get(0)).intValue(); i <= last; ++i) {
            List dimensionViewMembers1 = (List)levelDynamicObjectMap.get(i);
            long[] newIds = DBServiceHelper.genLongIds(null, (int)dimensionViewMembers1.size());
            int jn = dimensionViewMembers1.size();
            for (int j = 0; j < jn; ++j) {
                DimensionViewMember dimensionViewMember = (DimensionViewMember)dimensionViewMembers1.get(j);
                idsMap.putIfAbsent(dimensionViewMember.getViewMemberId(), newIds[j]);
                dimensionViewMember.setViewMemberId(Long.valueOf(newIds[j]));
                Long parentId = (Long)idsMap.get(dimensionViewMember.getParentId());
                if (parentId == null) continue;
                dimensionViewMember.setParentId(parentId);
            }
            dimensionViewMembers.addAll(dimensionViewMembers1);
        }
    }

    private void handInitMember(List<DimensionViewMember> initMember, Map<Long, List<DynamicObject>> parentMap, List<DynamicObject> dataList, String parentLongNumber, Long parentId, Long parentMemberId, Boolean ischild, Boolean isCross) {
        for (DynamicObject dynamicObject : dataList) {
            if (!DimensionManagerList.CHANGETYPE_VIEW_PRESET_LEVEL_ONE.contains(dynamicObject.getString("number")) && !DimensionManagerList.INTERNALCOMPANY_VIEW_PRESET_LEVEL_ONE.contains(dynamicObject.getString("number")) && !ischild.booleanValue()) continue;
            List<DynamicObject> childList = parentMap.get(dynamicObject.getLong("id"));
            Boolean isleaf = CollectionUtils.isNotEmpty(childList) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            DimensionViewMember dimensionViewMember = this.transDimensionViewMember(dynamicObject, parentLongNumber, parentId, parentMemberId, isCross, isleaf);
            initMember.add(dimensionViewMember);
            if (!CollectionUtils.isNotEmpty(childList)) continue;
            this.handInitMember(initMember, parentMap, childList, dimensionViewMember.getLongNumber(), dimensionViewMember.getViewMemberId(), dimensionViewMember.getMemberId(), true, isCross);
        }
    }

    protected DimensionViewMember transDimensionViewMember(DynamicObject dynamicObject, String parentLongNumber, Long parentId, Long parentMemberId, Boolean isCross, Boolean isleaf) {
        try {
            long modelId = this.getModelId();
            DimensionViewMember dimensionViewMember = new DimensionViewMember();
            dimensionViewMember.setStatus("C");
            dimensionViewMember.setEnable("1");
            dimensionViewMember.setViewMemberId(Long.valueOf(ID.genLongId()));
            dimensionViewMember.setName(dynamicObject.getString("name"));
            dimensionViewMember.setMemberId(Long.valueOf(dynamicObject.getLong("memberid")));
            if (isCross.booleanValue()) {
                dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.OUTER_REF.getIndex());
            } else {
                dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.INNER_REF.getIndex());
            }
            dimensionViewMember.setNumber(dynamicObject.getString("number"));
            dimensionViewMember.setAggoprt(dynamicObject.getString("aggoprt"));
            long dbRefView = dynamicObject.getLong("refview");
            dimensionViewMember.setRefview(Long.valueOf(dbRefView > 0L ? dbRefView : dynamicObject.getLong("view")));
            dimensionViewMember.setShowNumber(dynamicObject.getString("shownumber"));
            dimensionViewMember.setMembersource(MemberSourceEnum.SYSTEM_IMPORT.getIndex());
            dimensionViewMember.setLevel(dynamicObject.getInt("level"));
            String currLongNumber = parentLongNumber + "!" + dimensionViewMember.getNumber();
            dimensionViewMember.setLongNumber(currLongNumber);
            dimensionViewMember.setParentId(parentId);
            dimensionViewMember.setParentMemberId(parentMemberId);
            dimensionViewMember.setModel(Long.valueOf(modelId));
            dimensionViewMember.setDimension(Long.valueOf(dynamicObject.getLong("dimension")));
            dimensionViewMember.setDseq(Integer.valueOf(dynamicObject.getInt("dseq")));
            dimensionViewMember.setIsLeaf(isleaf.booleanValue());
            return dimensionViewMember;
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        Long modelId = this.getModelId();
        qs.add(new QFilter("model", "=", (Object)modelId));
        switch (f7Key) {
            case "viewgroup": {
                Set viewsGroupId;
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("dimension");
                if (dynamicObject != null) {
                    qs.add(new QFilter("dimension", "=", (Object)dynamicObject.getLong("id")));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(viewsGroupId = ViewGroupManager.getInstance().getViewGroupIdByViewId(this.getViewId().longValue())))) break;
                qs.add(new QFilter("id", "in", (Object)viewsGroupId));
                break;
            }
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }
}

