/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.DimensionViewConstant;
import kd.epm.eb.common.dimension.view.ViewMemberSelectedPojo;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.memberf7.newf7.base.SearchControlPojo;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISearchTree;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class OrganizationViewEditPlugin
extends MainSubAbstractFormPlugin
implements DimensionViewConstant,
TreeNodeClickListener,
ISearchTree {
    protected static final String LEFT_PRE = "leftpre";
    protected static final String LEFT_NEXT = "leftnext";
    protected static final String TOOLBAR = "toolbarap";
    private static final String MEMBERID = "memberid";
    private static final String RIGHT_MEMBER = "rightmember";
    private static final String NUMBER = "vnumber";
    private static final String NAME = "vname";
    private static final String RANGE = "range";
    private static final String LEVEL = "level";
    private static final String SOURCE = "source";
    private static final String CUR_LEVEL = "curlevel";
    private static final String RIGHT_IDS = "rightIds";
    private static final String INIT_RIGHT_IDS = "initRightIds";
    private static final Log log = LogFactory.getLog(OrganizationViewEditPlugin.class);

    public void initialize() {
        super.initialize();
        this.innerInitialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"add", "remove"});
        this.addItemClickListeners(new String[]{TOOLBAR, "advcontoolbarap"});
        TreeView leftTree = (TreeView)this.getControl("lefttreeview");
        leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView rightTree = (TreeView)this.getControl("righttreeview");
        rightTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        Search sr = (Search)this.getControl("searchapright");
        sr.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                TreeSearchUtil.TreeSearchParam RParam = new TreeSearchUtil.TreeSearchParam("righttreeview", "righttreeview", "rresult", "rfocus", "roldcache");
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), view, pageCache, RParam);
            }
        });
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MemberF7Parameter f7Param = this.getF7Parameter();
        ComboEdit showScope = (ComboEdit)this.getControl("showscope");
        showScope.setComboItems(f7Param.getRangeItems());
        this.setDefaultValue(f7Param, "showscope");
    }

    protected void setDefaultValue(MemberF7Parameter f7Param, String controlKey) {
        if (f7Param.getDefRangeValue() != null) {
            this.getModel().setValue(controlKey, (Object)String.valueOf(f7Param.getDefRangeValue().getIndex()));
        } else {
            this.getModel().setValue(controlKey, (Object)String.valueOf(RangeEnum.ONLY.getIndex()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabproperty"});
        }
        this.initPropertyTree();
    }

    public void afterCreateNewData(EventObject e) {
        Object copyView;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CUR_LEVEL, MEMBERID, SOURCE});
        this.setVisibleAndEnable(false);
        IFormView view = this.getView();
        boolean isCopy = false;
        Long model = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("model"));
        Long dimensionId = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("dimensionId"));
        Long viewId = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam("viewId"));
        if (viewId == 0L && (copyView = view.getFormShowParameter().getCustomParam("copyViewId")) != null) {
            viewId = IDUtils.toLong((Object)copyView);
            isCopy = true;
        }
        if (model == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u4f53\u7cfb\u5931\u8d25", (String)"OrganizationViewEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dimensionId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ef4\u5ea6\u5931\u8d25", (String)"OrganizationViewEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("dimension", (Object)dimensionId);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null) {
            return;
        }
        String dimNumber = dimension.getString("number");
        String memberKey = DimensionServiceHelper.getMemberKeyByDimNum((String)dimNumber);
        this.getModel().setValue("dimname", (Object)dimension.getString("name"));
        this.getPageCache().put("model", model.toString());
        this.getPageCache().put("dimensionId", dimensionId.toString());
        this.getPageCache().put("dimensionNumber", dimNumber);
        if (viewId != 0L) {
            this.setPageValue(viewId, memberKey, isCopy);
            this.getPageCache().put("viewId", viewId.toString());
        } else {
            this.setEntryDefault(memberKey, dimensionId, dimNumber);
            this.initLeftTree();
        }
        if (NewEbAppUtil.isNewEbModel((Long)model)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usage"});
            this.getModel().setValue("usage", (Object)"1");
            this.selectCountAnalyseView();
        }
        this.initPropertyTree();
    }

    private void setPageValue(Long viewId, String memberKey, boolean isCopy) {
        DynamicObject dimensionView = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        if (dimensionView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"OrganizationViewEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String usage = dimensionView.getString("usage");
        this.getPageCache().put("viewId", viewId.toString());
        if (isCopy) {
            this.getPageCache().put("isCopy", "true");
        }
        if ("0".equals(usage)) {
            this.isPageValueByEntry(viewId, memberKey, dimensionView, isCopy);
            this.initLeftTree();
        } else {
            IDataModel dataModel = this.getModel();
            String number = dimensionView.getString("number");
            String name = dimensionView.getString("name");
            DynamicObject baseview = (DynamicObject)dimensionView.get("baseview");
            if (this.isViewByBenchmark(baseview.getLong("id"))) {
                this.initLeftTree();
            } else {
                this.createLeftViewTree(baseview.getLong("id"));
            }
            this.setComboEdit(baseview);
            this.initRightTree();
            dataModel.setValue("usage", (Object)"1");
            String[] unableKeys = null;
            if (isCopy) {
                name = "";
                number = "";
                unableKeys = new String[]{"usage"};
            } else {
                unableKeys = new String[]{"number", "usage"};
            }
            dataModel.setValue("number", (Object)number);
            dataModel.setValue("name", (Object)name);
            this.getView().setEnable(Boolean.valueOf(false), unableKeys);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexrighttree", "advcontoolbarap", "flexsearchap", "flexplefttree"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap161"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contain"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapscope"});
            this.getModel().setValue("contain", (Object)true);
        }
    }

    private String limitLength(String propertyValue, int length) {
        if (propertyValue.length() > length) {
            propertyValue = propertyValue.substring(0, length);
        }
        return propertyValue;
    }

    private boolean isViewByBenchmark(Long viewId) {
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)viewId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)SOURCE, (QFilter[])qfBuilder.toArray());
        if (dynamicObject != null) {
            return StringUtils.equals((String)"1", (String)dynamicObject.getString(SOURCE));
        }
        return false;
    }

    private void isPageValueByEntry(Long viewId, String memberKey, DynamicObject dimensionView, boolean isCopy) {
        IDataModel dataModel = this.getModel();
        String number = dimensionView.getString("number");
        String name = dimensionView.getString("name");
        if (isCopy) {
            name = "";
            number = "";
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "usage"});
        }
        dataModel.setValue("number", (Object)number);
        dataModel.setValue("name", (Object)name);
        String fields = "id,memberid,dimension,range,levelcount,curlevel,source,view";
        QFilter qFilter = new QFilter("view", "=", (Object)viewId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_membersaveselect", (String)fields, (QFilter[])new QFilter[]{qFilter}, (String)"curlevel asc");
        if (dynamicObjects.size() == 0) {
            this.setEntryDefault(memberKey, this.getDimensionId(), this.getDimensionNumber());
            return;
        }
        boolean hasRefByBusModel = false;
        if (!isCopy) {
            hasRefByBusModel = this.checkUsedInBizModel(viewId);
        }
        LinkedHashMap<String, ViewMemberSelectedPojo> map = new LinkedHashMap<String, ViewMemberSelectedPojo>(dynamicObjects.size());
        ArrayList<Long> memIds = new ArrayList<Long>(dynamicObjects.size());
        for (DynamicObject dy : dynamicObjects) {
            String id = dy.getString("id");
            String memberId = dy.getString(MEMBERID);
            ViewMemberSelectedPojo viewMem = new ViewMemberSelectedPojo(id, memberId, dy.getLong("dimension"), dy.getString(RANGE), dy.getString("levelcount"), dy.getInt(CUR_LEVEL), dy.getString(SOURCE), viewId.longValue());
            map.put(memberId, viewMem);
            memIds.add(Long.parseLong(memberId));
        }
        QFilter qFilter1 = new QFilter("id", "in", memIds);
        DynamicObjectCollection members = QueryServiceHelper.query((String)memberKey, (String)"id,number,name,level", (QFilter[])new QFilter[]{qFilter1}, (String)"level,dseq");
        if (members.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        int[] row = this.getModel().batchCreateNewEntryRow("entryentity", members.size());
        int i = 0;
        HashMap<String, String> existMap = new HashMap<String, String>(members.size());
        for (DynamicObject member : members) {
            ViewMemberSelectedPojo viewSelect = (ViewMemberSelectedPojo)map.get(member.getString("id"));
            if (viewSelect == null) continue;
            String memNumber = member.getString("number");
            String menName = member.getString("name");
            this.getModel().setValue("id", (Object)viewSelect.getId(), row[i]);
            this.getModel().setValue(NUMBER, (Object)memNumber, row[i]);
            this.getModel().setValue(NAME, (Object)menName, row[i]);
            this.getModel().setValue(RANGE, (Object)viewSelect.getRange(), row[i]);
            this.getModel().setValue(LEVEL, (Object)viewSelect.getLevelCount(), row[i]);
            this.getModel().setValue(CUR_LEVEL, (Object)member.getInt(LEVEL), row[i]);
            this.getModel().setValue(MEMBERID, (Object)viewSelect.getMemberId(), row[i]);
            this.getModel().setValue(SOURCE, (Object)viewSelect.getSource(), row[i]);
            existMap.put(viewSelect.getMemberId(), memNumber);
            if ("0".equals(viewSelect.getRange())) {
                this.getView().setEnable(Boolean.FALSE, row[i], new String[]{LEVEL});
            }
            if (viewSelect.getCurLevel() == 2 && MemberSourceEnum.PRESET.getIndex().equals(viewSelect.getSource()) && "epm_userdefinedmembertree".equals(memberKey)) {
                this.getView().setEnable(Boolean.FALSE, row[i], new String[]{RANGE});
            }
            if (hasRefByBusModel) {
                this.getView().setEnable(Boolean.FALSE, row[i], new String[]{RANGE});
                this.getView().setEnable(Boolean.FALSE, row[i], new String[]{LEVEL});
            }
            ++i;
        }
        this.cacheRightIds(existMap);
        this.cacheInitRightIds(existMap);
    }

    private void setEntryDefault(String entity, long dimensionId, String dimNumber) {
        DynamicObject noneMember;
        DynamicObject object = DimensionServiceHelper.queryMemberByNumber((String)entity, (long)this.getModelId(), (long)dimensionId, (String)dimNumber, (String)"id,number,name,level");
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        if (object != null) {
            this.getModel().beginInit();
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().endInit();
            String id = object.getString("id");
            String number = object.getString("number");
            this.getModel().setValue(NUMBER, (Object)number, row);
            this.getModel().setValue(NAME, (Object)object.getString("name"), row);
            this.getModel().setValue(RANGE, (Object)"0", row);
            this.getModel().setValue(LEVEL, null, row);
            this.getModel().setValue(CUR_LEVEL, (Object)object.getInt(LEVEL), row);
            this.getModel().setValue(MEMBERID, (Object)id, row);
            this.getModel().setValue(SOURCE, (Object)"1", row);
            defaultMap.put(id, number);
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{LEVEL});
            this.getPageCache().put("viewName", object.getString("name"));
        }
        if ("epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)this.getDimensionNumber())) && (noneMember = this.getNoneMember()) != null) {
            this.getModel().beginInit();
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().endInit();
            String id = noneMember.getString("id");
            String number = noneMember.getString("number");
            this.getModel().setValue(NUMBER, (Object)number, row);
            this.getModel().setValue(NAME, (Object)noneMember.getString("name"), row);
            this.getModel().setValue(RANGE, (Object)"0", row);
            this.getModel().setValue(LEVEL, null, row);
            this.getModel().setValue(CUR_LEVEL, (Object)noneMember.getInt(LEVEL), row);
            this.getModel().setValue(MEMBERID, (Object)id, row);
            this.getModel().setValue(SOURCE, (Object)"1", row);
            defaultMap.put(id, number);
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{LEVEL, RANGE});
        }
        this.cacheRightIds(defaultMap);
    }

    protected DynamicObject getNoneMember() {
        String dimensionNumber = this.getDimensionNumber();
        String selectFields = "id,id as memberid,number,name,longnumber,parent,level,isleaf,aggoprt,dseq,enable,status,membersource";
        QFilter dimQf = new QFilter("dimension.number", "=", (Object)dimensionNumber);
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter = new QFilter(LEVEL, "=", (Object)2);
        QFilter qFilter1 = new QFilter("membersource", "=", (Object)MemberSourceEnum.PRESET.getIndex());
        QFilter[] filters = new QFilter[]{dimQf, modelQf, qFilter, qFilter1};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_userdefinedmembertree", (String)selectFields, (QFilter[])filters);
        if (dynamicObject != null) {
            this.getPageCache().put("NoneNumber", dynamicObject.getString("number"));
        }
        return dynamicObject;
    }

    @Override
    public void click(EventObject evt) {
    }

    private void cacheRightIds(Map<String, String> ids) {
        F7TreeUtils.cacheData((IPageCache)this.getPageCache(), (String)RIGHT_IDS, (String)SerializationUtils.toJsonString(ids));
    }

    private void cacheInitRightIds(Map<String, String> ids) {
        F7TreeUtils.cacheData((IPageCache)this.getPageCache(), (String)INIT_RIGHT_IDS, (String)SerializationUtils.toJsonString(ids));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
    }

    private boolean isAnalyzeIdBybaseId(Long analyzeByViewId) {
        Long viewId = DimensionViewServiceHelper.getInstance().queryBaseViewId(this.getModelId(), this.getDimensionId());
        return analyzeByViewId.compareTo(viewId) == 0;
    }

    private void setComboEdit(DynamicObject view) {
        this.setComboEditItems(view);
        this.getPageCache().put("sign", "1");
        this.getModel().setValue("combofield", (Object)"1");
        this.getPageCache().remove("sign");
    }

    private void setComboEditItems(DynamicObject view) {
        ComboEdit cmb = (ComboEdit)this.getControl("combofield");
        ArrayList<ComboItem> dimmemitems = new ArrayList<ComboItem>();
        dimmemitems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u57fa\u51c6\u89c6\u56fe", (String)"OrganizationViewEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])), "0"));
        dimmemitems.add(new ComboItem(new LocaleString(view.getString("name")), "1"));
        cmb.setComboItems(dimmemitems);
    }

    private void initRightTree() {
        TreeView tree = (TreeView)this.getControl("righttreeview");
        tree.deleteAllNodes();
        TreeNode rootRight = null;
        String _view = this.getPageCache().get("viewId");
        long view = _view != null ? Long.parseLong(_view) : 0L;
        DynamicObjectCollection members = null;
        if (view == 0L) {
            DynamicObject dynamicObject;
            members = new DynamicObjectCollection();
            String id = String.valueOf(GlobalIdUtil.genGlobalLongId());
            rootRight = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("rootNode"), TreeNode.class);
            Map memberMap = (Map)rootRight.getData();
            memberMap.put(MEMBERID, memberMap.get("id"));
            memberMap.put("id", id);
            rootRight.setId(id);
            rootRight.setData((Object)memberMap);
            if ("epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)this.getDimensionNumber())) && (dynamicObject = this.getNoneMember()) != null) {
                dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                dynamicObject.set("parent", (Object)id);
                members.add((Object)dynamicObject);
            }
        } else {
            members = this.getViewExistDimMembers(view, false);
            if (SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber())) {
                F7TreeUtils.cacheData((IPageCache)this.getPageCache(), (String)RIGHT_MEMBER, (String)SerializationUtils.serializeToBase64((Object)members));
            }
            DynamicObject rightRoot = (DynamicObject)members.iterator().next();
            String rightRootId = rightRoot.getString("id");
            String name = rightRoot.getString("name");
            rootRight = new TreeNode();
            rootRight.setId(rightRootId);
            rootRight.setText(rightRoot.getString("number") + " " + name);
            Map<String, String> memberMap = this.createMap(rightRoot);
            memberMap.put(MEMBERID, rightRoot.getString(MEMBERID));
            rootRight.setData(memberMap);
        }
        List<Map<String, String>> memberMapList = this.createMemberMapList(members);
        HashMap<String, String> rightIds = new HashMap<String, String>(16);
        this.setTreeNode(rootRight, memberMapList, rightIds);
        this.cacheIdsMap("righttreeids", rightIds);
        tree.addNode(rootRight);
        this.setTreeCache("righttreeview", rootRight);
        tree.checkNode(TreeNodeUtils.getBaseClone((TreeNode)rootRight));
        this.getPageCache().put("right_rootNodeId", rootRight.getId());
        rootRight.setIsOpened(true);
    }

    private void createLeftViewTree(Long baseView) {
        TreeView tree = (TreeView)this.getControl("lefttreeview");
        tree.deleteAllNodes();
        TreeNode rootLeft = new TreeNode();
        Long dimensionId = this.getDimensionId();
        if (dimensionId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u5931\u8d25", (String)"OrganizationViewEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection members = this.getViewExistDimMembers(baseView, true);
        DynamicObject leftRoot = (DynamicObject)members.iterator().next();
        String leftRootId = leftRoot.getString("id");
        String name = leftRoot.getString("name");
        List<Map<String, String>> memberMapList = this.createMemberMapList(members, true);
        rootLeft.setId(leftRootId);
        rootLeft.setText(leftRoot.getString("number") + " " + name);
        Map<String, String> memberMap = this.createMap(leftRoot);
        memberMap.put("id", leftRoot.getString(MEMBERID));
        rootLeft.setData(memberMap);
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootLeft));
        HashMap<String, String> leftIds = new HashMap<String, String>(16);
        this.setTreeNode(rootLeft, memberMapList, leftIds);
        this.cacheIdsMap("lefttreeids", leftIds);
        tree.addNode(rootLeft);
        this.setTreeCache("lefttreeview", rootLeft);
        tree.focusNode(rootLeft);
        this.getPageCache().put("left_curNode", rootLeft.getId());
        this.getPageCache().put("left_rootNodeId", rootLeft.getId());
        rootLeft.setIsOpened(true);
    }

    private Long getAnalyzeByViewId() {
        Long analyzeByViewId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("analyzeByViewId"), (Long)0L);
        if (analyzeByViewId == 0L) {
            return DimensionViewServiceHelper.getInstance().queryBaseViewId(this.getModelId(), this.getDimensionId());
        }
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)analyzeByViewId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"usage,parent", (QFilter[])qfBuilder.toArray());
        if (query.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)query.get(0);
            String usage = dynamicObject.getString("usage");
            Long parent = dynamicObject.getLong("parent");
            if ("1".equals(usage) && IDUtils.isNotEmptyLong((Long)parent).booleanValue()) {
                return parent;
            }
        }
        return analyzeByViewId;
    }

    private void setVisibleAndEnable(boolean flse) {
        this.getView().setVisible(Boolean.valueOf(flse), new String[]{"contain", "flexrighttree", "advcontoolbarap", "flexsearchap", "flexplefttree"});
        this.getView().setVisible(Boolean.valueOf(!flse), new String[]{"flexpanelap161"});
        this.getView().setVisible(Boolean.valueOf(flse), new String[]{"flexpanelapscope"});
        this.getView().setEnable(Boolean.valueOf(flse), new String[]{"combofield"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contain"});
        this.getModel().setValue("contain", (Object)flse);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
    }

    private void putCacheNewView(String id) {
        String newViewList = this.getPageCache().get("newViewList");
        if (StringUtils.isNotEmpty((String)newViewList)) {
            List newView = (List)SerializationUtils.deSerializeFromBase64((String)newViewList);
            newView.add(id);
            this.getPageCache().put("newViewList", SerializationUtils.serializeToBase64((Object)newView));
        } else {
            ArrayList<String> newView = new ArrayList<String>(16);
            newView.add(id);
            this.getPageCache().put("newViewList", SerializationUtils.serializeToBase64(newView));
        }
    }

    private boolean isUsage() {
        return "0".equalsIgnoreCase((String)this.getModel().getValue("usage"));
    }

    private boolean checkUsedInBizModel(Long viewId) {
        boolean hasRefByBusModel = false;
        try (DataSet ds = DB.queryDataSet((String)"queryRefBusModel", (DBRoute)BgBaseConstant.epm, (String)"select top 1 fviewid from t_eb_viewentry where fviewid = ?", (Object[])new Object[]{viewId});){
            if (ds != null && ds.hasNext()) {
                hasRefByBusModel = true;
            }
        }
        return hasRefByBusModel;
    }

    private DynamicObjectCollection getViewExistDimMembers(Long viewId, boolean isLeftTree) {
        QFilter viewQf = new QFilter("view", "=", (Object)viewId);
        viewQf.and(new QFilter("model", "=", (Object)this.getModelId()));
        if (SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber())) {
            viewQf.and(new QFilter("isoffsetentry", "=", (Object)false));
        }
        Boolean showDisable = (Boolean)this.getModel().getValue("cbshowdisable");
        if (isLeftTree && !showDisable.booleanValue()) {
            viewQf.and("disable", "=", (Object)false);
        }
        QFilter[] filters = new QFilter[]{viewQf};
        String selectFields = "id,memberid,number,name,simplename,longnumber,parent,level,isleaf,aggoprt,dseq,enable,status,isinnerorg,isouterorg,mergernode,membersource,disable";
        if (!this.isCopy()) {
            selectFields = selectFields + ",syncstatus,syncdate";
        }
        return QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])filters, (String)"parent,dseq");
    }

    protected boolean isUserDimension() {
        return "epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)this.getDimensionNumber()));
    }

    protected Map<String, TreeNode> getNodesByLevel(TreeNode root, int targetLevelCount) {
        LinkedHashMap<String, TreeNode> nodeMap = new LinkedHashMap<String, TreeNode>(1000);
        if (root == null) {
            return nodeMap;
        }
        int level = 0;
        if (level == targetLevelCount) {
            nodeMap.put(root.getId(), root);
            return nodeMap;
        }
        TreeNode nextLevelFirstNode = root;
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            TreeNode head = (TreeNode)queue.poll();
            if (nextLevelFirstNode != null && Objects.equals(head.getId(), nextLevelFirstNode.getId())) {
                ++level;
                nextLevelFirstNode = null;
            }
            if (level > targetLevelCount + 1) {
                return nodeMap;
            }
            nodeMap.put(head.getId(), head);
            if (head.getChildren() == null || head.getChildren().size() <= 0) continue;
            for (TreeNode child : head.getChildren()) {
                queue.offer(child);
                if (nextLevelFirstNode != null) continue;
                nextLevelFirstNode = child;
            }
        }
        return nodeMap;
    }

    protected void initLeftTree() {
        this.removeLeftSearchText();
        TreeView tree = (TreeView)this.getControl("lefttreeview");
        tree.deleteAllNodes();
        TreeNode rootLeft = new TreeNode();
        Long dimensionId = this.getDimensionId();
        if (dimensionId == null || dimensionId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u5931\u8d25", (String)"OrganizationViewEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = "id,number,name,longnumber,parent,level,isleaf,aggoprt,dseq,enable,status,membersource,disable";
        DynamicObjectCollection members = this.getRootViewDimMembers(dimensionId, selectFields, true);
        if (members.isEmpty()) {
            return;
        }
        DynamicObject leftRoot = (DynamicObject)members.iterator().next();
        String leftRootId = leftRoot.getString("id");
        String name = leftRoot.getString("name");
        List<Map<String, String>> memberMapList = this.createMemberMapList(members, false);
        rootLeft.setId(leftRootId);
        rootLeft.setText(leftRoot.getString("number") + " " + name);
        rootLeft.setData(this.createMap(leftRoot));
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootLeft));
        HashMap<String, String> leftIds = new HashMap<String, String>(memberMapList.size());
        this.setTreeNode(rootLeft, memberMapList, leftIds);
        this.cacheIdsMap("lefttreeids", leftIds);
        tree.addNode(rootLeft);
        this.setTreeCache("lefttreeview", rootLeft);
        this.cacheBaseTreeNode(dimensionId, selectFields);
        this.getPageCache().put("left_curNode", rootLeft.getId());
        this.getPageCache().put("left_rootNodeId", rootLeft.getId());
        rootLeft.setIsOpened(true);
        tree.focusNode(TreeNodeUtils.getBaseClone((TreeNode)rootLeft));
    }

    protected void cacheBaseTreeNode(Long dimensionId, String selectFields) {
        TreeNode rootLeft = new TreeNode();
        DynamicObjectCollection members = this.getRootViewDimMembers(dimensionId, selectFields, false);
        if (members.isEmpty()) {
            return;
        }
        DynamicObject leftRoot = (DynamicObject)members.iterator().next();
        String leftRootId = leftRoot.getString("id");
        String name = leftRoot.getString("name");
        List<Map<String, String>> memberMapList = this.createMemberMapList(members, false);
        rootLeft.setId(leftRootId);
        rootLeft.setText(leftRoot.getString("number") + " " + name);
        rootLeft.setData(this.createMap(leftRoot));
        HashMap<String, String> leftIds = new HashMap<String, String>(memberMapList.size());
        this.setTreeNode(rootLeft, memberMapList, leftIds);
        this.setTreeCache("baseNode", rootLeft);
    }

    protected void cacheIdsMap(String number, Map<String, String> nodeIds) {
        this.getPageCache().put(number, SerializationUtils.toJsonString(nodeIds));
    }

    protected void setTreeCache(String treeNumber, TreeNode root) {
        F7TreeUtils.cacheTreeNodeData((IPageCache)this.getPageCache(), (String)treeNumber, (TreeNode)root);
    }

    protected TreeNode getCacheTree(String treeNumber) {
        return F7TreeUtils.getCacheTreeNodeData((IPageCache)this.getPageCache(), (String)treeNumber);
    }

    protected List<Map<String, String>> createMemberMapList(DynamicObjectCollection dynamicObjects, boolean isFromView) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Map<String, String> memberMap = this.createMap(dynamicObject);
            if (isFromView) {
                memberMap.put(MEMBERID, dynamicObject.getString(MEMBERID));
            }
            list.add(memberMap);
        }
        return list;
    }

    protected List<Map<String, String>> createMemberMapList(DynamicObjectCollection dynamicObjects) {
        Map<String, String> memberMap = null;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(dynamicObjects.size());
        ArrayList<Map<String, String>> toUpdateMemberIds = new ArrayList<Map<String, String>>(16);
        HashMap<String, Map<String, String>> copyMap = new HashMap<String, Map<String, String>>(16);
        boolean copy = this.isCopy();
        for (DynamicObject dynamicObject : dynamicObjects) {
            memberMap = this.createMap(dynamicObject);
            String aggoprt = dynamicObject.getString("aggoprt");
            if (StringUtils.isNotEmpty((String)aggoprt)) {
                memberMap.put(MEMBERID, dynamicObject.getString(MEMBERID));
            }
            String memberSource = memberMap.get("membersource");
            String userDefined = this.getPageCache().get("NoneNumber");
            if (StringUtils.isNotEmpty((String)userDefined)) {
                if ("1".equals(memberSource) && !memberMap.get("number").equals(userDefined)) {
                    copyMap.put(memberMap.get("number"), memberMap);
                    this.putCacheNewView(memberMap.get("id"));
                    if (copy) {
                        toUpdateMemberIds.add(memberMap);
                    }
                }
            } else if ("1".equals(memberSource)) {
                copyMap.put(memberMap.get("number"), memberMap);
                this.putCacheNewView(memberMap.get("id"));
                if (copy) {
                    toUpdateMemberIds.add(memberMap);
                }
            }
            list.add(memberMap);
        }
        int size = toUpdateMemberIds.size();
        if (size != 0) {
            long[] pkIds = DB.genGlobalLongIds((int)size);
            for (int i = 0; i < toUpdateMemberIds.size(); ++i) {
                Map memberMap_toReplace = (Map)toUpdateMemberIds.get(i);
                memberMap_toReplace.put(MEMBERID, String.valueOf(pkIds[i]));
            }
        }
        if (copy && copyMap.size() != 0) {
            this.replaceCopyNumAndName(copyMap);
        }
        return list;
    }

    private void replaceCopyNumAndName(Map<String, Map<String, String>> copyMap) {
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)this.getDimensionId());
        qFilter.and(this.getNumberQFilter(copyMap));
        HashMap<String, Long> memberIndexMap = new HashMap<String, Long>(16);
        DynamicObjectCollection viewMembers = QueryServiceHelper.query((String)"eb_viewmember", (String)"number", (QFilter[])new QFilter[]{qFilter});
        block0: for (DynamicObject viewMember : viewMembers) {
            String number = viewMember.getString("number");
            for (Map.Entry<String, Map<String, String>> entry : copyMap.entrySet()) {
                String memberNumber = entry.getKey();
                String copyNumber = memberNumber + "copy";
                String replace = number.replace(copyNumber, "");
                Long indexKey = 0L;
                Long index = memberIndexMap.getOrDefault(memberNumber, 0L);
                if (StringUtils.isNotEmpty((String)replace)) {
                    if (ExecuteAnalyseUtil.getInstance().isNotLong(replace)) continue;
                    indexKey = ConvertUtils.toLong((Object)replace);
                }
                if (index > indexKey) continue;
                index = indexKey + 1L;
                memberIndexMap.put(memberNumber, index);
                continue block0;
            }
        }
        for (Map.Entry<String, Map<String, String>> entry : copyMap.entrySet()) {
            String memberNumber = entry.getKey();
            Map<String, String> memberInfo = entry.getValue();
            String copyNumber = "copy";
            Long index = (Long)memberIndexMap.get(memberNumber);
            if (index != null) {
                copyNumber = copyNumber + index;
            }
            String number = memberInfo.get("number") + copyNumber;
            String name = memberInfo.get("name");
            memberInfo.put("number", this.limitLength(number, 50));
            memberInfo.put("name", this.limitLength(name, 50));
        }
    }

    private QFilter getNumberQFilter(Map<String, Map<String, String>> copyMap) {
        QFilter qFilter = null;
        for (String memberNumber : copyMap.keySet()) {
            String copyNumber = memberNumber + "copy%";
            if (qFilter == null) {
                qFilter = new QFilter("number", "like", (Object)copyNumber);
                continue;
            }
            qFilter.or("number", "like", (Object)copyNumber);
        }
        return qFilter;
    }

    protected Map<String, String> createMap(DynamicObject dynamicObject) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        memberMap.put("id", dynamicObject.getString("id"));
        memberMap.put("number", dynamicObject.getString("number"));
        memberMap.put("name", dynamicObject.getString("name"));
        memberMap.put("longnumber", dynamicObject.getString("longnumber"));
        memberMap.put("parent", dynamicObject.getString("parent"));
        memberMap.put(LEVEL, dynamicObject.getString(LEVEL));
        memberMap.put("isleaf", dynamicObject.getString("isleaf"));
        memberMap.put("aggoprt", dynamicObject.getString("aggoprt"));
        memberMap.put("dseq", dynamicObject.getString("dseq"));
        memberMap.put("enable", dynamicObject.getString("enable"));
        memberMap.put("status", dynamicObject.getString("status"));
        memberMap.put("membersource", dynamicObject.getString("membersource"));
        try {
            memberMap.put("disable", dynamicObject.getString("disable"));
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"simplename")) {
            memberMap.put("simplename", dynamicObject.getString("simplename"));
        }
        return memberMap;
    }

    protected DynamicObjectCollection getRootViewDimMembers(Long dimId, String selectFields, boolean checkDisable) {
        String dimensionNumber;
        String entity;
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)dimId);
        builder.and("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        builder.and("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        Boolean showDisable = (Boolean)this.getModel().getValue("cbshowdisable");
        if (checkDisable && !showDisable.booleanValue()) {
            builder.and("disable", "=", (Object)false);
        }
        if (SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber())) {
            builder.and("isoffsetentry", "=", (Object)false);
        }
        if ((entity = DimensionServiceHelper.getMemberKeyByDimNum((String)(dimensionNumber = this.getDimensionNumber()))).equals("epm_userdefinedmembertree")) {
            this.getNoneMember();
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) || !SysDimensionEnum.include((String)dimensionNumber, (Boolean)true)) {
            selectFields = selectFields + ",simplename";
        }
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])builder.toArray(), (String)"level,dseq,number");
    }

    protected String getDimensionNumber() {
        String dimensionNumber = this.getPageCache().get("dimensionNumber");
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            DynamicObject dimension = null;
            try {
                dimension = (DynamicObject)this.getModel().getValue("dimension");
            }
            catch (Throwable e) {
                log.info("{}", (Object)e);
            }
            if (dimension == null && IDUtils.isNotNull((Long)this.getDimensionId())) {
                dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimensionId(), (String)"epm_dimension", (String)"id,number");
            }
            if (dimension != null) {
                dimensionNumber = dimension.getString("number");
            }
            this.getPageCache().put("dimensionNumber", dimensionNumber);
        }
        return dimensionNumber;
    }

    @Override
    public Long getDimensionId() {
        String dimensionId = this.getPageCache().get("dimensionId");
        if (StringUtils.isEmpty((String)dimensionId)) {
            try {
                DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
                dimensionId = dimension.getString("id");
            }
            catch (Throwable e) {
                log.info("{}", (Object)e);
            }
            if (StringUtils.isEmpty((String)dimensionId)) {
                dimensionId = StringUtils.toNoEmptyString((Object)this.getView().getFormShowParameter().getCustomParam("dimensionId"));
            }
            this.getPageCache().put("dimensionId", dimensionId);
        }
        return Long.valueOf(dimensionId);
    }

    protected Long getViewId() {
        Long viewId = null;
        String _viewId = this.getPageCache().get("viewId");
        if (StringUtils.isNotEmpty((String)_viewId)) {
            viewId = Long.valueOf(_viewId);
        }
        return viewId;
    }

    protected TreeNode setTreeNode(TreeNode root, List<Map<String, String>> rootNodeList, Map<String, String> numberMap) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(512);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parent");
            numberMap.put(node.get("number"), node.get("id"));
            List nodeList = nodeMap.computeIfAbsent(parentId, k -> new ArrayList());
            nodeList.add(node);
        }
        return this.createNode(root, nodeMap);
    }

    protected TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap) {
        List<Map<String, String>> list = nodeMap.get(root.getId());
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(16);
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                TreeNode entry = new TreeNode();
                entry.setParentid(root.getId());
                entry.setId(map.get("id"));
                entry.setText(map.get("number") + " " + map.get("name"));
                entry.setData(map);
                String membersource = map.get("membersource");
                String userdefined = this.getPageCache().get("NoneNumber");
                if (StringUtils.isNotEmpty((String)userdefined)) {
                    if ("1".equals(membersource) && !map.get("number").equals(userdefined)) {
                        entry.setColor("#5797ff");
                    }
                } else if ("1".equals(membersource)) {
                    entry.setColor("#5797ff");
                }
                this.createNode(entry, nodeMap);
                children.add(entry);
            }
        }
        return root;
    }

    @Override
    public Long getModelId() {
        String model = this.getPageCache().get("model");
        if (model == null) {
            return 0L;
        }
        return Long.valueOf(model);
    }

    private void selectCountAnalyseView() {
        if (this.isUsage()) {
            this.getPageCache().put("sign", "1");
            this.getModel().setValue("combofield", (Object)"0");
            this.getPageCache().remove("sign");
            this.setVisibleAndEnable(false);
            this.initLeftTree();
        } else {
            Long analyzeByViewId = this.getAnalyzeByViewId();
            if (!this.isAnalyzeIdBybaseId(analyzeByViewId)) {
                DynamicObject view = BusinessDataServiceHelper.loadSingle((Object)analyzeByViewId, (String)"eb_dimensionview");
                String usageView = view.getString("usage");
                if ("0".equals(usageView)) {
                    this.createLeftViewTree(analyzeByViewId);
                    this.setComboEdit(view);
                    this.setComboEditItems(view);
                } else {
                    DynamicObject parent = (DynamicObject)view.get("parent");
                    this.createLeftViewTree(parent.getLong("id"));
                    this.setComboEdit(parent);
                    this.setComboEditItems(parent);
                }
                this.setVisibleAndEnable(true);
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexrighttree", "advcontoolbarap", "flexsearchap", "flexplefttree"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap161"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapscope"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"combofield"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"contain"});
                this.getModel().setValue("contain", (Object)true);
            }
            String cacheTree = this.getPageCache().get("righttreeview");
            if (StringUtils.isEmpty((String)cacheTree)) {
                this.initRightTree();
            }
        }
    }

    private boolean isCopy() {
        String isCopy = this.getPageCache().get("isCopy");
        return StringUtils.isNotEmpty((String)isCopy);
    }

    @Override
    public MemberF7Parameter getF7Parameter() {
        Long modelId = this.getModelId();
        Long dimensionId = this.getDimensionId();
        String dimensionNumber = this.getDimensionNumber();
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setModelId(modelId);
        f7Param.setDimensionId(dimensionId);
        f7Param.setDimensionNumber(dimensionNumber);
        if (IDUtils.isNotNull((Long)this.getViewId())) {
            f7Param.setViewId(this.getViewId());
        }
        f7Param.setVerifyPermission(false);
        f7Param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
        f7Param.setCusRange((List)Lists.newArrayList((Object[])new String[]{RangeEnum.ONLY.getIndStr(), RangeEnum.DIRECTSUB_EXCLUDE.getIndStr(), RangeEnum.DIRECTSUB.getIndStr(), RangeEnum.ALL_EXCLUDE.getIndStr(), RangeEnum.ALL.getIndStr(), RangeEnum.ALL_DETAIL.getIndStr(), RangeEnum.ALL_NOTDETAIL.getIndStr()}));
        f7Param.setDefRangeValue(RangeEnum.ALL);
        f7Param.setShowCustomProperty(true);
        return f7Param;
    }

    @Override
    public SearchControlPojo getMemberTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getMemberTreePojo();
        pojo.setTreeKey("lefttreeview");
        pojo.setSearchKey("searchapleft");
        pojo.setDownKey(LEFT_NEXT);
        pojo.setUpKey(LEFT_PRE);
        pojo.setTreeCacheKey("lefttreeview");
        return pojo;
    }

    @Override
    public SearchControlPojo getPropertyTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getPropertyTreePojo();
        pojo.setTreeCacheKey("CACHE_TREE_PROPERTY_NODE_DATA");
        return pojo;
    }

    @Override
    public SearchControlPojo getRightTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getRightTreePojo();
        pojo.setTreeCacheKey(MemberTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).setTreeKey("righttreeview").getCacheTreeKey());
        return pojo;
    }
}

