/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.view;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class SelectBizModelDimPlugin
extends AbstractFormPlugin {
    private static final String MODEL = "model";
    private static final String BILLLIST = "billlistap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addPagerClickListener(new PagerClickListener(){

            public void pagerClick(PagerClickEvent pagerClickEvent) {
                SelectBizModelDimPlugin.this.refreshBillList();
            }
        });
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter qFilter = SelectBizModelDimPlugin.this.getqFilter();
                setFilterEvent.getQFilters().add(qFilter);
            }
        });
    }

    private QFilter getqFilter() {
        QFilter qFilter = null;
        qFilter = this.getPageCache().get(MODEL) != null ? new QFilter(MODEL, "=", (Object)Long.parseLong(this.getPageCache().get(MODEL))) : new QFilter(MODEL, "=", (Object)-1);
        if (this.getPageCache().get("Qflters") != null) {
            List qFilters1 = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("Qflters"));
            for (QFilter qf : qFilters1) {
                qFilter.and(qf);
            }
        }
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String modelId = (String)view.getFormShowParameter().getCustomParam(MODEL);
        this.getPageCache().put(MODEL, modelId);
        String qfs = (String)view.getFormShowParameter().getCustomParam("Qflters");
        if (StringUtils.isNotEmpty((String)qfs)) {
            this.getPageCache().put("Qflters", qfs);
        }
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        QFilter qFilter = this.getqFilter();
        billList.setFilter(qFilter);
        billList.setClearSelection(true);
        billList.refresh();
        billList.setOrderBy("dseq");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_confirm".equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectBizModelDimPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
            ArrayList<String> dimInfo = new ArrayList<String>(selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                ids.add((Long)row.getPrimaryKeyValue());
                dimInfo.add(row.getName() + '-' + row.getNumber());
            }
            if (this.isControlDimPage()) {
                this.maxSize(ids);
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e1a\u52a1\u6a21\u578b\u589e\u52a0\u7ef4\u5ea6", "SelectBizModelDimPlugin_2", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4e1a\u52a1\u6a21\u578b\u589e\u52a0\u7ef4\u5ea6(%1$s)", "SelectBizModelDimPlugin_3", "epm-eb-formplugin");
            this.writeLog(null, "save", opName, opDescription, new String[]{StringUtils.join(dimInfo, (char)',')});
            this.getView().returnDataToParent(ids);
            this.getView().close();
        }
    }

    private void maxSize(List<Long> ids) {
        Object size = this.getView().getFormShowParameter().getCustomParam("size");
        int maxSize = ids.size();
        if (size != null) {
            maxSize += ((Integer)size).intValue();
        }
        if (maxSize > 6) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u9009\u62e96\u4e2a\u81ea\u5b9a\u4e49\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SelectBizModelDimPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean isControlDimPage() {
        return "eb_bgmcontroldimension".equals(this.getView().getParentView().getEntityId());
    }
}

