/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.easupgrades;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.EASBudgetUpgradeImpl;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.enums.Status;
import kd.epm.eb.business.easupgrade.enums.UpgradeStatus;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.EasUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasDataUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeService;
import kd.epm.eb.business.easupgrade.sync.BaseDataSyncImpl;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.exception.EpmBizException;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class EasUpgradeFormPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(EasUpgradeFormPlugin.class);
    public static final String F7_EAS_DB = "easdb";
    public static final String DATASOURCE = "datasource";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BTN_MEM_UP_CHECK = "btn_memupcheck";
    private static final String BTN_DATA_UP_CHECK = "btn_dataupcheck";
    private static final String BTN_UP_MEMBER = "btn_upmember";
    private static final String BTN_UP_DATA = "btn_updata";
    private static final String BTN_UP_ALL = "btn_upall";
    private static final String BTN_MEM_UP_RECORD = "btn_memuprecord";
    private static final String BTN_DATA_UP_RECORD = "btn_datauprecord";
    private static final String BTN_COLLECT_DATA = "btn_collectdata";
    private static final String BTN_MEM_MAPPING = "btn_memmapping";
    private static final String BTN_EAS_CONNECT = "btn_easconnect";
    private static final String BTN_EAS_DB = "btn_easdb";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_SYNC = "btn_sync";
    private static final String BTN_TABLE_SYNC_LOG = "btn_table_sync_log";
    private static final String BTN_UP_LOG = "btn_up_log";
    private static final String BTN_DATA_UP_LOG = "btn_data_up_log";
    private static final String BTN_RESET_MEMBER = "reset_member";
    private static final String BTN_RESET_DATA = "reset_data";
    private static final EasUpgradeService easUpgradeService = EasUpgradeService.getInstance();
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
    public static final String ENTRYENTITY = "billlistap";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultEasDataCenter();
        this.setDefaultEpmDataSource();
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
    }

    public void setFilter(SetFilterEvent e) {
        Long esDbId = 0L;
        try {
            esDbId = this.getEasDbId();
        }
        catch (EpmBizException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        if (IDUtils.isNotNull((Long)esDbId)) {
            String dataCenter = EASUpgradeUtils.getDataCenter((Long)esDbId);
            e.getQFilters().add(new QFilter(F7_EAS_DB, "=", (Object)esDbId));
            e.getQFilters().add(new QFilter("datacenter", "=", (Object)dataCenter));
        } else {
            e.getQFilters().add(new QFilter(F7_EAS_DB, "=", (Object)esDbId));
        }
    }

    private void setDefaultEasDataCenter() {
        DynamicObjectCollection dynamicObjects = easUpgradeService.getEasDataSources(this.getEasdbtoCache());
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u51fa\u7b26\u5408\u8981\u6c42\u7684EAS\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u6570EAS\u6570\u636e\u6e90\u3002", (String)"EasUpgradeFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            long easDbId = ((DynamicObject)dynamicObjects.get(0)).getLong("id");
            this.getModel().setValue(F7_EAS_DB, (Object)easDbId);
            this.putEasdbtoCache(easDbId);
        }
    }

    private void setDefaultEpmDataSource() {
        String datasourceId = (String)cache.get(DATASOURCE + UserUtils.getUserId());
        if (StringUtils.isNotEmpty((String)datasourceId)) {
            this.getModel().setValue("DATASOURCE", (Object)Long.parseLong(datasourceId));
        }
    }

    private void putEasdbtoCache(long easDbId) {
        cache.put(F7_EAS_DB + UserUtils.getUserId(), (Object)String.valueOf(easDbId));
    }

    private long getEasdbtoCache() {
        String seasDbStr = (String)cache.get(F7_EAS_DB + UserUtils.getUserId());
        if (StringUtils.isNotEmpty((String)seasDbStr)) {
            return Long.parseLong(seasDbStr);
        }
        return 0L;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_memupcheck": {
                this.upgradeCheck("mem_upgrade_check");
                break;
            }
            case "btn_dataupcheck": {
                this.upgradeCheck("data_upgrade_check");
                break;
            }
            case "btn_upmember": {
                this.upgradeMember();
                break;
            }
            case "btn_updata": {
                this.upgradeData();
                break;
            }
            case "btn_upall": {
                this.upgradeAll();
                break;
            }
            case "btn_memuprecord": {
                this.memberUpgradeRecord();
                break;
            }
            case "btn_datauprecord": {
                this.dataUpgradeRecord();
                break;
            }
            case "btn_collectdata": {
                this.openDataIntegrationForm();
                break;
            }
            case "btn_memmapping": {
                this.openMemberMappingFrom();
                break;
            }
            case "btn_easconnect": {
                this.easConnect();
                break;
            }
            case "btn_easdb": {
                this.easDb();
                break;
            }
            case "btn_refresh": {
                this.refreshUpgradeRecordList();
                break;
            }
            case "btn_sync": {
                this.syncModel();
                break;
            }
            case "btn_table_sync_log": {
                this.openTableSyncLogForm();
                break;
            }
            case "btn_up_log": {
                this.openUpLog();
                break;
            }
            case "btn_data_up_log": {
                this.openDataUpLog();
                break;
            }
            case "reset_member": {
                this.resetMember();
                break;
            }
            case "reset_data": {
                this.resetData();
                break;
            }
        }
    }

    private void resetMember() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        selectedUpgradeModel.set("memupstatus", (Object)UpgradeStatus.NO.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectedUpgradeModel});
        this.refreshUpgradeRecordList();
    }

    private void resetData() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        selectedUpgradeModel.set("dataupstatus", (Object)UpgradeStatus.NO.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectedUpgradeModel});
        this.refreshUpgradeRecordList();
    }

    private void openUpLog() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        int memUpStatus = selectedUpgradeModel.getInt("memupstatus");
        if (memUpStatus != UpgradeStatus.ING.getVal() && memUpStatus != UpgradeStatus.SUCCEED.getVal() && memUpStatus != UpgradeStatus.FAILED.getVal()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6210\u5458\u5347\u7ea7\u72b6\u6001\u4e3a\u201c\u5347\u7ea7\u4e2d\u3001\u5df2\u5347\u7ea7\u3001\u5347\u7ea7\u5931\u8d25\u201d\u7684\u8bb0\u5f55\u67e5\u770b\u6210\u5458\u5347\u7ea7\u65e5\u5fd7\u3002", (String)"EasUpgradeFormPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{""}));
            return;
        }
        Long upgrademodelId = this.getSelectedUpgradeModelId(selectedUpgradeModel);
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setStatus(OperationStatus.VIEW);
        lsp.setBillFormId("eb_eas_upgrade_log");
        lsp.setPageId(lsp.getBillFormId() + "_" + this.getView().getPageId() + upgrademodelId);
        lsp.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("upgrademodel", "=", (Object)upgrademodelId)));
        lsp.getListFilterParameter().setOrderBy("dimuplog.easdimnumber");
        lsp.setCustomParam("upgrademodel", (Object)upgrademodelId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openDataUpLog() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        int memUpStatus = selectedUpgradeModel.getInt("dataupstatus");
        if (memUpStatus != UpgradeStatus.ING.getVal() && memUpStatus != UpgradeStatus.SUCCEED.getVal() && memUpStatus != UpgradeStatus.FAILED.getVal()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5347\u7ea7\u72b6\u6001\u4e3a\u201c\u5347\u7ea7\u4e2d\u3001\u5df2\u5347\u7ea7\u3001\u5347\u7ea7\u5931\u8d25\u201d\u7684\u8bb0\u5f55\u67e5\u770b\u6570\u636e\u5347\u7ea7\u65e5\u5fd7\u3002", (String)"EasUpgradeFormPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{""}));
            return;
        }
        Long upgrademodelId = this.getSelectedUpgradeModelId(selectedUpgradeModel);
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setStatus(OperationStatus.VIEW);
        lsp.setBillFormId("eb_eas_data_upgrade_log");
        lsp.setPageId(lsp.getBillFormId() + "_" + this.getView().getPageId() + upgrademodelId);
        lsp.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("upgrademodel", "=", (Object)upgrademodelId)));
        lsp.setCustomParam("upgrademodel", (Object)upgrademodelId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openTableSyncLogForm() {
        Long easDbId = this.getEasDbId();
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setStatus(OperationStatus.VIEW);
        lsp.setBillFormId("eb_eas_table_sync_log");
        lsp.setPageId(lsp.getBillFormId() + "_" + this.getView().getPageId() + easDbId);
        lsp.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(F7_EAS_DB, "=", (Object)easDbId)));
        lsp.setCustomParam(F7_EAS_DB, (Object)easDbId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openDataIntegrationForm() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        Long easDbId = this.getSelectedEasDbId(selectedUpgradeModel);
        String easModelId = this.getSelectedEasModelId(selectedUpgradeModel);
        ListShowParameter fsp = new ListShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setFormId("eb_integrationlist");
        fsp.setBillFormId("eb_integration");
        fsp.setPageId(fsp.getFormId() + "_" + this.getView().getPageId() + easDbId + easModelId);
        fsp.setCustomParam("easdbId", (Object)easDbId);
        fsp.setCustomParam("easModelID", (Object)easModelId);
        fsp.setCustomParam("easModelNumber", (Object)this.getSelectedEasModelNumber(selectedUpgradeModel));
        String selectedEasModelName = this.getSelectedEasModelName(selectedUpgradeModel);
        fsp.setCustomParam("easModelName", (Object)selectedEasModelName);
        fsp.setCaption(ResManager.loadResFormat((String)"EAS-%1\u6570\u636e\u96c6\u6210", (String)"EasUpgradeFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{selectedEasModelName}));
        fsp.setShowTitle(true);
        DynamicObject modelLog = EasUpgradeLogService.getInstance().get(this.getSelectedUpgradeModelId(selectedUpgradeModel));
        if (modelLog != null) {
            long modelId = modelLog.getLong("model.id");
            fsp.setCustomParam("modelId", (Object)modelId);
        }
        if (this.getView().getPageCache().get("notSyncData") == null) {
            BaseDataSyncImpl sync = new BaseDataSyncImpl();
            DynamicObject srcDsObject = sync.createSrcDsObject(easDbId, this.getSelectedRefcube(selectedUpgradeModel));
            fsp.setCustomParam("srcDsId", (Object)srcDsObject.getLong("id"));
        }
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void openMemberMappingFrom() {
        if (this.checkSelOne()) {
            return;
        }
        ListShowParameter fsp = new ListShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setFormId("eb_integration_maplist");
        fsp.setShowTitle(true);
        DynamicObject modelLog = EasUpgradeLogService.getInstance().get(this.getSelectedUpgradeModelId(this.getSelectedUpgradeModel()));
        if (modelLog != null) {
            long modelId = modelLog.getLong("model.id");
            fsp.setCustomParam("modelId", (Object)modelId);
        }
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void syncModel() {
        DynamicObject easdb = (DynamicObject)this.getModel().getValue(F7_EAS_DB);
        Long easDbId = this.getEasDbId();
        easUpgradeService.checkVersion(easDbId);
        BaseDataSyncImpl sync = new BaseDataSyncImpl();
        try {
            cache.put("eassync" + easDbId, (Object)"1", 600);
            this.writeLog(null, null, new MultiLangEnumBridge("\u540c\u6b65EAS\u9884\u7b97\u6a21\u578b", "EasUpgradeFormPlugin_37", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f00\u59cb\u540c\u6b65EAS\u9884\u7b97\u6a21\u578b\u3002", "EasUpgradeFormPlugin_38", "epm-eb-formplugin"), null);
            for (String upgradeTable : EasUpgradeConstants.UPGRADE_TABLES) {
                if ("T_SYS_DATACENTER".equals(upgradeTable)) continue;
                sync.start(easDbId, upgradeTable);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            cache.remove("eassync" + easDbId);
        }
        easUpgradeService.easModeltoEbModel(easDbId);
        this.refreshUpgradeRecordList();
    }

    private Long getEasDbId() {
        DynamicObject easdb = (DynamicObject)this.getModel().getValue(F7_EAS_DB);
        if (easdb == null) {
            throw new EpmBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2aEAS\u6570\u636e\u6e90\u3002", (String)"EasUpgradeFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return easdb.getLong("id");
    }

    private String getCurSelBudgetModelNumber() {
        return (String)this.getModel().getValue("number");
    }

    private void upgradeCheck(String type) {
        if (this.checkSelOne()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_easupgradeinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String caption = "mem_upgrade_check".equals(type) ? ResManager.loadKDString((String)"\u6210\u5458\u5347\u7ea7\u68c0\u67e5", (String)"EasUpgradeFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u68c0\u67e5", (String)"EasUpgradeFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("type", (Object)type);
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        formShowParameter.setCustomParam("easDbId", (Object)this.getSelectedEasDbId(selectedUpgradeModel));
        formShowParameter.setCustomParam("easModelId", (Object)this.getSelectedEasModelId(selectedUpgradeModel));
        this.getView().showForm(formShowParameter);
    }

    private void upgradeMember() {
        Long dataSourceId = this.getSelectEpmDataSourceId();
        if (IDUtils.isNull((Long)dataSourceId)) {
            return;
        }
        this.checkInSync();
        DynamicObject[] selectedRows = this.getSelectedDys();
        boolean hasMemSuccess = false;
        boolean hasDataSuccess = false;
        for (DynamicObject selectedRow : selectedRows) {
            int memUpStatus = selectedRow.getInt("memupstatus");
            int dataupsStatus = selectedRow.getInt("dataupstatus");
            String number = selectedRow.getString("number");
            if (memUpStatus == UpgradeStatus.ING.getVal() || memUpStatus == UpgradeStatus.WAIT.getVal() || dataupsStatus == UpgradeStatus.ING.getVal() || dataupsStatus == UpgradeStatus.WAIT.getVal()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u9884\u7b97\u6a21\u578b\u6b63\u5728\u5347\u7ea7\u6216\u6b63\u5728\u7b49\u5f85\u5347\u7ea7\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5347\u7ea7\u64cd\u4f5c\u3002", (String)"EasUpgradeFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                return;
            }
            if (memUpStatus == UpgradeStatus.SUCCEED.getVal()) {
                hasMemSuccess = true;
            }
            if (dataupsStatus != UpgradeStatus.SUCCEED.getVal()) continue;
            hasDataSuccess = true;
        }
        if (hasDataSuccess) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u5305\u542b\u201c\u5df2\u5347\u7ea7\u201c\u7684\u9884\u7b97\u6a21\u578b\uff0c\u518d\u6b21\u6267\u884c\u5347\u7ea7\u4f1a\u8986\u76d6\u661f\u701a\u5df2\u5347\u7ea7\u7684\u6210\u5458\u548c\u6570\u636e\uff1b\u5347\u7ea7\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u7684\u6570\u636e\u53ca\u5173\u8054\u7684\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u5230\u661f\u701a\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u53ef\u901a\u8fc7\u201c\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u201d\u548c\u201c\u6570\u636e\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("memReUpgrade", (IFormPlugin)this));
        } else if (hasMemSuccess) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u5305\u542b\u6210\u5458\u5347\u7ea7\u72b6\u6001\u201c\u5df2\u5347\u7ea7\u201d\u7684\u9884\u7b97\u6a21\u578b\uff0c\u518d\u6b21\u6267\u884c\u5347\u7ea7\u6210\u5458\u4f1a\u8986\u76d6\u661f\u701a\u5df2\u5347\u7ea7\u7684\u6210\u5458\uff1b\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u5173\u8054\u7684\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u5347\u7ea7\u5230\u661f\u701a\uff0c\u65f6\u95f4\u8f83\u957f\uff0c\u53ef\u901a\u8fc7\u201c\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("memReUpgrade", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u5173\u8054\u7684\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u5347\u7ea7\u5230\u661f\u701a\uff0c\u65f6\u95f4\u8f83\u957f\uff0c\u53ef\u901a\u8fc7\u201c\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("memUpgrade", (IFormPlugin)this));
        }
    }

    private void upgradeData() {
        this.checkInSync();
        DynamicObject[] selectedRows = this.getSelectedDys();
        boolean hasSuccess = false;
        for (DynamicObject selectedRow : selectedRows) {
            int memUpStatus = selectedRow.getInt("memupstatus");
            int dataupsStatus = selectedRow.getInt("dataupstatus");
            String number = selectedRow.getString("number");
            if (memUpStatus == UpgradeStatus.FAILED.getVal() || memUpStatus == UpgradeStatus.NO.getVal()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9884\u7b97\u6a21\u578b\u201c%1\u201d\u6210\u5458\u672a\u5347\u7ea7\u6216\u5347\u7ea7\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6570\u636e\u5347\u7ea7\u64cd\u4f5c\u3002", (String)"EasUpgradeFormPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                return;
            }
            if (memUpStatus == UpgradeStatus.ING.getVal() || memUpStatus == UpgradeStatus.WAIT.getVal() || dataupsStatus == UpgradeStatus.ING.getVal() || dataupsStatus == UpgradeStatus.WAIT.getVal()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u9884\u7b97\u6a21\u578b\u6b63\u5728\u5347\u7ea7\u6216\u6b63\u5728\u7b49\u5f85\u5347\u7ea7\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5347\u7ea7\u64cd\u4f5c\u3002", (String)"EasUpgradeFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                return;
            }
            if (dataupsStatus != UpgradeStatus.SUCCEED.getVal()) continue;
            hasSuccess = true;
        }
        if (hasSuccess) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u5305\u542b\u6570\u636e\u5347\u7ea7\u72b6\u6001\u201c\u5df2\u5347\u7ea7\u201c\u7684\u9884\u7b97\u6a21\u578b\uff0c\u518d\u6b21\u6267\u884c\u5347\u7ea7\u6570\u636e\u4f1a\u8986\u76d6\u661f\u701a\u5df2\u5347\u7ea7\u7684\u6570\u636e\uff1b\u5347\u7ea7\u9009\u4e2d\u9884\u7b97\u6a21\u578b\u7684\u6570\u636e\u5230\u661f\u701a\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u53ef\u901a\u8fc7\u201d\u6570\u636e\u5458\u5347\u7ea7\u60c5\u51b5\u201c\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("dataReUpgrade", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u7684\u6570\u636e\u5230\u661f\u701a\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u53ef\u901a\u8fc7\u5728\u201c\u6570\u636e\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("dataUpgrade", (IFormPlugin)this));
        }
    }

    private void upgradeAll() {
        Long dataSourceId = this.getSelectEpmDataSourceId();
        if (IDUtils.isNull((Long)dataSourceId)) {
            return;
        }
        this.checkInSync();
        DynamicObject[] selectedRows = this.getSelectedDys();
        boolean hasSuccess = false;
        for (DynamicObject selectedRow : selectedRows) {
            int memUpStatus = selectedRow.getInt("memupstatus");
            int dataupsStatus = selectedRow.getInt("dataupstatus");
            String number = selectedRow.getString("number");
            if (memUpStatus == UpgradeStatus.ING.getVal() || memUpStatus == UpgradeStatus.WAIT.getVal() || dataupsStatus == UpgradeStatus.ING.getVal() || dataupsStatus == UpgradeStatus.WAIT.getVal()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u9884\u7b97\u6a21\u578b\u6b63\u5728\u5347\u7ea7\u6216\u6b63\u5728\u7b49\u5f85\u5347\u7ea7\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5347\u7ea7\u64cd\u4f5c\u3002", (String)"EasUpgradeFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                return;
            }
            if (memUpStatus == UpgradeStatus.SUCCEED.getVal()) {
                hasSuccess = true;
            }
            if (dataupsStatus != UpgradeStatus.SUCCEED.getVal()) continue;
            hasSuccess = true;
        }
        if (hasSuccess) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u5305\u542b\u201c\u5df2\u5347\u7ea7\u201c\u7684\u9884\u7b97\u6a21\u578b\uff0c\u518d\u6b21\u6267\u884c\u5347\u7ea7\u4f1a\u8986\u76d6\u661f\u701a\u5df2\u5347\u7ea7\u7684\u6210\u5458\u548c\u6570\u636e\uff1b\u5347\u7ea7\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u7684\u6570\u636e\u53ca\u5173\u8054\u7684\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u5230\u661f\u701a\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u53ef\u901a\u8fc7\u201c\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u201d\u548c\u201c\u6570\u636e\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("allReUpgrade", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u9009\u4e2d\u7684\u9884\u7b97\u6a21\u578b\u7684\u6570\u636e\u53ca\u5173\u8054\u7684\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u5230\u661f\u701a\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u53ef\u4ee5\u901a\u8fc7\u5728\u201c\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u201d\u548c\u201c\u6570\u636e\u5347\u7ea7\u60c5\u51b5\u201d\u67e5\u770b\u5347\u7ea7\u60c5\u51b5\uff0c\u786e\u5b9a\u8981\u5347\u7ea7\u5417\uff1f", (String)"EasUpgradeFormPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("allUpgrade", (IFormPlugin)this));
        }
    }

    private void checkInSync() {
        if ("1".equals(cache.get("eassync" + this.getEasDbId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65EAS\u9884\u7b97\u6a21\u578b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5347\u7ea7\u64cd\u4f5c\u3002", (String)"EasUpgradeFormPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void memberUpgradeRecord() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        int memUpStatus = selectedUpgradeModel.getInt("memupstatus");
        if (memUpStatus != UpgradeStatus.ING.getVal() && memUpStatus != UpgradeStatus.SUCCEED.getVal() && memUpStatus != UpgradeStatus.FAILED.getVal()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6210\u5458\u5347\u7ea7\u72b6\u6001\u4e3a\u201c\u5347\u7ea7\u4e2d\u3001\u5df2\u5347\u7ea7\u3001\u5347\u7ea7\u5931\u8d25\u201d\u7684\u8bb0\u5f55\u67e5\u770b\u6210\u5458\u5347\u7ea7\u60c5\u51b5\u3002", (String)"EasUpgradeFormPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{""}));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_easupgradeinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u5347\u7ea7\u60c5\u51b5", (String)"EasUpgradeFormPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("type", (Object)"upgrade_record_mem");
        formShowParameter.setCustomParam("easDbId", (Object)this.getSelectedEasDbId(selectedUpgradeModel));
        formShowParameter.setCustomParam("easModelId", (Object)this.getSelectedEasModelId(selectedUpgradeModel));
        formShowParameter.setCustomParam("upgradeModelId", (Object)this.getSelectedUpgradeModelId(selectedUpgradeModel));
        this.getView().showForm(formShowParameter);
    }

    private void dataUpgradeRecord() {
        if (this.checkSelOne()) {
            return;
        }
        DynamicObject selectedUpgradeModel = this.getSelectedUpgradeModel();
        int dataUpStatus = selectedUpgradeModel.getInt("dataupstatus");
        if (dataUpStatus != UpgradeStatus.ING.getVal() && dataUpStatus != UpgradeStatus.SUCCEED.getVal() && dataUpStatus != UpgradeStatus.FAILED.getVal()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5347\u7ea7\u72b6\u6001\u4e3a\u201c\u5347\u7ea7\u4e2d\u3001\u5df2\u5347\u7ea7\u3001\u5347\u7ea7\u5931\u8d25\u201d\u7684\u8bb0\u5f55\u67e5\u770b\u6570\u636e\u5347\u7ea7\u60c5\u51b5\u3002", (String)"EasUpgradeFormPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{""}));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_easupgradeinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u60c5\u51b5", (String)"EasUpgradeFormPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("type", (Object)"upgrade_record_data");
        formShowParameter.setCustomParam("easDbId", (Object)this.getSelectedEasDbId(selectedUpgradeModel));
        formShowParameter.setCustomParam("easModelId", (Object)this.getSelectedEasModelId(selectedUpgradeModel));
        formShowParameter.setCustomParam("upgradeModelId", (Object)this.getSelectedUpgradeModelId(selectedUpgradeModel));
        this.getView().showForm(formShowParameter);
    }

    private void easConnect() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("isc_database_link");
        showParameter.setPageId(this.getView().getPageId() + "isc_database_link");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void easDb() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("isc_data_source");
        showParameter.setPageId(this.getView().getPageId() + "isc_data_source");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void refreshUpgradeRecordList() {
        BillList billList = (BillList)this.getControl(ENTRYENTITY);
        billList.refresh();
    }

    private String getSelectedEasModelName(DynamicObject upgradeModel) {
        return upgradeModel.getString("name");
    }

    private String getSelectedEasModelNumber(DynamicObject upgradeModel) {
        return upgradeModel.getString("number");
    }

    private String getSelectedRefcube(DynamicObject upgradeModel) {
        return upgradeModel.getString("refcube");
    }

    private String getSelectedEasModelId(DynamicObject upgradeModel) {
        return upgradeModel.getString("easmodelid");
    }

    private Long getSelectedEasDbId(DynamicObject upgradeModel) {
        return upgradeModel.getLong(F7_EAS_DB);
    }

    private Long getSelectedUpgradeModelId(DynamicObject upgradeModel) {
        return upgradeModel.getLong("id");
    }

    private DynamicObject getSelectEpmDataSource() {
        return (DynamicObject)this.getModel().getValue(DATASOURCE);
    }

    private Long getSelectEpmDataSourceId() {
        DynamicObject dataSource = this.getSelectEpmDataSource();
        if (dataSource == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u591a\u7ef4\u6570\u636e\u5e93\u6570\u636e\u6e90\u3002", (String)"EasUpgradeFormPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dataSource.getLong("id");
    }

    private DynamicObject getSelectedUpgradeModel() {
        return BusinessDataServiceHelper.loadSingle((Object)this.getSelectedPkId(), (String)"eb_easupgrade_record");
    }

    private Long getSelectedPkId() {
        BillList billList = (BillList)this.getControl(ENTRYENTITY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9884\u7b97\u6a21\u578b\u3002", (String)"EasUpgradeFormPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    private DynamicObject[] getSelectedDys() {
        BillList billList = (BillList)this.getControl(ENTRYENTITY);
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9884\u7b97\u6a21\u578b\u3002", (String)"EasUpgradeFormPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_easupgrade_record");
        return BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dynamicObject.getDynamicObjectType());
    }

    private boolean checkSelOne() {
        BillList billList = (BillList)this.getControl(ENTRYENTITY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9884\u7b97\u6a21\u578b\u3002", (String)"EasUpgradeFormPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (F7_EAS_DB.equals(name)) {
            this.putEasdbtoCache(this.getEasDbId());
            this.refreshUpgradeRecordList();
        } else if (DATASOURCE.equals(name)) {
            cache.put(DATASOURCE + UserUtils.getUserId(), (Object)String.valueOf(this.getSelectEpmDataSourceId()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            try {
                if ("memUpgrade".equals(callBackId) || "memReUpgrade".equals(callBackId)) {
                    this.doMemberUpgrade();
                } else if ("dataUpgrade".equals(callBackId) || "dataReUpgrade".equals(callBackId)) {
                    this.doDataUpgrade();
                } else if ("allUpgrade".equals(callBackId) || "allReUpgrade".equals(callBackId)) {
                    this.doAllUpgrade();
                }
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void doMemberUpgrade() {
        DynamicObject[] selectedRows = this.getSelectedDys();
        ArrayList<String> numbers = new ArrayList<String>(selectedRows.length);
        for (DynamicObject selectedRow : selectedRows) {
            numbers.add(selectedRow.getString("number"));
        }
        this.writeLog("update", new MultiLangEnumBridge("\u5347\u7ea7\u6210\u5458", "EasUpgradeFormPlugin_31", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5347\u7ea7EAS\u9884\u7b97\u6a21\u578b%1$s\u7684\u6210\u5458\u3002", "EasUpgradeFormPlugin_32", "epm-eb-formplugin"), new String[]{((Object)numbers).toString()});
        EBThreadPoolExecutor.executeOnce(() -> {
            try {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.WAIT, 1);
                for (DynamicObject selectedRow : selectedRows) {
                    numbers.add(selectedRow.getString("number"));
                    EASUpgradeParam param = new EASUpgradeParam();
                    try {
                        param.setUpgradeBaseData(Boolean.TRUE.booleanValue());
                        param.setUpgradeData(Boolean.FALSE.booleanValue());
                        String easmodelId = selectedRow.getString("easmodelid");
                        param.getEASSchema().setSchemaId(easmodelId);
                        param.setApplication(this.getApplication());
                        param.setUpgradeModelId(this.getSelectedUpgradeModelId(selectedRow));
                        param.setEpmDataSourceId(this.getSelectEpmDataSourceId());
                        param.setUpgradeSourceId(this.getSelectedEasDbId(selectedRow));
                        easUpgradeService.startEasModelMemberUpgrade(param.getUpgradeModelId());
                        EASBudgetUpgradeImpl upgrade = EASBudgetUpgradeImpl.getInstance();
                        upgrade.upgrade((IEASUpgradeParam)param);
                    }
                    catch (Exception e) {
                        EasUpgradeLog log = new EasUpgradeLog();
                        log.setCreater(UserUtils.getUserId());
                        log.setUpgradeModelId(param.getUpgradeModelId());
                        log.setCreatedate(TimeServiceHelper.now());
                        log.setStatus(Status.FAILED.getVal());
                        log.setInfo(e.getMessage());
                        EasUpgradeLogService easUpgradeLogService = EasUpgradeLogService.getInstance();
                        easUpgradeLogService.add(log);
                        easUpgradeService.upEasModelMemberUpgrade(param.getUpgradeModelId(), UpgradeStatus.FAILED, null);
                    }
                }
            }
            catch (Exception e) {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.FAILED, 1);
                throw new KDBizException(e.getMessage());
            }
        }, (String)"doMemberUpgrade");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4e2d\uff0c\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u8be6\u60c5\u3002", (String)"EasUpgradeFormPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void doAllUpgrade() {
        DynamicObject[] selectedRows = this.getSelectedDys();
        ArrayList<String> numbers = new ArrayList<String>(selectedRows.length);
        for (DynamicObject selectedRow : selectedRows) {
            numbers.add(selectedRow.getString("number"));
        }
        this.writeLog("update", new MultiLangEnumBridge("\u5168\u91cf\u5347\u7ea7", "EasUpgradeFormPlugin_35", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9EAS\u9884\u7b97\u6a21\u578b%1$s\u8fdb\u884c\u5347\u7ea7\u6210\u5458\u548c\u5347\u7ea7\u6570\u636e\u64cd\u4f5c", "EasUpgradeFormPlugin_36", "epm-eb-formplugin"), new String[]{((Object)numbers).toString()});
        EBThreadPoolExecutor.executeOnce(() -> {
            try {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.WAIT, 3);
                for (DynamicObject selectedRow : selectedRows) {
                    EasUpgradeLog log;
                    EASUpgradeParam param = new EASUpgradeParam();
                    param.setUpgradeBaseData(Boolean.TRUE.booleanValue());
                    param.setUpgradeData(Boolean.FALSE.booleanValue());
                    String easmodelId = selectedRow.getString("easmodelid");
                    IEASSchema easSchema = param.getEASSchema();
                    easSchema.setSchemaId(easmodelId);
                    easSchema.setRefCube(this.getSelectedRefcube(selectedRow));
                    param.setApplication(this.getApplication());
                    param.setUpgradeModelId(this.getSelectedUpgradeModelId(selectedRow));
                    param.setEpmDataSourceId(this.getSelectEpmDataSourceId());
                    param.setUpgradeSourceId(this.getSelectedEasDbId(selectedRow));
                    EASBudgetUpgradeImpl upgrade = EASBudgetUpgradeImpl.getInstance();
                    List results = new ArrayList(10);
                    try {
                        easUpgradeService.startEasModelMemberUpgrade(param.getUpgradeModelId());
                        results = upgrade.upgrade((IEASUpgradeParam)param);
                    }
                    catch (Exception e) {
                        log = new EasUpgradeLog();
                        log.setCreater(UserUtils.getUserId());
                        log.setUpgradeModelId(param.getUpgradeModelId());
                        log.setCreatedate(TimeServiceHelper.now());
                        log.setStatus(Status.FAILED.getVal());
                        log.setInfo(e.getMessage());
                        EasUpgradeLogService easUpgradeLogService = EasUpgradeLogService.getInstance();
                        easUpgradeLogService.add(log);
                        easUpgradeService.upEasModelMemberUpgrade(param.getUpgradeModelId(), UpgradeStatus.FAILED, null);
                    }
                    if (!EASUpgradeResult.isSuccess(results)) continue;
                    try {
                        param.setUpgradeBaseData(Boolean.FALSE.booleanValue());
                        param.setUpgradeData(Boolean.TRUE.booleanValue());
                        if (this.getView().getPageCache().get("notSyncData") != null) {
                            param.setSyncData(false);
                        }
                        easUpgradeService.upEasModelDataUpgradeStatus(param.getUpgradeModelId(), UpgradeStatus.ING);
                        upgrade.upgrade((IEASUpgradeParam)param);
                    }
                    catch (Exception e) {
                        log = new EasDataUpgradeLog();
                        log.setCreater(UserUtils.getUserId());
                        log.setUpgradeModelId(param.getUpgradeModelId());
                        log.setCreatedate(TimeServiceHelper.now());
                        log.setStatus(Status.FAILED.getVal());
                        log.setInfo(e.getMessage());
                        EasDataUpgradeLogService easDataUpgradeLogService = EasDataUpgradeLogService.getInstance();
                        easDataUpgradeLogService.add((EasDataUpgradeLog)log);
                        easUpgradeService.upEasModelDataUpgradeStatus(param.getUpgradeModelId(), UpgradeStatus.FAILED);
                    }
                }
            }
            catch (Exception e) {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.FAILED, 3);
                throw new KDBizException(e.getMessage());
            }
        }, (String)"doAllUpgrade");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4e2d\uff0c\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u8be6\u60c5\u3002", (String)"EasUpgradeFormPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void doDataUpgrade() {
        DynamicObject[] selectedRows = this.getSelectedDys();
        ArrayList<String> numbers = new ArrayList<String>(selectedRows.length);
        for (DynamicObject selectedRow : selectedRows) {
            numbers.add(selectedRow.getString("number"));
        }
        this.writeLog("update", new MultiLangEnumBridge("\u5347\u7ea7\u6570\u636e", "EasUpgradeFormPlugin_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5347\u7ea7EAS\u9884\u7b97\u6a21\u578b%1$s\u7684\u6570\u636e\u3002", "EasUpgradeFormPlugin_34", "epm-eb-formplugin"), new String[]{((Object)numbers).toString()});
        EBThreadPoolExecutor.executeOnce(() -> {
            try {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.WAIT, 2);
                for (DynamicObject selectedRow : selectedRows) {
                    EASUpgradeParam param = new EASUpgradeParam();
                    try {
                        String easmodelId = selectedRow.getString("easmodelid");
                        param.setUpgradeBaseData(Boolean.FALSE.booleanValue());
                        param.setUpgradeData(Boolean.TRUE.booleanValue());
                        IEASSchema easSchema = param.getEASSchema();
                        easSchema.setSchemaId(easmodelId);
                        easSchema.setRefCube(this.getSelectedRefcube(selectedRow));
                        param.setApplication(this.getApplication());
                        param.setEpmDataSourceId(this.getSelectEpmDataSourceId());
                        param.setUpgradeSourceId(this.getSelectedEasDbId(selectedRow));
                        param.setUpgradeModelId(this.getSelectedUpgradeModelId(selectedRow));
                        if (this.getView().getPageCache().get("notSyncData") != null) {
                            param.setSyncData(false);
                        }
                        easUpgradeService.startEasModelDataUpgrade(param.getUpgradeModelId());
                        EASBudgetUpgradeImpl upgrade = EASBudgetUpgradeImpl.getInstance();
                        upgrade.upgrade((IEASUpgradeParam)param);
                    }
                    catch (Exception e) {
                        EasDataUpgradeLog log = new EasDataUpgradeLog();
                        log.setCreater(UserUtils.getUserId());
                        log.setUpgradeModelId(param.getUpgradeModelId());
                        log.setCreatedate(TimeServiceHelper.now());
                        log.setStatus(Status.FAILED.getVal());
                        log.setInfo(e.getMessage());
                        EasDataUpgradeLogService easDataUpgradeLogService = EasDataUpgradeLogService.getInstance();
                        easDataUpgradeLogService.add(log);
                        easUpgradeService.upEasModelDataUpgradeStatus(param.getUpgradeModelId(), UpgradeStatus.FAILED);
                    }
                }
            }
            catch (Exception e) {
                easUpgradeService.upEasModelStatus(selectedRows, UpgradeStatus.FAILED, 2);
                throw new KDBizException(e.getMessage());
            }
        }, (String)"doDataUpgrade");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4e2d\uff0c\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u8be6\u60c5\u3002", (String)"EasUpgradeFormPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private ApplicationTypeEnum getApplication() {
        String bizAppId = this.getBizAppId();
        if (ApplicationTypeEnum.BGMD.getAppnum().equals(bizAppId)) {
            return ApplicationTypeEnum.BGMD;
        }
        if (ApplicationTypeEnum.BG.getAppnum().equals(bizAppId)) {
            return ApplicationTypeEnum.BG;
        }
        throw new KDBizException("not support this app");
    }
}

