/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.easupgrades;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.enums.EasDataCategoryEnum;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class EasUpgradeInfoFormPlugin
extends AbstractFormPlugin {
    public static final String MEM_ENTRYENTITY = "mementryentity";
    public static final String DATA_ENTRYENTITY = "dataentryentity";
    public static final String TOOLBARAP = "toolbarap";
    public static final String BTN_REFRESH = "btn_refresh";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    private void refresh() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String easModelId = (String)formShowParameter.getCustomParam("easModelId");
        Long easDbId = (Long)formShowParameter.getCustomParam("easDbId");
        Long upgradeModelId = (Long)formShowParameter.getCustomParam("upgradeModelId");
        this.setFromVisibleByType();
        this.loadMemEntry(easDbId, easModelId, upgradeModelId);
        this.loadDataEntry(upgradeModelId);
        this.getView().updateView();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_REFRESH.equals(itemKey)) {
            this.refresh();
        }
    }

    private void loadMemEntry(Long easDbId, String easModelId, Long upgradeModelId) {
        List<EASDim> easDims;
        if (this.isUpgradeDataRecord()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"memberup"});
            return;
        }
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        DynamicObject log = BusinessDataServiceHelper.loadSingle((String)"eb_eas_upgrade_log", (String)"dimuplog.easdimnumber,dimuplog.dimstatus,createdate", (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> dimLogMap = new HashMap<String, DynamicObject>(16);
        if (log != null) {
            DynamicObjectCollection dimuplog = log.getDynamicObjectCollection("dimuplog");
            for (DynamicObject object : dimuplog) {
                dimLogMap.put(object.getString("easdimnumber"), object);
            }
        }
        if (CollectionUtils.isNotEmpty(easDims = this.getEASDimListBySchemeId(easDbId, easModelId))) {
            DynamicObject rowEntity;
            this.getModel().deleteEntryData(MEM_ENTRYENTITY);
            int[] index = this.getModel().batchCreateNewEntryRow(MEM_ENTRYENTITY, easDims.size() + 2);
            int i = 0;
            for (EASDim easDimension : easDims) {
                SysDimensionEnum epmDimension;
                rowEntity = this.getModel().getEntryRowEntity(MEM_ENTRYENTITY, index[i]);
                rowEntity.set("easdimnumber", (Object)easDimension.getNumber());
                rowEntity.set("easdimname", (Object)easDimension.getName());
                List members = easDimension.getMembers();
                if (members.size() > 0) {
                    rowEntity.set("easviewname", (Object)((EASMember)members.get((int)0)).name);
                    if (!"BG_Account".equals(easDimension.getNumber())) {
                        rowEntity.set("viewname", (Object)ResManager.loadResFormat((String)"\u57fa\u51c6%1\u89c6\u56fe", (String)"EasUpgradeInfoFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{easDimension.getName().getLocaleValue()}));
                    }
                }
                if ("BG_Consolidation".equals(easDimension.getNumber())) {
                    rowEntity.set("dimnumber", (Object)SysDimensionEnum.Entity.getNumber());
                    rowEntity.set("dimname", (Object)SysDimensionEnum.Entity.getChineseName());
                    rowEntity.set("memdescription", (Object)ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u5173\u8054\u7684\u5408\u5e76\u8303\u56f4\u5347\u7ea7\u5230\u5206\u6790\u89c6\u56fe", (String)"EasUpgradeInfoFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject dimLog = (DynamicObject)dimLogMap.get(easDimension.getNumber());
                if (log != null && dimLog != null) {
                    rowEntity.set("memupgradestatus", (Object)dimLog.getString("dimstatus"));
                    rowEntity.set("memupgradetime", (Object)log.getDate("createdate"));
                }
                if ((epmDimension = (SysDimensionEnum)EasUpgradeConstants.DIMNUMBERMAP.get(easDimension.getNumber())) != null) {
                    this.fillEpmDimensionInfo(rowEntity, epmDimension);
                } else {
                    rowEntity.set("dimnumber", (Object)easDimension.getNumber());
                    rowEntity.set("dimname", (Object)easDimension.getName());
                }
                ++i;
            }
            rowEntity = this.getModel().getEntryRowEntity(MEM_ENTRYENTITY, index[i++]);
            this.fillEpmDimensionInfo(rowEntity, SysDimensionEnum.AuditTrail);
            rowEntity = this.getModel().getEntryRowEntity(MEM_ENTRYENTITY, index[i]);
            this.fillEpmDimensionInfo(rowEntity, SysDimensionEnum.ChangeType);
        }
    }

    private void fillEpmDimensionInfo(DynamicObject rowEntity, SysDimensionEnum epmDimension) {
        rowEntity.set("dimnumber", (Object)epmDimension.getNumber());
        rowEntity.set("dimname", (Object)epmDimension.getChineseName());
        if (SysDimensionEnum.Entity == epmDimension) {
            rowEntity.set("viewname", (Object)ResManager.loadKDString((String)"\u57fa\u51c6\u7ec4\u7ec7\u89c6\u56fe", (String)"EasUpgradeInfoFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            rowEntity.set("memdescription", (Object)ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u5347\u7ea7\uff0c\u5347\u7ea7\u540e\u53ef\u521b\u5efa\u5206\u6790\u89c6\u56fe", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (SysDimensionEnum.BudgetPeriod == epmDimension) {
            rowEntity.set("combinedimnumber", (Object)"EasPeriod");
            rowEntity.set("combinedimname", (Object)ResManager.loadKDString((String)"\u671f\u95f4\u5206\u7c7b", (String)"EasUpgradeInfoFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            rowEntity.set("memdescription", (Object)ResManager.loadKDString((String)"EAS\u7684\u201c\u671f\u95f4\u5206\u7c7b\u201d\u5347\u7ea7\u4e3a\u7ec4\u5408\u7ef4\u5ea6\u201c\u671f\u95f4\u5206\u7c7b\u201d\uff0c\u201c\u671f\u95f4\u6210\u5458\u201d\u5347\u7ea7\u4e3a\u201c\u9884\u7b97\u671f\u95f4\u201d\u6210\u5458", (String)"EasUpgradeInfoFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (SysDimensionEnum.AuditTrail == epmDimension || SysDimensionEnum.ChangeType == epmDimension) {
            rowEntity.set("memdescription", (Object)ResManager.loadKDString((String)"EAS\u65e0\uff0c\u661f\u701a\u9884\u7f6e", (String)"EasUpgradeInfoFormPlugin_5", (String)"", (Object[])new Object[0]));
        }
    }

    public List<EASDim> getEASDimListBySchemeId(Long dataSourceId, @NotNull String easSchemaId) {
        String sql = "select fid, fdimnumber,fdimname_l1,fdimname_l2,fdimname_l3 from " + EASDimUpgradeUtils.getSyncTable((Long)dataSourceId, (String)"T_MBG_BGDIMSETTINGS") + " where fbgschemeid = ? order by fdimnumber !='BG_Organization', fdimnumber !='BG_Consolidation',fseq";
        Object[] params = new Object[]{easSchemaId};
        ArrayList<EASDim> easDims = new ArrayList<EASDim>(10);
        ArrayList<String> dimIds = new ArrayList<String>(10);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])params);){
            if (ds != null) {
                for (Row row : ds) {
                    String dimId = row.getString("fid");
                    String dimnumber = row.getString("fdimnumber");
                    if (!("BG_Version".equals(dimnumber) || "BG_Scenario".equals(dimnumber) || "BG_Element".equals(dimnumber) || "BG_Currency".equals(dimnumber) || "BG_Period".equals(dimnumber) || "BG_Consolidation".equals(dimnumber))) {
                        dimIds.add(dimId);
                    }
                    EASDim easDim = EASDim.defaultEAS((String)dimId, (String)dimnumber);
                    easDim.setName(EASUpgradeUtils.getLocaleStr((Row)row, (String)"fdimname"));
                    easDims.add(easDim);
                }
            }
        }
        if (dimIds.size() > 0) {
            StringBuilder sb = new StringBuilder("select fid,ftype,fmemberid,fbgdimsettingsid,fnumber,fname_l1,fname_l2,fname_l3 from ");
            sb.append(EASDimUpgradeUtils.getSyncTable((Long)dataSourceId, (String)"T_MBG_BGDIMSETTINGSMEMBER")).append(" where (ftype = 1 or ftype = 2) and fbgdimsettingsid in (").append(EASUpgradeUtils.getSqlInStr(dimIds)).append(")");
            DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (String)sb.toString());
            Object object = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        String dimId = row.getString("fbgdimsettingsid");
                        EASMember view = new EASMember();
                        view.id = row.getString("fid");
                        view.memberId = row.getString("fmemberid");
                        view.type = row.getInteger("ftype");
                        view.name = EASUpgradeUtils.getLocaleStr((Row)row, (String)"fname");
                        for (EASDim easDim : easDims) {
                            if (!StringUtils.equals((String)easDim.getId(), (String)dimId)) continue;
                            easDim.getMembers().add(view);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return easDims;
    }

    private void loadDataEntry(Long upgradeModelId) {
        if (this.isUpgradeMemRecord()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataup"});
            return;
        }
        EasDataCategoryEnum[] dataCategoryEnums = EasDataCategoryEnum.values();
        this.getModel().deleteEntryData(DATA_ENTRYENTITY);
        int[] index = this.getModel().batchCreateNewEntryRow(DATA_ENTRYENTITY, dataCategoryEnums.length);
        int i = 0;
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        DynamicObject log = BusinessDataServiceHelper.loadSingle((String)"eb_eas_data_upgrade_log", (String)"status,createdate", (QFilter[])qFilter.toArray());
        String status = null;
        Date createdate = null;
        if (log != null) {
            status = log.getString("status");
            createdate = log.getDate("createdate");
        }
        for (EasDataCategoryEnum dataCategory : dataCategoryEnums) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(DATA_ENTRYENTITY, index[i]);
            rowEntity.set("easdatacategory", (Object)dataCategory.getBridge().loadKDString());
            rowEntity.set("easversion", (Object)dataCategory.getEasVersion());
            rowEntity.set("audittrail", (Object)dataCategory.getAuditTrail());
            rowEntity.set("changetype", (Object)dataCategory.getChangeType());
            rowEntity.set("version", (Object)dataCategory.getVersion());
            rowEntity.set("datadescription", (Object)dataCategory.getDescription().loadKDString());
            if (EasDataCategoryEnum.BUDGET_PREPARE_DATA == dataCategory || EasDataCategoryEnum.ACTUAL_DATA == dataCategory || EasDataCategoryEnum.BUDGET_COMBINE_DATA == dataCategory) {
                rowEntity.set("dataupgradestatus", (Object)status);
                rowEntity.set("dataupgradetime", (Object)createdate);
            }
            ++i;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void setFromVisibleByType() {
        if (this.isMemUpgradeCheck()) {
            EntryGrid dataEntry = (EntryGrid)this.getControl(DATA_ENTRYENTITY);
            dataEntry.setCollapseable(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataup", "memupgradestatus", "memupgradetime", "dataupgradestatus", "dataupgradetime", BTN_REFRESH});
        } else if (this.isDataUpgradeCheck()) {
            EntryGrid memEntry = (EntryGrid)this.getControl(MEM_ENTRYENTITY);
            memEntry.setCollapseable(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"memberup", "memupgradestatus", "memupgradetime", "dataupgradestatus", "dataupgradetime", BTN_REFRESH});
        } else if (this.isUpgradeMemRecord()) {
            EntryGrid memEntry = (EntryGrid)this.getControl(MEM_ENTRYENTITY);
            memEntry.setCollapseable(false);
            HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(16);
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u6210\u5458\u5347\u7ea7\u60c5\u51b5", (String)"EasUpgradeFormPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("memberup", ctrl);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATA_ENTRYENTITY});
        } else if (this.isUpgradeDataRecord()) {
            EntryGrid dataEntry = (EntryGrid)this.getControl(DATA_ENTRYENTITY);
            dataEntry.setCollapseable(false);
            HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(16);
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u60c5\u51b5", (String)"EasUpgradeFormPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("dataup", ctrl);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MEM_ENTRYENTITY});
        }
    }

    private boolean isMemUpgradeCheck() {
        return "mem_upgrade_check".equals(this.getCustomFormParam("type"));
    }

    private boolean isDataUpgradeCheck() {
        return "data_upgrade_check".equals(this.getCustomFormParam("type"));
    }

    private boolean isUpgradeMemRecord() {
        return "upgrade_record_mem".equals(this.getCustomFormParam("type"));
    }

    private boolean isUpgradeDataRecord() {
        return "upgrade_record_data".equals(this.getCustomFormParam("type"));
    }
}

