/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ebupgrades.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.epm.eb.business.ebupgrades.constants.EbUpgradeCheckPluginEnum;
import kd.epm.eb.business.ebupgrades.interfaces.EbUpgradeCheck;
import kd.epm.eb.business.ebupgrades.pojo.EbUpgradeCheckResultPojo;
import kd.epm.eb.business.ebupgrades.utils.UpgradesServiceImpl;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class EbModelUpgradeCheckPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    @Override
    public void registerListener(EventObject e) {
        Tab modeltab = (Tab)this.getControl("modeltab");
        modeltab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getView().getControl("labelap");
        label.setText(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7\u524d\u68c0\u67e5\u7ed3\u679c\u62a5\u544a\uff0c\u5347\u7ea7\u4fdd\u8bc1\u5386\u53f2\u6570\u636e\u51c6\u786e\u8fc1\u79fb\uff0c\u53ef\u80fd\u6709\u90e8\u5206\u914d\u7f6e\u9700\u8981\u5728\u65b0\u8d39\u7528\u9884\u7b97\u4e2d\u91cd\u65b0\u8bbe\u7f6e,\u8bf7\u8ba4\u771f\u9605\u8bfb\u5e76\u8bc4\u4f30\uff0c\n\u201d\u786e\u5b9a\u540e\u5c06\u5f00\u59cb\u6267\u884c\u5347\u7ea7\u201c\uff0c\u8d39\u7528\u9884\u7b97\u5347\u7ea7\u9700\u8981\u4e00\u6b21\u6027\u5b8c\u6210\u6240\u6709\u65e7\u7248\u8d39\u7528\u9884\u7b97\u4f53\u7cfb\u7684\u5347\u7ea7\uff0c\u8bf7\u786e\u8ba4\u5e76\u8bbe\u7f6e\u6bcf\u4e2a\u4f53\u7cfb\u7684\u68c0\u67e5\u62a5\u544a\u3002", (String)"EbModelUpgradeCheckPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object modelIds = customParams.get("modelIds");
        if (modelIds != null) {
            List models = (List)SerializationUtils.deSerializeFromBase64((String)((String)modelIds));
            this.getPageCache().put("modelIds", SerializationUtils.serializeToBase64((Object)models));
            if (CollectionUtils.isNotEmpty((Collection)models)) {
                this.validCheck(models);
                this.handleTab(models);
            }
        }
    }

    private void validCheck(List<Long> models) {
        EbUpgradeCheckPluginEnum[] values = EbUpgradeCheckPluginEnum.values();
        HashSet resultPojoSet = new HashSet(16);
        for (EbUpgradeCheckPluginEnum value : values) {
            EbUpgradeCheck ebUpgradeCheck = value.getEbUpgradeCheck();
            List ebUpgradeCheckResultPojos = ebUpgradeCheck.upgradeCheck(models);
            if (!CollectionUtils.isNotEmpty((Collection)ebUpgradeCheckResultPojos)) continue;
            resultPojoSet.addAll(ebUpgradeCheckResultPojos);
        }
        Map<Long, List<EbUpgradeCheckResultPojo>> collect = resultPojoSet.stream().collect(Collectors.groupingBy(EbUpgradeCheckResultPojo::getModelId));
        Map<Long, List<EbUpgradeCheckResultPojo>> needConfirm = resultPojoSet.stream().filter(e -> e.getIgnoreOption() == Boolean.TRUE).collect(Collectors.toSet()).stream().collect(Collectors.groupingBy(EbUpgradeCheckResultPojo::getModelId));
        this.cacheResultMap(collect);
        this.cacheNeedConfirm(needConfirm);
    }

    private void cacheNeedConfirm(Map<Long, List<EbUpgradeCheckResultPojo>> needConfirm) {
        HashMap needConfirmCache = new HashMap(needConfirm.size());
        for (Map.Entry<Long, List<EbUpgradeCheckResultPojo>> next : needConfirm.entrySet()) {
            Long key = next.getKey();
            List<EbUpgradeCheckResultPojo> value = next.getValue();
            HashMap<String, String> stringMap = (HashMap<String, String>)needConfirmCache.get(key);
            if (stringMap == null) {
                stringMap = new HashMap<String, String>(16);
            }
            for (EbUpgradeCheckResultPojo pojo : value) {
                stringMap.put(pojo.getEbUpgradeItem().getItem(), pojo.getResult());
            }
            needConfirmCache.put(key, stringMap);
        }
        if (needConfirmCache.size() != 0) {
            this.getPageCache().put("needConfirm", SerializationUtils.serializeToBase64(needConfirmCache));
        }
    }

    private void cacheResultMap(Map<Long, List<EbUpgradeCheckResultPojo>> collect) {
        this.getPageCache().put("resultMap", SerializationUtils.serializeToBase64(collect));
    }

    private void handleTab(List<Long> models) {
        TabAp tabap = new TabAp();
        tabap.setKey("modeltab");
        tabap.setName(new LocaleString("modeltab"));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>(10);
        String tabKey = String.valueOf(models.get(0));
        for (Long model : models) {
            TabPageAp tabPageAp = new TabPageAp();
            DynamicObject dynamicObject = ModelUtils.getModel((Long)model);
            keys.add(dynamicObject.getString("id"));
            tabPageAp.setKey(dynamicObject.getString("id"));
            tabPageAp.setName(new LocaleString(dynamicObject.getString("name")));
            tabap.getItems().add(tabPageAp);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"EbModelUpgradeCheckPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("modeltab", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(1);
        closeMap.put("closable", false);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
        Tab modelTab = (Tab)this.getView().getControl("modeltab");
        modelTab.activeTab(tabKey);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.refreshEntryEntity(tabKey);
    }

    private void refreshEntryEntity(String tabKey) {
        DynamicObject model = ModelUtils.getModel((Long)Long.parseLong(tabKey));
        Map<Long, List<EbUpgradeCheckResultPojo>> resultMap = this.getCheckResultMapFromCache();
        if (resultMap == null) {
            return;
        }
        List<EbUpgradeCheckResultPojo> checkResult = resultMap.get(model.getLong("id"));
        if (CollectionUtils.isEmpty(checkResult)) {
            return;
        }
        checkResult.sort(Comparator.comparing(EbUpgradeCheckResultPojo::getEbUpgradeItem));
        IDataModel dataModel = this.getView().getModel();
        dataModel.deleteEntryData("entryentity");
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String selectOption = this.getPageCache().get("currentOption");
        Map currentOption = new HashMap(16);
        if (StringUtils.isNotEmpty((String)selectOption)) {
            currentOption = (Map)SerializationUtils.deSerializeFromBase64((String)selectOption);
        }
        Map optionMap = (Map)currentOption.get(model.getLong("id"));
        if (CollectionUtils.isNotEmpty(checkResult)) {
            for (int i = 0; i < checkResult.size(); ++i) {
                EbUpgradeCheckResultPojo pojo = checkResult.get(i);
                vs.set("item", (Object)pojo.getEbUpgradeItem().getItem(), i);
                vs.set("checkitem", (Object)pojo.getEbUpgradeItem().getBridge(), i);
                vs.set("result", (Object)pojo.getResult(), i);
                vs.set("suggest", (Object)pojo.getSuggest(), i);
                Boolean ignoreOption = pojo.getIgnoreOption();
                if (optionMap != null && optionMap.containsKey(i + 1)) {
                    vs.set("option", optionMap.get(i + 1), i);
                } else {
                    vs.set("option", (Object)false, i);
                }
                boolean enable = Boolean.FALSE;
                if (ignoreOption != null) {
                    enable = ignoreOption;
                }
                this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"option"});
            }
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("entryentity", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    private Map<Long, List<EbUpgradeCheckResultPojo>> getCheckResultMapFromCache() {
        String resultMap = this.getPageCache().get("resultMap");
        if (StringUtils.isNotEmpty((String)resultMap)) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)resultMap);
        }
        return new HashMap<Long, List<EbUpgradeCheckResultPojo>>(16);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.startUpgrade();
        }
    }

    private void showUpgradeProgress() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_upgradeprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7", (String)"EbModelUpgradeCheckPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("msg", (Object)ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u6b63\u5728\u5347\u7ea7\u3002", (String)"EbModelUpgradeCheckPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showProgress");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void startUpgrade() {
        String resultMap = this.getPageCache().get("resultMap");
        if (StringUtils.isNotEmpty((String)resultMap)) {
            String needConfirm = this.getPageCache().get("needConfirm");
            if (StringUtils.isNotEmpty((String)needConfirm)) {
                Map confirmMap = (Map)SerializationUtils.deSerializeFromBase64((String)needConfirm);
                StringBuilder stringBuilder = new StringBuilder();
                Map model = ModelUtils.getModel(confirmMap.keySet());
                for (Map.Entry next : confirmMap.entrySet()) {
                    Map value = (Map)next.getValue();
                    Long key = (Long)next.getKey();
                    stringBuilder.append(((BizModel)model.get(key)).getName()).append("\uff1a");
                    for (String s : value.values()) {
                        stringBuilder.append(s).append("\uff0c");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.append("\uff1b");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f85\u786e\u8ba4\u5ffd\u7565\u9879\uff1a%1\u3002\u8bf7\u5148\u786e\u8ba4\u540e\u518d\u5347\u7ea7\u3002", (String)"EbModelUpgradeCheckPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.toString()}));
                return;
            }
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)resultMap);
            if (map != null) {
                Collection values = map.values();
                ArrayList totalResultPojo = new ArrayList(16);
                if (CollectionUtils.isNotEmpty(values)) {
                    for (List value : values) {
                        totalResultPojo.addAll(value);
                    }
                    Set collect = totalResultPojo.stream().filter(e -> e.getIgnoreOption() == null).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(collect)) {
                        String modelIds = this.getPageCache().get("modelIds");
                        if (StringUtils.isNotEmpty((String)modelIds)) {
                            List models = (List)SerializationUtils.deSerializeFromBase64((String)modelIds);
                            boolean allBGModel = ModelUtil.isAllBGModel((List)models);
                            if (!allBGModel) {
                                this.doStartUpgrade();
                            } else {
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4f53\u7cfb\u5df2\u5347\u7ea7\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u754c\u9762\u3002", (String)"EbModelUpgradeCheckPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        Map<Long, List<EbUpgradeCheckResultPojo>> failedMap = collect.stream().collect(Collectors.groupingBy(EbUpgradeCheckResultPojo::getModelId));
                        if (failedMap != null && failedMap.size() > 0) {
                            Map model = ModelUtils.getModel(failedMap.keySet());
                            Iterator<Map.Entry<Long, List<EbUpgradeCheckResultPojo>>> iterator = failedMap.entrySet().iterator();
                            StringBuilder stringBuilder = new StringBuilder();
                            while (iterator.hasNext()) {
                                Map.Entry<Long, List<EbUpgradeCheckResultPojo>> next = iterator.next();
                                List<EbUpgradeCheckResultPojo> value = next.getValue();
                                Long key = next.getKey();
                                stringBuilder.append(((BizModel)model.get(key)).getName()).append("\uff1a");
                                for (EbUpgradeCheckResultPojo pojo : value) {
                                    stringBuilder.append(pojo.getResult()).append("\uff0c");
                                }
                                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                                stringBuilder.append("\uff1b");
                            }
                            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f85\u5904\u7406\u9879\uff1a%1\u3002\u8bf7\u5148\u5904\u7406\u540e\u518d\u5347\u7ea7\u3002", (String)"EbModelUpgradeCheckPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.toString()}));
                        }
                    }
                }
            }
        }
    }

    private void doStartUpgrade() {
        String modelIds = this.getPageCache().get("modelIds");
        if (StringUtils.isNotEmpty((String)modelIds)) {
            List ids = (List)SerializationUtils.deSerializeFromBase64((String)modelIds);
            EBThreadPoolExecutor.executeOnce(() -> UpgradesServiceImpl.getInstance().doUpgrades(ids), (String)"upgradeModel");
            this.showUpgradeProgress();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("showProgress".equals(actionId)) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("option".equals(name)) {
            HashMap<Integer, Boolean> integerBooleanMap;
            DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
            String item = dataEntity.getString("item");
            String result = dataEntity.getString("result");
            Object newValue = e.getChangeSet()[0].getNewValue();
            String needConfirm = this.getPageCache().get("needConfirm");
            Map currentOption = new HashMap(16);
            Tab tab = (Tab)this.getControl("modeltab");
            long modelId = Long.parseLong(tab.getCurrentTab());
            String selectOption = this.getPageCache().get("currentOption");
            if (StringUtils.isNotEmpty((String)selectOption)) {
                currentOption = (Map)SerializationUtils.deSerializeFromBase64((String)selectOption);
            }
            if ((integerBooleanMap = (HashMap<Integer, Boolean>)currentOption.get(modelId)) == null) {
                integerBooleanMap = new HashMap<Integer, Boolean>(16);
            }
            int seq = dataEntity.getInt("seq");
            integerBooleanMap.put(seq, Objects.equals(true, newValue));
            currentOption.put(modelId, integerBooleanMap);
            this.getPageCache().put("currentOption", SerializationUtils.serializeToBase64(currentOption));
            if (Objects.equals(true, newValue)) {
                if (StringUtils.isNotEmpty((String)needConfirm)) {
                    Map needConfirmCache = (Map)SerializationUtils.deSerializeFromBase64((String)needConfirm);
                    HashMap<String, String> stringMap = (HashMap<String, String>)needConfirmCache.get(modelId);
                    if (stringMap == null) {
                        stringMap = new HashMap<String, String>(16);
                    }
                    if (Objects.equals(true, newValue)) {
                        stringMap.remove(item);
                    } else {
                        stringMap.put(item, result);
                    }
                    if (stringMap.isEmpty()) {
                        needConfirmCache.remove(modelId);
                    } else {
                        needConfirmCache.put(modelId, stringMap);
                    }
                    if (needConfirmCache.size() == 0) {
                        this.getPageCache().remove("needConfirm");
                    } else {
                        this.getPageCache().put("needConfirm", SerializationUtils.serializeToBase64((Object)needConfirmCache));
                    }
                }
            } else if (Objects.equals(false, newValue)) {
                if (StringUtils.isNotEmpty((String)needConfirm)) {
                    Map needConfirmCache = (Map)SerializationUtils.deSerializeFromBase64((String)needConfirm);
                    HashMap<String, String> stringMap = (HashMap<String, String>)needConfirmCache.get(modelId);
                    if (stringMap == null) {
                        stringMap = new HashMap<String, String>(16);
                    }
                    stringMap.put(item, result);
                    needConfirmCache.put(modelId, stringMap);
                    this.getPageCache().put("needConfirm", SerializationUtils.serializeToBase64((Object)needConfirmCache));
                } else {
                    HashMap needConfirmCache = new HashMap(16);
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put(item, result);
                    needConfirmCache.put(modelId, map);
                    this.getPageCache().put("needConfirm", SerializationUtils.serializeToBase64(needConfirmCache));
                }
            }
        }
    }
}

