/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ExamineAnnotationV1Plugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BUTTON_OK = "button_ok";
    private static final String BUTTON_CANCEL = "button_cancel";
    private static final String REPORTPROCESS = "reportprocess";
    private static final Log log = LogFactory.getLog(ExamineAnnotationV1Plugin.class);
    private static final String CACHE_ATTACH_POPUP = "attachPopupCache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK, BUTTON_CANCEL});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.insertMutexRecord();
        this.getModel().setValue("model", this.getFormCustomParam("model"));
        this.getPageCache().put("remark", (String)this.getModel().getValue("remark"));
        this.getPageCache().put("isAddNew", "true");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("remark", (String)this.getModel().getValue("remark"));
        this.loadAttachData();
    }

    private void loadAttachData() {
        List attachments = new ArrayList(16);
        String file_url = this.getView().getParentView().getPageCache().get(CACHE_ATTACH_POPUP);
        if (!kd.epm.eb.common.utils.StringUtils.isEmpty((String)file_url)) {
            attachments = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
        } else if (this.getFileId() != 0L) {
            attachments.addAll(AttachmentServiceHelper.getAttachments((String)"eb_examine_annotatio_v1", (Object)this.getFileId(), (String)"attachmentpanelap"));
        } else {
            return;
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.bindData(attachments);
    }

    private void processUpload(UploadEvent evt, boolean isRemove) {
        List<Object> urls = null;
        urls = this.getPageCache().get("file_url") == null ? new ArrayList(16) : (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
        for (Object url : evt.getUrls()) {
            if (isRemove) {
                urls = urls.stream().filter(x -> !x.get("url").equals(((Map)url).get("url"))).collect(Collectors.toList());
                continue;
            }
            urls.add((Map)url);
        }
        this.getPageCache().put("file_url", SerializationUtils.serializeToBase64(urls));
    }

    public void afterUpload(UploadEvent evt) {
        this.processUpload(evt, false);
    }

    private void saveAttachmentData(Map<String, Object> url, Long id, String urlstr) {
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynObj.set("fBillType", (Object)"eb_examine_annotatio_v1");
        dynObj.set("fnumber", url.get("uid"));
        dynObj.set("fInterID", (Object)id);
        dynObj.set("fFileId", (Object)urlstr);
        dynObj.set("fAttachmentName", url.get("name"));
        dynObj.set("fExtName", url.get("type"));
        dynObj.set("fAttachmentSize", url.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", url.get("creator"));
        dynObj.set("fCreateTime", url.get("createdate"));
        dynObj.set("fModifyMen_Id", url.get("creator"));
        dynObj.set("fModifyTime", url.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    private Long getFileId() {
        Object templateId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (templateId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)templateId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "button_ok": {
                this.saveAnnotation();
                break;
            }
            case "button_cancel": {
                String currentRemark = (String)this.getModel().getValue("remark");
                String oldRemark = this.getPageCache().get("remark");
                if (currentRemark.equals(oldRemark)) {
                    this.getView().close();
                    break;
                }
                String message = ResManager.loadKDString((String)"\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BgTaskPackageEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BUTTON_CANCEL, (IFormPlugin)this));
                break;
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.processUpload(evt, true);
    }

    private void saveAnnotation() {
        DynamicObject[] updateReports;
        Object remark = this.getModel().getValue("remark");
        if (remark == null || StringUtils.isBlank((String)remark.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u6ce8\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7eaf\u7a7a\u683c\u3002", (String)"ExamineCheckReportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("remark", (Object)remark.toString().trim());
        String examineReport = (String)this.getFormCustomParam("examineReport");
        if (StringUtils.isEmpty((String)examineReport)) {
            return;
        }
        List reports = (List)SerializationUtils.deSerializeFromBase64((String)examineReport);
        Optional<Integer> optional = reports.stream().map(x -> x.getInt("processtype")).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        List ids = reports.stream().filter(x -> {
            int status = x.getInt("status");
            return status == ExamineCheckResultEnum.NoPass.getIndex() || status == ExamineCheckResultEnum.NoPassCanAnnotation.getIndex() || status == ExamineCheckResultEnum.NoPassIgnore.getIndex();
        }).map(x -> x.getLong("id")).collect(Collectors.toList());
        String file_url = this.getPageCache().get("file_url");
        List urls = new ArrayList(16);
        if (StringUtils.isNotEmpty((String)file_url)) {
            urls = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
        }
        ArrayList finalUrls = urls;
        List collect = reports.stream().map(report -> {
            DynamicObject annotation = BusinessDataServiceHelper.newDynamicObject((String)"eb_examine_annotatio_v1");
            long longId = ID.genLongId();
            for (Map url : finalUrls) {
                String urlstr = AttachmentServiceHelper.saveTempToFileService((String)url.get("url").toString(), (String)"epm", (String)"eb_examine_annotatio_v1", (Object)longId, (String)url.get("name").toString());
                this.saveAttachmentData(url, longId, urlstr);
            }
            annotation.set("id", (Object)longId);
            annotation.set("model", this.getFormCustomParam("model"));
            annotation.set(REPORTPROCESS, (Object)report.getLong(REPORTPROCESS));
            annotation.set("billid", (Object)report.getLong("applybill"));
            annotation.set("examine", (Object)report.getLong("examine.id"));
            annotation.set("modifier", this.getModel().getValue("modifier"));
            annotation.set("modifydate", this.getModel().getValue("modifydate"));
            annotation.set("remark", this.getModel().getValue("remark"));
            annotation.set("dimrange", (Object)report.getString("dimrange"));
            return annotation;
        }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(x -> x.getLong(REPORTPROCESS) + ":" + x.getLong("examine.id") + ":" + x.getString("dimrange")))), ArrayList::new));
        Map<String, List<DynamicObject>> annotationGroupMap = collect.stream().collect(Collectors.groupingBy(x -> x.getLong(REPORTPROCESS) + "_" + x.getLong("examine")));
        for (DynamicObject dynamicObject : updateReports = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"))) {
            List<DynamicObject> dynamicObjectList = annotationGroupMap.get(dynamicObject.getLong("reportprocess.id") + "_" + dynamicObject.getLong("examine.id"));
            if (!CollectionUtils.isNotEmpty(dynamicObjectList)) continue;
            for (DynamicObject dynamicObject1 : dynamicObjectList) {
                if (!dynamicObject.get("dimrange").equals(dynamicObject1.get("dimrange"))) continue;
                dynamicObject.set("annotation", (Object)dynamicObject1.getLong("id"));
                this.updateExamineReportStatus(dynamicObject);
            }
        }
        try (TXHandle required = TX.required((String)"saveAnnotationInfo");){
            try {
                SaveServiceHelper.save((DynamicObject[])collect.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])updateReports);
            }
            catch (Exception ex) {
                log.error("\u6279\u6ce8\u5931\u8d25\uff1a" + ex);
                required.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u6ce8\u5931\u8d25\u3002", (String)"ExamineCheckReportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                if (required != null) {
                    if (var13_14 != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable throwable) {
                            var13_14.addSuppressed(throwable);
                        }
                    } else {
                        required.close();
                    }
                }
                return;
            }
        }
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void updateExamineReportStatus(DynamicObject dynamicObject) {
        if (ExamineBehaviorEnum.POSTIL.getValue().equals(dynamicObject.getString("examine.checkinfluence")) && (dynamicObject.getInt("status") == ExamineCheckResultEnum.NoPassCanAnnotation.getIndex() || dynamicObject.getInt("status") == ExamineCheckResultEnum.NoPass.getIndex())) {
            dynamicObject.set("status", (Object)ExamineCheckResultEnum.Annotation.getIndex());
        }
        if (ExamineBehaviorEnum.HINT.getValue().equals(dynamicObject.getString("examine.checkinfluence")) && dynamicObject.getInt("status") == ExamineCheckResultEnum.NoPassIgnore.getIndex() || dynamicObject.getInt("status") == ExamineCheckResultEnum.NoPass.getIndex()) {
            dynamicObject.set("status", (Object)ExamineCheckResultEnum.Annotation.getIndex());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "button_cancel": {
                if (MessageBoxResult.Yes.getValue() != evt.getResult().getValue()) break;
                this.getView().close();
                break;
            }
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseMutex();
    }

    private void releaseMutex() {
        DeleteServiceHelper.delete((String)"eb_exannotation_mutual", (QFilter[])new QFilter("annotation_process", "=", this.getFormCustomParam(REPORTPROCESS)).toArray());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void insertMutexRecord() {
        String examineReport = (String)this.getFormCustomParam("examineReport");
        if (StringUtils.isEmpty((String)examineReport)) {
            return;
        }
        List list = (List)SerializationUtils.deSerializeFromBase64((String)examineReport);
        Optional<Integer> optional = list.stream().map(x -> x.getInt("processtype")).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        Integer processtype = optional.get();
        Set reportprocess = ProcessTypeEnum.APPLY.getIndex() == processtype.intValue() ? list.stream().map(x -> x.getLong("applybill")).collect(Collectors.toSet()) : list.stream().map(x -> x.getLong(REPORTPROCESS)).collect(Collectors.toSet());
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        for (Long reportId : reportprocess) {
            DynamicObject mutexRecord = BusinessDataServiceHelper.newDynamicObject((String)"eb_exannotation_mutual");
            mutexRecord.set("annotation_process", (Object)reportId);
            mutexRecord.set("annotation_user", (Object)this.getUserId());
            dynamicObjects.add(mutexRecord);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
    }
}

