/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.examine.ExamineListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ExamineCategoryListF7Plugin
extends AbstractFormPlugin {
    protected static final String MODEL_KEY = "model";
    protected static final String BIZ_MODEL = "bizmodel";
    private static final String PRE_CUSTOM = "custom";
    private static final String BIZMODEL_KEY = "bizmodel";
    private static final String BTNOK = "btnok";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";

    public void initialize() {
        super.initialize();
        TreeEntryGrid entry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, "addnew", "edit"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            return;
        }
        this.initBizModel();
    }

    private void initExamineGroupTree(Set<Long> currentIds) {
        QFilter qf = new QFilter("businessmodel", "=", (Object)this.getBizModel());
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"eb_examinecategory", (String)"id,name,code,parent.id,isleaf,level,businessmodel,modifier.name,parent.name,modifydate", (QFilter[])qf.toArray(), (String)"level,createdate,realseq");
        if (CollectionUtils.isEmpty((Collection)catalogs)) {
            return;
        }
        Set<Long> ids = catalogs.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Map examineGroupDimMemberScope = ExamineServiceImpl.getInstance().getExamineGroupDimMemberScope(ids);
        Map<Long, DynamicObject> maps = catalogs.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        TreeNode treeNode = ExamineListPlugin.generateExamineGroupTree(this.getBizModel(), catalogs);
        this.getPageCache().put("cacheExamineGroupTreeParam", ObjectSerialUtil.toByteSerialized((Object)treeNode));
        ArrayList<Integer> rowNums = new ArrayList<Integer>(16);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(TREE_ENTRY_ENTITY, catalogs.size() + 1);
        DynamicObject rowObject = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, 0);
        rowObject.set("number", (Object)treeNode.getLongNumber());
        rowObject.set("name", (Object)treeNode.getText());
        rowObject.set("id", (Object)Long.parseLong(treeNode.getId()));
        rowObject.set("pid", (Object)0);
        this.handleTree(this.getModel(), treeNode.getChildren(), examineGroupDimMemberScope, maps, 1, rowNums, currentIds);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeEntry.setCollapse(false);
        this.getModel().endInit();
        this.getView().updateView(TREE_ENTRY_ENTITY);
        if (!rowNums.isEmpty()) {
            int[] rowIndexs = rowNums.stream().mapToInt(Integer::valueOf).toArray();
            treeEntry.selectRows(rowIndexs, rowIndexs[0]);
        }
        this.showHasDataDimCol(ids);
    }

    private int handleTree(IDataModel model, List<TreeNode> treeNodes, Map<Long, Map<String, String>> examineGroupDimMemberScope, Map<Long, DynamicObject> maps, int row, List<Integer> rowNums, Set<Long> currentId) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return row;
        }
        for (TreeNode treeNode : treeNodes) {
            if (currentId.contains(Long.valueOf(treeNode.getId()))) {
                rowNums.add(row);
            }
            DynamicObject child = maps.get(Long.parseLong(treeNode.getId()));
            DynamicObject rowObject = model.getEntryRowEntity(TREE_ENTRY_ENTITY, row);
            ++row;
            rowObject.set("number", (Object)child.getString("code"));
            rowObject.set("name", (Object)child.getString("name"));
            rowObject.set("groupmodifier1", (Object)child.getString("modifier.name"));
            rowObject.set("parent", child.get("parent.name"));
            rowObject.set("modifydate1", (Object)child.getDate("modifydate"));
            Map<String, String> dimMemberScopeMap = examineGroupDimMemberScope.get(child.getLong("id"));
            if (dimMemberScopeMap != null && dimMemberScopeMap.size() > 0) {
                for (Map.Entry<String, String> entry : dimMemberScopeMap.entrySet()) {
                    if (!SysDimensionEnum.include((String)entry.getKey(), (Boolean)true)) continue;
                    rowObject.set(entry.getKey().toLowerCase(), (Object)entry.getValue());
                }
            }
            rowObject.set("id", (Object)child.getLong("id"));
            rowObject.set("pid", (Object)treeNode.getParentid());
            if (!CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) continue;
            row = this.handleTree(this.getModel(), treeNode.getChildren(), examineGroupDimMemberScope, maps, row, rowNums, currentId);
        }
        return row;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{"bizmodel"});
        String currentIdJson = (String)this.getView().getFormShowParameter().getCustomParam("currentids");
        Set currentIds = (Set)JsonUtils.readValue((String)currentIdJson, (TypeReference)new TypeReference<Set<Long>>(){});
        this.initExamineGroupTree(currentIds);
    }

    private void initBizModel() {
        Object businessmodel = this.getView().getFormShowParameter().getCustomParam("businessmodel");
        if (businessmodel != null) {
            this.getModel().setValue("bizmodel", businessmodel);
        }
    }

    private void initModel() {
        Object model = this.getView().getFormShowParameter().getCustomParam(MODEL_KEY);
        if (model != null) {
            this.getModel().setValue(MODEL_KEY, model);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btnok": {
                int[] rowNums;
                String clickNodeString;
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
                TreeNode clickNode = null;
                String formId = this.getView().getFormShowParameter().getFormId();
                if ("eb_examinecategory_f7_s".equals(formId) && StringUtils.isNotEmpty((String)(clickNodeString = (String)this.getView().getFormShowParameter().getCustomParam("clickNodePageParam")))) {
                    clickNode = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)clickNodeString);
                }
                if ((rowNums = entryGrid.getSelectRows()) == null || rowNums.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                HashSet<Long> ids = new HashSet<Long>(rowNums.length);
                for (int row : rowNums) {
                    Long id = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, row).getLong("id");
                    if ("eb_examinecategory_f7_s".equals(formId)) {
                        TreeNode treeNode;
                        if (ExamineServiceImpl.getInstance().existDimMemberScope(id)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u8bbe\u7f6e\u4e86\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u589e\u52a0\u4e0b\u7ea7\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"EbExamineEditPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (clickNode != null && !OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && (treeNode = clickNode.getTreeNode(id.toString(), 10)) != null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u4e0a\u7ea7\u5206\u7ec4\u4e3a\u5f53\u524d\u8282\u70b9\u53ca\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"EbExamineEditPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    ids.add(id);
                }
                this.getView().returnDataToParent(ids);
                this.getView().close();
                break;
            }
            case "addnew": {
                this.checkExamineGroupPermItem("47156aff000000ac");
                this.showTreeAddOrEditForm("1");
                break;
            }
            case "edit": {
                this.checkExamineGroupPermItem("4715a0df000000ac");
                this.showTreeAddOrEditForm("2");
                break;
            }
        }
    }

    private void checkExamineGroupPermItem(String key) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        Long userId = UserUtils.getUserId();
        int is = this.checkItemPermission(userId, modelId, this.getBizAppId(), "eb_examinelist", key);
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u52fe\u7a3d\u5173\u7cfb\u7684\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u64cd\u4f5c\u6743\u9650\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("examineGroupCloseCallBack".equals(event.getActionId())) {
            if (event.getReturnData() == null) {
                return;
            }
            String currentIdJson = (String)this.getView().getFormShowParameter().getCustomParam("currentids");
            Set currentIds = (Set)JsonUtils.readValue((String)currentIdJson, (TypeReference)new TypeReference<Set<Long>>(){});
            this.initExamineGroupTree(currentIds);
        }
    }

    private void showTreeAddOrEditForm(String type) {
        TreeNode rootNode = null;
        if ("1".equals(type)) {
            rootNode = new TreeNode("", this.getBizModel().toString(), ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4", (String)"ExamineListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> rootData = new HashMap<String, Object>(16);
            rootData.put("level", 2);
            rootData.put("name", rootNode.getText());
            rootNode.setData(rootData);
            rootNode.setLongNumber("root");
            if ("root".equals(rootNode.getLongNumber()) && type.equals("2")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (type.equals("1") && ExamineServiceImpl.getInstance().existDimMemberScope(IDUtils.toLong((Object)rootNode.getId()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u8bbe\u7f6e\u4e86\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u4e0d\u53ef\u4ee5\u589e\u52a0\u4e0b\u7ea7\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineCategoryListF7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rows[0]);
            String number = dynamicObject.getString("number");
            if ("root".equals(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ExamineListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject catalog = QueryServiceHelper.queryOne((String)"eb_examinecategory", (String)"id,name,code,parent.id,isleaf,level,businessmodel", (QFilter[])new QFilter("id", "=", (Object)dynamicObject.getLong("id")).toArray());
            if (catalog == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            rootNode = new TreeNode(catalog.getString("parent.id"), catalog.getString("id"), catalog.getString("name"));
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("level", catalog.getInt("level"));
            data.put("name", rootNode.getText());
            rootNode.setData(data);
            rootNode.setLeaf(catalog.getBoolean("isleaf"));
            rootNode.setLongNumber(catalog.getString("code"));
            Object id = this.getView().getParentView().getModel().getValue("id");
            if ("root".equals(rootNode.getLongNumber()) && type.equals("2")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (type.equals("1") && ExamineServiceImpl.getInstance().existDimMemberScope(IDUtils.toLong((Object)rootNode.getId()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u8bbe\u7f6e\u4e86\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u4e0d\u53ef\u4ee5\u589e\u52a0\u4e0b\u7ea7\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineCategoryListF7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("mutigroup.fbasedataid", "=", (Object)catalog.getLong("id"));
            if (id != null) {
                qFilter.and("id", "!=", (Object)Long.parseLong(id.toString()));
            }
            this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootNode));
            if (QueryServiceHelper.exists((String)"eb_examine", (QFilter[])qFilter.toArray())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u5df2\u88ab\u591a\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5f15\u7528\uff0c\u4fee\u6539\u5c06\u540c\u65f6\u5f71\u54cd\u6240\u6709\u5f15\u7528\u7684\u52fe\u7a3d\u5173\u7cfb\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u4fee\u6539\uff1f", (String)"ExamineListPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("editConfirm", (IFormPlugin)this));
                return;
            }
        }
        this.openExamineGroupPage(rootNode, type);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "editConfirm": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                String rootNodeString = this.getPageCache().get("rootNode");
                if (StringUtils.isEmpty((String)rootNodeString)) {
                    return;
                }
                TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeString, TreeNode.class);
                this.openExamineGroupPage(rootNode, "2");
                break;
            }
        }
    }

    private void openExamineGroupPage(TreeNode clickNode, String type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_examinecategory");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put(MODEL_KEY, this.getModelId());
        paramsMap.put("businessmodel", this.getBizModel());
        String treeNodeString = this.getPageCache().get("cacheExamineGroupTreeParam");
        paramsMap.put("cacheExamineGroupTreeParam", treeNodeString);
        paramsMap.put("clickNodePageParam", ObjectSerialUtil.toByteSerialized((Object)clickNode));
        showParameter.setCustomParams(paramsMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "examineGroupCloseCallBack"));
        if (Objects.equal((Object)"1", (Object)type)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u7ec4", (String)"ExamineListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            paramsMap.put("needLockMemberScope", this.isNeedLockMemberScope(clickNode) ? "1" : "0");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5206\u7ec4", (String)"ExamineListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(showParameter);
    }

    private boolean isNeedLockMemberScope(TreeNode clickNode) {
        return ExamineServiceImpl.getInstance().isLeaf(IDUtils.toLong((Object)clickNode.getId()));
    }

    private void showHasDataDimCol(Set<Long> groupIds) {
        String[] dimCols = this.getAllDimCols();
        this.getView().setVisible(Boolean.valueOf(false), dimCols);
        Set hasMemberScopeDim = ExamineServiceImpl.getInstance().getHasMemberScopeDim(groupIds);
        if (hasMemberScopeDim.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), hasMemberScopeDim.toArray(new String[0]));
        }
    }

    private String[] getAllDimCols() {
        SysDimensionEnum[] values = SysDimensionEnum.values();
        String[] dimCols = new String[values.length + 10];
        for (int i = 0; i < values.length; ++i) {
            dimCols[i] = values[i].getNumber().toLowerCase();
        }
        for (int j = 0; j < 10; ++j) {
            dimCols[values.length + j] = PRE_CUSTOM + j;
        }
        return dimCols;
    }

    private Long getBizModel() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue("bizmodel");
        if (bizModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
        return bizModel.getLong("id");
    }

    @Override
    public Long getModelId() {
        DynamicObject curModel = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (curModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
        return curModel.getLong("id");
    }
}

