/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.examine.bo.ExamineBaseInfo;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.permission.EBPermissionUtils;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExamineListPlugin
extends MainSubAbstractListPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
CreateListDataProviderListener,
EBPermission,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ExamineListPlugin.class);
    protected static final String MODEL_KEY = "model";
    private static final String BAR_ADD = "baradd";
    private static final String BAR_COPY = "barcopy";
    private static final String BAR_ENABLE = "barenable";
    private static final String BAR_FORBIDDEN = "barforbidden";
    private static final String BTN_MOVE = "btn_move";
    private static final String BAR_REFRESH = "barrefresh";
    private static final String BAR_DELETE = "bardelete";
    private static final String BAR_EXIT = "barexit";
    private static final String TOOLBARAP = "toolbarap";
    private static final String VARIABLE_SET = "variable_set";
    public static final String EB_EXAMINE = "eb_examine";
    public static final String EB_EXAMINE_NUMBER_AGC = "eb_examine_number_agc";
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String CONFIRM_DELETE_TREE_NODE = "confirmDeleteTreeNode";
    private static final String CONFIRM_DELETE_EXAMINE = "confirmDeleteExamine";
    protected static final String CLICK_NODE_PAGE_PARAM = "clickNodePageParam";
    protected static final String AFTER_AE_EXAMINE = "afterAEExamine";
    public static final String BUSINESS_MODEL_KEY = "businessmodel";
    private static final String BILLLISTKEY = "billlistap";
    private static final String FILTER_CONTAINER = "filtercontainerap";
    private static final String LEFT_TAB = "lefttab";
    private static final String EXAMINE_TAB = "examinetab";
    private static final String TEMPLATE_TAB = "templatetab";
    private static final String EXAMINE_GROUP_TREE = "examinegrouptree";
    private static final String TEMPLATE_TREE = "templatetree";
    private static final String EXAMINE_GROUP_LIST = "examinegrouplist";
    private static final String BIZMODEL_KEY = "bizmodel";
    private static final String BIZMODEL_SWITCH = "bizmodelswitch";
    private static final String BIZMODEL_LABEL = "bizmodlelable";
    private static final String CACHE_EXAMINE_GROUP_TREE_NODE = "cacheExamineGroupTreeNodeId";
    private static final String CACHE_TEMPLATE_TREE_NODE = "cacheTemplateTreeNodeId";
    private static final String CACHE_TEMPLATE_TREE = "cacheTemplateTree";
    private static final String CACHE_EXAMINEGROUP_TREE = "cacheExamineGroupTree";
    public static final String CACHE_EXAMINEGROUP_TREE_PARAM = "cacheExamineGroupTreeParam";
    public static final String EXAMINE_GROUP_CLOSECALLBACK = "examineGroupCloseCallBack";
    private static final String EXAMINE_MOVE_CLOSECALLBACK = "examineMoveCloseCallBack";
    public static final String LOCK_SIGN = "needLockMemberScope";
    public static final String ADD_EXAMINE_BASE_INFO = "addExamineBaseInfo";
    public static final String LABELAP = "labelap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        FilterContainer fc = (FilterContainer)this.getControl(FILTER_CONTAINER);
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId(EB_EXAMINE);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        try {
            super.filterContainerInit(args);
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (!"maindimension".equals(filterColumn.getFieldName()) || !(filterColumn instanceof CommonFilterColumn)) continue;
                List dimensionList = this.getIModelCacheHelper().getDimensionListByBusModel(this.getCurBizModel());
                List comboItemList = dimensionList.stream().filter(x -> !SysDimensionEnum.InternalCompany.getNumber().equals(x.getNumber())).map(dimension -> new ComboItem(new LocaleString(dimension.getName()), dimension.getId() + "-" + dimension.getNumber())).collect(Collectors.toList());
                ((CommonFilterColumn)filterColumn).setComboItems(comboItemList);
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{BTN_ADD, BTN_EDIT, BTN_DELETE, BIZMODEL_SWITCH, "searchbefore", "searchnext", "searchbefore1", "searchnext1"});
        BasedataEdit dataEdit = (BasedataEdit)this.getControl(MODEL_KEY);
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dataEdit = (BasedataEdit)this.getControl(BIZMODEL_KEY)) != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        EntryGrid entryGrid = (EntryGrid)this.getControl(EXAMINE_GROUP_LIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab leftTab = (Tab)this.getControl(LEFT_TAB);
        leftTab.addTabSelectListener(this::tabSelected);
        this.addTreeNodeClickListener(this, EXAMINE_GROUP_TREE);
        this.addTreeNodeClickListener(this, TEMPLATE_TREE);
        this.addSearchListener("searchap1", EXAMINE_GROUP_TREE, CACHE_EXAMINEGROUP_TREE);
        this.addSearchListener("searchap2", TEMPLATE_TREE, CACHE_TEMPLATE_TREE);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABELAP});
            this.initModel();
            if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
                return;
            }
            this.initBizModel();
            this.tabSelected(new TabSelectEvent((Object)this.getControl(LEFT_TAB), EXAMINE_TAB));
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void initBizModel() {
        DynamicObject object;
        Long curBizModel = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId());
        if (IDUtils.isEmptyLong((Long)curBizModel).booleanValue()) {
            curBizModel = this.getCurBizModel();
        }
        if (IDUtils.isNotNull((Long)curBizModel) && (object = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"name", (QFilter[])new QFilter("id", "=", (Object)curBizModel).toArray())) != null) {
            this.getModel().setValue(BIZMODEL_KEY, (Object)curBizModel);
            ((Label)this.getControl(BIZMODEL_LABEL)).setText(object.getString("name"));
        }
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{"bizmodelflex"});
    }

    private void initModel() {
        Long modelId = this.getModelIdAfterCreateNewData();
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL_KEY, (Object)modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"ExamineListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            String key = event.getProperty().getName();
            if (MODEL_KEY.equals(key)) {
                PluginUtils.setModelFilter(event, this.getView());
            } else if (BIZMODEL_KEY.equals(key)) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
                if (filters == null) {
                    filters = new ArrayList<QFilter>(16);
                }
                filters.add(new QFilter(MODEL_KEY, "=", (Object)this.getCurModelId()));
                showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            switch (e.getProperty().getName()) {
                case "model": {
                    this.modelChange();
                    break;
                }
                case "bizmodel": {
                    this.bizModelChange();
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void bizModelChange() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZMODEL_KEY);
        if (bizModel != null) {
            ((Label)this.getControl(BIZMODEL_LABEL)).setText(bizModel.getString("name"));
            UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)bizModel.getLong("id"));
        }
        this.pageRefresh();
    }

    private void modelChange() {
        Long newModelId = this.getCurModelId();
        if (IDUtils.isEmptyLong((Long)newModelId).booleanValue()) {
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)newModelId);
        this.initBizModel();
        this.pageRefresh();
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        try {
            super.beforeClick(evt);
            if (evt.getSource() instanceof Control) {
                this.checkPermission(this.getView(), ((Control)evt.getSource()).getKey());
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        try {
            String column = arg0.getFieldName();
            if ("number".equals(column)) {
                this.checkPermission();
            } else if ("examinegroupnumber".equals(column)) {
                this.checkExamineGroupPermItem();
                this.examineGroupHyperlink();
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void examineGroupHyperlink() {
        TreeNode treeNode;
        Object value = this.getModel().getValue("examinegroupid");
        TreeNode clickNodeFromCache = this.getClickNodeFromCache(false);
        if (value != null && clickNodeFromCache != null && (treeNode = clickNodeFromCache.getTreeNode(value.toString(), 10)) != null) {
            this.openExamineGroupPage(treeNode, "2");
        }
    }

    private void checkPermission() {
        String[] items;
        String permItem;
        String source = this.getView().getEntityId();
        if (StringUtils.isBlank((String)source)) {
            throw new KDBizException("view is null.");
        }
        String operation = "baredit";
        Map permItemsMap = EBPermissionUtils.getInstance().getPermItem().getPermItemsMap();
        Map entityItems = (Map)permItemsMap.get(source);
        if (entityItems != null && (permItem = (String)entityItems.get(operation)) != null && (items = permItem.split("@")) != null && items.length >= 3) {
            this.doEBCheckPermission(items[0], items[1], items[2]);
        }
    }

    @Override
    public void click(EventObject evt) {
        try {
            String key;
            super.click(evt);
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "btnadd": {
                    this.showTreeAddOrEditForm("1");
                    break;
                }
                case "btnedit": {
                    this.showTreeAddOrEditForm("2");
                    break;
                }
                case "btndelete": {
                    this.showTreeDeleteFrom();
                    break;
                }
                case "bizmodelswitch": {
                    this.switchBizModel();
                    break;
                }
                case "searchbefore": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EXAMINE_GROUP_TREE, CACHE_EXAMINEGROUP_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                    break;
                }
                case "searchnext": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EXAMINE_GROUP_TREE, CACHE_EXAMINEGROUP_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                    break;
                }
                case "searchbefore1": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATE_TREE, CACHE_TEMPLATE_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                    break;
                }
                case "searchnext1": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATE_TREE, CACHE_TEMPLATE_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                    break;
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void checkExamineGroupPermItem() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        Long userId = UserUtils.getUserId();
        int is = this.checkItemPermission(userId, modelId, this.getBizAppId(), this.getView().getEntityId(), "4715a0df000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u52fe\u7a3d\u5173\u7cfb\u7684\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u64cd\u4f5c\u6743\u9650\u3002", (String)"ExamineListPlugin_83", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void moveExamine() {
        Tab control = (Tab)this.getControl(LEFT_TAB);
        TreeNode clickNodeFromCache = this.getClickNodeFromCache(false);
        if (TEMPLATE_TAB.equals(control.getCurrentTab())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u6309\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u201d\u9875\u7b7e\u4e0b\u9009\u62e9\u52fe\u7a3d\u5173\u7cfb\u79fb\u52a8\u3002", (String)"ExamineListPlugin_79", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (clickNodeFromCache == null || clickNodeFromCache.getId().equals(this.getCurBizModel().toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u8282\u70b9\u3002", (String)"ExamineListPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList list = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection cards = list.getSelectedRows();
        if (cards == null || cards.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u79fb\u52a8\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"ExamineListPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("eb_examinecategory");
        showParameter.setShowApproved(true);
        showParameter.setShowUsed(true);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId()).and(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel());
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXAMINE_MOVE_CLOSECALLBACK));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void moveExamine(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        long toExamineGroup = 0L;
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnRows = (ListSelectedRowCollection)returnData;
            if (returnRows.isEmpty()) {
                return;
            }
            toExamineGroup = IDUtils.toLong((Object)returnRows.get(0).getPrimaryKeyValue());
        }
        long examineGroupId = 0L;
        TreeNode clickNodeFromCache = this.getClickNodeFromCache(false);
        if (clickNodeFromCache != null && !clickNodeFromCache.getId().equals(this.getCurBizModel().toString())) {
            examineGroupId = IDUtils.toLong((Object)clickNodeFromCache.getId());
        }
        HashSet<Long> selectExamineIds = new HashSet<Long>(16);
        BillList control = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            selectExamineIds.add(IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
        }
        if (IDUtils.isNotEmptyLong((Long)toExamineGroup).booleanValue() && IDUtils.isNotEmptyLong((Long)examineGroupId).booleanValue() && selectExamineIds.size() > 0) {
            try {
                String sql = "update t_eb_examine_relation set fbasedataid = ? where fid in (" + SqlBatchUtils.getBatchParamsSql((int)selectExamineIds.size()) + ") and fbasedataid =  ? ;";
                String oldDataSql = "update t_eb_examine set fgroup = ? where fid in (" + SqlBatchUtils.getBatchParamsSql((int)selectExamineIds.size()) + ") and fgroup =  ? ;";
                ArrayList<Long> sqlParams = new ArrayList<Long>(selectExamineIds.size() + 2);
                sqlParams.add(toExamineGroup);
                sqlParams.addAll(selectExamineIds);
                sqlParams.add(examineGroupId);
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])sqlParams.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)oldDataSql, (Object[])sqlParams.toArray());
                ExamineServiceImpl.getInstance().clearExamineCache(this.getModelId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"ExamineListPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        this.pageRefresh();
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        try {
            super.beforeItemClick(evt);
            this.checkPermission(this.getView(), evt.getItemKey());
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        try {
            String key;
            super.itemClick(evt);
            switch (key = evt.getItemKey()) {
                case "baradd": {
                    this.showExamineBaseInfo();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u65b0\u589e", "ExamineListPlugin_50", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u65b0\u589e\u6210\u529f", "ExamineListPlugin_51", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"add", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "barcopy": {
                    this.copyExamine();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u590d\u5236", "ExamineListPlugin_54", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u590d\u5236\u6210\u529f", "ExamineListPlugin_55", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"copy", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "bardelete": {
                    this.showExamineDeleteForm();
                    ExamineServiceImpl.getInstance().clearExamineCache(this.getModelId());
                    break;
                }
                case "barrefresh": {
                    this.pageRefresh();
                    break;
                }
                case "barexit": {
                    this.getView().close();
                    break;
                }
                case "barforbidden": {
                    this.changeExamineStatus(BAR_FORBIDDEN);
                    ExamineServiceImpl.getInstance().clearExamineCache(this.getModelId());
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u7981\u7528", "ExamineListPlugin_65", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u7981\u7528\u6210\u529f", "ExamineListPlugin_66", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"disable", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "barenable": {
                    this.changeExamineStatus(BAR_ENABLE);
                    ExamineServiceImpl.getInstance().clearExamineCache(this.getModelId());
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u542f\u7528", "ExamineListPlugin_67", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u542f\u7528\u6210\u529f", "ExamineListPlugin_68", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"enable", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "variable_set": {
                    this.showVariableSetFrom();
                    break;
                }
                case "btn_move": {
                    this.moveExamine();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u79fb\u52a8", "ExamineListPlugin_52", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u79fb\u52a8\u6210\u529f", "ExamineListPlugin_53", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"move", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "btn_upgrade": {
                    this.upgrade();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5347\u7ea7", "ExamineListPlugin_74", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5347\u7ea7\u6210\u529f", "ExamineListPlugin_75", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"upgrade", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void showExamineBaseInfo() {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setStatus(OperationStatus.ADDNEW);
        ExamineBaseInfo examineBaseInfo = new ExamineBaseInfo();
        examineBaseInfo.setModelId(this.getCurModelId());
        examineBaseInfo.setBizModelId(this.getCurBizModel());
        if ("root".equals(clickNode.getLongNumber())) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"eb_examinecategory", (String)"id", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)this.getModelId()).and(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel()).and("code", "=", (Object)"SYS_default").toArray());
            examineBaseInfo.setGroup(object.getString("id"));
        } else {
            examineBaseInfo.setGroup(clickNode.getId());
        }
        paramsMap.put("examineBaseInfo", ObjectSerialUtil.toByteSerialized((Object)examineBaseInfo));
        showParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u57fa\u672c\u4fe1\u606f", (String)"ExamineListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("eb_examine_base_info");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(paramsMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_EXAMINE_BASE_INFO);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public Long getUserId() {
        return super.getUserId();
    }

    @Override
    public boolean isCheckModel() {
        return true;
    }

    @Override
    public Long getModelId() {
        return this.getCurModelId();
    }

    private void showVariableSetFrom() {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)modelId).and("type", "=", (Object)"2");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rule_varible", (String)"id", (QFilter[])qFilter.toArray());
        Long id = null;
        params.put(MODEL_KEY, modelId);
        params.put("type", "2");
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("eb_rule_varible");
        parameter.setCustomParams(params);
        if (dynamicObject != null) {
            id = dynamicObject.getLong("id");
            parameter.setPkId((Object)id.toString());
        }
        parameter.setCaption(ResManager.loadKDString((String)"\u53d8\u91cf\u8d4b\u503c", (String)"ExamineListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.setBillStatus(BillOperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showvariableset");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void changeExamineStatus(String statusStr) {
        DynamicObject[] doArr;
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        if (billList.getSelectedRows().size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ExamineListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BAR_ENABLE.equals(statusStr)) {
            this.checkExamineRange(billList.getSelectedRows().getPrimaryKeyValues());
        }
        for (DynamicObject dynamicObject : doArr = BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType())) {
            dynamicObject.set("status", (Object)(BAR_FORBIDDEN.equals(statusStr) ? "0" : "1"));
        }
        SaveServiceHelper.save((DynamicObject[])doArr);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u7528/\u7981\u7528", "ExamineListPlugin_1", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u542f\u7528/\u7981\u7528\u6210\u529f\u3002", "ExamineListPlugin_2", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"enable/disable", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
        this.initBillList();
        if (BAR_FORBIDDEN.equals(statusStr)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExamineListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (BAR_ENABLE.equals(statusStr)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ExamineListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkExamineRange(Object[] ids) {
        Map<Long, ExamineDto> examineDtoMap = ExamineServiceImpl.getInstance().listExamineFromLocalCache(this.getModelId()).getExamineDtoList().stream().collect(Collectors.toMap(ExamineDto::getId, x -> x));
        Set longIds = Arrays.stream(ids).map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
        List examineDtos = ExamineServiceImpl.getInstance().listExamineFromDB(this.getModelId(), "", longIds);
        for (ExamineDto examineDto : examineDtos) {
            for (ExamineDto examineDto1 : examineDtos) {
                this.checkExamineRange(examineDto, examineDto1);
            }
            for (ExamineDto examineDto1 : examineDtoMap.values()) {
                this.checkExamineRange(examineDto, examineDto1);
            }
        }
    }

    private void checkExamineRange(ExamineDto examineDto, ExamineDto examineDto1) {
        if (examineDto.getId().equals(examineDto1.getId()) || !examineDto1.getFormulaStr().equals(examineDto.getFormulaStr())) {
            return;
        }
        Collection examineAuditPojoNumberStringIntersectionSet = CollectionUtils.intersection(examineDto1.getScopes().keySet(), examineDto.getScopes().keySet());
        if (CollectionUtils.isEmpty((Collection)examineAuditPojoNumberStringIntersectionSet)) {
            return;
        }
        boolean existEmptyMemberNumberStringIntersectionSet = false;
        for (String ruleAuditPojoNumberString : examineAuditPojoNumberStringIntersectionSet) {
            Collection memberNumberStringIntersectionSet;
            Set memberNumberStringSet = (Set)examineDto1.getScopes().get(ruleAuditPojoNumberString);
            Set previousMemberNumberStringSet = (Set)examineDto.getScopes().get(ruleAuditPojoNumberString);
            if (CollectionUtils.isEmpty((Collection)memberNumberStringSet) || CollectionUtils.isEmpty((Collection)previousMemberNumberStringSet) || !CollectionUtils.isEmpty((Collection)(memberNumberStringIntersectionSet = CollectionUtils.intersection((Iterable)memberNumberStringSet, (Iterable)previousMemberNumberStringSet)))) continue;
            existEmptyMemberNumberStringIntersectionSet = true;
            break;
        }
        if (!existEmptyMemberNumberStringIntersectionSet) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u4e0e%2\u52fe\u7a3d\u5173\u7cfb\u7684\u9002\u7528\u8303\u56f4\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"EbExamineEditPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[]{examineDto1.getNumber(), examineDto.getNumber()}));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        try {
            super.closedCallBack(evt);
            String actionKey = evt.getActionId();
            if (actionKey.equals(EXAMINE_GROUP_CLOSECALLBACK)) {
                this.loadExamineGroupTree();
                Object returnData = evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                ExamineServiceImpl.getInstance().listExamineFromLocalCache(this.getModelId());
            } else if (actionKey.equals(EXAMINE_MOVE_CLOSECALLBACK)) {
                this.moveExamine(evt);
            } else if (actionKey.equals(ADD_EXAMINE_BASE_INFO)) {
                Object returnData = evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                this.showExamineAddForm(returnData.toString());
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        try {
            String callBackId;
            super.confirmCallBack(evt);
            switch (callBackId = evt.getCallBackId()) {
                case "confirmDeleteTreeNode": {
                    if (!MessageBoxResult.Yes.name().equals(evt.getResultValue())) break;
                    this.deleteTreeNodes();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u5220\u9664", "ExamineListPlugin_69", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u5220\u9664\u6210\u529f", "ExamineListPlugin_70", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"groupDelete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
                case "confirmDeleteExamine": {
                    if (!MessageBoxResult.Yes.name().equals(evt.getResultValue())) break;
                    this.deleteExamine();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5220\u9664", "ExamineListPlugin_71", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5220\u9664\u6210\u529f", "ExamineListPlugin_72", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
                    break;
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = null;
                try {
                    allRows = super.getData(start, limit);
                    ArrayList membInfoStrList = new ArrayList(16);
                    for (DynamicObject row : allRows) {
                        if (!row.containsProperty("formula")) continue;
                        String formulaStr = row.getString("formula");
                        ExamineServiceHelper.findMembInfoStr(membInfoStrList, (String)formulaStr);
                    }
                    Map dimMapMembNums = ExamineServiceHelper.mapDimMembNums(null, membInfoStrList, null, null);
                    Map dimMembFullInfo = ExamineServiceHelper.qureyDimMembInfo((Map)dimMapMembNums, (long)ExamineListPlugin.this.getCurModelId());
                    Map templateInfoMap = ExamineServiceImpl.getInstance().getTemplateInfoMap(ExamineListPlugin.this.getModelId());
                    IModelCacheHelper modelCacheHelper = ExamineListPlugin.this.getIModelCacheHelper();
                    for (DynamicObject row : allRows) {
                        if (!row.containsProperty("formula") || !row.containsProperty("maindimension")) continue;
                        String formulaStr = row.getString("formula");
                        String maindimension = row.getString("maindimension");
                        String dimNum = StringUtils.isBlank((String)maindimension) ? SysDimensionEnum.Account.getNumber() : maindimension.split("-")[1];
                        Dimension dimension = modelCacheHelper.getDimension(dimNum);
                        row.set("maindimension", (Object)dimension.getName());
                        row.set("formula", (Object)ExamineServiceHelper.changeFormulaShow((String)formulaStr, (Map)dimMembFullInfo, (Map)templateInfoMap, (Dimension)modelCacheHelper.getDimension(dimNum)));
                    }
                }
                catch (KDBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb\u89e3\u6790\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"ExamineListPlugin_73", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
                }
                return allRows;
            }
        });
    }

    protected void pageRefresh() {
        Tab tab = (Tab)this.getControl(LEFT_TAB);
        this.tabSelected(new TabSelectEvent((Object)tab, tab.getCurrentTab()));
    }

    protected void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                this.spreadAllNode(t);
            }
        }
    }

    protected Long getCurModelId() {
        DynamicObject curModel = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (curModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExamineListPlugin_81", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return curModel.getLong("id");
    }

    private void showTreeDeleteFrom() {
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            return;
        }
        Map data = (Map)clickNode.getData();
        if (data != null && "root".equals(String.valueOf(clickNode.getLongNumber()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashSet<Long> treeKeys = new LinkedHashSet<Long>();
        this.getExamineGroupChildrenNodeIds(treeKeys, clickNode);
        QFilter qf = new QFilter("group", "in", treeKeys);
        if (QueryServiceHelper.exists((String)"eb_examinecategory", (QFilter[])new QFilter("id", "in", treeKeys).and("code", "=", (Object)"SYS_default").toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u9ed8\u8ba4\u52fe\u7a3d\u5173\u7cfb\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExamineListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)EB_EXAMINE, (String)"id", (QFilter[])qf.toArray(), (String)"");){
            if (rows != null && rows.hasNext()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u52fe\u7a3d\u5173\u7cfb\uff0c\u518d\u5220\u9664\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5220\u9664\u9009\u4e2d\u7684\u52fe\u7a3d\u5173\u7cfb\u5206\u7c7b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExamineListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DELETE_TREE_NODE, (IFormPlugin)this));
    }

    private void showTreeAddOrEditForm(String type) {
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("root".equals(clickNode.getLongNumber()) && type.equals("2")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (type.equals("1") && ExamineServiceImpl.getInstance().existDimMemberScope(IDUtils.toLong((Object)clickNode.getId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u8bbe\u7f6e\u4e86\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u4e0d\u53ef\u4ee5\u589e\u52a0\u4e0b\u7ea7\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineCategoryListF7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openExamineGroupPage(clickNode, type);
    }

    private void openExamineGroupPage(TreeNode clickNode, String type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_examinecategory");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put(MODEL_KEY, this.getCurModelId());
        paramsMap.put(BUSINESS_MODEL_KEY, this.getCurBizModel());
        TreeNode leftTree = this.getLeftRootFromCache(false);
        paramsMap.put(CACHE_EXAMINEGROUP_TREE_PARAM, ObjectSerialUtil.toByteSerialized((Object)leftTree));
        paramsMap.put(CLICK_NODE_PAGE_PARAM, ObjectSerialUtil.toByteSerialized((Object)clickNode));
        showParameter.setCustomParams(paramsMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXAMINE_GROUP_CLOSECALLBACK));
        if (Objects.equal((Object)"1", (Object)type)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u7ec4", (String)"ExamineListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            paramsMap.put(LOCK_SIGN, this.isNeedLockMemberScope(clickNode) ? "1" : "0");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5206\u7ec4", (String)"ExamineListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(showParameter);
    }

    private void showExamineDeleteForm() {
        BillList list = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection cards = list.getSelectedRows();
        if (cards == null || cards.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u5220\u9664\u7684\u8bb0\u5f55\u3002", (String)"ExamineListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Object[] ids = cards.getPrimaryKeyValues();
            QFilter qf = new QFilter("status", "=", (Object)true).and(new QFilter("id", "in", (Object)ids));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EB_EXAMINE, (String)"id", (QFilter[])qf.toArray());
            if (dynamicObjects.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"ExamineListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExamineListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DELETE_EXAMINE, (IFormPlugin)this));
            }
        }
    }

    private void showExamineAddForm(String examineBaseInfo) {
        BaseShowParameter showParameter = new BaseShowParameter();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4\u3002", (String)"ExamineListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setStatus(OperationStatus.ADDNEW);
        if ("root".equals(clickNode.getLongNumber())) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"eb_examinecategory", (String)"id", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)this.getModelId()).and(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel()).and("code", "=", (Object)"SYS_default").toArray());
            paramsMap.put("group", object.getString("id"));
        } else {
            paramsMap.put("group", clickNode.getId());
        }
        paramsMap.put(MODEL_KEY, this.getCurModelId());
        paramsMap.put(BUSINESS_MODEL_KEY, this.getCurBizModel());
        paramsMap.put("examineBaseInfo", examineBaseInfo);
        showParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb", (String)"DataModelTransEnum_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setFormId(EB_EXAMINE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(paramsMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, AFTER_AE_EXAMINE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void deleteTreeNodes() {
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            return;
        }
        LinkedHashSet<Long> treeKeys = new LinkedHashSet<Long>();
        this.getExamineGroupChildrenNodeIds(treeKeys, clickNode);
        DeleteServiceHelper.delete((String)"eb_examinecategory", (QFilter[])new QFilter("id", "in", treeKeys).toArray());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"eb_examinecategory", (String)"isleaf", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)clickNode.getParentid())).toArray());
        if (object != null) {
            object.set("isleaf", (Object)1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.ExamineGroup.getType(), treeKeys});
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "ExamineListPlugin_16", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5206\u7c7b\u5220\u9664\u6210\u529f\u3002", "ExamineListPlugin_17", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
        this.loadExamineGroupTree();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExamineListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void deleteExamine() {
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ExamineListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = selectedRows.getPrimaryKeyValues();
        QFilter qf = new QFilter("status", "=", (Object)false).and(new QFilter("id", "in", (Object)ids));
        int deleteRows = DeleteServiceHelper.delete((String)EB_EXAMINE, (QFilter[])qf.toArray());
        if (deleteRows <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"ExamineListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.deleteDimQuote(ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExamineListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "ExamineListPlugin_16", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u52fe\u7a3d\u5173\u7cfb\u5220\u9664\u6210\u529f\u3002", "ExamineListPlugin_19", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
        this.initBillList();
    }

    private void deleteDimQuote(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        HashSet resourceIds = Sets.newHashSetWithExpectedSize((int)ids.length);
        for (Object id : ids) {
            resourceIds.add(IDUtils.toLong((Object)id));
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Examine.getType(), resourceIds});
    }

    private void getExamineGroupChildrenNodeIds(Set<Long> ids, TreeNode curNode) {
        List children = curNode.getChildren();
        ids.add(Long.parseLong(curNode.getId()));
        if (children != null) {
            for (TreeNode child : children) {
                this.getExamineGroupChildrenNodeIds(ids, child);
            }
        }
    }

    private void getCurTemplateChildrenNodeIds(Set<Long> ids, TreeNode curNode) {
        List children = curNode.getChildren();
        Object dataMap = curNode.getData();
        if (dataMap != null && "template".equals(((Map)dataMap).get("type"))) {
            ids.add(Long.parseLong(curNode.getId()));
        }
        if (children != null) {
            for (TreeNode child : children) {
                this.getExamineGroupChildrenNodeIds(ids, child);
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        try {
            log.info("examine filter start");
            super.setFilter(e);
            e.getQFilters().add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
            Tab leftTab = (Tab)this.getControl(LEFT_TAB);
            String currentTab = leftTab.getCurrentTab();
            if (TEMPLATE_TAB.equals(currentTab)) {
                this.templateTabFilter(e);
            } else {
                this.examineGroupTabFilter(e);
            }
            log.info("examine filter end\uff1a" + e.getQFilters().toString());
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void templateTabFilter(SetFilterEvent e) {
        TreeNode currentNode = this.getClickNodeFromCache(true);
        LinkedHashSet<Long> templateIds = new LinkedHashSet<Long>();
        if (currentNode != null) {
            this.getCurTemplateChildrenNodeIds(templateIds, currentNode);
        }
        if (CollectionUtils.isEmpty(templateIds)) {
            e.getQFilters().add(new QFilter("id", "=", (Object)0L));
        } else {
            e.getQFilters().add(new QFilter("ebtemplates.fbasedataid_id", "in", templateIds));
        }
    }

    protected void examineGroupTabFilter(SetFilterEvent e) {
        TreeNode currentNode = this.getClickNodeFromCache(false);
        LinkedHashSet<Long> groupIds = new LinkedHashSet<Long>();
        if (currentNode != null) {
            this.getExamineGroupChildrenNodeIds(groupIds, currentNode);
        } else {
            groupIds.add(0L);
        }
        e.getQFilters().add(new QFilter("group", "in", groupIds).or("mutigroup.fbasedataid_id", "in", groupIds));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        try {
            super.beforeShowBill(e);
            BillShowParameter billShowParameter = e.getParameter();
            if (billShowParameter instanceof BaseShowParameter) {
                billShowParameter.setFormId(EB_EXAMINE);
                int statusVal = billShowParameter.getBillStatusValue();
                if (statusVal == BillOperationStatus.EDIT.getValue()) {
                    ExamineBaseInfo examineBaseInfo = new ExamineBaseInfo();
                    examineBaseInfo.setModelId(this.getCurModelId());
                    DynamicObject object = QueryServiceHelper.queryOne((String)EB_EXAMINE, (String)"group.businessmodel", (QFilter[])new QFilter("id", "=", billShowParameter.getPkId()).toArray());
                    if (object != null) {
                        examineBaseInfo.setBizModelId(Long.valueOf(object.getLong("group.businessmodel")));
                    }
                    billShowParameter.setCustomParam("examineBaseInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)examineBaseInfo));
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void copyExamine() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DiffAnalyzePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList list = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection cards = list.getSelectedRows();
        if (cards == null || cards.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u590d\u5236\u7684\u8bb0\u5f55\u3002", (String)"ExamineListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Object[] ids;
            ArrayList<DynamicObject> copySchemes = new ArrayList<DynamicObject>(16);
            for (Object id : ids = cards.getPrimaryKeyValues()) {
                copySchemes.add(this.getCopyScheme(id));
            }
            SaveServiceHelper.save((DynamicObject[])copySchemes.toArray(new DynamicObject[0]));
            this.initBillList();
        }
    }

    private DynamicObject getCopyScheme(Object id) {
        Long pkId = ConvertUtils.toLong((Object)id);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)EB_EXAMINE);
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u52fe\u7a3d\u5173\u7cfb\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExamineListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject scheme_copy = BusinessDataServiceHelper.newDynamicObject((String)EB_EXAMINE);
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("number");
        ignoreKeys.add("name");
        DynamicObjectUtils.copy((DynamicObject)scheme, (DynamicObject)scheme_copy, ignoreKeys);
        long schemeId = DB.genGlobalLongId();
        String number = scheme.getString("number");
        String indexStr = ExecuteAnalyseUtil.getInstance().getCopyIndex(number, EB_EXAMINE, this.getModelId());
        String number_copy = number + indexStr;
        this.checkNumberLength(number_copy);
        String name_copy = scheme.getString("name") + indexStr;
        this.checkNameLength(name_copy);
        scheme_copy.set("number", (Object)number_copy);
        scheme_copy.set("name", (Object)name_copy);
        scheme_copy.set("id", (Object)schemeId);
        scheme_copy.set("status", (Object)"0");
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        scheme_copy.set("creater", (Object)userId);
        scheme_copy.set("modifier", (Object)userId);
        scheme_copy.set("createdate", (Object)now);
        scheme_copy.set("modifydate", (Object)now);
        BgmdMainSubControlHelper.getInstance().setDefaultValueWhenCopy(scheme_copy);
        return scheme_copy;
    }

    private void checkNumberLength(String propertyString) {
        if (propertyString.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u590d\u5236\u540e\uff0c\u7f16\u7801\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ExamineListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkNameLength(String propertyString) {
        if (propertyString.length() > 80) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u590d\u5236\u540e\uff0c\u540d\u79f0\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ExamineListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected Long getModelIdAfterCreateNewData() {
        return UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)false);
    }

    private void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.leftTabSelected(tabKey);
    }

    private void leftTabSelected(String tabKey) {
        if (EXAMINE_TAB.equals(tabKey)) {
            this.examineTabSelected();
        } else if (TEMPLATE_TAB.equals(tabKey)) {
            this.templateTabSelected();
        }
    }

    private void examineTabSelected() {
        this.loadExamineGroupTree();
    }

    private void templateTabSelected() {
        this.loadTemplateTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String treeKey = ((Control)evt.getSource()).getKey();
            if (TEMPLATE_TREE.equals(treeKey)) {
                this.templateTreeNodeClick(evt);
            } else if (EXAMINE_GROUP_TREE.equals(treeKey)) {
                this.examineGroupTreeNodeClick(evt);
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void templateTreeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.putClickNodeToCache(nodeId, true);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLLISTKEY, FILTER_CONTAINER});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{EXAMINE_GROUP_LIST, LABELAP});
        this.initBillList();
    }

    private void examineGroupTreeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.putClickNodeToCache(nodeId, false);
        if (StringUtils.equals((String)nodeId, (String)this.getCurBizModel().toString())) {
            this.loadExamineGroupList();
        } else {
            this.loadCurGroupExamine();
        }
    }

    private void loadCurGroupExamine() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLLISTKEY, FILTER_CONTAINER});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{EXAMINE_GROUP_LIST, LABELAP});
        this.initBillList();
    }

    private void loadExamineGroupList() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTKEY, FILTER_CONTAINER});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{EXAMINE_GROUP_LIST, LABELAP});
        TreeNode clickNode = this.getClickNodeFromCache(false);
        if (clickNode == null) {
            return;
        }
        LinkedHashSet<Long> groupIds = new LinkedHashSet<Long>();
        this.getExamineGroupChildrenNodeIds(groupIds, clickNode);
        Map examineGroupDimMemberScope = ExamineServiceImpl.getInstance().getExamineGroupDimMemberScope(groupIds);
        QFilter qf = new QFilter(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel());
        DynamicObjectCollection examineGroupData = QueryServiceHelper.query((String)"eb_examinecategory", (String)"id,code,name,modifier.name,parent.name,modifydate", (QFilter[])qf.toArray(), (String)"level");
        if (CollectionUtils.isEmpty((Collection)examineGroupData)) {
            this.getModel().deleteEntryData(EXAMINE_GROUP_LIST);
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(EXAMINE_GROUP_LIST);
        int[] index = this.getModel().batchCreateNewEntryRow(EXAMINE_GROUP_LIST, examineGroupData.size());
        int i = 0;
        for (DynamicObject dynamicObject : examineGroupData) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(EXAMINE_GROUP_LIST, index[i]);
            rowEntity.set("examinegroupid", (Object)dynamicObject.getLong("id"));
            rowEntity.set("examinegroupnumber", (Object)dynamicObject.getString("code"));
            rowEntity.set("examinegroupname", (Object)dynamicObject.getString("name"));
            rowEntity.set("parentgroup", (Object)dynamicObject.getString("parent.name"));
            rowEntity.set("groupmodifier", (Object)dynamicObject.getString("modifier.name"));
            rowEntity.set("modifydate", (Object)dynamicObject.getDate("modifydate"));
            Map dimMemberScopeMap = (Map)examineGroupDimMemberScope.get(dynamicObject.getLong("id"));
            if (dimMemberScopeMap != null && dimMemberScopeMap.size() > 0) {
                for (Map.Entry entry : dimMemberScopeMap.entrySet()) {
                    if (!SysDimensionEnum.include((String)((String)entry.getKey()), (Boolean)true)) continue;
                    rowEntity.set(((String)entry.getKey()).toLowerCase(), entry.getValue());
                }
            }
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(EXAMINE_GROUP_LIST);
        this.showHasDataDimCol(groupIds);
    }

    private void loadExamineGroupTree() {
        this.presetDefaultExamineGroup();
        QFilter qf = new QFilter(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel());
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"eb_examinecategory", (String)"id,name,code,parent.id,isleaf,level,businessmodel,modifier.name,parent.name,modifydate", (QFilter[])qf.toArray(), (String)"level,createdate,realseq");
        TreeNode leftNode = ExamineListPlugin.generateExamineGroupTree(this.getCurBizModel(), catalogs);
        TreeView treeLeft = (TreeView)this.getControl(EXAMINE_GROUP_TREE);
        treeLeft.deleteAllNodes();
        treeLeft.addNode(leftNode);
        this.spreadAllNode(leftNode);
        this.putLeftRootToCache(leftNode, false);
        TreeNode cacheClickNode = this.getClickNodeFromCache(false);
        if (cacheClickNode == null) {
            cacheClickNode = leftNode;
        }
        this.treeNodeClick(new TreeNodeEvent((Object)treeLeft, (Object)cacheClickNode.getParentid(), (Object)cacheClickNode.getId()));
        treeLeft.focusNode(cacheClickNode);
    }

    private void presetDefaultExamineGroup() {
        QFilter qFilter = new QFilter("code", "=", (Object)"SYS_default");
        qFilter.and(MODEL_KEY, "=", (Object)this.getModelId());
        qFilter.and(BUSINESS_MODEL_KEY, "=", (Object)this.getCurBizModel());
        boolean exists = QueryServiceHelper.exists((String)"eb_examinecategory", (QFilter[])qFilter.toArray());
        if (!exists) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_examinecategory");
            object.set("code", (Object)"SYS_default");
            object.set("name", (Object)LanguageUtils.getLocaleValue((String)ResManager.loadKDString((String)"\u9ed8\u8ba4\u52fe\u7a3d\u5173\u7cfb\u7ec4", (String)"ExamineListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)"ExamineListPlugin_42", (String)"epm-eb-formplugin"));
            object.set(MODEL_KEY, (Object)this.getModelId());
            object.set("parent", (Object)this.getCurBizModel());
            object.set(BUSINESS_MODEL_KEY, (Object)this.getCurBizModel());
            object.set("level", (Object)3);
            object.set("realseq", (Object)0);
            object.set("isleaf", (Object)true);
            object.set("creater", (Object)UserUtils.getUserId());
            object.set("createdate", (Object)TimeServiceHelper.now());
            object.set("modifier", (Object)UserUtils.getUserId());
            object.set("modifydate", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            ExamineServiceImpl.getInstance().clearExamineGroupCache(this.getModelId());
        }
    }

    public static TreeNode generateExamineGroupTree(Long curBizModel, DynamicObjectCollection catalogs) {
        TreeNode rootNode = new TreeNode("", curBizModel.toString(), ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u5206\u7ec4", (String)"ExamineListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> rootData = new HashMap<String, Object>(16);
        rootData.put("level", 2);
        rootData.put("name", rootNode.getText());
        rootNode.setData(rootData);
        rootNode.setLongNumber("root");
        if (CollectionUtils.isNotEmpty((Collection)catalogs)) {
            HashMap<String, List<TreeNode>> nodeMap = new HashMap<String, List<TreeNode>>();
            for (DynamicObject catalog : catalogs) {
                String parentId = "0".equals(catalog.getString("parent.id")) || curBizModel.toString().equals(catalog.getString("parent.id")) ? rootNode.getId() : catalog.getString("parent.id");
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)nodeMap.get(parentId);
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>();
                    nodeMap.put(parentId, treeNodes);
                }
                TreeNode treeNode = new TreeNode(parentId, catalog.getString("id"), catalog.getString("name"));
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("level", catalog.getInt("level"));
                data.put("name", treeNode.getText());
                data.put("catalog", catalog);
                treeNode.setData(data);
                treeNode.setLeaf(catalog.getBoolean("isleaf"));
                treeNode.setLongNumber(catalog.getString("code"));
                if ("SYS_default".equals(catalog.getString("code"))) {
                    treeNodes.add(0, treeNode);
                    continue;
                }
                treeNodes.add(treeNode);
            }
            ExamineListPlugin.createTree(rootNode, nodeMap, rootNode.getId());
        }
        return rootNode;
    }

    private static TreeNode createTree(TreeNode root, Map<String, List<TreeNode>> nodeMap, String headId) {
        List<TreeNode> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            for (TreeNode treeNode : list) {
                ExamineListPlugin.createTree(treeNode, nodeMap, treeNode.getId());
                children.add(treeNode);
            }
        }
        return root;
    }

    private void loadTemplateTree() {
        TreeNode templateTreeNode = this.generateTemplateTree();
        TreeView treeLeft = (TreeView)this.getControl(TEMPLATE_TREE);
        treeLeft.deleteAllNodes();
        treeLeft.addNode(templateTreeNode);
        this.spreadAllNode(templateTreeNode);
        this.putLeftRootToCache(templateTreeNode, true);
        TreeNode cacheClickNode = this.getClickNodeFromCache(true);
        if (cacheClickNode == null) {
            cacheClickNode = templateTreeNode;
        }
        this.treeNodeClick(new TreeNodeEvent((Object)treeLeft, (Object)cacheClickNode.getParentid(), (Object)cacheClickNode.getId()));
        treeLeft.focusNode(cacheClickNode);
    }

    private TreeNode generateTemplateTree() {
        Long modelId = this.getModelId();
        Long curBizModel = this.getCurBizModel();
        TreeNode rootNode = new TreeNode("", curBizModel.toString(), ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExamineListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (IDUtils.isEmptyLong((Long)curBizModel).booleanValue()) {
            return rootNode;
        }
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)modelId);
        qFilter.and("templatestatus", "!=", (Object)"A");
        qFilter.and("dataset", "in", (Object)BusinessModelServiceHelper.getInstance().queryDataSetIds(curBizModel));
        HashMap<String, List> templateMap = new HashMap<String, List>(16);
        DynamicObjectCollection templateDataSets = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,name,number,templatecatalog,templatetype,templatestatus", (QFilter[])qFilter.toArray(), (String)"number asc");
        for (DynamicObject dynamicObject : templateDataSets) {
            String id = dynamicObject.getString("id");
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String templateCatalog = dynamicObject.getString("templatecatalog");
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("type", "template");
            TreeNode treeNode = new TreeNode(templateCatalog, id, number + " " + name, dataMap);
            treeNode.setLongNumber(number);
            List treeNodes = templateMap.computeIfAbsent(templateCatalog, e -> new ArrayList(16));
            treeNodes.add(treeNode);
        }
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        DynamicObjectCollection catalogDataSets = QueryServiceHelper.query((String)"eb_templatecatalog", (String)"id,name,number,parent", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)modelId).toArray(), (String)"level,sequence");
        for (DynamicObject dynamicObject : catalogDataSets) {
            String id = dynamicObject.getString("id");
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String parent = dynamicObject.getString("parent");
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("type", "templatecatalog");
            TreeNode treeNode = new TreeNode("", id, name, dataMap);
            treeNode.setLongNumber(number);
            catalogMap.put(id, treeNode);
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                rootNode = treeNode;
            } else {
                treeNode.setParentid(parent);
                TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                treeNode1.addChild(treeNode);
            }
            if (!templateMap.containsKey(dynamicObject.getString("id"))) continue;
            List treeNodes = (List)templateMap.get(dynamicObject.getString("id"));
            treeNode.setChildren(treeNodes);
        }
        return rootNode;
    }

    private void switchBizModel() {
        BasedataEdit modelItem = (BasedataEdit)this.getControl(BIZMODEL_KEY);
        modelItem.click();
    }

    private void addSearchListener(String searchKey, String treeKey, String treeCacheKey) {
        Search search = (Search)this.getView().getControl(searchKey);
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(treeKey, treeCacheKey));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ExamineListPlugin_82", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private boolean isNeedLockMemberScope(TreeNode clickNode) {
        return ExamineServiceImpl.getInstance().isLeaf(IDUtils.toLong((Object)clickNode.getId()));
    }

    private void showHasDataDimCol(Set<Long> groupIds) {
        String[] dimCols = this.getAllDimCols();
        this.getView().setVisible(Boolean.valueOf(false), dimCols);
        Set hasMemberScopeDim = ExamineServiceImpl.getInstance().getHasMemberScopeDim(groupIds);
        hasMemberScopeDim.removeIf(e -> !SysDimensionEnum.include((String)e, (Boolean)true));
        if (hasMemberScopeDim.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), hasMemberScopeDim.toArray(new String[0]));
        }
    }

    private String[] getAllDimCols() {
        SysDimensionEnum[] values = SysDimensionEnum.values();
        String[] dimCols = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            dimCols[i] = values[i].getNumber().toLowerCase();
        }
        return dimCols;
    }

    private TreeNode getClickNodeFromCache(boolean isTemplateTree) {
        TreeNode leftTree = this.getLeftRootFromCache(isTemplateTree);
        if (leftTree != null) {
            String clickNodeId = this.getPageCache().get(CACHE_EXAMINE_GROUP_TREE_NODE);
            if (isTemplateTree) {
                clickNodeId = this.getPageCache().get(CACHE_TEMPLATE_TREE_NODE);
            }
            return leftTree.getTreeNode(clickNodeId, 20);
        }
        return null;
    }

    protected void putClickNodeToCache(String clickNodeId, boolean isTemplateTree) {
        if (isTemplateTree) {
            this.getPageCache().put(CACHE_TEMPLATE_TREE_NODE, clickNodeId);
        } else {
            this.getPageCache().put(CACHE_EXAMINE_GROUP_TREE_NODE, clickNodeId);
        }
    }

    private TreeNode getLeftRootFromCache(boolean isTemplateTree) {
        if (isTemplateTree) {
            return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_TEMPLATE_TREE), TreeNode.class);
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_EXAMINEGROUP_TREE), TreeNode.class);
    }

    protected void putLeftRootToCache(TreeNode rootLeft, boolean isTemplateTree) {
        if (isTemplateTree) {
            this.getPageCache().put(CACHE_TEMPLATE_TREE, SerializationUtils.toJsonString((Object)rootLeft));
        } else {
            this.getPageCache().put(CACHE_EXAMINEGROUP_TREE, SerializationUtils.toJsonString((Object)rootLeft));
        }
    }

    private Long getCurBizModel() {
        Long modelId = this.getModelId();
        DynamicObject defaultBizModel = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)modelId).and("number", "=", (Object)BizModelEnum.AUNNALBUDGET.getNumber()).toArray());
        if (defaultBizModel == null && (defaultBizModel = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)modelId).toArray())) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\u3002", (String)"ExamineListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject curBizModel = (DynamicObject)this.getModel().getValue(BIZMODEL_KEY);
        if (curBizModel == null || !QueryServiceHelper.exists((String)"eb_businessmodel", (QFilter[])new QFilter(MODEL_KEY, "=", (Object)modelId).and("id", "=", (Object)curBizModel.getLong("id")).toArray())) {
            return defaultBizModel.getLong("id");
        }
        return curBizModel.getLong("id");
    }

    private void upgrade() {
        String info = ExamineServiceHelper.getInstance().upgradeExamineRangeData(this.getModelId());
        if (StringUtils.isNotEmpty((String)info) && !ExamineServiceHelper.examineUpgrade((Long)this.getModelId()).booleanValue()) {
            this.getView().showSuccessNotification(info);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"ExamineListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

