/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.MemberPojo;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ExamineQueryReportPlugin
extends AbstractFormPlugin {
    public static final String BTN_CONFIRM = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPageList();
    }

    private void initPageList() {
        this.deleteEntryData();
        String reportProcess = (String)this.getView().getFormShowParameter().getCustomParam("reportProcess");
        if (StringUtils.isEmpty((String)reportProcess)) {
            return;
        }
        List reportProcessPojos = (List)JsonUtils.readValue((String)reportProcess, (TypeReference)new TypeReference<List<ReportProcessPojo>>(){});
        if (CollectionUtils.isEmpty((Collection)reportProcessPojos)) {
            return;
        }
        this.getPageCache().put("reportProcess", reportProcess);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("billlist_entity", reportProcessPojos.size());
        int i = 0;
        for (ReportProcessPojo d : reportProcessPojos) {
            this.getModel().setValue("reportnumber", (Object)d.getTemplatePojo().getTemplateNumberString(), i);
            this.getModel().setValue("reportname", (Object)d.getTemplatePojo().getTemplateNameString(), i);
            List memberPojoList = d.getMemberPojoList();
            MemberPojo versionMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Version.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            MemberPojo dataTypeMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.DataType.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            MemberPojo periodMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.BudgetPeriod.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            MemberPojo entityMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            this.getModel().setValue("entityname", (Object)entityMemberPojo.getMemberNameString(), i);
            this.getModel().setValue("reportprocesspojo", (Object)SerializationUtils.toJsonString((Object)d), i);
            String statusString = (String)LambdaUtils.get(() -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)d.getStatusString()) || !NumberUtils.isCreatable((String)d.getStatusString())) {
                    return null;
                }
                BgTaskStateEnum bgTaskStateEnum = (BgTaskStateEnum)LambdaUtils.getTarget((Object[])BgTaskStateEnum.values(), item -> item.getNumber().equals(d.getStatusString()));
                if (bgTaskStateEnum != null) {
                    return bgTaskStateEnum.getName();
                }
                return null;
            });
            this.getModel().setValue("status", (Object)statusString, i);
            this.getModel().setValue("id", (Object)d.getReportProcessIdLong(), i);
            this.getModel().setValue("version", (Object)versionMemberPojo.getMemberIdLong(), i);
            this.getModel().setValue("datatype", (Object)dataTypeMemberPojo.getMemberIdLong(), i);
            this.getModel().setValue("period", (Object)periodMemberPojo.getMemberIdLong(), i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView("billlist_entity");
    }

    private void deleteEntryData() {
        this.getModel().deleteEntryData("billlist_entity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("billlist_entity");
            int[] rowNums = entryGrid.getSelectRows();
            if (rowNums == null || rowNums.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String reportprocesspojo = (String)this.getModel().getValue("reportprocesspojo", rowNums[0]);
            if (StringUtils.isEmpty((String)reportprocesspojo)) {
                return;
            }
            ReportProcessPojo reportProcessPojo = (ReportProcessPojo)SerializationUtils.fromJsonString((String)reportprocesspojo, ReportProcessPojo.class);
            this.getView().returnDataToParent((Object)reportProcessPojo);
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        Long model = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (model != null) {
            return model;
        }
        return 0L;
    }
}

