/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.ListExpandEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.lang3.StringUtils;

public class ExamineReportNewListPlugin
extends AbstractListPlugin
implements SubPage,
MainPage,
TreeNodeQueryListener {
    private static final String BTN_EXPORT = "export";
    private static final String BTN_ANNOTATION = "btn_annotation";
    private static final String BTN_DEL_ANNOTATION = "btn_del_annotation";
    private static final String BTN_DELETE = "delete";
    private static final String MODEL = "model";
    private static final String BILLLISTKEY = "billlistap";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId("eb_examine_result_report");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        Long modelId = this.getModelId();
        switch (args.getFieldName()) {
            case "detailentity.name": 
            case "detailperiod.name": 
            case "account.name": 
            case "examine.ebtemplates.fbasedataid.name": 
            case "annotation.modifydate": 
            case "annotation.remark": {
                args.getQfilters().add(new QFilter(MODEL, "=", (Object)modelId));
                break;
            }
            case "examine.number": 
            case "examine.name": 
            case "examine.explain": {
                String bizModelId = this.getPageCache().get("bizModelId");
                if (StringUtils.isNotEmpty((CharSequence)bizModelId) && !"0".equals(bizModelId)) {
                    args.getQfilters().add(new QFilter("group.businessmodel.id", "=", (Object)Long.parseLong(bizModelId)));
                }
                args.getQfilters().add(new QFilter(MODEL, "=", (Object)modelId));
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long bizModelId;
        super.afterCreateNewData(e);
        this.getReportOrTaskPojo();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTKEY});
        this.showInContainerCross();
        String schemeOrTaskId = (String)this.getView().getFormShowParameter().getCustomParam("schemeOrTaskId");
        if (StringUtils.isNotBlank((CharSequence)schemeOrTaskId)) {
            this.getPageCache().put("schemeOrTaskId", schemeOrTaskId);
        }
        if ((bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId")) != null) {
            this.getPageCache().put("bizModelId", bizModelId.toString());
        }
        if ("excel".equals(this.getView().getFormShowParameter().getCustomParam("sourceFrom"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"back"});
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter instanceof BaseShowParameter) {
            billShowParameter.setFormId("eb_examine_result_report");
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("back".equals(itemKey)) {
            this.getView().returnDataToParent((Object)itemKey);
        }
    }

    private void showInContainerCross() {
        List<QFilter> filters = this.formParamFilter();
        filters.add(this.modelFilter());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"crosspanel"});
        this.getPageCache().put("isExamineVisible", "true");
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = this.getPageIdAndCache(this.getPageCache(), "eb_examine_cross");
        showParameter.getOpenStyle().setTargetKey("crosspanel");
        showParameter.setPageId(pageId);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("filter", (Object)SerializationUtils.toJsonString(filters));
        showParameter.setCustomParam("pagination", (Object)"true");
        showParameter.setCustomParam("single", (Object)"false");
        showParameter.setCustomParam("height", (Object)"580");
        showParameter.setFormId("eb_examine_cross");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setShowClose(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"EbExamineEditPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "export": {
                this.checkExportPerm();
                this.sendExportDataMsg();
                break;
            }
            case "btn_annotation": {
                this.checkAnnotationPerm("36JX8QFCPKYM");
                this.sendAddAnnotationMsg();
                break;
            }
            case "btn_del_annotation": {
                this.checkAnnotationPerm("36JXCYKE9RQ/");
                this.sendDelAnnotationMsg();
                break;
            }
            case "delete": {
                this.sendDelDataMsg();
                break;
            }
        }
    }

    private void checkAnnotationPerm(String permItemId) {
        Long modelId = this.getModelId();
        Long userId = UserUtils.getUserId();
        if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId) || ProcessTypeEnum.REPORT != this.getProcessType()) {
            return;
        }
        String entityId = "bgm_rptpreparation";
        if (this.checkItemPermission(userId, modelId, this.getBizAppId(), entityId, permItemId) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u8868\u7f16\u5236\u7684\u52fe\u7a3d\u6279\u6ce8/\u64a4\u9500\u6279\u51c6\u64cd\u4f5c\u6743\u9650\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void sendAddAnnotationMsg() {
        CommandParam commandParam = new CommandParam(this.getView().getFormShowParameter().getFormId(), "eb_examine_cross", "addAnnotation", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void sendDelAnnotationMsg() {
        CommandParam commandParam = new CommandParam(this.getView().getFormShowParameter().getFormId(), "eb_examine_cross", "delAnnotation", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void sendDelDataMsg() {
        CommandParam commandParam = new CommandParam(this.getView().getFormShowParameter().getFormId(), "eb_examine_cross", "delData", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void sendExportDataMsg() {
        CommandParam commandParam = new CommandParam(this.getView().getFormShowParameter().getFormId(), "eb_examine_cross", "exportData", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void checkExportPerm() {
        Long modelId = this.getModelId();
        Long userId = UserUtils.getUserId();
        if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId) || ProcessTypeEnum.REPORT != this.getProcessType() && ProcessTypeEnum.TASK != this.getProcessType()) {
            return;
        }
        String entityId = "bgm_rptpreparation";
        if (this.checkItemPermission(userId, modelId, this.getBizAppId(), entityId, "2X8BI29NPEZC") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u8868\u7f16\u5236\u7684\u7684\u52fe\u7a3d\u62a5\u544a\u5bfc\u51fa\u64cd\u4f5c\u6743\u9650\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private ProcessTypeEnum getProcessType() {
        Map condition;
        Object processType;
        String cache = this.getPageCache().get("formCondition");
        if (cache == null) {
            cache = (String)this.getFormCustomParam("formCondition");
            this.getPageCache().put("formCondition", cache);
        }
        if ((processType = (condition = (Map)SerializationUtils.deSerializeFromBase64((String)cache)).get("processType")) != null) {
            return ProcessTypeEnum.getProcessTypeByNumber((String)processType.toString());
        }
        return ProcessTypeEnum.REPORT;
    }

    public void expandClick(ListExpandEvent e) {
        super.expandClick(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        switch (fieldName = args.getFieldName()) {
            case "status": {
                HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
                int rowIndex = hyperLinkClickEvent.getRowIndex();
                BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
                Object focusRowPkId = list.getFocusRowPkId();
                this.expandClick(new ListExpandEvent((Object)BILLLISTKEY, focusRowPkId, rowIndex));
            }
        }
        args.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Optional<QFilter> first = e.getQFilters().stream().filter(q -> "status".equals(q.getProperty())).findFirst();
        if (first.isPresent()) {
            QFilter qFilter = first.get();
            ArrayList<String> oldValue = new ArrayList<String>(16);
            ArrayList newValue = new ArrayList(16);
            if (qFilter.getValue() instanceof List) {
                oldValue.addAll((List)qFilter.getValue());
            } else {
                oldValue.add((String)qFilter.getValue());
            }
            oldValue.forEach(p -> {
                if ("10".equals(p)) {
                    newValue.addAll(Arrays.asList("45", "50", "40"));
                } else if ("20".equals(p)) {
                    newValue.add("60");
                } else {
                    newValue.add("30");
                }
            });
            qFilter.__setCP("in");
            qFilter.__setValue(newValue);
        }
        qFilters.addAll(this.formParamFilter());
        qFilters.add(this.modelFilter());
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        QFilter filter = new QFilter("id", "in", ids.stream().map(p -> p.getLong("id")).collect(Collectors.toList()));
        CommandParam commandParam = new CommandParam(this.getView().getFormShowParameter().getFormId(), "eb_examine_cross", "setFilter", new Object[]{SerializationUtils.toJsonString(Collections.singletonList(filter))});
        this.sendMsg(this.getView(), commandParam);
    }

    private List<QFilter> formParamFilter() {
        Object template;
        Object entity;
        Object version;
        Object dataType;
        Object bizModelId;
        String cache = this.getPageCache().get("formCondition");
        if (cache == null) {
            cache = (String)this.getFormCustomParam("formCondition");
            this.getPageCache().put("formCondition", cache);
        }
        Map condition = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        Object model = condition.get(MODEL);
        if (model != null) {
            this.getPageCache().put(MODEL, model.toString());
        }
        if ((bizModelId = condition.get("bizModelId")) != null) {
            this.getPageCache().put("bizModelId", bizModelId.toString());
        }
        Object processId = condition.get("processId");
        Object processType = condition.get("processType");
        if (processType != null) {
            List processIds;
            ProcessTypeEnum processType1 = (ProcessTypeEnum)processType;
            qFilters.add(new QFilter("processtype", "=", (Object)String.valueOf(processType1.getIndex())));
            if (ProcessTypeEnum.APPLY.getNumber().equals(processType1.getNumber())) {
                if (processId != null) {
                    processIds = SerializationUtils.fromJsonStringToList((String)processId.toString(), Long.class);
                    qFilters.add(new QFilter("applybill", "in", (Object)processIds));
                }
            } else if (processId != null) {
                processIds = SerializationUtils.fromJsonStringToList((String)processId.toString(), Long.class);
                qFilters.add(new QFilter("reportprocess", "in", (Object)processIds));
            }
        } else if (processId != null) {
            List processIds = SerializationUtils.fromJsonStringToList((String)processId.toString(), Long.class);
            qFilters.add(new QFilter("reportprocess", "in", (Object)processIds));
        }
        Object period = condition.get("period");
        if (period != null) {
            qFilters.add(new QFilter("period", "=", (Object)Long.parseLong(period.toString())));
        }
        if ((dataType = condition.get("datatype")) != null) {
            qFilters.add(new QFilter("datatype", "=", (Object)Long.parseLong(dataType.toString())));
        }
        if ((version = condition.get("version")) != null) {
            qFilters.add(new QFilter("version", "=", (Object)Long.parseLong(version.toString())));
        }
        if ((entity = condition.get("entity")) != null) {
            qFilters.add(new QFilter("entity", "in", entity));
        }
        if ((template = condition.get("template")) != null) {
            qFilters.add(new QFilter("template", "in", condition.get("template")));
        }
        return qFilters;
    }

    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("refreshPageData".equals(operation)) {
            this.updatePageData(com);
        }
    }

    public void sendMsg(IFormView currView, CommandParam cmd) {
        super.sendMsg(currView, cmd);
    }

    private void updatePageData(CommandParam com) {
        List param = com.getParam();
        if (param.size() < 1) {
            return;
        }
        this.getPageCache().put("formCondition", (String)param.get(0));
        BillList list = (BillList)this.getControl(BILLLISTKEY);
        list.clearSelection();
        list.refresh();
    }

    private QFilter modelFilter() {
        return new QFilter(MODEL, "=", (Object)this.getModelId());
    }

    @Override
    public Long getModelId() {
        String model_cache = this.getPageCache().get(MODEL);
        if (model_cache != null) {
            return IDUtils.toLong((Object)model_cache);
        }
        Object model_param = this.getFormCustomParam("KEY_MODEL_ID");
        this.getPageCache().put(MODEL, String.valueOf(model_param));
        return IDUtils.toLong(model_param);
    }

    public IModelCacheHelper getIModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    private ReportOrTaskPojo getReportOrTaskPojo() {
        String reportOrTaskPojoJsonStringObject = (String)this.getView().getFormShowParameter().getCustomParam(ReportOrTaskPojo.class.getName());
        if (reportOrTaskPojoJsonStringObject != null) {
            ReportOrTaskPojo reportOrTaskPojo = (ReportOrTaskPojo)JsonUtils.readValue((String)reportOrTaskPojoJsonStringObject, ReportOrTaskPojo.class);
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)reportOrTaskPojo);
            return reportOrTaskPojo;
        }
        return null;
    }
}

