/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.examinev2.vo.ExprPanelTypeEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportV2;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExamineResultExportUtil {
    private static final String lineSeparator = System.getProperty("line.separator", "\n");

    public static void exportResultData(List<ExamineCheckReportV2> examineCheckReportV2s, IFormView formView) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        sheet.setColumnWidth(0, 1280);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 38400);
        sheet.setColumnWidth(3, 10240);
        sheet.setColumnWidth(4, 5120);
        workbook.setSheetName(0, ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"ExamineResultPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row row = sheet.createRow(0);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        ExamineResultExportUtil.setCellValue(sheet, row, cellStyle, 0, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ExamineResultPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ExamineResultExportUtil.setCellValue(sheet, row, cellStyle, 1, ResManager.loadKDString((String)"\u6821\u9a8c\u5f71\u54cd", (String)"ExamineResultPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ExamineResultExportUtil.setCellValue(sheet, row, cellStyle, 2, ResManager.loadKDString((String)"\u68c0\u67e5\u8fc7\u7a0b\u4fe1\u606f", (String)"ExamineResultPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ExamineResultExportUtil.setCellValue(sheet, row, cellStyle, 3, ResManager.loadKDString((String)"\u6279\u6ce8\u4fe1\u606f", (String)"ExamineResultPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ExamineResultExportUtil.setCellValue(sheet, row, cellStyle, 4, ResManager.loadKDString((String)"\u6279\u6ce8\u65f6\u95f4", (String)"ExamineResultPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (int i = 0; i < examineCheckReportV2s.size(); ++i) {
            Row rowData = sheet.createRow(i + 1);
            rowData.setHeightInPoints(45.0f);
            ExamineCheckReportV2 reportV2 = examineCheckReportV2s.get(i);
            ExamineResultExportUtil.setCellValue(sheet, rowData, cellStyle, 0, i + 1);
            String result = "";
            result = 50 == reportV2.getResult() ? ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u63d0\u4ea4", (String)"ExamineResultPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]) : (45 == reportV2.getResult() || 60 == reportV2.getResult() ? ResManager.loadKDString((String)"\u8981\u6c42\u6279\u6ce8", (String)"ExamineResultPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) : (40 == reportV2.getResult() ? ResManager.loadKDString((String)"\u4ec5\u63d0\u793a", (String)"ExamineResultPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u901a\u8fc7", (String)"ExamineResultPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            ExamineResultExportUtil.setCellValue(sheet, rowData, cellStyle, 1, result);
            String formula = reportV2.getShowPanel() == null ? "" : reportV2.getShowPanel().stream().filter(Objects::nonNull).map(e -> {
                ExprPanel panel = (ExprPanel)JSONObject.parseObject((String)e.toJSONString(), ExprPanel.class);
                if (ExprPanelTypeEnum.Member == panel.getType()) {
                    return panel.getValue();
                }
                return panel.getShowString();
            }).collect(Collectors.joining());
            String v2 = ResManager.loadResFormat((String)"\u68c0\u67e5\u8303\u56f4\uff1a%1\u516c\u5f0f\uff1a%2\uff0c\u5de6\u5f0f= %3\uff0c\u53f3\u5f0f= %4\uff0c\u6bd4\u8f83\u7b26\u53f7 %5\uff0c\u5dee\u989d= %6", (String)"ExamineResultPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{reportV2.getDimRange() + lineSeparator, formula, reportV2.getLeftValue(), reportV2.getRightValue(), reportV2.getSymbol(), reportV2.getDifference()});
            StringBuilder valueStringBuilder = new StringBuilder();
            valueStringBuilder.append(reportV2.getTemplateName());
            valueStringBuilder.append(reportV2.getExamineName());
            valueStringBuilder.append(reportV2.getExamineNumber());
            if (StringUtils.isNotEmpty((String)reportV2.getExamineExplain())) {
                valueStringBuilder.append(lineSeparator);
                String tipString = ResManager.loadKDString((String)"\u63d0\u793a\u8bf4\u660e\uff1a", (String)"ExamineCrossI18N_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                valueStringBuilder.append(tipString);
                valueStringBuilder.append(reportV2.getExamineExplain());
            }
            valueStringBuilder.append(lineSeparator);
            valueStringBuilder.append(v2);
            ExamineResultExportUtil.setCellValue(sheet, rowData, cellStyle, 2, valueStringBuilder.toString());
            ExamineResultExportUtil.setCellValue(sheet, rowData, cellStyle, 3, reportV2.getAnnotationRemark());
            ExamineResultExportUtil.setCellValue(sheet, rowData, cellStyle, 4, reportV2.getAnnotationTime());
        }
        try {
            String url = ExamineResultExportUtil.writeFile((Workbook)workbook, ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"ExamineResultPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        }
        catch (IOException e2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u62a5\u9519\u3002", (String)"ExamineResultPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private static void setCellValue(Sheet sheet, Row row, CellStyle cellStyle, int colIndex, Object rowData) {
        Cell cell = row.createCell(colIndex);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(rowData == null ? "" : rowData.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeFile(Workbook workbook, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

