/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineCheckDataServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineReportUnique;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.examine.ExamineResultExportUtil;
import kd.epm.eb.model.permission.MemberPermHelper;

public class ExamineResultPlugin
extends AbstractFormPlugin
implements MainPage {
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_EXPORT = "btn_export";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_EXPORT});
    }

    public void afterCreateNewData(EventObject e) {
        String examineCheckReportJson = (String)this.getView().getFormShowParameter().getCustomParam("examineCheckReport");
        String json = (String)this.getView().getFormShowParameter().getCustomParam("reportIds");
        String schemeOrTaskId = (String)this.getView().getFormShowParameter().getCustomParam("schemeOrTaskId");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schemeOrTaskId)) {
            this.getPageCache().put("schemeOrTaskId", schemeOrTaskId);
        }
        if (StringUtils.isNotEmpty((String)json)) {
            List ids = (List)SerializationUtils.fromJsonString((String)json, List.class);
            QFilter filter = new QFilter("reportprocess", "in", (Object)ids);
            this.showInContainerCross(filter);
        } else {
            List examineCheckReport = SerializationUtils.fromJsonStringToList((String)examineCheckReportJson, ExamineCheckReport.class);
            List reportProcessIds = examineCheckReport.stream().filter(x -> x.getApproveBillId() == null).map(x -> x.getReportProcessId()).collect(Collectors.toList());
            List examineReportUniques = examineCheckReport.stream().map(x -> {
                ExamineReportUnique examineReportUnique = new ExamineReportUnique();
                examineReportUnique.setApproveBillId(x.getApproveBillId());
                examineReportUnique.setReportProcessId(x.getReportProcessId());
                return examineReportUnique;
            }).collect(Collectors.toList());
            List hasApproveBill = examineReportUniques.stream().filter(x -> x.getApproveBillId() != null).collect(Collectors.toList());
            QFilter qFilter = null;
            for (ExamineReportUnique examineReportUnique : hasApproveBill) {
                if (qFilter == null) {
                    qFilter = new QFilter("reportprocess", "=", (Object)examineReportUnique.getReportProcessId()).and("approveBillId", "=", (Object)examineReportUnique.getApproveBillId());
                    continue;
                }
                qFilter.or(new QFilter("reportprocess", "=", (Object)examineReportUnique.getReportProcessId()).and("approveBillId", "=", (Object)examineReportUnique.getApproveBillId()));
            }
            if (!CollectionUtils.isEmpty(reportProcessIds)) {
                if (qFilter == null) {
                    qFilter = new QFilter("reportprocess", "in", reportProcessIds);
                } else {
                    qFilter.or("reportprocess", "in", reportProcessIds);
                }
            }
            this.showInContainerCross(qFilter);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_ok": {
                String json = this.getPageCache().get("ids");
                if (StringUtils.isEmpty((String)json)) {
                    return;
                }
                List ids = (List)SerializationUtils.fromJsonString((String)json, List.class);
                List examineCheckReportsV1 = ExamineCheckReportServiceImpl.getInstance().queryCheckReportByListV1((Collection)ids);
                boolean result = examineCheckReportsV1.stream().anyMatch(e -> !e.getExamineCheckResultEnum().isPass());
                if ("commit".equals(this.getKey()) && !result) {
                    this.getView().returnDataToParent((Object)"success");
                }
                this.getView().close();
                break;
            }
            case "btn_export": {
                this.checkExportPerm();
                this.exportData();
            }
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null) {
            return 0L;
        }
        return modelId;
    }

    private String getKey() {
        String key = this.getPageCache().get("key");
        if (StringUtils.isEmpty((String)key) && StringUtils.isNotEmpty((String)(key = (String)this.getView().getFormShowParameter().getCustomParam("key")))) {
            this.getPageCache().put("key", key);
        }
        return key;
    }

    private void showInContainerCross(QFilter filter) {
        if (filter == null) {
            return;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])filter.toArray());
        List ids = dynamicObjects.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        this.getPageCache().put("ids", JsonUtils.getJsonString(ids));
        filter = new QFilter("id", "in", ids);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"crosspanel"});
        this.getPageCache().put("isExamineVisible", "true");
        FormShowParameter showParameter = new FormShowParameter();
        this.getPageCache().put("pagePool", SerializationUtils.toJsonString(new HashMap()));
        String pageId = this.getPageIdAndCache(this.getPageCache(), "eb_examine_cross");
        showParameter.getOpenStyle().setTargetKey("crosspanel");
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("filter", (Object)SerializationUtils.toJsonString(Collections.singletonList(filter)));
        showParameter.setCustomParam("pagination", (Object)"false");
        showParameter.setCustomParam("single", (Object)"true");
        showParameter.setCustomParam("height", (Object)"511");
        showParameter.setFormId("eb_examine_cross");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setShowClose(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"ExamineResultPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        String json = this.getPageCache().get("ids");
        if (StringUtils.isEmpty((String)json)) {
            return;
        }
        List ids = (List)SerializationUtils.fromJsonString((String)json, List.class);
        QFilter filter = new QFilter("id", "in", (Object)ids);
        List examineCheckReportV2s = ExamineCheckDataServiceImpl.getInstance().queryCrossData(Collections.singletonList(filter));
        if (CollectionUtils.isEmpty((Collection)examineCheckReportV2s)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u52fe\u7a3d\u5173\u7cfb\u68c0\u67e5\u62a5\u544a\u3002", (String)"ExamineResultPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ExamineResultExportUtil.exportResultData(examineCheckReportV2s, this.getView());
    }

    private void checkExportPerm() {
        Long modelId = this.getModelId();
        Long userId = UserUtils.getUserId();
        if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId) || ProcessTypeEnum.REPORT != this.getProcessType()) {
            return;
        }
        String entityId = "bgm_rptpreparation";
        if (this.checkItemPermission(userId, modelId, this.getBizAppId(), entityId, "2X8BI29NPEZC") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u8868\u7f16\u5236\u7684\u7684\u52fe\u7a3d\u62a5\u544a\u5bfc\u51fa\u64cd\u4f5c\u6743\u9650\u3002", (String)"ExamineResultPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private ProcessTypeEnum getProcessType() {
        Object processType = this.getView().getFormShowParameter().getCustomParam("processType");
        if (processType != null) {
            return ProcessTypeEnum.getProcessTypeByNumber((String)processType.toString());
        }
        return ProcessTypeEnum.REPORT;
    }
}

