/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.examine.reportshowexamine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DimensionDataDetailPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.pageRefresh();
    }

    private void pageRefresh() {
        this.getView().getParentView().getPageCache().put("dimChildPageId", this.getView().getPageId());
        Map<String, String> allDimNum = this.getAllDimNum();
        if (CollectionUtils.isEmpty(allDimNum)) {
            return;
        }
        Map<String, Long> dimensionView = this.getDimensionView();
        Long modelId = this.getModelId();
        HashSet longNameNumDimsSet = new HashSet(16);
        List longNameNumDimsList = MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)modelId);
        if (CollectionUtils.isNotEmpty((Collection)longNameNumDimsList)) {
            longNameNumDimsSet.addAll(longNameNumDimsList);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long dataSetId = this.getDatasetId();
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        String memberDisplayType = this.getMemberDisplayType();
        int dimMemShowType = StringUtils.isEmpty((String)memberDisplayType) ? MemberDisplayTypeEnum.NAME.getIndex() : Integer.parseInt(memberDisplayType);
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        dataModel.beginInit();
        int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", allDimNum.size());
        int i = 0;
        for (Dimension dimension : dimensionList) {
            String longName;
            String dimensionNumber = dimension.getNumber();
            String memberNumber = allDimNum.get(dimensionNumber);
            Long viewId = dimensionView.get(dimensionNumber);
            Member member = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber);
            if (member == null) continue;
            boolean displayLongDim = longNameNumDimsSet.contains(dimensionNumber);
            this.getModel().setValue("dimension", (Object)member.getDimension().getName(), rows[i]);
            if (MemberDisplayTypeEnum.NAME.getIndex() == dimMemShowType) {
                dataModel.setValue("member", (Object)member.getName(), rows[i]);
            } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == dimMemShowType) {
                if (StringUtils.isEmpty((String)member.getSimpleName())) {
                    dataModel.setValue("member", (Object)member.getName(), rows[i]);
                } else {
                    dataModel.setValue("member", (Object)member.getSimpleName(), rows[i]);
                }
            } else if (MemberDisplayTypeEnum.NUMBER.getIndex() == dimMemShowType) {
                dataModel.setValue("member", (Object)member.getNumber(), rows[i]);
            } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == dimMemShowType) {
                dataModel.setValue("member", (Object)(member.getName() + ":" + member.getNumber()), rows[i]);
            } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == dimMemShowType) {
                if (StringUtils.isEmpty((String)member.getSimpleName())) {
                    dataModel.setValue("member", (Object)(member.getName() + ":" + member.getNumber()), rows[i]);
                } else {
                    dataModel.setValue("member", (Object)(member.getSimpleName() + ":" + member.getNumber()), rows[i]);
                }
            } else if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == dimMemShowType) {
                if (displayLongDim) {
                    dataModel.setValue("member", (Object)member.getLongNumber(), rows[i]);
                } else {
                    dataModel.setValue("member", (Object)member.getNumber(), rows[i]);
                }
            } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == dimMemShowType) {
                if (displayLongDim) {
                    longName = member.getLongName(modelCacheHelper.getParentsByOrder(this.currentEntityViewId(), member, false));
                    dataModel.setValue("member", (Object)(StringUtils.isEmpty((String)longName) ? member.getName() : longName), rows[i]);
                } else {
                    dataModel.setValue("member", (Object)member.getName(), rows[i]);
                }
            } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == dimMemShowType) {
                if (displayLongDim) {
                    longName = member.getLongName(modelCacheHelper.getParentsByOrder(this.currentEntityViewId(), member, false));
                    dataModel.setValue("member", (Object)(StringUtils.isEmpty((String)longName) ? member.getName() : longName + ":" + member.getLongNumber()), rows[i]);
                } else {
                    dataModel.setValue("member", (Object)(member.getName() + ":" + member.getNumber()), rows[i]);
                }
            }
            ++i;
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    private Map<String, String> getAllDimNum() {
        return (Map)this.getView().getFormShowParameter().getCustomParam("allDimNum");
    }

    private Map<String, Long> getDimensionView() {
        JSONObject jsonObject = JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("dimensionView")));
        return jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> Long.parseLong(v.getValue().toString()), (o1, o2) -> o2));
    }

    private String getMemberDisplayType() {
        return (String)this.getView().getFormShowParameter().getCustomParam("memberDisplayType");
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    public Long getDatasetId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dataSetId");
    }

    private Long currentEntityViewId() {
        String currentEntityViewId = (String)this.getView().getFormShowParameter().getCustomParam("currentEntityViewId");
        if (StringUtils.isEmpty((String)currentEntityViewId)) {
            return 0L;
        }
        return Long.parseLong(currentEntityViewId);
    }
}

