/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.ebBusiness.model.excel.ApiResponseModel;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.ExcelApiService;

public class ExcelApi
extends AbstractBillWebApiPlugin {
    private static final String METHOD_NAME = "method";
    private static final String PARAM = "param";
    public static final String ISGZIP = "isGzip";
    private static Log log = LogFactory.getLog(ExcelApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ExcelApiCommon.doLog((String)params.get(METHOD_NAME), log);
        ApiResult result = new ApiResult();
        ApiResponseModel response = new ApiResponseModel();
        try {
            ExcelApiService service;
            LicenseCheckResult checkResult;
            String methodName = (String)params.get(METHOD_NAME);
            if (!methodName.equalsIgnoreCase("checkLicense") && !(checkResult = (service = new ExcelApiService()).checkLicense()).getHasLicense().booleanValue()) {
                throw new KDBizException(checkResult.getMsg());
            }
            Object backData = this.invoke(params);
            if (params.containsKey(ISGZIP) && ((Boolean)params.get(ISGZIP)).booleanValue() && null != backData) {
                backData = ObjectSerialUtil.compress4GZip((String)JSON.toJSONStringWithDateFormat((Object)backData, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            }
            ExcelApiCommon.doLog("After_" + (String)params.get(METHOD_NAME), log);
            response.setBackData(backData);
        }
        catch (KDBizException e) {
            String backData = StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20);
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put(ExcelApiCommon.KEY_ERROR, backData);
            response.setBackData(data);
        }
        catch (Exception e) {
            response.setSuccess(false);
            String backData = "errorMessage:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20);
            response.setBackData((Object)backData);
        }
        result.setData((Object)response);
        return result;
    }

    private Object invoke(Map<String, Object> params) throws Exception {
        String methodName = (String)params.get(METHOD_NAME);
        Object param = params.get(PARAM);
        try {
            Class<?> clazz = Class.forName("kd.epm.eb.formplugin.excel.ExcelApiService");
            Object instance = clazz.newInstance();
            for (Method m : clazz.getMethods()) {
                int paramCount;
                int count;
                if (!m.getName().equals(methodName) || (count = m.getParameterCount()) != (paramCount = param instanceof List ? ((List)param).size() : (param instanceof Object[] ? ((Object[])param).length : (param != null ? 1 : 0)))) continue;
                if (count == 0) {
                    return m.invoke(instance, new Object[0]);
                }
                return m.invoke(instance, param);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof KDBizException) {
                throw new KDBizException(e.getCause().getMessage());
            }
            throw e;
        }
        return null;
    }
}

