/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RptSchemeStatusEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelBizModelEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelDimMemberEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelDimPropertyEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelDimensionEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelDimensionViewEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelDynamicMemberEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelEnumValueEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelPermissionEntity;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelRptSchemeAssignEntity;
import kd.epm.eb.formplugin.excel.formula.ExcelQueryValue;
import kd.epm.eb.model.permission.MemberPermHelper;

public class ExcelDimension {
    private static Log log = LogFactory.getLog(ExcelDimension.class);

    public Object getModelList(Map<String, Object> param) {
        ExcelApiCommon.doLog("begin_getModelList:", log);
        if (param == null) {
            return null;
        }
        QFilter qUser = new QFilter("user.id", "=", (Object)UserUtils.getUserId());
        Set ids = FunPermissionHelper.getAllHasPermModel((QFilter[])new QFilter[]{qUser});
        ids.addAll(FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ApplicationTypeEnum.BGM));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", (Object)ids.toArray()));
        qFilters.add(new QFilter("reporttype", "=", (Object)"7"));
        if (param.containsKey("modifytime")) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                qFilters.add(new QFilter("modifytime", ">=", (Object)format.parse(param.get("modifytime").toString())));
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id,name,shownumber", (QFilter[])qFilters.toArray(new QFilter[0]));
        HashMap<String, Object> data = null;
        ArrayList modelNameList = new ArrayList();
        for (DynamicObject dy : dys) {
            data = new HashMap<String, Object>();
            data.put("Id", dy.getString("id"));
            data.put("Name", dy.getString("name"));
            data.put("Number", dy.getString("shownumber"));
            data.put("ShowNumber", dy.getString("shownumber"));
            data.put("IsAdmin", manageModelIds.contains(dy.getLong("id")));
            modelNameList.add(data);
        }
        ExcelApiCommon.doLog("suc_getModelList:", log);
        return modelNameList;
    }

    public Object getBizScopeList(Map<String, Object> param) {
        ExcelApiCommon.doLog("begin_getBizScopeList:", log);
        Object modelId = param.get("Id");
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"eb_businessmodel", (String)"id,number, name", (QFilter[])qfBuilder.toArray());
        ArrayList modelNameList = new ArrayList(dys.length);
        HashMap<String, String> data = null;
        for (DynamicObject dy : dys) {
            data = new HashMap<String, String>();
            data.put("Id", dy.getString("id"));
            data.put("Name", dy.getString("name"));
            data.put("Number", dy.getString("number"));
            modelNameList.add(data);
        }
        ExcelApiCommon.doLog("suc_getBizScopeList:", log);
        return modelNameList;
    }

    public Object getBizModelList(Map<String, Object> param) {
        ExcelApiCommon.doLog("begin_getBizModelList:", log);
        Object modelId = param.get("modelId");
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"id,number, name,businessmodel,entryentity.datasetdim", (QFilter[])qfBuilder.toArray());
        if (dys == null || dys.length == 0) {
            return null;
        }
        ArrayList<ExcelBizModelEntity> returns = new ArrayList<ExcelBizModelEntity>(16);
        ArrayList<ExcelBizModelEntity> temp = null;
        ExcelBizModelEntity bizModelObj = null;
        for (DynamicObject dy : dys) {
            DynamicObjectCollection dynamicObjects = dy.getDynamicObjectCollection("entryentity");
            temp = new ArrayList<ExcelBizModelEntity>(16);
            for (DynamicObject dimension : dynamicObjects) {
                bizModelObj = new ExcelBizModelEntity();
                bizModelObj.setId(dy.getLong("id"));
                bizModelObj.setName(dy.getString("name"));
                bizModelObj.setNumber(dy.getString("number"));
                bizModelObj.setBizScopeId(dy.getLong("businessmodel.id"));
                bizModelObj.setBizScopeName(dy.getString("businessmodel.name"));
                bizModelObj.setBizScopeNumber(dy.getString("businessmodel.number"));
                bizModelObj.setDimensionId(dimension.getLong("datasetdim.id"));
                bizModelObj.setDimensionName(dimension.getString("datasetdim.name"));
                bizModelObj.setDimensionNumber(dimension.getString("datasetdim.number"));
                bizModelObj.setDimensionShortNumber(dimension.getString("datasetdim.shortnumber"));
                temp.add(bizModelObj);
                returns.add(bizModelObj);
            }
            if (temp.stream().anyMatch(e -> e.getDimensionNumber().equalsIgnoreCase("account"))) continue;
            bizModelObj = new ExcelBizModelEntity();
            bizModelObj.setId(dy.getLong("id"));
            bizModelObj.setName(dy.getString("name"));
            bizModelObj.setNumber(dy.getString("number"));
            bizModelObj.setBizScopeId(dy.getLong("businessmodel.id"));
            bizModelObj.setBizScopeName(dy.getString("businessmodel.name"));
            bizModelObj.setBizScopeNumber(dy.getString("businessmodel.number"));
            bizModelObj.setDimensionId(0L);
            bizModelObj.setDimensionName("Account");
            bizModelObj.setDimensionNumber("Account");
            bizModelObj.setDimensionShortNumber("A");
            returns.add(bizModelObj);
        }
        ExcelApiCommon.doLog("suc_getBizModelList:", log);
        return returns;
    }

    public Object getBizModelDimensionList(Map<String, Object> param) {
        ExcelApiCommon.doLog("begin_getBizModelDimensionList:", log);
        ArrayList bizModelDimensionList = new ArrayList();
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        IModelCacheHelper mocalCache = ModelCacheContext.getOrCreate((Long)modelId);
        Object bizScopeId = param.get("bizScopeId");
        Long bizModelId = IDUtils.toLong((Object)bizScopeId);
        Map viewGroupViewsByBusModel = mocalCache.getViewGroupViewsByBusModel(bizModelId);
        String sql = "select fid,fseq,fdimensionid,fviewid from t_eb_viewentry where fid = " + bizModelId;
        try (DataSet ds = DB.queryDataSet((String)"getBizModelDimensionList", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fdimensionid = row.getLong("fdimensionid");
                Dimension dimension = mocalCache.getDimension(row.getLong("fdimensionid"));
                ArrayList<Long> viewIds = (ArrayList<Long>)viewGroupViewsByBusModel.get(dimension.getNumber());
                if (CollectionUtils.isEmpty((Collection)viewIds)) {
                    viewIds = new ArrayList<Long>(1);
                    viewIds.add(0L);
                }
                for (Long id : viewIds) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("Id", row.getLong("fid"));
                    data.put("dimensionId", fdimensionid);
                    data.put("dimensionNumber", dimension.getNumber());
                    data.put("dimensionName", dimension.getName());
                    data.put("dimensionShortNumber", dimension.getShortNumber());
                    data.put("dimensionSeq", dimension.getSeq());
                    Long viewId = id;
                    data.put("viewId", viewId);
                    View view = dimension.getView(viewId);
                    data.put("viewNumber", view != null ? view.getNumber() : "");
                    data.put("viewName", view != null ? view.getName() : "");
                    data.put("seq", row.getInteger("fseq"));
                    data.put("source", view != null ? view.getSource() : "");
                    bizModelDimensionList.add(data);
                }
            }
        }
        ExcelApiCommon.doLog("suc_getBizModelDimensionList:", log);
        return bizModelDimensionList;
    }

    private void addOtherViews(List<ExcelDimensionViewEntity> viewIds, Long viewId, Long dimensionId, List<Object> bizModelDimensionList, List<Long> dimViews) {
        if (viewIds == null || viewIds.size() == 0) {
            return;
        }
        HashMap<String, Object> data = null;
        for (ExcelDimensionViewEntity view : viewIds) {
            if (viewId.compareTo(view.getId()) == 0 || !dimViews.contains(view.getId())) continue;
            data = new HashMap<String, Object>();
            data.put("Id", view.getId());
            data.put("dimensionId", dimensionId);
            data.put("viewId", view.getId());
            data.put("viewNumber", view.getNumber());
            data.put("viewName", view.getName());
            data.put("seq", 1);
            data.put("source", view.getSource());
            bizModelDimensionList.add(data);
        }
    }

    private String getViewNameNumber(List<ExcelDimensionViewEntity> viewIds, Long viewId, boolean isNumber) {
        if (viewIds == null) {
            return "";
        }
        for (ExcelDimensionViewEntity viewid : viewIds) {
            if (viewId.compareTo(viewid.getId()) != 0) continue;
            return isNumber ? viewid.getNumber() : viewid.getName();
        }
        return "";
    }

    private Long getBaseViewId(List<ExcelDimensionViewEntity> viewIds) {
        if (viewIds == null) {
            return 0L;
        }
        for (ExcelDimensionViewEntity viewid : viewIds) {
            if (viewid.getSource() != 1) continue;
            return viewid.getId();
        }
        return 0L;
    }

    private int getViewSource(List<ExcelDimensionViewEntity> viewIds, Long viewId) {
        if (viewIds == null) {
            return 0;
        }
        for (ExcelDimensionViewEntity view : viewIds) {
            if (viewId.compareTo(view.getId()) != 0) continue;
            return view.getSource();
        }
        return 0;
    }

    public Object getDynamicObject(Map<String, Object> param) {
        if (param == null) {
            return null;
        }
        String entityName = (String)param.get("formId");
        String selectFields = (String)param.get("selectFields");
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>(10);
        List filters = (List)param.get("qFilter");
        for (Map item : filters) {
            qFilter.add(new QFilter(item.get("property").toString(), item.get("cp").toString(), item.get("value")));
        }
        DynamicObject dy = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])qFilter.toArray(new QFilter[0]));
        if (dy != null) {
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            for (String item : selectFields.split(",")) {
                data.put(item.trim(), dy.get(item.trim()));
            }
            return data;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ExcelDimMemberEntity> getMemberByModelId(Map<String, Object> param) {
        ArrayList<ExcelDimMemberEntity> members = new ArrayList<ExcelDimMemberEntity>();
        Map<Long, List<ExcelDimensionViewEntity>> viewLsts = this.getCslScheme(param);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("model.id", "=", (Object)IDUtils.toLong((Object)param.get("modelId"))));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("id", "=", (Object)IDUtils.toLong((Object)param.get("dimensionId"))));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id,membermodel,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");){
            while (ds != null && ds.hasNext()) {
                DataSet dssub;
                block39: {
                    Row row = ds.next();
                    String memberModel = row.getString("membermodel");
                    ArrayList<QFilter> qMemberFilters = new ArrayList<QFilter>();
                    qMemberFilters.add(new QFilter("model.id", "=", param.get("modelId")));
                    if (param.containsKey("modifyTime")) {
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            qMemberFilters.add(new QFilter("modifytime", ">=", (Object)format.parse(param.get("modifyTime").toString())));
                        }
                        catch (ParseException e) {
                            log.error((Throwable)e);
                        }
                    }
                    if (!row.getBoolean("issysdimension").booleanValue()) {
                        qMemberFilters.add(new QFilter("dimension.id", "=", (Object)row.getLong("id")));
                    }
                    String selectFields = "id,number,name,isleaf,level,parent.id,createtime,modifytime,longnumber,dseq,membersource,shownumber";
                    switch (memberModel) {
                        case "epm_accountmembertree": {
                            selectFields = selectFields + " ,dataset.id";
                            break;
                        }
                        case "epm_changetypemembertree": {
                            selectFields = selectFields + " ,view";
                            break;
                        }
                        case "epm_metricmembertree": {
                            selectFields = selectFields + " ,datatype";
                            break;
                        }
                    }
                    Long dimensionId = row.getLong("id");
                    dssub = QueryServiceHelper.queryDataSet((String)"", (String)memberModel, (String)selectFields, (QFilter[])qMemberFilters.toArray(new QFilter[0]), (String)"id desc");
                    Throwable throwable = null;
                    try {
                        while (dssub != null && dssub.hasNext()) {
                            Row memberRow = dssub.next();
                            ExcelDimMemberEntity member = new ExcelDimMemberEntity();
                            member.setId(memberRow.getLong("id"));
                            member.setMemberId(memberRow.getLong("id"));
                            member.setNumber(memberRow.getString("number"));
                            member.setName(memberRow.getString("name"));
                            member.setIsLeaf(memberRow.getBoolean("isleaf"));
                            member.setLevel(memberRow.getInteger("level"));
                            member.setParentId(memberRow.getLong("parent.id"));
                            member.setCreateTime(memberRow.getDate("createtime"));
                            member.setModifyTime(memberRow.getDate("modifytime"));
                            member.setLongNumber(memberRow.getString("longnumber"));
                            member.setDseq(memberRow.getLong("dseq"));
                            member.setDimensionId(row.getLong("id"));
                            member.setMemberSource(memberRow.getString("membersource"));
                            member.setShowNumber(memberRow.getString("shownumber"));
                            if ("epm_accountmembertree".equals(memberModel)) {
                                member.setSchemeId(memberRow.getLong("dataset.id"));
                            }
                            members.add(member);
                        }
                        if (dssub == null) continue;
                        if (throwable == null) break block39;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (dssub == null) throw throwable3;
                            if (throwable == null) {
                                dssub.close();
                                throw throwable3;
                            }
                            try {
                                dssub.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        dssub.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                dssub.close();
            }
        }
        members.addAll(this.getViewMember(IDUtils.toLong((Object)param.get("modelId"))));
        return members;
    }

    private List<ExcelDimMemberEntity> getViewMember(Long modelId) {
        ArrayList<ExcelDimMemberEntity> members = new ArrayList<ExcelDimMemberEntity>();
        ArrayList<QFilter> qMemberFilters = new ArrayList<QFilter>();
        qMemberFilters.add(new QFilter("model.id", "=", (Object)modelId));
        String selectFields = "id,number,name,isleaf,level,parent.id,view.id,modifydate,longnumber,dseq,memberid,dimension.id,shownumber";
        try (DataSet dssub = QueryServiceHelper.queryDataSet((String)"", (String)"eb_viewmember", (String)selectFields, (QFilter[])qMemberFilters.toArray(new QFilter[0]), (String)"id desc");){
            while (dssub != null && dssub.hasNext()) {
                Row memberRow = dssub.next();
                ExcelDimMemberEntity member = new ExcelDimMemberEntity();
                member.setId(memberRow.getLong("id"));
                member.setMemberId(memberRow.getLong("memberid"));
                member.setNumber(memberRow.getString("number"));
                member.setName(memberRow.getString("name"));
                member.setIsLeaf(memberRow.getBoolean("isleaf"));
                member.setLevel(memberRow.getInteger("level"));
                member.setParentId(memberRow.getLong("parent.id"));
                member.setModifyTime(memberRow.getDate("modifydate"));
                member.setLongNumber(memberRow.getString("longnumber"));
                member.setDseq(memberRow.getLong("dseq"));
                member.setDimensionId(memberRow.getLong("dimension.id"));
                member.setSchemeId(memberRow.getLong("view.id"));
                member.setShowNumber(memberRow.getString("shownumber"));
                members.add(member);
            }
        }
        return members;
    }

    public Map<String, List<String>> getScenePeriodMap(Long modelid) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        return map;
    }

    public List<ExcelDimensionEntity> getDimensionByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        DataSet dimData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id,name,number,shortnumber,dseq,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<ExcelDimensionEntity> dimensions = new ArrayList<ExcelDimensionEntity>();
        dimData.forEach(dimRow -> {
            ExcelDimensionEntity dim = new ExcelDimensionEntity();
            dim.setId(dimRow.getLong("id"));
            dim.setNumber(dimRow.getString("number"));
            dim.setName(dimRow.getString("name"));
            dim.setShortNumber(dimRow.getString("shortnumber"));
            dim.setDseq(dimRow.getInteger("dseq"));
            dim.setModifyTime(dimRow.getDate("modifytime"));
            dimensions.add(dim);
        });
        return dimensions;
    }

    public List<ExcelDimPropertyEntity> getPropertyByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("model.id", "=", param.get("modelId")));
        if (param.containsKey("dimensionId")) {
            qFilters.add(new QFilter("dimension.id", "=", param.get("dimensionId")));
        }
        DataSet propertyData = QueryServiceHelper.queryDataSet((String)"", (String)"eb_custompropertyvalue", (String)"id,number,name,dseq,property", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<ExcelDimPropertyEntity> properties = new ArrayList<ExcelDimPropertyEntity>();
        propertyData.forEach(propertyRow -> {
            ExcelDimPropertyEntity property = new ExcelDimPropertyEntity();
            property.setId(propertyRow.getLong("id"));
            property.setNumber(propertyRow.getString("number"));
            property.setName(propertyRow.getString("name"));
            property.setParentId(0L);
            property.setLevel(1);
            property.setLongNumber(propertyRow.getString("number"));
            property.setDseq(propertyRow.getLong("dseq"));
            properties.add(property);
        });
        return properties;
    }

    public List<ExcelDynamicMemberEntity> getDynamicOrStaticMembers(Map<String, Object> param) {
        ArrayList<ExcelDynamicMemberEntity> result = new ArrayList<ExcelDynamicMemberEntity>();
        Object modelId = param.get("modelId");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", modelId));
        DataSet dimData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id,membermodel,number,name", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        dimData.forEach(dimRow -> {
            String id = dimRow.get("id").toString();
            String number = dimRow.get("number").toString();
            ExcelDynamicMemberEntity member = new ExcelDynamicMemberEntity();
            member.setId((Long)dimRow.get("id"));
            member.setName(dimRow.get("name").toString());
            member.setNumber(dimRow.get("number").toString());
            member.setMemberScope(10);
            member.setDynamic(false);
            member.setDimensionNumber(number);
            result.add(member);
        });
        return result;
    }

    public List<ExcelDimensionViewEntity> getCslSchemeByModelId(Map<String, Object> param) {
        Map<Long, List<ExcelDimensionViewEntity>> dimensionViewMap = this.getCslScheme(param);
        if (dimensionViewMap == null) {
            return null;
        }
        ArrayList<ExcelDimensionViewEntity> returns = new ArrayList<ExcelDimensionViewEntity>(16);
        dimensionViewMap.forEach((p, v) -> returns.addAll((Collection<ExcelDimensionViewEntity>)v));
        return returns;
    }

    private Map<Long, List<ExcelDimensionViewEntity>> getCslScheme(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model.id", "=", (Object)modelId));
        DynamicObject[] dimData = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"id,number,name,parent.id,isleaf,level,source,modifydate,description,dimension.id,baseview.id,usage,longnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        DynamicObjectCollection filterSchemes = new DynamicObjectCollection();
        for (DynamicObject dyobj : dimData) {
            dyobj.refreshDataEntityState();
            filterSchemes.add((Object)dyobj);
        }
        HashMap<Long, List<ExcelDimensionViewEntity>> returns = new HashMap<Long, List<ExcelDimensionViewEntity>>(16);
        for (DynamicObject row : filterSchemes) {
            ExcelDimensionViewEntity scheme = new ExcelDimensionViewEntity();
            scheme.setId(row.getLong("id"));
            scheme.setNumber(row.getString("number"));
            scheme.setName(row.getString("name"));
            scheme.setParentId(row.getLong("parent.id"));
            scheme.setLeaf(row.getBoolean("isleaf"));
            scheme.setLevel(row.getInt("level"));
            scheme.setModifyTime(row.getDate("modifydate"));
            scheme.setLongNumber(row.getString("longnumber"));
            scheme.setEffectiveStatus(true);
            scheme.setLegalOrgView(false);
            scheme.setEnable(true);
            scheme.setNodeType(0);
            scheme.setUsage(row.getInt("usage"));
            scheme.setBaseview(row.getLong("baseview.id"));
            scheme.setDimension(row.getLong("dimension.id"));
            scheme.setSource(row.getInt("source"));
            ArrayList<ExcelDimensionViewEntity> schemes = (ArrayList<ExcelDimensionViewEntity>)returns.get(scheme.getDimension());
            if (schemes == null) {
                schemes = new ArrayList<ExcelDimensionViewEntity>(16);
            }
            schemes.add(scheme);
            returns.put(scheme.getDimension(), schemes);
        }
        return returns;
    }

    public List<ExcelEnumValueEntity> getEnumValueByModelId(Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", param.get("modelId")));
        DynamicObject[] enumValueData = BusinessDataServiceHelper.load((String)"eb_enumvalue", (String)"id,dimid,enumname,enumnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<ExcelEnumValueEntity> enumValues = new ArrayList<ExcelEnumValueEntity>(enumValueData.length);
        for (DynamicObject valueRow : enumValueData) {
            ExcelEnumValueEntity enumValue = new ExcelEnumValueEntity();
            enumValue.setId(valueRow.getLong("id"));
            enumValue.setDimensionId(valueRow.getLong("dimid"));
            enumValue.setName(valueRow.getString("enumname"));
            enumValue.setValue(valueRow.getString("enumnumber"));
            enumValues.add(enumValue);
        }
        return enumValues;
    }

    public List<ExcelPermissionEntity> getUserPermissionMember(Map<String, Object> param) {
        List<ExcelPermissionEntity> allMemberRight;
        try {
            allMemberRight = ExcelQueryValue.getInstance().getUserPermissionMember(param);
        }
        catch (Exception e) {
            log.error("ExcelApiService.getUserPermissionMember_ERROR:", (Throwable)e);
            throw new KDBizException(new ErrorCode("ExcelApiService.getUserPermissionMember_ERROR:", e.getMessage()), new Object[]{e});
        }
        return allMemberRight;
    }

    public boolean hasDimPerm(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        Long userId = IDUtils.toLong((Object)param.get("userId"));
        String dimNum = param.get("dimNum").toString();
        if (!DimMembPermUtil.needCheckDataPerm((String)dimNum, (Long)modelId)) {
            return true;
        }
        return ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId);
    }

    public Map<String, Long> getViewByDataSet(long dataSetId) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "=", (Object)dataSetId));
        DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dataset", (String)"id, name, number,businessmodel", (QFilter[])builder.toArray());
        if (ds == null) {
            return null;
        }
        Long busModelId = ds.getDynamicObject("businessmodel").getLong("id");
        return BusinessModelServiceHelper.getViewIds((Long)busModelId, (boolean)true);
    }

    public List<ExcelRptSchemeAssignEntity> getSchemeAssigns(Map<String, Object> param) {
        DynamicObjectCollection dynamicObjects;
        LinkedList<ExcelRptSchemeAssignEntity> result = new LinkedList<ExcelRptSchemeAssignEntity>();
        if (param == null || param.isEmpty()) {
            return result;
        }
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        String name = (String)param.get("name");
        QFilter qFilter = new QFilter("model.id", "=", (Object)modelId).and(new QFilter("scheme.status", "!=", (Object)RptSchemeStatusEnum.DISABLE.getNumber()));
        if (StringUtils.isNotEmpty((String)name)) {
            qFilter.and("name", "like", (Object)("%" + name + "%"));
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id,name,scheme.id,scheme.number,scheme.name,scheme.orgview.id,scheme.orgview.number,scheme.orgview.name,year.id,year.number,year.name,datatype.id,datatype.number,datatype.name,version.id,version.number,version.name,bizrange.id,bizrange.number,bizrange.name,assigntime", (QFilter[])new QFilter[]{qFilter})) != null) {
            dynamicObjects.forEach(e -> {
                ExcelRptSchemeAssignEntity entity = new ExcelRptSchemeAssignEntity();
                entity.setModelId(modelId);
                entity.setId(e.getLong("id"));
                entity.setName(e.getString("name"));
                entity.setSchemeId(e.getLong("scheme.id"));
                entity.setSchemeNumber(e.getString("scheme.number"));
                entity.setSchemeName(e.getString("scheme.name"));
                entity.setOrgViewId(e.getLong("scheme.orgview.id"));
                entity.setOrgViewNumber(e.getString("scheme.orgview.number"));
                entity.setOrgViewName(e.getString("scheme.orgview.name"));
                entity.setPeriodId(e.getLong("year.id"));
                entity.setPeriodNumber(e.getString("year.number"));
                entity.setPeriodName(e.getString("year.name"));
                entity.setDatatypeId(e.getLong("datatype.id"));
                entity.setDatatypeNumber(e.getString("datatype.number"));
                entity.setDatatypeName(e.getString("datatype.name"));
                entity.setVersionId(e.getLong("version.id"));
                entity.setVersionNumber(e.getString("version.number"));
                entity.setVersionName(e.getString("version.name"));
                entity.setBizmodelId(e.getLong("bizrange.id"));
                entity.setBizmodelNumber(e.getString("bizrange.number"));
                entity.setBizmodelName(e.getString("bizrange.name"));
                entity.setLastAssignTime(e.getDate("assigntime"));
                result.add(entity);
            });
        }
        return result;
    }
}

