/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.formula;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonCheckUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.service.ShowBizRuleUtils;
import org.apache.commons.lang3.StringUtils;

public class ExcelCheckUtil {
    public static final String MODEL_ID_KEY = "ModelId";
    public static final String DATASET_ID_KEY = "DataSetId";
    public static final String QUERY_KEY = "QueryKey";
    public static final String DIMENSION_MEMBER_KEY = "DimensionMembers";
    public static final String FORMULAS_KEY = "Formulas";
    public static final String FORMULA_DIM_MEMBERS_KEY = "FormulaDimMembers";
    public static final String VALUE_KEY = "Value";
    public static final String[] NOT_ALLOW_EMPTY_PARAM1 = new String[]{"DimensionMembers", "Formulas"};
    public static final String[] NOT_ALLOW_EMPTY_PARAM2 = new String[]{"ModelId", "QueryKey", "FormulaDimMembers"};
    private static ThreadLocal<Map<Long, IModelCacheHelper>> modelCache = new ThreadLocal();
    public static final String DIM_SEPARATOR = ",";
    public static final String MEM_SEPARATOR = "@";
    public static final String ERROR_PRE = "Err!";
    public static final String DimensionNumber = "DimensionNumber";

    public static Map<String, Object> checkCellAllowEntered(Map<String, Object> params, Map<String, String> dimensions, Map<String, String> filterDimMap) {
        String accountNumber;
        Long datasetId;
        IModelCacheHelper modelCacheHelper;
        HashMap<String, Object> checkResults = new HashMap<String, Object>(16);
        boolean paramFlag = ExcelCheckUtil.checkParams(params, dimensions, filterDimMap, checkResults);
        if (!paramFlag) {
            return checkResults;
        }
        Long modelId = (Long)ExcelCheckUtil.getValueT(params, MODEL_ID_KEY);
        String key = (String)ExcelCheckUtil.getValueT(params, QUERY_KEY);
        boolean isValid = ExcelCheckUtil.checkDimensionsAllowEntered(checkResults, key, modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId), datasetId = modelCacheHelper.getMember(accountNumber = SysDimensionEnum.Account.getNumber(), null, dimensions.get(accountNumber)).getDatasetId(), dimensions);
        if (!isValid) {
            return checkResults;
        }
        checkResults.put(key, null);
        return checkResults;
    }

    private static boolean checkParams(Map<String, Object> formula, Map<String, String> out_dimensions, Map<String, String> filterDimMap, Map<String, Object> out_CheckResults) {
        boolean paramValid = ExcelCheckUtil.checkParamValid(out_CheckResults, formula, NOT_ALLOW_EMPTY_PARAM2);
        if (!paramValid) {
            return false;
        }
        String accountNumber = SysDimensionEnum.Account.getNumber();
        Long modelId = (Long)ExcelCheckUtil.getValueT(formula, MODEL_ID_KEY);
        String key = (String)ExcelCheckUtil.getValueT(formula, QUERY_KEY);
        out_CheckResults.put(key, null);
        if (ExcelCheckUtil.checkModelIsExist(out_CheckResults, modelId, key)) {
            return false;
        }
        String dimensionStr = (String)ExcelCheckUtil.getValueT(formula, FORMULA_DIM_MEMBERS_KEY);
        out_dimensions.putAll(ExcelCheckUtil.loadDimensionMap(modelId, dimensionStr, filterDimMap, key, out_CheckResults));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String accountMemberStr = out_dimensions.get(accountNumber);
        if (StringUtils.isEmpty((CharSequence)accountMemberStr) || accountMemberStr.equalsIgnoreCase("ACCOUNT")) {
            ExcelCheckUtil.returnCheckResults(out_CheckResults, key, ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u79d1\u76ee\u6216\u8005\u79d1\u76ee\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u96c6\u3002", (String)"ExcelCheckUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        Member accountMember = modelCacheHelper.getMember(accountNumber, null, accountMemberStr);
        if (accountMember == null) {
            ExcelCheckUtil.returnCheckResults(out_CheckResults, key, String.format(ResManager.loadKDString((String)"\u53c2\u6570[%1$s]\u7684\u6210\u5458[%2$s]\u4e0d\u5b58\u5728\u3002", (String)"ExcelCheckUtil_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), accountNumber, accountMemberStr), new String[0]);
            return false;
        }
        Long datasetId = accountMember.getDatasetId();
        paramValid = ExcelCheckUtil.checkDimenMemberParam(out_CheckResults, key, out_dimensions, modelCacheHelper, datasetId);
        if (!paramValid) {
            return false;
        }
        paramValid = ExcelCheckUtil.checkDimensionConsistent(out_CheckResults, key, out_dimensions, modelCacheHelper, datasetId);
        return paramValid;
    }

    public static boolean checkModelIsExist(Map<String, Object> checkResults, Long modelId, String key) {
        if (IDUtils.isNull((Long)modelId)) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApprovePlanListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return true;
        }
        return false;
    }

    private static boolean checkDimenMemberParam(Map<String, Object> checkResults, String queryKey, Map<String, String> dimensions, IModelCacheHelper modelCacheHelper, Long datasetId) {
        Long busModelByDataSet = modelCacheHelper.getBusModelByDataSet(datasetId);
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            String dimenNumber = entry.getKey();
            String dimenMember = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)dimenMember)) {
                ExcelCheckUtil.returnCheckResults(checkResults, queryKey, String.format(ResManager.loadKDString((String)"\u53c2\u6570[%1$s]\u7684\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelCheckUtil_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), dimenNumber), new String[0]);
                return false;
            }
            Member member = modelCacheHelper.getMemberByAnyView(busModelByDataSet, dimenNumber, dimenMember);
            if (member != null) continue;
            ExcelCheckUtil.returnCheckResults(checkResults, queryKey, String.format(ResManager.loadKDString((String)"\u53c2\u6570[%1$s]\u7684\u6210\u5458[%2$s]\u4e0d\u5b58\u5728\u3002", (String)"ExcelCheckUtil_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), dimenNumber, dimenMember), new String[0]);
            return false;
        }
        return true;
    }

    public static Map<String, String> loadDimensionMap(Long modelId, String dimensionStr, Map<String, String> filterDimMap, String key, Map<String, Object> checkResults) {
        IModelCacheHelper modelCacheHelper = ExcelCheckUtil.getModelCacheHelper(modelId);
        HashMap<String, String> dimensionMap = new HashMap<String, String>(20);
        if (filterDimMap != null && filterDimMap.size() > 0) {
            dimensionMap.putAll(filterDimMap);
        }
        dimensionMap.putAll(ExcelCheckUtil.loadDimensionMapByShortNumberStr(modelCacheHelper, dimensionStr, key, checkResults));
        String accountMember = (String)dimensionMap.get(SysDimensionEnum.Account.getNumber());
        if (accountMember == null) {
            return dimensionMap;
        }
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountMember);
        if (member == null) {
            return dimensionMap;
        }
        Long datasetId = member.getDatasetId();
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        Set dimenSet = Stream.of(dimensionNums).collect(Collectors.toSet());
        Iterator iterator = dimensionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String dimenKey = (String)next.getKey();
            if (dimenSet.contains(dimenKey)) continue;
            iterator.remove();
        }
        return dimensionMap;
    }

    public static IModelCacheHelper getModelCacheHelper(Long modelId) {
        IModelCacheHelper modelCacheHelper;
        Map<Long, IModelCacheHelper> cacheHelperMap = modelCache.get();
        if (cacheHelperMap == null) {
            cacheHelperMap = new HashMap<Long, IModelCacheHelper>(16);
        }
        if ((modelCacheHelper = cacheHelperMap.get(modelId)) == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            cacheHelperMap.put(modelId, modelCacheHelper);
            modelCache.set(cacheHelperMap);
        }
        return modelCacheHelper;
    }

    public static void clearCache() {
        modelCache.remove();
    }

    public static Map<String, String> loadDimensionMapByShortNumberStr(IModelCacheHelper modelCacheHelper, String dimensionStr, String queryKey, Map<String, Object> checkResults) {
        HashMap<String, String> dimensionMap = new HashMap<String, String>(30);
        Map<String, String> dimensionShortNumberMap = ExcelCheckUtil.loadDimensionShortNumberMap(modelCacheHelper);
        String[] split = dimensionStr.split(DIM_SEPARATOR);
        if (split.length == 0) {
            return dimensionMap;
        }
        for (String dimAndMemStr : split) {
            String[] dimAndMemArr = dimAndMemStr.split(MEM_SEPARATOR);
            if (dimAndMemArr.length != 2) {
                ExcelCheckUtil.returnCheckResults(checkResults, queryKey, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u4e2d\u7684[%1$s]\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ExcelCheckUtil_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), dimAndMemStr), new String[0]);
                continue;
            }
            String dimen = dimensionShortNumberMap.get(dimAndMemArr[0].toLowerCase(Locale.ENGLISH));
            String member = dimAndMemArr[1];
            dimensionMap.put(dimen, member);
        }
        return dimensionMap;
    }

    private static Map<String, String> loadDimensionShortNumberMap(IModelCacheHelper modelCacheHelper) {
        List dimensionList = modelCacheHelper.getDimensions().entrySet().stream().filter(entry -> entry != null && entry.getValue() != null).map(entry -> (Dimension)entry.getValue()).collect(Collectors.toList());
        HashMap<String, String> resultMap = new HashMap<String, String>((int)((double)dimensionList.size() * 1.75 + 1.0));
        for (Dimension dimension : dimensionList) {
            resultMap.put(dimension.getShortNumber().toLowerCase(Locale.ENGLISH), dimension.getNumber());
        }
        return resultMap;
    }

    private static boolean checkDimensionsAllowEntered(Map<String, Object> checkResults, String key, IModelCacheHelper modelCacheHelper, Long datasetId, Map<String, String> dimensions) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        long busModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
        boolean flag = ExcelCheckUtil.checkDimPermNotOk(checkResults, key, dimensions, modelId, busModelId, DimMembPermType.WRITE);
        if (flag) {
            return false;
        }
        flag = ExcelCheckUtil.cellIsLeafByDataset(dimensions, modelCacheHelper, datasetId, key, checkResults);
        if (!flag) {
            return false;
        }
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
        flag = CommonCheckUtil.checkDataLock((Long)modelId, (Long)bizModelId, dimensions);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u5df2\u88ab\u6570\u636e\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_7", (String)"epm-eb-business", (Object[])new Object[0]), new String[0]);
            return false;
        }
        flag = CommonCheckUtil.checkRollBudget((Long)modelId, dimensions);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u6eda\u52a8\u9884\u7b97\u6eda\u52a8\u671f\u95f4\u4ee5\u524d\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        flag = CommonCheckUtil.checkChangeType(dimensions);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u5360\u7528\u3001\u6267\u884c\u4e0b\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        flag = CommonCheckUtil.checkAuditTrailUse((IModelCacheHelper)modelCacheHelper, dimensions, (AuditTrailUseEnum)AuditTrailUseEnum.AUTO_OFFSET);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u81ea\u52a8\u62b5\u6d88\u7ebf\u7d22\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        boolean bl = flag = ShowBizRuleUtils.getReportShowBizRuleBo(dimensions, (Long)modelId, null) != null;
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u8ba1\u7b97\u51fa\u6765\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        flag = CommonCheckUtil.checkAuditTrailUse((IModelCacheHelper)modelCacheHelper, dimensions, (AuditTrailUseEnum)AuditTrailUseEnum.DECOMPOSE);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u5ba1\u6279\u8c03\u6574\u7ebf\u7d22\u4e0b\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        flag = ExcelCheckUtil.containVirtualMember(dimensions, modelCacheHelper, busModelId);
        if (flag) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadKDString((String)"\u542b\u6709\u865a\u62df\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[0]);
            return false;
        }
        return true;
    }

    private static boolean containVirtualMember(Map<String, String> dimensions, IModelCacheHelper modelCacheHelper, long busModelId) {
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            Member memberByAnyView = modelCacheHelper.getMemberByAnyView(Long.valueOf(busModelId), entry.getKey(), entry.getValue());
            if (memberByAnyView != null && !MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(memberByAnyView.getSource())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDimPermNotOk(Map<String, Object> checkResults, String key, Map<String, String> dimensions, long modelId, long busModelId, DimMembPermType dimMembPermType) {
        HashMap permissionMap = Maps.newHashMapWithExpectedSize((int)32);
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            Set permissions;
            if (!permissionMap.containsKey(entry.getKey())) {
                Set _permissions;
                Member memberByAnyView = orCreate.getMemberByAnyView(Long.valueOf(busModelId), entry.getKey(), entry.getValue());
                if (memberByAnyView instanceof ViewMember) {
                    Long viewId = ((ViewMember)memberByAnyView).getViewId();
                    _permissions = DimMembPermHelper.getPermMembNumbers((String)entry.getKey(), (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)dimMembPermType, (boolean)true);
                } else {
                    _permissions = DimMembPermHelper.getPermMembNumbers((String)entry.getKey(), (Long)modelId, (Long)busModelId, (Long)0L, (DimMembPermType)dimMembPermType, (boolean)true);
                }
                if (_permissions != null) {
                    permissionMap.put(entry.getKey(), new HashSet(_permissions));
                } else {
                    permissionMap.put(entry.getKey(), null);
                }
            }
            if ((permissions = (Set)permissionMap.get(entry.getKey())) == null || permissions.contains(entry.getValue())) continue;
            tags.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709(%1$s)\u7ef4\u5ea6\u7684\u6210\u5458\u5199\u5165\u6743\u9650", (String)"ExcelCheckUtil_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), entry.getKey()));
        }
        if (tags.size() > 0) {
            ExcelCheckUtil.returnCheckResults(checkResults, key, StringUtils.join(tags, (char)','), new String[0]);
            return true;
        }
        return false;
    }

    public static boolean cellIsLeafByDataset(Map<String, String> allDimNum, IModelCacheHelper iModelCacheHelper, Long datasetId, String key, Map<String, Object> checkResults) {
        Long busModelByDataSet = iModelCacheHelper.getBusModelByDataSet(datasetId);
        for (Map.Entry<String, String> entry : allDimNum.entrySet()) {
            Member member = iModelCacheHelper.getMemberByAnyView(busModelByDataSet, entry.getKey(), entry.getValue());
            if (member == null || member.isLeaf()) continue;
            ExcelCheckUtil.returnCheckResults(checkResults, key, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u6210\u5458\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u7ef4\u5ea6\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\u6570\u636e\u3002", (String)"ExcelCheckUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getDimension().getNumber(), member.getNumber()}), new String[0]);
            return false;
        }
        return true;
    }

    private static boolean checkDimensionConsistent(Map<String, Object> checkResults, String key, Map<String, String> dimensions, IModelCacheHelper modelCacheHelper, Long datasetId) {
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        Set paramDimens = dimensions.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        if (dimensionNums == null || paramDimens.size() != dimensionNums.length) {
            Set dimensionSet = Stream.of(dimensionNums).filter(dimen -> !paramDimens.contains(dimen)).map(dimensionNumber -> {
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
                if (dimension == null) {
                    return dimensionNumber;
                }
                return dimension.getName();
            }).collect(Collectors.toSet());
            String join = String.join((CharSequence)DIM_SEPARATOR, dimensionSet);
            ExcelCheckUtil.returnCheckResults(checkResults, key, String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u7ef4\u5ea6[%1$s]\u4fe1\u606f\u3002", (String)"ExcelCheckUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), join), new String[0]);
            return false;
        }
        HashSet<String> dimenSet = new HashSet<String>(Arrays.asList(dimensionNums));
        for (String paramDimen : paramDimens) {
            if (dimenSet.contains(paramDimen)) continue;
            ExcelCheckUtil.returnCheckResults(checkResults, key, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7ef4\u5ea6\u6210\u5458\u4e0e\u5b9e\u9645\u4e1a\u52a1\u89c4\u5219\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e00\u81f4\u3002\u8bf7\u6ce8\u610f\u5dee\u5f02\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ExcelCheckUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), paramDimen), new String[0]);
            return false;
        }
        return true;
    }

    public static boolean checkParamValid(Map<String, Object> checkResults, Map<String, Object> params, String[] paramKeys) {
        for (String paramKey : paramKeys) {
            Object obj = params.get(paramKey);
            if (obj != null && !StringUtils.isEmpty((CharSequence)obj.toString())) continue;
            ExcelCheckUtil.returnCheckResults(checkResults, params.toString(), String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%1$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelCheckUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), paramKey), new String[0]);
            return false;
        }
        return true;
    }

    private static void returnCheckResults(Map<String, Object> checkResults, String key, String msg, String ... format) {
        String errMsg = String.format(msg, format);
        checkResults.put(key, StringUtils.join((Object[])new String[]{ERROR_PRE, errMsg}));
    }

    public static <T> T getValueT(Map<String, Object> param, String key) {
        Object obj = param.get(key);
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    public static Map<String, Object> checkGetVParam(Map<String, Object> formula, Map<String, String> filterDimMap, Map<String, String> out_dimensions) {
        HashMap<String, Object> checkResults = new HashMap<String, Object>(16);
        ExcelCheckUtil.checkParams(formula, out_dimensions, filterDimMap, checkResults);
        Long modelId = (Long)ExcelCheckUtil.getValueT(formula, MODEL_ID_KEY);
        String key = (String)ExcelCheckUtil.getValueT(formula, QUERY_KEY);
        String accountNumber = SysDimensionEnum.Account.getNumber();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long datasetId = modelCacheHelper.getMember(accountNumber, null, out_dimensions.get(accountNumber)).getDatasetId();
        ExcelCheckUtil.checkDimPermNotOk(checkResults, key, out_dimensions, modelId, modelCacheHelper.getBusModelByDataSet(datasetId), DimMembPermType.READ);
        return checkResults;
    }
}

