/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.formula;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.formplugin.excel.formula.ExcelCheckUtil;
import kd.epm.eb.formplugin.excel.formula.ExcelQueryValue;
import kd.epm.eb.formplugin.excel.formula.ExcelSetValue;
import kd.epm.eb.olap.api.metadata.IKDCell;

public class ExcelFormula {
    private static Log log = LogFactory.getLog(ExcelFormula.class);

    public Map<String, Object> getV(Map<String, Object> param) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            ExcelQueryValue.getInstance().queryValue(param, resultMap);
        }
        catch (Exception e) {
            log.error("ExcelApiService.getV_ERROR:", (Throwable)e);
            throw new KDBizException(new ErrorCode("ExcelApiService.getV_ERROR:", e.getMessage()), new Object[]{e});
        }
        finally {
            ExcelCheckUtil.clearCache();
        }
        return resultMap;
    }

    public Map<String, Object> setV(Map<String, Object> params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(16);
        try {
            Map<String, String> modelDataSetId = ExcelSetValue.getInstance().arrangeParams(params, resultMap, cells);
            LogStats stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("ExcelApiService-setV");
            if (modelDataSetId == null || modelDataSetId.containsKey("0")) {
                HashMap<String, Object> hashMap = resultMap;
                return hashMap;
            }
            ExcelSetValue.getInstance().saveOlap(modelDataSetId, cells, ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
        }
        catch (Exception e) {
            log.error("ExcelApiService.setV_ERROR:", (Throwable)e);
            throw new KDBizException(new ErrorCode("ExcelApiService.setV_ERROR:", e.getMessage()), new Object[]{e});
        }
        finally {
            ExcelCheckUtil.clearCache();
        }
        return resultMap;
    }
}

