/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.formula;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelPermissionEntity;
import kd.epm.eb.formplugin.excel.formula.ExcelCheckUtil;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.eb.olap.impl.utils.OlapCommandInfo;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;

public class ExcelQueryValue {
    public static volatile ExcelQueryValue excelQueryValue = null;

    private ExcelQueryValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcelQueryValue getInstance() {
        if (excelQueryValue != null) return excelQueryValue;
        Class<ExcelQueryValue> clazz = ExcelQueryValue.class;
        synchronized (ExcelQueryValue.class) {
            if (excelQueryValue != null) return excelQueryValue;
            excelQueryValue = new ExcelQueryValue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return excelQueryValue;
        }
    }

    public void queryValue(Map<String, Object> params, Map<String, Object> out_ResultMap) {
        Map filterDimMap = (Map)params.get("DimensionMembers");
        Map formula = (Map)params.get("Formulas");
        String queryKey = (String)ExcelCheckUtil.getValueT(formula, "QueryKey");
        Long modelId = IDUtils.toLong(formula.get("ModelId"));
        HashMap<String, String> out_dimensions = new HashMap<String, String>(20);
        out_ResultMap.putAll(ExcelCheckUtil.checkGetVParam(formula, filterDimMap, out_dimensions));
        String checkMap = (String)ExcelCheckUtil.getValueT(out_ResultMap, queryKey);
        if (StringUtils.isNotEmpty((String)checkMap)) {
            return;
        }
        IModelCacheHelper modelcache = ExcelCheckUtil.getModelCacheHelper(modelId);
        String accountNumber = SysDimensionEnum.Account.getNumber();
        Long datasetId = modelcache.getMember(accountNumber, null, (String)out_dimensions.get(accountNumber)).getDatasetId();
        this.queryOlap(modelId, datasetId, queryKey, out_dimensions, out_ResultMap);
    }

    private void queryOlap(Long modelId, Long datasetId, String queryKey, Map<String, String> dimensions, Map<String, Object> out_ResultMap) {
        HashMap<String, HashSet> memberInfo = new HashMap<String, HashSet>(dimensions.size());
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            memberInfo.put(entry.getKey(), Sets.newHashSet((Object[])new String[]{entry.getValue()}));
        }
        QueryRequest queryRequest = new QueryRequest(modelId, datasetId, memberInfo);
        List bgCells = OlapCommService.getInstance().queryList(queryRequest);
        out_ResultMap.put(queryKey, bgCells == null || bgCells.isEmpty() ? null : ((BGCell)bgCells.get(0)).getValue());
    }

    private List<IKDCell> queryIKDCell(Map<String, String> olapParam, Long dataSetId, Long bizModelId, Long modelId, IModelCacheHelper modelcache, String[] dimArr) {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(dimArr);
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String accountNumber = null;
        for (String dimNumber : dimArr) {
            String member = olapParam.get(dimNumber);
            if (StringUtils.isEmpty(accountNumber) && SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                accountNumber = member;
            }
            queryInfo.addFilter(dimNumber, new String[]{member});
        }
        OlapCommandInfo[] olapCommandInfos = new OlapCommandInfo[]{OlapCommandInfo.of(null, (SelectCommandInfo)queryInfo)};
        IKDOlapRequest request = KDOlapRequestUtils.of((IModelCacheHelper)modelcache, (Long)modelId, (Long)bizModelId, (Long)dataSetId, null, (OlapCommandInfo[])olapCommandInfos, null, (boolean)false);
        request.getProperties().setPropertyValue("DATA_GET_ALL", KDValue.TRUE);
        return ExcelQueryValue.getOlapValue(request);
    }

    private static List<IKDCell> getOlapValue(IKDOlapRequest request) {
        return (List)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapService", (String)"get", (Object[])new Object[]{request});
    }

    public List<ExcelPermissionEntity> getUserPermissionMember(Map<String, Object> params) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        Long modelId = (Long)ExcelCheckUtil.getValueT(params, "ModelId");
        String dimensionNumber = (String)ExcelCheckUtil.getValueT(params, "DimensionNumber");
        boolean notExist = ExcelCheckUtil.checkModelIsExist(resultMap, modelId, "");
        if (notExist) {
            Set errSet = resultMap.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> entry.getValue().toString()).collect(Collectors.toSet());
            String join = String.join((CharSequence)"|", errSet);
            throw new KDBizException(new ErrorCode("ExcelQueryValue.getUserPermissionMember_ERROR:", join), new Object[]{this});
        }
        List allDatasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
        if (allDatasets == null || allDatasets.size() == 0) {
            return new ArrayList<ExcelPermissionEntity>(0);
        }
        ArrayList<ExcelPermissionEntity> list = new ArrayList<ExcelPermissionEntity>(16);
        HashSet<Long> bizScopeIds = new HashSet<Long>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (Dataset dataset : allDatasets) {
            Long datasetId = dataset.getId();
            Long bizScopeId = modelCacheHelper.getBusModelByDataSet(datasetId);
            if (bizScopeIds.contains(bizScopeId)) continue;
            bizScopeIds.add(bizScopeId);
            Map viewGroupViewsByBusModel = modelCacheHelper.getViewGroupViewsByBusModel(bizScopeId);
            this.loadPermissionSet(modelId, list, bizScopeId, dimensionNumber, DimMembPermType.READ, (List)viewGroupViewsByBusModel.get(dimensionNumber));
            this.loadPermissionSet(modelId, list, bizScopeId, dimensionNumber, DimMembPermType.WRITE, (List)viewGroupViewsByBusModel.get(dimensionNumber));
        }
        return list;
    }

    private void loadPermissionSet(Long modelId, List<ExcelPermissionEntity> list, Long bizScopeId, String dim, DimMembPermType permType, List<Long> viewIds) {
        HashSet allViewHasPermNumbers = new HashSet(16);
        if (CollectionUtils.isNotEmpty(viewIds)) {
            for (Long viewId : viewIds) {
                Set membNumbers = DimMembPermHelper.getPermMembNumbers((String)dim, (Long)modelId, (Long)bizScopeId, (Long)viewId, (DimMembPermType)permType, (boolean)true);
                if (membNumbers == null) continue;
                allViewHasPermNumbers.addAll(membNumbers);
            }
        } else {
            Set membNumbers = DimMembPermHelper.getPermMembNumbers((String)dim, (Long)modelId, (Long)bizScopeId, (Long)0L, (DimMembPermType)permType, (boolean)true);
            if (membNumbers != null) {
                allViewHasPermNumbers.addAll(membNumbers);
            }
        }
        for (String membNumber : allViewHasPermNumbers) {
            list.add(new ExcelPermissionEntity(modelId, bizScopeId, dim, membNumber, UserUtils.getUserId(), permType.getIndex(), UserUtils.getUserId()));
        }
    }
}

