/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.formula;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.excel.formula.ExcelCheckUtil;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;

public class ExcelSetValue {
    public static volatile ExcelSetValue excelSetValue = null;

    private ExcelSetValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcelSetValue getInstance() {
        if (excelSetValue != null) return excelSetValue;
        Class<ExcelSetValue> clazz = ExcelSetValue.class;
        synchronized (ExcelSetValue.class) {
            if (excelSetValue != null) return excelSetValue;
            excelSetValue = new ExcelSetValue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return excelSetValue;
        }
    }

    public Map<String, String> arrangeParams(Map<String, Object> params, Map<String, Object> out_ResultMap, List<IKDCell> out_Cells) {
        Map filterDimMap = (Map)params.get("DimensionMembers");
        Map formula = (Map)params.get("Formulas");
        Long modelId = IDUtils.toLong(formula.get("ModelId"));
        String key = (String)ExcelCheckUtil.getValueT(formula, "QueryKey");
        HashMap<String, String> dimensions = new HashMap<String, String>(20);
        out_ResultMap.putAll(ExcelCheckUtil.checkCellAllowEntered(formula, dimensions, filterDimMap));
        String checkMap = (String)ExcelCheckUtil.getValueT(out_ResultMap, key);
        if (StringUtils.isNotEmpty((String)checkMap)) {
            return null;
        }
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelId);
        Long datasetId = this.getDataSetId(modelcache, 0L, (String)dimensions.get(SysDimensionEnum.Account.getNumber()));
        String[] dimensionNums = modelcache.getDimensionNums(datasetId);
        String[] memberArr = this.getDimValueByDimOrd(dimensionNums, dimensions);
        Object fvalue = formula.get("Value");
        BigDecimal writeValue = BigDecimal.ZERO;
        if (!(fvalue instanceof BigDecimal)) {
            out_ResultMap.put(key, ResManager.loadKDString((String)"\u9700\u8981\u66f4\u65b0\u7684\u503c\u4e0d\u5408\u6cd5", (String)"ExcelSetValue_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        writeValue = (BigDecimal)fvalue;
        out_Cells.add(KDCell.of((String[])memberArr, (BigDecimal)writeValue));
        HashMap<String, String> returns = new HashMap<String, String>(5);
        returns.put("ModelId", modelId.toString());
        returns.put("DataSetId", datasetId.toString());
        returns.putAll(dimensions);
        return returns;
    }

    public void saveOlap(Map<String, String> modelDataSetId, List<IKDCell> cells, Map<String, String> shrekProperties) {
        Long modelId = IDUtils.toLong((Object)modelDataSetId.get("ModelId"));
        Long dataSetId = IDUtils.toLong((Object)modelDataSetId.get("DataSetId"));
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDatasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
        for (Dataset dataset : allDatasets) {
            if (dataset.getId().compareTo(dataSetId) != 0) continue;
            Model model = modelcache.getModelobj();
            String[] dimensionNums = modelcache.getDimensionNums(dataSetId);
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.ExcelApi));
            IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)model, (Dataset)dataset, (String[])dimensionNums, shrekProperties);
            Object object = null;
            try {
                for (IKDCell cell : cells) {
                    shrekOlapSave.add(cell.getMeta().getNumber(), (Object)cell.getValue().getDecimal());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (shrekOlapSave != null) {
                    if (object != null) {
                        try {
                            shrekOlapSave.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        shrekOlapSave.close();
                    }
                }
            }
            String traceId = RequestContext.getOrCreate().getTraceId();
            for (IKDCell cell : cells) {
                EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
                    RequestContext.getOrCreate().setTraceId(traceId);
                    RuleExecutionService.getInstance().executeRuleChain(null, dataSetId, modelId, this.createCells(modelDataSetId, cell), RuleExecuteTypeEnum.EXCEL_CLIENT.getType());
                });
            }
        }
    }

    private List<BGCell> createCells(Map<String, String> modelDataSetId, IKDCell cell) {
        BigDecimal fmoney = cell.getValue().getDecimal();
        if (fmoney == null) {
            return null;
        }
        BigDecimal value = ConvertUtils.toDecimal((Object)fmoney);
        LinkedList<BGCell> cells = new LinkedList<BGCell>();
        HashMap memberMap = Maps.newHashMap();
        modelDataSetId.forEach((k, v) -> {
            if (!"ModelId".equals(k) && !"DataSetId".equals(k)) {
                memberMap.put(k, v);
            }
        });
        BGCell bgCell = new BGCell((Map)memberMap, (Object)value);
        cells.add(bgCell);
        return cells;
    }

    public String[] getDimValueByDimOrd(String[] allDimKey, Map<String, String> ebDimMap) {
        if (ebDimMap == null || ebDimMap.size() == 0) {
            return null;
        }
        String[] returns = new String[allDimKey.length];
        for (int i = 0; i < allDimKey.length; ++i) {
            returns[i] = ebDimMap.get(allDimKey[i]);
        }
        return returns;
    }

    public Long getDataSetId(IModelCacheHelper modelCacheHelper, Long dataSetId, String accountNumber) {
        if (dataSetId.compareTo(0L) > 0) {
            return dataSetId;
        }
        Dimension dim = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
        return dim.getMember(null, accountNumber).getDatasetId();
    }
}

