/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelRptSchemeEntity;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.excelEntity.report.TemplateCatalog;
import kd.epm.eb.formplugin.task.command.TaskUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ExcelBgTaskExecuteHelper {
    public List<ExcelRptSchemeEntity> getRptTask(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        List taskListIds = (List)param.get("taskListIds");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (CollectionUtils.isNotEmpty((Collection)taskListIds)) {
            filter.and(new QFilter("id", "in", (Object)taskListIds));
        }
        DataSet dimData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_tasklist", (String)"id,number,name,modifydate,bizmodel.id,orgview.id", (QFilter[])filter.toArray(), (String)"id desc");
        ArrayList<ExcelRptSchemeEntity> returns = new ArrayList<ExcelRptSchemeEntity>(16);
        dimData.forEach(row -> {
            ExcelRptSchemeEntity rptScheme = new ExcelRptSchemeEntity();
            rptScheme.setModelId(modelId);
            rptScheme.setId(row.getLong("id"));
            rptScheme.setNumber(row.getString("number"));
            rptScheme.setName(row.getString("name"));
            rptScheme.setModifyTime(row.getDate("modifydate"));
            rptScheme.setOrgviewId(row.getLong("orgview.id"));
            rptScheme.setBizRangeId(row.getLong("bizmodel.id"));
            rptScheme.setTaskReport(2);
            returns.add(rptScheme);
        });
        return returns;
    }

    public List<String> getReportTaskF7Scope(Map<String, Object> param) {
        Long taskListId = IDUtils.toLong((Object)param.get("taskId"));
        QFBuilder filter = new QFBuilder("task.tasklist", "=", (Object)taskListId);
        DataSet dimData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_taskprocess", (String)"id,org.number as orgNumber", (QFilter[])filter.toArray(), (String)"id desc");
        ArrayList<String> returns = new ArrayList<String>(16);
        dimData.forEach(row -> returns.add(row.getString("orgNumber")));
        return returns;
    }

    public Map<String, Object> queryYear(Map<String, Object> param) {
        HashSet<Long> yearIds = new HashSet<Long>(16);
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        QFBuilder builder = new QFBuilder("task.tasklist.model", "=", (Object)modelId);
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        builder.add("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"queryYear", (String)"eb_taskprocess", (String)"id,task.tasklist.year as year,modifydate", (QFilter[])builder.toArray(), (String)"modifydate desc");
        long lastYear = 0L;
        if (ds != null) {
            while (ds.hasNext()) {
                Row next = ds.next();
                if (lastYear == 0L) {
                    lastYear = next.getLong("year");
                }
                yearIds.add(next.getLong("year"));
            }
        }
        HashMap<String, Object> values = new HashMap<String, Object>(2);
        if (yearIds.size() > 0) {
            values.put("lastYear", String.valueOf(lastYear));
            values.put("yearIds", yearIds);
        }
        return values;
    }

    public List<TemplateCatalog> getExcelExecuteTaskList(Map<String, Object> param) {
        HashSet<Long> tempIds = new HashSet<Long>(16);
        TreeNode root = this.queryFromDB(param, tempIds);
        Map<Long, DynamicObject> templates = this.getTemplates(tempIds);
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        if (root == null) {
            return null;
        }
        HashMap<String, Long> mapIds = new HashMap<String, Long>(16);
        List<TemplateCatalog> templateCatalogs = this.buildExcelMap(modelId, root.getChildren(), templates, mapIds, "");
        return templateCatalogs;
    }

    private TreeNode queryFromDB(Map<String, Object> param, Set<Long> tempIds) {
        TreeNode root = new TreeNode(null, "#", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskTreePanelDraw_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        Long yearId = IDUtils.toLong((Object)param.get("yearId"));
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("year", "=", (Object)yearId);
        Map<Long, DynamicObject> taskListMap = TaskUtils.queryTaskList(builder);
        if (taskListMap == null || taskListMap.isEmpty()) {
            return root;
        }
        builder.clear();
        builder.add("tasklist", "in", taskListMap.keySet());
        Map<Long, DynamicObject> taskMap = TaskUtils.queryTask(builder, false);
        if (taskMap == null || taskMap.isEmpty()) {
            return root;
        }
        builder.clear();
        builder.add("task.tasklist.model", "=", (Object)modelId);
        builder.and("task.tasklist.year", "=", (Object)yearId);
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        builder.add("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        LinkedHashMap reportProcessStatusMap = Maps.newLinkedHashMap();
        if (this.loadReportProcessStatus(modelId, builder, reportProcessStatusMap)) {
            return root;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension orgDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        builder.clear();
        builder.add("model", "=", (Object)modelId);
        DynamicObjectCollection templates = modelCache.getModelobj().isModelByNewEB() ? QueryServiceHelper.query((String)"eb_templateentity_bg", (String)"id,name,number,templatetype", (QFilter[])builder.toArray()) : QueryServiceHelper.query((String)"eb_templateentity", (String)"id,name,number,templatetype", (QFilter[])builder.toArray());
        Map<Long, DynamicObject> templateMap = templates.stream().collect(Collectors.toMap(template -> template.getLong("id"), template -> template));
        builder.clear();
        builder.add("task", "in", taskMap.keySet());
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        builder.add("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)"id,state, org.id as orgId, org.longNumber, orgview as orgViewId,task.id as taskId, task.tasklist.id as taskListId, task.taskseq,templatetype, template, tempseq, task.tasklist.tpseq", (QFilter[])builder.toArray(), (String)"task.tasklist.tpseq,org.longNumber,task.taskseq,tempseq");
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>();
        String _yearId = yearId.toString();
        if (ds != null) {
            while (ds.hasNext()) {
                TreeNode levelThreeNode;
                TreeNode levelTwoNode;
                String processid;
                String status;
                Row row = ds.next();
                Long taskProcessId = row.getLong("id");
                Long tempId = row.getLong("template");
                Long orgId = row.getLong("orgId");
                String mapValue = (String)reportProcessStatusMap.get(taskProcessId);
                if (mapValue == null) {
                    status = "";
                    processid = "0";
                } else {
                    status = mapValue.split(",")[0];
                    processid = mapValue.split(",")[1];
                }
                Long orgViewId = row.getLong("orgViewId");
                Long taskId = row.getLong("taskId");
                DynamicObject task = taskMap.get(IDUtils.toLong((Object)taskId));
                String taskName = task != null ? task.getString("name") : "";
                String taskNumber = task != null ? task.getString("number") : "";
                Long taskListId = row.getLong("taskListId");
                DynamicObject taskList = taskListMap.get(taskListId);
                Member orgMember = orgDim.getMember(orgViewId, row.getLong("orgId"));
                String orgName = orgMember != null ? orgMember.getName() : "";
                String orgNumber = orgMember != null ? orgMember.getNumber() : "";
                String orgLongNumber = orgMember != null ? orgMember.getLongNumber() : "";
                String templatetype = row.getString("templatetype").trim().length() < 1 ? "bcm_templateentity" : row.getString("templatetype");
                DynamicObject template2 = templateMap.get(IDUtils.toLong((Object)row.getLong("template")));
                String tempName = template2 != null ? template2.getString("name") : "";
                String reporttype = template2 != null ? template2.getString("templatetype") : "";
                Long dataTypeId = taskList != null ? taskList.getLong("datatype") : 0L;
                Long versionId = taskList != null ? taskList.getLong("version") : 0L;
                TreeNode levelOneNode = (TreeNode)allNodes.get(taskListId.toString());
                if (levelOneNode == null) {
                    String taskListName = taskList != null ? taskList.getString("name") : "";
                    levelOneNode = new TreeNode(root.getId(), taskListId.toString(), taskListName);
                    levelOneNode.setLongNumber(taskList != null ? taskList.getString("number") : "");
                    levelTwoNode = new TreeNode(levelOneNode.getId(), taskListId + "_" + orgId, orgName);
                    levelTwoNode.setLongNumber(orgNumber);
                    levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId, taskName);
                    levelThreeNode.setLongNumber(taskNumber);
                    levelOneNode.addChild(levelTwoNode);
                    levelTwoNode.addChild(levelThreeNode);
                    root.addChild(levelOneNode);
                    allNodes.put(levelOneNode.getId(), levelOneNode);
                    allNodes.put(levelTwoNode.getId(), levelTwoNode);
                    allNodes.put(levelThreeNode.getId(), levelThreeNode);
                } else {
                    levelTwoNode = (TreeNode)allNodes.get(taskListId + "_" + orgId);
                    if (levelTwoNode == null) {
                        levelTwoNode = new TreeNode(levelOneNode.getId(), taskListId + "_" + orgId, orgName);
                        levelTwoNode.setLongNumber(orgNumber);
                        levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId, taskName);
                        levelThreeNode.setLongNumber(taskNumber);
                        levelTwoNode.addChild(levelThreeNode);
                        levelOneNode.addChild(levelTwoNode);
                        allNodes.put(levelTwoNode.getId(), levelTwoNode);
                        allNodes.put(levelThreeNode.getId(), levelThreeNode);
                    } else {
                        levelThreeNode = (TreeNode)allNodes.get(orgId + "_" + taskId);
                        if (levelThreeNode == null) {
                            levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId, taskName);
                            levelThreeNode.setLongNumber(taskNumber);
                            levelTwoNode.addChild(levelThreeNode);
                            allNodes.put(levelThreeNode.getId(), levelThreeNode);
                        }
                    }
                }
                TreeNode levelfourNode = new TreeNode(levelThreeNode.getId(), tempId.toString(), tempName);
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("templatetype", templatetype);
                map.put("reporttype", reporttype);
                map.put("templateid", tempId.toString());
                tempIds.add(IDUtils.toLong((Object)tempId));
                map.put("processid", processid);
                map.put("taskProcessId", taskProcessId.toString());
                map.put("status", status);
                map.put("orgViewId", orgViewId.toString());
                map.put("orgId", orgId.toString());
                map.put("orgNumber", orgNumber);
                map.put("orgLongNumber", orgLongNumber);
                map.put("versionId", versionId.toString());
                map.put("dataTypeId", dataTypeId.toString());
                map.put("yearId", _yearId);
                levelfourNode.setData(map);
                levelThreeNode.addChild(levelfourNode);
            }
        }
        return root;
    }

    private boolean loadReportProcessStatus(long modelId, QFBuilder builder, Map<Long, String> reportProcessStatusMap) {
        Long tempId;
        Long versionId;
        Long dataTypeId;
        Long yearId;
        Long orgId;
        LinkedHashSet taskIdSet = Sets.newLinkedHashSet();
        LinkedHashMap tmpMap = Maps.newLinkedHashMap();
        LinkedHashSet orgSet = Sets.newLinkedHashSet();
        LinkedHashSet yearSet = Sets.newLinkedHashSet();
        LinkedHashSet dtSet = Sets.newLinkedHashSet();
        LinkedHashSet versionSet = Sets.newLinkedHashSet();
        LinkedHashSet tempIdSet = Sets.newLinkedHashSet();
        String selectFields = "id,org.id as orgId,task.id as taskId,task.tasklist.year as yearId,task.tasklist.datatype as dataTypeId,task.tasklist.version as versionId,template";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)selectFields, (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    orgId = row.getLong("orgId");
                    yearId = row.getLong("yearId");
                    dataTypeId = row.getLong("dataTypeId");
                    versionId = row.getLong("versionId");
                    tempId = row.getLong("template");
                    Long taskId = row.getLong("taskId");
                    taskIdSet.add(taskId);
                    yearSet.add(yearId);
                    dtSet.add(dataTypeId);
                    versionSet.add(versionId);
                    tempIdSet.add(tempId);
                    orgSet.add(orgId);
                    String unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + taskId;
                    tmpMap.put(unionKey, id);
                }
            }
        }
        if (orgSet.isEmpty() || tempIdSet.isEmpty()) {
            return true;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("entity", "in", (Object)orgSet));
        qFilter.and("period", "in", (Object)yearSet);
        qFilter.and("version", "in", (Object)versionSet);
        qFilter.and("datatype", "in", (Object)dtSet);
        qFilter.and(new QFilter("template", "in", (Object)tempIdSet));
        String reportFields = "id,status,entity,submitentity.id,datatype.id,period.id,version.id,template.id as templateId";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_reportprocess", (String)reportFields, (QFilter[])qFilter.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    String status = row.getString("status") + "," + row.getString("id");
                    orgId = row.getLong("entity");
                    yearId = row.getLong("period.id");
                    dataTypeId = row.getLong("datatype.id");
                    versionId = row.getLong("version.id");
                    tempId = row.getLong("templateId");
                    for (Long _taskId : taskIdSet) {
                        String unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + _taskId;
                        Long taskProcessId = (Long)tmpMap.get(unionKey);
                        if (!IDUtils.isNotNull((Long)taskProcessId)) continue;
                        reportProcessStatusMap.put(taskProcessId, status);
                    }
                }
            }
        }
        tmpMap.clear();
        return false;
    }

    private Map<Long, DynamicObject> getTemplates(Set<Long> ids) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name,templatetype,dataunit,templatecatalog.id,templatecatalog.name,templatecatalog.number,templatecatalog.parent,isrelation", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            map.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return map;
    }

    private List<TemplateCatalog> buildExcelMap(Long modelId, List<TreeNode> childs, Map<Long, DynamicObject> templates, Map<String, Long> mapIds, String parentNumber) {
        if (childs == null || childs.size() == 0 || childs.get(0) == null) {
            return null;
        }
        ArrayList<TemplateCatalog> templateCatalog = new ArrayList<TemplateCatalog>(childs.size());
        for (TreeNode cln : childs) {
            Long id;
            TemplateCatalog currentCatalog = new TemplateCatalog();
            currentCatalog.setNumber(cln.getLongNumber());
            if (StringUtil.isEmptyString((String)parentNumber)) {
                currentCatalog.setLongNumber(cln.getLongNumber());
            } else {
                currentCatalog.setLongNumber(parentNumber + "." + cln.getLongNumber());
            }
            if (cln.getId().contains("_")) {
                id = GlobalIdUtil.genGlobalLongId();
                mapIds.put(cln.getId(), id);
            } else {
                id = IDUtils.toLong((Object)cln.getId());
            }
            currentCatalog.setId(id);
            currentCatalog.setName(cln.getText());
            if (cln.getParentid().contains("_")) {
                currentCatalog.setParentId(mapIds.get(cln.getParentid()));
            } else {
                currentCatalog.setParentId(IDUtils.toLong((Object)cln.getParentid()));
            }
            List childrens = cln.getChildren();
            if (childrens != null && childs.size() > 0 && childs.get(0) != null) {
                if (((TreeNode)childrens.get(0)).getData() != null) {
                    currentCatalog.setTemplates(this.getExcelReportList(modelId, childrens, templates));
                    currentCatalog.setChilderns(new ArrayList<TemplateCatalog>());
                } else {
                    currentCatalog.setTemplates(new ArrayList<ExcelReportList>());
                    currentCatalog.setChilderns(this.buildExcelMap(modelId, childrens, templates, mapIds, currentCatalog.getLongNumber()));
                }
            }
            templateCatalog.add(currentCatalog);
        }
        return templateCatalog;
    }

    private List<ExcelReportList> getExcelReportList(Long modelId, List<TreeNode> childs, Map<Long, DynamicObject> templates) {
        if (childs == null || childs.size() == 0 || childs.get(0) == null) {
            return null;
        }
        ArrayList<ExcelReportList> excelReportLists = new ArrayList<ExcelReportList>(childs.size());
        for (TreeNode child : childs) {
            Map data = (Map)child.getData();
            DynamicObject template = templates.get(IDUtils.toLong(data.get("templateid")));
            if (template == null) continue;
            ExcelReportList excelReportList = new ExcelReportList();
            ExcelReportList.ExcelReportBaseInfo baseInfo = new ExcelReportList.ExcelReportBaseInfo();
            baseInfo.setModelId(modelId);
            baseInfo.setTemplateId(template.getLong("id"));
            baseInfo.setTemplateName(template.getString("name"));
            baseInfo.setTemplateNumber(template.getString("number"));
            baseInfo.setTemplateType(template.getLong("templatecatalog.id"));
            baseInfo.setTemplateTypeName(template.getString("templatecatalog.name"));
            baseInfo.setTemplateTypeNumber(template.getString("templatecatalog.number"));
            baseInfo.setParentId(template.getLong("templatecatalog.parent"));
            baseInfo.setProcessId(IDUtils.toLong(data.get("processid")));
            baseInfo.setTaskProcessId(IDUtils.toLong(data.get("taskProcessId")));
            baseInfo.setOrgId(IDUtils.toLong(data.get("orgId")));
            baseInfo.setVersionId(IDUtils.toLong(data.get("versionId")));
            baseInfo.setDataTypeId(IDUtils.toLong(data.get("dataTypeId")));
            baseInfo.setYearId(IDUtils.toLong(data.get("yearId")));
            baseInfo.setOrgViewId(IDUtils.toLong(data.get("orgViewId")));
            baseInfo.setProcessType(ProcessTypeEnum.TASK.getNumber());
            baseInfo.setReportType(template.getString("templatetype"));
            baseInfo.setDataUnit(template.getInt("dataUnit"));
            baseInfo.setEnableDimRelation(template.getBoolean("isrelation"));
            excelReportList.setBaseInfo(baseInfo);
            ExcelReportList.ExcelReportOtherInfo otherInfo = new ExcelReportList.ExcelReportOtherInfo();
            otherInfo.setReportStatus((String)data.get("status"));
            excelReportList.setOtherInfo(otherInfo);
            excelReportLists.add(excelReportList);
        }
        return excelReportLists;
    }
}

