/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.approveBill.ApproveBillUtil;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelReportShowBizRuleBo;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOperateReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolutionDimMember;
import kd.epm.eb.formplugin.excel.report.ExcelDrillThroughHelper;
import kd.epm.eb.formplugin.excel.report.ExcelOlapQuerySync;
import kd.epm.eb.formplugin.excel.report.ExcelReportHelper;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadJsAction;
import kd.epm.eb.formplugin.excel.report.IExcelOpenReportBaseService;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class ExcelDynamicReportProcess
extends DynamicReportProcess
implements IExcelOpenReportBaseService {
    public ExcelDynamicReportProcess(ExcelOpenReportParams openReportParams, ExcelSpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        this.setView(this.iniFormView(openReportParams, "eb_executetask"));
        this.initService();
        this.getPageCache().put("sourceFrom", "excel");
        new ExcelSpreadJsAction((AbstractFormPlugin)this, this.getSpreadKey()).selectedSpread(this.getPageCache(), openReportParams);
    }

    public void cacheSpreadManager() {
        super.cacheSpreadManager();
        this.getPageCache().put("spread_mananger_cache_key", this.ebSpreadManager == null ? null : EbSpreadManagerSerializerUtil.toJson((IEbSpreadManager)this.ebSpreadManager));
    }

    @Override
    protected ExcelOlapQuerySync newOlapQuerySnc(OlapQuerySync.ViewArea viewArea, Map<String, Set<CellDimMember>> alldimensionWithMembers) {
        return new ExcelOlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getView().getPageId(), viewArea, this.getRefreshedRows(), alldimensionWithMembers, this.getModelCacheHelper());
    }

    @Override
    public ExcelDynamicReportProcess getReportPlugin(ExcelOpenReportParams openReportParams) {
        this.setReportPlugin(this, openReportParams);
        return this;
    }

    @Override
    public void initialize() {
        this.initService();
    }

    @Override
    public void cacheCurTemplateModel(AbstractReportPlugin plugin) {
        super.cacheTemplateModel();
    }

    public LinkedHashMap<String, Object> cellValueUpdate(ExcelOpenReportParams openReportParams) {
        this.pluginCellValueUpdate(openReportParams);
        this.getCellStyle(openReportParams);
        return this.getSpreadContainer(this).getOperateMaps();
    }

    public void viewComputeProcess(Object args) {
        String pointStr = this.getSpreadSelector().getStartPosition();
        if (pointStr == null) {
            return;
        }
        FormShowParameter formShowParameter = this.getFormShowParameter(pointStr);
        ExcelReportShowBizRuleBo reportShowBizRuleBo = new ExcelReportHelper().getBizRuleObjByDimMembs(formShowParameter);
        if (reportShowBizRuleBo != null) {
            ((ExcelSpreadContainer)this.spreadContainer).getOperateMaps().put("ReportShowBizRuleBo", (Object)reportShowBizRuleBo);
        }
    }

    @Override
    public void drillthrough(Object param) {
        try {
            ExcelDrillThroughHelper helper01 = new ExcelDrillThroughHelper(this.getSpreadSelector(), this.getSpreadManager(), this.getTemplateModel());
            ITemplateModel templateModel_temp = helper01.getTemplateModel().transforRowDimIntoPageDim().collect();
            Map<String, String> defaultmember = helper01.getDefaultMember();
            for (Map.Entry stringStringEntry : this.getSpreadManager().getPageViewDims().entrySet()) {
                defaultmember.put((String)stringStringEntry.getKey(), ((PageViewDimMember)stringStringEntry.getValue()).getNumber());
            }
            List<AdHocSolutionDimMember> returns = new ExcelReportHelper().getSolutionDimMembers(templateModel_temp, defaultmember, this.getModelCacheHelper());
            if (returns.size() > 0) {
                LinkedHashMap<String, Object> operateMaps = ((ExcelSpreadContainer)this.spreadContainer).getOperateMaps();
                operateMaps.put("SolutionDimMember", returns);
                operateMaps.put("DatasetID", templateModel_temp.getTemplateBaseInfo().getDatasetID());
                operateMaps.put("dimenstionViews", templateModel_temp.getDimensionView());
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void getCellStyle(ExcelOpenReportParams openReportParams) {
        ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea> returns = new ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea>(16);
        List values = (List)openReportParams.getValue();
        if (values == null || values.size() == 0) {
            return;
        }
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        for (Object value : values) {
            Map jsonMap = (Map)value;
            if (jsonMap == null || jsonMap.size() == 0) continue;
            int row = Integer.parseInt(jsonMap.get("r").toString());
            int col = Integer.parseInt(jsonMap.get("c").toString());
            ECell cell = sheet.getECellNotAdd(row, col);
            ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea cellArea = new ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea(row, col);
            CellStyleInfo style = new CellStyleInfo();
            cellArea.setStyle(style);
            style.setFm(((StyleCell)cell).getFormatter());
            returns.add(cellArea);
        }
        ((ExcelSpreadContainer)this.spreadContainer).getOperateMaps().put("cellStyle", returns);
    }

    @Override
    protected void rebuildPageView() {
        ITemplateModel templateModel = this.getTemplateModel();
        this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(this.getView(), templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(false);
        pageViewPanelDraw.setNeedCheckPerm(true);
        pageViewPanelDraw.setShowHideDim(false);
        pageViewPanelDraw.setDefaultDimMember(this.getDefaultDimMember());
        pageViewPanelDraw.setExtraQfilter(this.getExtraQfilter());
        pageViewPanelDraw.setDrillthrough_key(this.getDrillthrough_key());
        pageViewPanelDraw.buildWithOutView();
    }

    @Override
    public void cellClick(SpreadSelector selector) {
        super.cellClick(selector);
        this.getMemberMapByCell(selector.getStartRow(), selector.getStartCol());
    }

    protected boolean needSetTemplatePageEntity() {
        return true;
    }

    protected void iniControl() {
    }

    @Override
    protected void hideOrShowMenu() {
    }

    protected void setPanelVisible() {
    }

    public void invokeSpreadJson() {
        super.invokeSpreadJson();
        if (this.cellIndetCol >= 0) {
            ((ExcelSpreadContainer)this.spreadContainer).getOperateMaps().put("rowpartitionDimMems", this.getRowpartitionDimMems());
        }
    }

    private String getRowpartitionDimMems() {
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        List rowPartitionDimMems = ebSpreadManager.getRowpartitionDimMems();
        if (rowPartitionDimMems == null || rowPartitionDimMems.size() == 0) {
            return "";
        }
        List rowpartitionDims = ebSpreadManager.getRowpartitionDims();
        Map indentcells = this.getSpreadManager().getIndentcells();
        String dimNumber = "";
        if (indentcells != null && indentcells.size() > 0) {
            for (Map.Entry entry : indentcells.entrySet()) {
                List cells = (List)entry.getValue();
                if (cells == null || cells.isEmpty()) continue;
                dimNumber = (String)((ECell)cells.get(0)).getUserObject("dimnumber");
                break;
            }
        }
        if (StringUtils.isEmpty((String)dimNumber)) {
            return "";
        }
        int c = 0;
        for (int i = 0; i < rowpartitionDims.size(); ++i) {
            if (((String)rowpartitionDims.get(i)).compareTo(dimNumber) != 0) continue;
            c = i;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append(String.format("\"%s\": \"%s\",", "dimNumber", dimNumber));
        for (int r = 0; r < rowPartitionDimMems.size(); ++r) {
            List rowPartitionDimMem = (List)rowPartitionDimMems.get(r);
            if (rowPartitionDimMem == null) continue;
            stringBuilder.append(String.format("\"%s\": \"%s\",", ((CellDimMember)rowPartitionDimMem.get(c)).getDimMemberNumber(), r + 1));
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void afterSaveReoprt(boolean saveSuss) {
    }

    @Override
    public String getMutexKey() {
        return this.getPageCache().get("mutexKey");
    }

    protected LinkedHashMap<String, Object> confirmCallBack(ExcelOpenReportParams openReportParams) {
        return this.getSpreadContainer(this).getOperateMaps();
    }

    @Override
    protected void getCells(List<BGCell> datas) {
        this.getSpreadContainer(this).getOperateMaps().put(ExcelApiCommon.KEY_SAVEDATAS, datas.isEmpty() ? "0" : datas.size() + "");
    }

    public LinkedHashMap<String, Object> spreadF7LookUpDataSub(LookUpDataArgs args) {
        super.spreadF7LookUpData(args);
        return this.getSpreadContainer(this).getOperateMaps();
    }

    @Override
    public void subAfterItemClick(ItemClickEvent event) {
        switch (event.getItemKey()) {
            case "btn_save": {
                String modelid = this.getPageCache().get("KEY_MODEL_ID");
                String processid = this.getPageCache().get("current_report_id");
                String orgViewId = this.getPageCache().get("CURRENT_ORG_VIEW");
                if (!StringUtils.isNotEmpty((String)processid) || !StringUtils.isNotEmpty((String)orgViewId)) break;
                ApproveBillUtil.updateReportStatus(Long.parseLong(modelid), Long.parseLong(processid), Long.parseLong(orgViewId));
            }
        }
    }

    protected void putInSaveDataContext(BgTemplate templateBaseInfo) {
        OlapTraceServiceHelper.setTraceOpInfo((String)templateBaseInfo.getNumber());
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.ExcelApi));
    }
}

