/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.ReportOperationEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ExcelReportCheck {
    public static boolean checkVailad(ITemplateModel templateModel, ExcelOpenReportParams openReportParams, ExcelSpreadContainer spreadContainer) {
        if (!ExcelReportCheck.checkOrgPermIsOk(templateModel, openReportParams, spreadContainer)) {
            return false;
        }
        return ExcelReportCheck.checkPermDataTypeAndVersionIsOk(templateModel, openReportParams, spreadContainer);
    }

    private static boolean checkOrgPermIsOk(ITemplateModel templateModel, ExcelOpenReportParams openReportParams, ExcelSpreadContainer spreadContainer) {
        Long hasPermOrg = ExcelReportCheck.getHasPermOrg(templateModel.getTemplateBaseInfo().getBizModel(), openReportParams);
        if (IDUtils.isNull((Long)hasPermOrg)) {
            spreadContainer.getOperateMaps().put(ExcelApiCommon.KEY_ERROR, ResManager.loadKDString((String)"\u62a5\u8868\u65e0\u6cd5\u6253\u5f00\uff0c\u56e0\u4e3a\u65e0\u6743\u9650\u6216\u7ec4\u7ec7\u4e0d\u5728\u6a21\u677f\u8bbe\u7f6e\u7684\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"BgTaskExecutePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static Long getHasPermOrg(Long busModelId, ExcelOpenReportParams openReportParams) {
        Long orgid = openReportParams.getBaseInfo().getOrgId();
        Long modelId = openReportParams.getBaseInfo().getModelId();
        QFilter orgFilter = new QFilter("id", "=", (Object)orgid);
        orgFilter.and("model", "=", (Object)modelId);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id, number, longnumber", (QFilter[])orgFilter.toArray());
        long orgViewId = openReportParams.getBaseInfo().getOrgViewId();
        if (org != null && BgTaskExecuteHelper.isNopermOrg(modelId, busModelId, org.getString("number"), orgViewId)) {
            orgid = null;
            QFilter qFilter = new QFilter("longnumber", "like", (Object)(org.getString("longnumber") + "!%"));
            qFilter.and("model", "=", (Object)modelId);
            Object[] orgs = BusinessDataServiceHelper.load((String)"epm_entitymembertree", (String)"id,number,longnumber", (QFilter[])qFilter.toArray());
            if (ArrayUtils.isEmpty((Object[])orgs)) {
                return null;
            }
            Long templateId = openReportParams.getBaseInfo().getTemplateId();
            Long processId = openReportParams.getBaseInfo().getTaskProcessId();
            Set tmplOrgs = TemplateModelHelper.parseOrgIdRange((Long)modelId, (Long)templateId, (Long)processId, (ProcessTypeEnum)ProcessTypeEnum.TASK);
            boolean isHasRootPerm = MemberPermHelper.ifUserHasRootPermByModel((Long)UserUtils.getUserId(), (Long)modelId);
            Set noPermOrgs = isHasRootPerm ? null : MemberPermCacheServiceHelper.build(null, (Long)modelId, (Long)busModelId, (String[])new String[]{SysDimensionEnum.Entity.getNumber()}).getNopermMems(SysDimensionEnum.Entity.getNumber(), Long.valueOf(orgViewId));
            for (Object d : orgs) {
                if (noPermOrgs != null && noPermOrgs.contains(d.getString("number"))) continue;
                if (CollectionUtils.isEmpty((Collection)tmplOrgs)) {
                    orgid = d.getLong("id");
                    break;
                }
                if (!tmplOrgs.contains(d.getLong("id"))) continue;
                orgid = d.getLong("id");
                break;
            }
        }
        return orgid;
    }

    private static boolean checkPermDataTypeAndVersionIsOk(ITemplateModel templateModel, ExcelOpenReportParams openReportParams, ExcelSpreadContainer spreadContainer) {
        if (openReportParams == null || openReportParams.getDimFilterParams() == null) {
            return true;
        }
        Long templateId = templateModel.getTemplateBaseInfo().getId();
        Long processId = openReportParams.getBaseInfo().getTaskProcessId();
        Long modelId = openReportParams.getBaseInfo().getModelId();
        Long busModelId = templateModel.getTemplateBaseInfo().getBizModel();
        Map varValueMap = ReportVarUtil.getVarValues((String)ProcessTypeEnum.TASK.getNumber(), (Long)modelId, (Long)processId, (String)"1");
        IMemberPermCache memberPermCache = MemberPermCacheServiceHelper.build((Long)RequestContext.get().getCurrUserId(), (Long)modelId, (Long)busModelId, null);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String dataTypeNum = ExcelReportCheck.getMemberNumber(modelCache, SysDimensionEnum.DataType.getNumber(), openReportParams);
        String versionNum = ExcelReportCheck.getMemberNumber(modelCache, SysDimensionEnum.Version.getNumber(), openReportParams);
        Set pageDataTypeMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)modelId, (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.DataType.getNumber(), (Map)varValueMap);
        if (CollectionUtils.isNotEmpty((Collection)pageDataTypeMemberSet) && memberPermCache.isNoperm(SysDimensionEnum.DataType.getNumber(), dataTypeNum, Long.valueOf(0L))) {
            spreadContainer.getOperateMaps().put(ExcelApiCommon.KEY_ERROR, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u5f53\u524d\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u7684\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set pageVersionMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)modelId, (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.Version.getNumber(), (Map)varValueMap);
        if (CollectionUtils.isNotEmpty((Collection)pageVersionMemberSet) && memberPermCache.isNoperm(SysDimensionEnum.Version.getNumber(), versionNum, Long.valueOf(0L))) {
            spreadContainer.getOperateMaps().put(ExcelApiCommon.KEY_ERROR, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u5f53\u524d\u4efb\u52a1\u7248\u672c\u7684\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static String getMemberNumber(IModelCacheHelper modelCache, String dimKey, ExcelOpenReportParams openReportParams) {
        Member member;
        if (openReportParams.getDimFilterParams().containsKey(dimKey) && (member = modelCache.getMember(dimKey, Long.valueOf(0L), openReportParams.getDimFilterParams().get(dimKey))) != null) {
            return member.getNumber();
        }
        return "";
    }

    public static boolean checkTaskMonitor(ExcelOpenReportParams openReportParams, ExcelSpreadContainer spreadContainer) {
        DynamicObject object;
        ExcelReportList.ExcelReportBaseInfo baseInfo = openReportParams.getBaseInfo();
        if (baseInfo != null && ProcessTypeEnum.TASK.getNumber().equals(baseInfo.getProcessType()) && (object = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"task,task.model", (QFilter[])new QFilter("id", "=", (Object)baseInfo.getTaskProcessId()).toArray())) != null) {
            Long taskId = object.getLong("task");
            String checkInfo = BgTaskDeployListService.getInstance().checkTaskMonitor(Long.valueOf(baseInfo.getModelId()), (Set)Sets.newHashSet((Object[])new Long[]{taskId}), ReportOperationEnum.EDIT, Long.valueOf(baseInfo.getOrgId()), Long.valueOf(baseInfo.getOrgViewId()));
            if (StringUtils.isNotEmpty((CharSequence)checkInfo)) {
                spreadContainer.getOperateMaps().put(ExcelApiCommon.KEY_ERROR, checkInfo);
                return true;
            }
        }
        return false;
    }
}

