/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RptSchemeStatusEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserQueryResult;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelReportShowBizRuleBo;
import kd.epm.eb.formplugin.excel.excelEntity.ExcelRptSchemeEntity;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.excelEntity.report.TemplateCatalog;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolutionDimMember;
import kd.epm.eb.formplugin.excel.report.ExcelReportShowBizRulePlugin2;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelDimTypeEnum;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.formplugin.reportscheme.helper.TemplateEntityPermHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.metric.IMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import org.apache.commons.collections4.CollectionUtils;

public class ExcelReportHelper {
    public List<TemplateCatalog> getExcelReportList(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        Long schemeId = IDUtils.toLong((Object)param.get("schemeId"));
        Long periodId = IDUtils.toLong((Object)param.get("periodId"));
        Long versionId = IDUtils.toLong((Object)param.get("versionId"));
        Long dataTypeId = IDUtils.toLong((Object)param.get("dataTypeId"));
        Long orgId = IDUtils.toLong((Object)param.get("orgId"));
        HashSet<Long> orgIds = new HashSet<Long>(1);
        orgIds.add(orgId);
        List<TemplateCatalog> templateCatalogs = new ArrayList<TemplateCatalog>(16);
        if (CollectionUtils.isEmpty(orgIds)) {
            return templateCatalogs;
        }
        DynamicObject scheme = this.getScheme(schemeId);
        if (scheme == null) {
            return templateCatalogs;
        }
        Long orgViewId = scheme.getLong("orgview.id");
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        Long schemeAssignId = this.getSchemeAssignId(modelId, schemeId, periodId, versionId, dataTypeId);
        Set<Long> templateIdSet = reportPreparationListHelper.getTemplateTreeIdSet(modelId, schemeId);
        Map<Long, DynamicObject> templates = this.getTemplates(templateIdSet);
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, periodId, dataTypeId, versionId, orgIds, templateIdSet);
        this.filterEntityInTemplate(modelId, schemeId, orgViewId, reportProcessList, templateIdSet);
        Map<Long, DynamicObject> submitOrgs = this.getSubmitOrg(reportProcessList);
        List templateSortIds = ReportSchemeTemplateSortService.getInstance().getTemplateIdsBySort(schemeAssignId, templateIdSet);
        reportProcessList.sort((o1, o2) -> {
            int index1 = templateSortIds.indexOf(o1.getTemplateId());
            int index2 = templateSortIds.indexOf(o2.getTemplateId());
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            return Integer.compare(index1, index2);
        });
        templateCatalogs = this.buildExcelMap(modelId, orgViewId, reportProcessList, templates, schemeAssignId, submitOrgs);
        return templateCatalogs;
    }

    public List<ExcelRptSchemeEntity> getRptScheme(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelid"));
        QFilter filter = new QFilter("model", "=", (Object)modelId).and(new QFilter("scheme.status", "!=", (Object)RptSchemeStatusEnum.DISABLE.getNumber()));
        DynamicObject[] assignList = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id, scheme_id", (QFilter[])filter.toArray());
        List schemeIdList = Arrays.stream(assignList).map(dyObj -> dyObj.getLong("scheme_id")).collect(Collectors.toList());
        filter.and("id", "in", schemeIdList);
        DataSet dimData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_rptscheme", (String)"id,number,name,modifydate,bizrange.id,orgview.id", (QFilter[])filter.toArray(), (String)"id desc");
        ArrayList<ExcelRptSchemeEntity> returns = new ArrayList<ExcelRptSchemeEntity>(16);
        dimData.forEach(row -> {
            ExcelRptSchemeEntity rptScheme = new ExcelRptSchemeEntity();
            rptScheme.setModelId(modelId);
            rptScheme.setId(row.getLong("id"));
            rptScheme.setNumber(row.getString("number"));
            rptScheme.setName(row.getString("name"));
            rptScheme.setModifyTime(row.getDate("modifydate"));
            rptScheme.setOrgviewId(row.getLong("orgview.id"));
            rptScheme.setBizRangeId(row.getLong("bizrange.id"));
            rptScheme.setTaskReport(1);
            returns.add(rptScheme);
        });
        return returns;
    }

    public Set<Long> getEntityIdsByRptScheme(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        Long schemeId = IDUtils.toLong((Object)param.get("schemeId"));
        Long bizRangeId = IDUtils.toLong((Object)param.get("bizRangeId"));
        Long orgviewId = IDUtils.toLong((Object)param.get("orgviewId"));
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        return reportPreparationListHelper.getEntityTreeIdSet(modelId, schemeId, bizRangeId, orgviewId);
    }

    public ExcelReportShowBizRuleBo getBizRuleObjByDimMembs(FormShowParameter formShowParameter) {
        if (formShowParameter == null) {
            return null;
        }
        Map allDimNums = (Map)formShowParameter.getCustomParam("allDimNum");
        long modelId = (Long)formShowParameter.getCustomParam("modelId");
        long dataSetId = (Long)formShowParameter.getCustomParam("dataSetId");
        long templateId = (Long)formShowParameter.getCustomParam("templateId");
        String dataUnit = (String)formShowParameter.getCustomParam("dataunit");
        String metricCellStyleInfo = (String)formShowParameter.getCustomParam("metricCellStyleInfo");
        List metricCellStyleInfoList = metricCellStyleInfo != null ? (List)JsonUtils.readValue((String)metricCellStyleInfo, (TypeReference)new TypeReference<List<MetricCellStyleInfo>>(){}) : new ArrayList(1);
        ExcelReportShowBizRuleBo reportShowBizRuleBo = this.getBizRuleObjByDimMembs(allDimNums, metricCellStyleInfoList, modelId, dataSetId, templateId, dataUnit);
        if (reportShowBizRuleBo != null) {
            reportShowBizRuleBo.setMetricCellStyleInfo(metricCellStyleInfo);
        }
        return reportShowBizRuleBo;
    }

    public ExcelReportShowBizRuleBo getBizRuleObjByDimMembs(Map<String, String> cellDimNumberToMemberNumberPair, List<MetricCellStyleInfo> metricCellStyleInfoList, long modelId, long dataSetId, long templateId, String dataUnit) {
        ExcelReportShowBizRulePlugin2 rulePlugin2 = new ExcelReportShowBizRulePlugin2();
        rulePlugin2.setMetricCellStyleInfoList(metricCellStyleInfoList);
        rulePlugin2.getPageCache().put("dataSetId", String.valueOf(dataSetId));
        rulePlugin2.getPageCache().put("templateId", String.valueOf(templateId));
        rulePlugin2.getPageCache().put("dataUnit", dataUnit);
        rulePlugin2.getPageCache().put("modelId", String.valueOf(modelId));
        return (ExcelReportShowBizRuleBo)rulePlugin2.getBizRuleObjByDimMembs(cellDimNumberToMemberNumberPair, modelId);
    }

    public List<AdHocSolutionDimMember> getSolutionDimMembers(ITemplateModel templateModel_temp, Map<String, String> defaultmember, IModelCacheHelper modelCacheHelper) {
        IDimension dimension;
        ArrayList<AdHocSolutionDimMember> returns = new ArrayList<AdHocSolutionDimMember>(16);
        long templateId = templateModel_temp.getTemplateBaseInfo().getId();
        HashMap<String, String> defaultDimMember = new HashMap<String, String>(16);
        if (defaultmember != null) {
            defaultmember.forEach((K, V) -> defaultDimMember.put((String)K, modelCacheHelper.getMember(K, (Long)templateModel_temp.getDimemsionViews().get(K), V).getId().toString()));
        }
        int i = 0;
        AdHocSolutionDimMember dimMember = null;
        for (IPageDimensionEntry pageDimensionEntry : templateModel_temp.getPagemembentry()) {
            dimension = pageDimensionEntry.getDimension();
            dimMember = this.getSingleDimMember(i - 1, ExcelDimTypeEnum.PAGE.getIndex(), modelCacheHelper.getDimension(dimension.getNumber()), defaultDimMember, templateId);
            if (dimMember != null) {
                returns.add(dimMember);
            }
            ++i;
        }
        for (Object viewPointDimensionEntry : templateModel_temp.getViewpointmembentry()) {
            dimension = viewPointDimensionEntry.getDimension();
            dimMember = this.getSingleDimMember(i - 1, ExcelDimTypeEnum.PAGE.getIndex(), modelCacheHelper.getDimension(dimension.getNumber()), defaultDimMember, templateId);
            if (dimMember != null) {
                returns.add(dimMember);
            }
            ++i;
        }
        i = 0;
        List colPartitions = templateModel_temp.getPartitionSetting().getColPartition();
        for (RowColPartition colPartition : colPartitions) {
            String dimensionNumber;
            for (IRowColDimensionEntry colDimensionEntry : colPartition.getRowColDimensionEntries()) {
                dimMember = this.getSingleDimMember(i, ExcelDimTypeEnum.COL.getIndex(), modelCacheHelper.getDimension(colDimensionEntry.getDimension().getNumber()), defaultDimMember, templateId);
                if (dimMember != null) {
                    dimensionNumber = colDimensionEntry.getDimension().getNumber();
                    dimMember.setMember(modelCacheHelper.getMember(dimensionNumber, (Long)templateModel_temp.getDimemsionViews().get(dimensionNumber), ((IDimensionMember)colDimensionEntry.getMembers().get(0)).getNumber()).getId().toString());
                    returns.add(dimMember);
                }
                ++i;
            }
            for (IMetricDimMmeber metricDimMmeber : colPartition.getMetricDimMmebers()) {
                dimMember = this.getSingleDimMember(i, ExcelDimTypeEnum.COL.getIndex(), modelCacheHelper.getDimension(metricDimMmeber.getDimnumber()), defaultDimMember, templateId);
                if (dimMember != null) {
                    dimensionNumber = metricDimMmeber.getDimnumber();
                    dimMember.setMember(modelCacheHelper.getMember(dimensionNumber, (Long)templateModel_temp.getDimemsionViews().get(dimensionNumber), metricDimMmeber.getNumber()).getId().toString());
                    returns.add(dimMember);
                }
                ++i;
            }
        }
        List rowPartitions = templateModel_temp.getPartitionSetting().getRowPartition();
        for (RowColPartition rowParPartition : rowPartitions) {
            String dimensionNumber;
            for (IRowColDimensionEntry colDimensionEntry : rowParPartition.getRowColDimensionEntries()) {
                dimMember = this.getSingleDimMember(i, ExcelDimTypeEnum.ROW.getIndex(), modelCacheHelper.getDimension(colDimensionEntry.getDimension().getNumber()), defaultDimMember, templateId);
                if (dimMember != null) {
                    dimensionNumber = colDimensionEntry.getDimension().getNumber();
                    dimMember.setMember(modelCacheHelper.getMember(dimensionNumber, (Long)templateModel_temp.getDimemsionViews().get(dimensionNumber), ((IDimensionMember)colDimensionEntry.getMembers().get(0)).getNumber()).getId().toString());
                    returns.add(dimMember);
                }
                ++i;
            }
            for (IMetricDimMmeber metricDimMmeber : rowParPartition.getMetricDimMmebers()) {
                dimMember = this.getSingleDimMember(i, ExcelDimTypeEnum.ROW.getIndex(), modelCacheHelper.getDimension(metricDimMmeber.getDimnumber()), defaultDimMember, templateId);
                if (dimMember != null) {
                    dimensionNumber = metricDimMmeber.getDimnumber();
                    dimMember.setMember(modelCacheHelper.getMember(dimensionNumber, (Long)templateModel_temp.getDimemsionViews().get(dimensionNumber), metricDimMmeber.getNumber()).getId().toString());
                    returns.add(dimMember);
                }
                ++i;
            }
        }
        return returns;
    }

    public Map<String, Object> getSchemeAssignRecord(Map<String, Object> param) {
        HashMap<String, Object> returnValues = new HashMap<String, Object>(4);
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scheme.status", "!=", (Object)RptSchemeStatusEnum.DISABLE.getNumber());
        try {
            DynamicObjectCollection assignList = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id, scheme, year, datatype, version", (QFilter[])filter.toArray(), (String)"defaultassign desc,assigntime desc", (int)1);
            if (CollectionUtils.isEmpty((Collection)assignList)) {
                return returnValues;
            }
            DynamicObject dynamicObject = (DynamicObject)assignList.get(0);
            DynamicObject scheme = this.getScheme(dynamicObject.getLong("scheme"));
            if (scheme == null) {
                return returnValues;
            }
            ExcelRptSchemeEntity rptScheme = new ExcelRptSchemeEntity();
            rptScheme.setModelId(modelId);
            rptScheme.setId(scheme.getLong("id"));
            rptScheme.setNumber(scheme.getString("number"));
            rptScheme.setName(scheme.getString("name"));
            rptScheme.setModifyTime(scheme.getDate("modifydate"));
            rptScheme.setOrgviewId(scheme.getLong("orgview.id"));
            rptScheme.setBizRangeId(scheme.getLong("bizrange.id"));
            returnValues.put("RptScheme", rptScheme);
            returnValues.put("BudgetPeriod", dynamicObject.getLong("year"));
            returnValues.put("DataType", dynamicObject.getLong("datatype"));
            returnValues.put("Version", dynamicObject.getLong("version"));
            return returnValues;
        }
        catch (Exception exception) {
            return returnValues;
        }
    }

    private DynamicObject getScheme(Long schemeId) {
        if (schemeId != null) {
            QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
            return BusinessDataServiceHelper.loadSingle((String)"eb_rptscheme", (String)"id,number,name,modifydate,orgview, bizrange", (QFilter[])qFilter.toArray());
        }
        return null;
    }

    private Long getSchemeAssignId(Long modelId, Long schemeId, Long periodId, Long versionId, Long dataTypeId) {
        if (modelId == null || schemeId == null || periodId == null || versionId == null || dataTypeId == null) {
            return 0L;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and(new QFilter("scheme.status", "!=", (Object)RptSchemeStatusEnum.DISABLE.getNumber()));
        qFilter.and("year", "=", (Object)periodId);
        qFilter.and("scheme", "=", (Object)schemeId);
        qFilter.and("version", "=", (Object)versionId);
        qFilter.and("datatype", "=", (Object)dataTypeId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    private Map<Long, DynamicObject> getSubmitOrg(List<ReportProcess> reportProcessList) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (CollectionUtils.isEmpty(reportProcessList)) {
            return map;
        }
        HashSet<Long> submitOrgIds = new HashSet<Long>(16);
        for (ReportProcess reportProcess : reportProcessList) {
            submitOrgIds.add(reportProcess.getSubmitEntity());
        }
        QFilter qFilter = new QFilter("id", "in", submitOrgIds);
        DynamicObjectCollection submitOrgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name,number", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)submitOrgs)) {
            for (DynamicObject dynamicObject : submitOrgs) {
                map.put(dynamicObject.getLong("id"), dynamicObject);
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getTemplates(Set<Long> ids) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name,templatetype,dataunit,templatecatalog.id,templatecatalog.name,templatecatalog.number,templatecatalog.parent,isrelation", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            map.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return map;
    }

    private List<TemplateCatalog> buildExcelMap(Long modelId, Long orgViewId, List<ReportProcess> reportProcessList, Map<Long, DynamicObject> templates, Long schemeAssignId, Map<Long, DynamicObject> submitOrgs) {
        ArrayList<TemplateCatalog> templateCatalog = new ArrayList<TemplateCatalog>(16);
        if (CollectionUtils.isEmpty(reportProcessList) || templates.isEmpty()) {
            return templateCatalog;
        }
        ArrayList<ExcelReportList> excelReportLists = new ArrayList<ExcelReportList>(reportProcessList.size());
        for (ReportProcess reportProcess : reportProcessList) {
            DynamicObject template = templates.get(reportProcess.getTemplateId());
            if (template == null) continue;
            ExcelReportList excelReportList = new ExcelReportList();
            ExcelReportList.ExcelReportBaseInfo baseInfo = new ExcelReportList.ExcelReportBaseInfo();
            baseInfo.setModelId(modelId);
            baseInfo.setTemplateId(template.getLong("id"));
            baseInfo.setTemplateName(template.getString("name"));
            baseInfo.setTemplateNumber(template.getString("number"));
            baseInfo.setTemplateType(template.getLong("templatecatalog.id"));
            baseInfo.setTemplateTypeName(template.getString("templatecatalog.name"));
            baseInfo.setTemplateTypeNumber(template.getString("templatecatalog.number"));
            baseInfo.setParentId(template.getLong("templatecatalog.parent"));
            baseInfo.setProcessId(reportProcess.getId());
            baseInfo.setTaskProcessId(schemeAssignId);
            baseInfo.setOrgId(reportProcess.getEntityId());
            baseInfo.setOrgViewId(orgViewId);
            baseInfo.setProcessType(ProcessTypeEnum.REPORT.getNumber());
            baseInfo.setReportType(template.getString("templatetype"));
            baseInfo.setDataUnit(template.getInt("dataUnit"));
            baseInfo.setEnableDimRelation(template.getBoolean("isrelation"));
            excelReportList.setBaseInfo(baseInfo);
            ExcelReportList.ExcelReportOtherInfo otherInfo = new ExcelReportList.ExcelReportOtherInfo();
            otherInfo.setReportStatus(reportProcess.getStatus());
            DynamicObject submitOrg = submitOrgs.get(reportProcess.getSubmitEntity());
            if (submitOrg != null) {
                otherInfo.setSubmitOrgId(submitOrg.getLong("id"));
                otherInfo.setSubmitOrgNumber(submitOrg.getString("number"));
                otherInfo.setSubmitOrgName(submitOrg.getString("name"));
            }
            otherInfo.setSubmitor(reportProcess.getSubmitUserName());
            excelReportList.setOtherInfo(otherInfo);
            excelReportLists.add(excelReportList);
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"eb_templatecatalog", (String)"id,name,number,parent.id,longnumber,sequence", (QFilter[])qFilter.toArray(), (String)"sequence ASC");
        List catalogRootNodes = catalogs.stream().filter(x -> x.getLong("parent.id") == 0L).collect(Collectors.toList());
        templateCatalog = new ArrayList(catalogRootNodes.size());
        for (DynamicObject catalog : catalogRootNodes) {
            TemplateCatalog currentCatalog = new TemplateCatalog();
            currentCatalog.setId(catalog.getLong("id"));
            currentCatalog.setName(catalog.getString("name"));
            currentCatalog.setNumber(catalog.getString("number"));
            currentCatalog.setLongNumber(catalog.getString("longnumber"));
            currentCatalog.setDesq(catalog.getInt("sequence"));
            currentCatalog.setParentId(catalog.getLong("parent.id"));
            currentCatalog.setTemplates(excelReportLists.stream().filter(k -> k.getBaseInfo().getTemplateType() == catalog.getLong("id")).collect(Collectors.toList()));
            this.BuildCatalogTree(currentCatalog, catalogs, excelReportLists);
            templateCatalog.add(currentCatalog);
        }
        return templateCatalog;
    }

    private void BuildCatalogTree(TemplateCatalog currentCatalog, DynamicObjectCollection catalogs, List<ExcelReportList> templates) {
        List<TemplateCatalog> childCatalog = catalogs.stream().filter(x -> x.getLong("parent.id") == currentCatalog.getId()).map(x -> {
            TemplateCatalog catalog = new TemplateCatalog();
            catalog.setId(x.getLong("id"));
            catalog.setName(x.getString("name"));
            catalog.setNumber(x.getString("number"));
            catalog.setLongNumber(x.getString("longnumber"));
            catalog.setDesq(x.getInt("sequence"));
            catalog.setParentId(x.getLong("parent.id"));
            catalog.setTemplates(templates.stream().filter(k -> k.getBaseInfo().getTemplateType() == x.getLong("id")).collect(Collectors.toList()));
            return catalog;
        }).collect(Collectors.toList());
        currentCatalog.setChilderns(childCatalog);
        for (TemplateCatalog catalog : childCatalog) {
            this.BuildCatalogTree(catalog, catalogs, templates);
        }
    }

    private void filterEntityInTemplate(Long modelId, Long schemeId, Long orgViewId, List<ReportProcess> reportProcessList, Set<Long> templateIdSet) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        TemplateEntityPermHelper templateEntityPermHelper = new TemplateEntityPermHelper();
        Map<Long, Set<Map<String, Object>>> templateEntityRangeMap = templateEntityPermHelper.getTemplateEntityRangeMap(schemeId);
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
        Long schemeViewId = TemplatePermServiceHelper.getSchemeViewId((Long)schemeId);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateIdSet, null, (Long)schemeViewId);
        if (templateEntityRangeMap != null && templateEntityRangeMap.size() > 0) {
            Iterator<ReportProcess> iterator = reportProcessList.iterator();
            while (iterator.hasNext()) {
                ReportProcess reportProcess = iterator.next();
                Long entityId = reportProcess.getEntityId();
                Long templateId = reportProcess.getTemplateId();
                boolean b = reportPreparationListHelper.canAddReportProcess(templateEntityRangeMap, templateId, entityId, modelCacheHelper, orgViewId, entityRangeCache, userTemplatePermDetails);
                if (b) continue;
                iterator.remove();
            }
        }
    }

    private AdHocSolutionDimMember getSingleDimMember(int i, int type, Dimension dimension, Map<String, String> defaultmember, long templateId) {
        if (dimension == null) {
            return null;
        }
        AdHocSolutionDimMember dimMember = new AdHocSolutionDimMember();
        dimMember.setId(templateId);
        dimMember.setSolutionId(templateId);
        dimMember.setType(type);
        dimMember.setDimensionId(dimension.getId());
        dimMember.setDimensionIndex(IDUtils.toLong((Object)i));
        String member = defaultmember.get(dimension.getNumber());
        dimMember.setMember(member);
        return dimMember;
    }
}

