/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.ebSpread.util.SpreadUtils;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOperateReportParams;
import kd.epm.eb.spread.command.rangedefined.ButtonCell;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ComboboxCell;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.CustomFormula;
import kd.epm.eb.spread.command.rangedefined.FormulaCell;
import kd.epm.eb.spread.command.rangedefined.RedPointCell;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.rangedefined.Shortcut;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.rangedefined.WorkbookOptions;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import org.apache.commons.collections4.CollectionUtils;

public class ExcelSpreadContainer
implements ISpreadContainer {
    private LinkedHashMap<String, Object> operateMaps = new LinkedHashMap(16);

    public LinkedHashMap<String, Object> getOperateMaps() {
        return this.operateMaps;
    }

    public void updateCellValue2(List<ECell> cells) {
        if (cells == null || cells.size() == 0) {
            return;
        }
        HashMap<String, Object> MdDate = (HashMap<String, Object>)this.operateMaps.get(ExcelApiCommon.KEY_CELLVALUE);
        if (MdDate == null) {
            MdDate = new HashMap<String, Object>(16);
            this.operateMaps.put(ExcelApiCommon.KEY_CELLVALUE, MdDate);
        }
        for (ECell cell : cells) {
            Object value;
            if (cell == null || (value = cell.getValue()) == null) continue;
            MdDate.put(Integer.valueOf(cell.getRow()) + "|" + Integer.valueOf(cell.getCol()), value);
        }
    }

    public void updateCellValue(List<Map<String, Object>> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        HashMap<String, Object> MdDate = (HashMap<String, Object>)this.operateMaps.get(ExcelApiCommon.KEY_CELLVALUE);
        if (MdDate == null) {
            MdDate = new HashMap<String, Object>(16);
            this.operateMaps.put(ExcelApiCommon.KEY_CELLVALUE, MdDate);
        }
        for (Map<String, Object> map : parameters) {
            Object value;
            if (map == null || (value = map.get("v")) == null) continue;
            MdDate.put(StringUtils.join((Object[])new Serializable[]{(Integer)map.get("r"), "|", (Integer)map.get("c")}), value);
            Object formatter = map.get("fm");
            if (formatter == null) continue;
            MdDate.put(StringUtils.join((Object[])new Serializable[]{(Integer)map.get("r"), "|", (Integer)map.get("c"), "|", "fm"}), formatter.toString());
        }
    }

    public void callbackAction(String plugin_methodname) {
    }

    public void rebuildSpread(String json) {
        this.operateMaps.putIfAbsent(ExcelApiCommon.KEY_JSON, this.getBytes2ExcelB64Data(json));
    }

    private String getBytes2ExcelB64Data(String data) {
        String prefix = "base64";
        byte[] datas = data.startsWith(prefix) ? SpreadUtils.transZippedJson2Excel((String)data.substring(prefix.length())) : SpreadUtils.transJson2Excel((String)data);
        return Base64.getEncoder().encodeToString(datas);
    }

    public void appendRowCols(int rows, int cols) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle>(5);
        ExcelOperateReportParams.ExcelSetCellStyle cellStyle = new ExcelOperateReportParams.ExcelSetCellStyle();
        cellStyle.setC(cols);
        cellStyle.setR(rows);
        doRows.put("appendRowCols", cellStyle);
        MdDate.add(doRows);
    }

    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        this.insertRowCol(rowindexs, colindexs, false);
    }

    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs, boolean copyStyle) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols>(5);
        ExcelOperateReportParams.ExcelRowCols deleteRowCol = new ExcelOperateReportParams.ExcelRowCols();
        deleteRowCol.setColindexs(colindexs);
        deleteRowCol.setRowindexs(rowindexs);
        deleteRowCol.setCopyStyle(copyStyle);
        doRows.put("insertRowCol", deleteRowCol);
        MdDate.add(doRows);
    }

    public void deleteRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        ArrayList MdDate;
        if (rowindexs != null && rowindexs.size() > 0) {
            rowindexs.sort((o1, o2) -> o2 - o1);
        }
        if (colindexs != null && colindexs.size() > 0) {
            colindexs.sort((o1, o2) -> o2 - o1);
        }
        if ((MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE)) == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols>(5);
        ExcelOperateReportParams.ExcelRowCols deleteRowCol = new ExcelOperateReportParams.ExcelRowCols();
        deleteRowCol.setColindexs(colindexs);
        deleteRowCol.setRowindexs(rowindexs);
        doRows.put("deleteRowCol", deleteRowCol);
        MdDate.add(doRows);
    }

    public void deleteRowCol(int index, int count, boolean isRow) {
        ArrayList<Integer> rowindexs = null;
        ArrayList<Integer> colindexs = null;
        if (isRow) {
            rowindexs = new ArrayList<Integer>(count);
            for (int i = count; i > 0; --i) {
                rowindexs.add(index + i);
            }
        } else {
            colindexs = new ArrayList<Integer>(count);
            for (int i = count; i > 0; --i) {
                colindexs.add(index + i);
            }
        }
        this.deleteRowCol(rowindexs, colindexs);
    }

    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow, boolean allowSize) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle>(5);
        ExcelOperateReportParams.ExcelSetCellStyle cellStyle = new ExcelOperateReportParams.ExcelSetCellStyle();
        cellStyle.setC(range.getC());
        cellStyle.setCc(range.getCc());
        cellStyle.setR(range.getR());
        cellStyle.setRc(range.getRc());
        cellStyle.setIndex(index);
        cellStyle.setCount(count);
        cellStyle.setIsrow(isrow);
        cellStyle.setStyleIndex(styleIndex);
        doRows.put("fieldInsertRowCol", cellStyle);
        MdDate.add(doRows);
    }

    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow) {
        this.fieldInsertRowCol(range, index, count, styleIndex, isrow, true);
    }

    public void fieldDeleteRowCol(CellArea range, int index, int count, boolean isrow) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelSetCellStyle>(5);
        ExcelOperateReportParams.ExcelSetCellStyle cellStyle = new ExcelOperateReportParams.ExcelSetCellStyle();
        cellStyle.setC(range.getC());
        cellStyle.setCc(range.getCc());
        cellStyle.setR(range.getR());
        cellStyle.setRc(range.getRc());
        cellStyle.setIndex(index);
        cellStyle.setCount(count);
        cellStyle.setIsrow(isrow);
        doRows.put("fieldDeleteRowCol", cellStyle);
        MdDate.add(doRows);
    }

    public void insertRowsBelow(List<Integer> rowindexs, boolean copyStyle) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols>(5);
        ExcelOperateReportParams.ExcelRowCols deleteRowCol = new ExcelOperateReportParams.ExcelRowCols();
        deleteRowCol.setRowindexs(rowindexs);
        deleteRowCol.setCopyStyle(copyStyle);
        doRows.put("insertRowsBelow", deleteRowCol);
        MdDate.add(doRows);
    }

    public void insertRowsBelow(int rowIndex, int count, boolean copyStyle) {
        if (count > 0) {
            ArrayList<Integer> rowindexs = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                rowindexs.add(i + rowIndex);
            }
            this.insertRowsBelow(rowindexs, copyStyle);
        }
    }

    public void insertColsAfter(int colIndex, int count, boolean copyStyle) {
    }

    public void setColumnsWidth(List<Integer> colindexs, int width) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols>(5);
        ExcelOperateReportParams.ExcelRowCols cellStyle = new ExcelOperateReportParams.ExcelRowCols();
        cellStyle.setColindexs(colindexs);
        cellStyle.setWidth(width);
        doRows.put("setColumnsWidth", cellStyle);
        MdDate.add(doRows);
    }

    public void setRowsHeight(List<Integer> rowindexs, int height) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols> doRows = new LinkedHashMap<String, ExcelOperateReportParams.ExcelRowCols>(5);
        ExcelOperateReportParams.ExcelRowCols cellStyle = new ExcelOperateReportParams.ExcelRowCols();
        cellStyle.setColindexs(rowindexs);
        cellStyle.setWidth(height);
        doRows.put("setRowsHeight", cellStyle);
        MdDate.add(doRows);
    }

    public void lockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<CellArea>> doRows = new LinkedHashMap<String, List<CellArea>>(5);
        doRows.put("lockCell", paras);
        MdDate.add(doRows);
    }

    public void lockECells(List<ECell> paras) {
        this.lockCells(this.cell2Areas(paras));
    }

    public void unlockCells(List<CellArea> paras) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<CellArea>> doRows = new LinkedHashMap<String, List<CellArea>>(5);
        doRows.put("unLockCell", paras);
        MdDate.add(doRows);
    }

    public void lockSheets(List<String> sheetnames) {
    }

    public void unlockSheets(List<String> sheetnames) {
    }

    public void setSpan(List<CellArea> areas) {
        if (areas != null && areas.size() > 0) {
            ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
            if (MdDate == null) {
                MdDate = new ArrayList(16);
                this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
            }
            LinkedHashMap<String, List<CellArea>> doRows = new LinkedHashMap<String, List<CellArea>>(5);
            doRows.put("setSpan", areas);
            MdDate.add(doRows);
        }
    }

    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<AreasStyle>> doRows = new LinkedHashMap<String, List<AreasStyle>>(5);
        doRows.put("setCellStyle", areasStyles);
        MdDate.add(doRows);
    }

    private List<CellArea> cell2Areas(List<ECell> cells) {
        if (cells == null || cells.size() == 0) {
            return null;
        }
        ArrayList<CellArea> cellAreas = new ArrayList<CellArea>(cells.size());
        for (ECell cell : cells) {
            CellArea cellArea = new CellArea(cell.getRow(), cell.getCol(), 1, 1);
            cellAreas.add(cellArea);
        }
        return cellAreas;
    }

    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean quickAddNew) {
        this.setFListCellArea(this.cell2Areas(cells), fuzzyQuery, combobox, false, false);
    }

    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox) {
        this.setFListCellArea(cellAreas, fuzzyQuery, combobox, false, false);
    }

    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        if (cellAreas == null || cellAreas.size() == 0) {
            return;
        }
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea> excelCellArea = new ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea>(cellAreas.size());
        for (CellArea cellArea : cellAreas) {
            ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea excelCell = new ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea(cellArea.getR(), cellArea.getC());
            excelCell.setDst(combobox ? 1 : 0);
            excelCellArea.add(excelCell);
        }
        LinkedHashMap<String, ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea>> doRows = new LinkedHashMap<String, ArrayList<ExcelOperateReportParams.ExcelSetCellStyle.ExcelCellArea>>(5);
        doRows.put("setFListCell", excelCellArea);
        MdDate.add(doRows);
    }

    public void setComboCell(List<ComboboxCell> comboboxCells) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<ComboboxCell>> doRows = new LinkedHashMap<String, List<ComboboxCell>>(5);
        doRows.put("setComboCell", comboboxCells);
        MdDate.add(doRows);
    }

    public void setBtnCell(List<ButtonCell> buttonCells) {
    }

    public void setCustomBtnCell(List<ButtonCell> buttonCells) {
    }

    public void setCellTag(List<RedPointCell> redPointCells) {
    }

    public void clearRowCellTags3(int rowIndex, int count, int startCol, int endCol) {
    }

    public void clearColCellTags3(int colIndex, int count, int startRow, int endRow) {
    }

    public void resetCell(List<CellArea> areas) {
    }

    public void getSpreadJson(String callBack_MethodName) {
    }

    public void getRangeStyles(List<Object> area, String si, String callBack_MethodName) {
    }

    public void getLockedCells(boolean compression, String si, String callBack_MethodName) {
    }

    public void setLookupData(ECell cell, Object data) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, Object> dataObj = new LinkedHashMap<String, Object>(5);
        dataObj.put("setLookupData", data);
        MdDate.add(dataObj);
    }

    public void setCustomFormulaCell(List<ECell> cells) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<CellArea>> doRows = new LinkedHashMap<String, List<CellArea>>(5);
        doRows.put("setCustomFormulaCell", this.cell2Areas(cells));
        MdDate.add(doRows);
    }

    public void setAllCustomFormulaCell() {
    }

    public void registerCustomFormula(List<CustomFormula> customFormulas) {
    }

    public void setFormula(List<FormulaCell> formulaCells) {
    }

    public void setSelections(CellArea cellArea, boolean triggerSel) {
        this.operateMaps.put(ExcelApiCommon.KEY_SETSELECTIONS, cellArea);
    }

    public void setSelections(CellArea cellArea) {
        this.operateMaps.put(ExcelApiCommon.KEY_SETSELECTIONS, cellArea);
    }

    public void exportExcelFile(String fileName) {
    }

    public void lockToolbarItems(List<ToolBarItemsEnum> lockItems, List<ToolBarItemsEnum> unlockItems) {
    }

    public void hideContextMenuItems(List<ContextMenuItemsEnum> hideItems, List<ContextMenuItemsEnum> showItems) {
    }

    public void hideContextMenuItemsByKey(List<String> hideItems, List<String> showItems) {
    }

    public void addContextMenuItems(String callBackMethod, String title, ContextMenuWorkArea contextMenuWorkArea) {
        this.operateMaps.put(ExcelApiCommon.KEY_ADDCONTEXTMENUITEMS, callBackMethod);
    }

    public void deleteContextMenuItems(String[] name) {
    }

    public void setDisplayLeftText(String text) {
    }

    public void setDisplayCenterText(String text) {
    }

    public void clearCellsStyle(List<CellArea> cellAreas) {
    }

    public void controlToolbarItems(List<ToolBarItemsEnum> needControl, List<ToolBarItemsEnum> notneedControl) {
    }

    public void closeToolbar() {
    }

    public void closeToolbar(Boolean showExpandBtnVisible) {
    }

    public void setToolbarExpandBtnVisible(Boolean visible) {
    }

    public void frozenSheet(SheetFrozenInfo frozenInfo) {
        this.operateMaps.put(ExcelApiCommon.KEY_FROZENSHEET, frozenInfo);
    }

    public void setRowsAutoFit(List<Integer> rows) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<Integer>> doRows = new LinkedHashMap<String, List<Integer>>(5);
        doRows.put("setRowsAutoFit", rows);
        MdDate.add(doRows);
    }

    public void setColsAutoFit(List<Integer> cols) {
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, List<Integer>> doRows = new LinkedHashMap<String, List<Integer>>(5);
        doRows.put("setColsAutoFit", cols);
        MdDate.add(doRows);
    }

    public void setShortcutKey(Shortcut shortcut) {
    }

    public void setWorkbookOptions(WorkbookOptions workbookOptions) {
    }

    public void setDisplayContent(String status, String cellMsg, String convertStatus) {
        this.setDisplayContent("", status, cellMsg, convertStatus, "");
    }

    public void setDisplayContent(String attachement, String status, String cellMsg, String convertStatus, String unit) {
        this.operateMaps.put("setDisplayContent", attachement);
        this.operateMaps.put("setStatusBarContent", cellMsg);
    }

    public void getColumnsWidth(Integer[] cols, String callBackMethodName) {
    }

    public void getColumnsWidth(List<Integer> cols, String callBackMethodName) {
    }

    public void getRowsHeight(Integer[] rows, String callBackMethodName) {
    }

    public void getRowsHeight(List<Integer> rows, String callBackMethodName) {
    }

    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, boolean default_collapsed) {
        this.doSetOutLineColumn(col, showCheckBox, maxLevel, default_collapsed);
    }

    private void doSetOutLineColumn(int col, Boolean showCheckBox, Integer maxLevel, Object collapsedFlags) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", collapsedFlags);
        }
        options.put("c", col);
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, HashMap<String, Object>> doRows = new LinkedHashMap<String, HashMap<String, Object>>(5);
        doRows.put("setOutlineColumn", options);
        MdDate.add(doRows);
    }

    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, Map<Integer, Boolean> collapsedFlags) {
        this.doSetOutLineColumn(col, showCheckBox, maxLevel, collapsedFlags);
    }

    public void getOutlineColumnNode(int si, String callbackMethod) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("si", si);
        params.put("invokemethod", callbackMethod);
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, HashMap<String, Object>> doRows = new LinkedHashMap<String, HashMap<String, Object>>(5);
        doRows.put("getOutlineColumnNode", params);
        MdDate.add(doRows);
    }

    public void setVirtualMode(String callbackMethod, boolean isopen) {
    }

    public void setVirtualMode(String callbackMethod, boolean isopen, Integer delay) {
    }

    public void addSheets(int index, String name, int rc, int cc) {
    }

    public void updateCellValueAddSheet(List<Map<String, Object>> parameters, int si) {
    }

    public void setColumnsWidthAddSheet(Map<String, Object> parasmap) {
    }

    public void appendRowColsAddSheet(int rows, int cols, int si) {
    }

    public void setCol0rRowGroupbyOnesheet(int count, int index, int si, boolean isRow) {
    }

    public void expandRowOrColOutlines(int maxlevels, boolean expand, int si, boolean isRow) {
    }

    public void insertRowColAddSheet(List<Integer> rowindexs, List<Integer> colindexs, int si) {
    }

    public void setCellStyleAddSheet(List<AreasStyle> areasStyles, int si) {
    }

    public void setCellTags(List<Map<String, Object>> cellTags) {
    }

    public void setComment(List<Map<String, Object>> data, int si) {
    }

    public void addContextMenuItems(String callBackMethod, String title, List<Map<String, Object>> subMenus, ContextMenuWorkArea contextMenuWorkArea) {
    }

    public void addContextMenuItems(List<MenuItem> menuItems, ContextMenuWorkArea contextMenuWorkArea) {
    }

    public void hideShowContextMenuItems(List<MenuItem> hideItems, List<MenuItem> showItems) {
    }

    public void setRowsVisible(List<Integer> rowindexs, boolean isVisible) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("rows", rowindexs);
        parasmap.put("value", !isVisible);
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, HashMap<String, Object>> doRows = new LinkedHashMap<String, HashMap<String, Object>>(5);
        doRows.put("setRowsVisible", parasmap);
        MdDate.add(doRows);
    }

    public void setColumnsVisible(List<Integer> colindexs, boolean isVisible) {
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("rows", colindexs);
        parasmap.put("value", !isVisible);
        ArrayList MdDate = (ArrayList)this.operateMaps.get(ExcelApiCommon.KEY_OPERATE);
        if (MdDate == null) {
            MdDate = new ArrayList(16);
            this.operateMaps.put(ExcelApiCommon.KEY_OPERATE, MdDate);
        }
        LinkedHashMap<String, HashMap<String, Object>> doRows = new LinkedHashMap<String, HashMap<String, Object>>(5);
        doRows.put("setColumnsVisible", parasmap);
        MdDate.add(doRows);
    }

    public void setGroupColNode(Collection<CellGroupNodeInfo> cellGroupNodeInfos) {
    }

    public void setStatusBarVisible(Boolean visible) {
    }
}

