/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.report;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.ebSpread.util.SpreadUtils;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.ExcelFormView;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.report.ExcelFixReportProcess;
import kd.epm.eb.formplugin.excel.report.ExcelReportCheck;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadJsAction;
import kd.epm.eb.formplugin.task.command.IRptMutexSupport;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.lang3.StringUtils;

public interface IExcelOpenReportBaseService
extends IRptMutexSupport {
    public static final Log logger = LogFactory.getLog(IExcelOpenReportBaseService.class);

    default public AbstractReportPlugin getReportPlugin(ExcelOpenReportParams openReportParams) {
        return null;
    }

    default public void cacheMutexKey(ExcelOpenReportParams openReportParams, AbstractReportPlugin plugin) {
        if (openReportParams != null) {
            String mutexKey = String.format("%s,%s,%s,%s,%s", openReportParams.getBaseInfo().getOrgId(), openReportParams.getBaseInfo().getTemplateId(), openReportParams.getDimFilterParams().get("Version"), openReportParams.getDimFilterParams().get("DataType"), openReportParams.getDimFilterParams().get("BudgetPeriod"));
            plugin.getPageCache().put("mutexKey", mutexKey);
            ExcelApiCommon.doLog("Excel_mutexKey", logger);
        }
    }

    @Override
    default public void setEnable(boolean enable) {
    }

    default public void pageRelease(AbstractReportPlugin plugin) {
        if (this.isNeedMutexLock()) {
            this.getAppCacheMutexRequestService().releaseMutexLock(plugin.getPageCache().get("eb_rpt_mutexkey"), true);
        }
    }

    default public AbstractReportPlugin loadReport(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        SpreadUtils.SetLicenseKey((boolean)true);
        this.cacheContextParam(openReportParams, plugin);
        plugin.setCurrentEntityViewId(openReportParams.getBaseInfo().getOrgViewId() + "");
        plugin.setCurrentEntityNumber(openReportParams.getBaseInfo().getOrgNumber());
        ITemplateModel templateModel = this.buildTemplateModel(this.queryTemplateDynamicObj(openReportParams.getBaseInfo().getTemplateId()), plugin.getPageCache());
        if (templateModel == null) {
            return plugin;
        }
        templateModel.setModelId(Long.valueOf(openReportParams.getBaseInfo().getModelId()));
        if (openReportParams.getDataUnit() != null) {
            templateModel.getTemplateBaseInfo().setDataunit(openReportParams.getDataUnit() + "");
        }
        if (ExcelReportCheck.checkTaskMonitor(openReportParams, this.getSpreadContainer(plugin))) {
            return plugin;
        }
        if (!ExcelReportCheck.checkVailad(templateModel, openReportParams, this.getSpreadContainer(plugin))) {
            return plugin;
        }
        Optional<IPageDimensionEntry> optional = templateModel.getPagemembentry().stream().filter(entry -> SysDimensionEnum.Entity.getNumber().equals(entry.getDimension().getNumber())).findFirst();
        if (optional.isPresent()) {
            templateModel.getDimemsionViews().put(SysDimensionEnum.Entity.getNumber(), openReportParams.getBaseInfo().getOrgViewId());
        }
        this.openReport(plugin, openReportParams, templateModel);
        this.getPageDims(openReportParams, templateModel, plugin);
        this.getAreaInfos(plugin);
        this.getViewInfos(templateModel, plugin);
        return plugin;
    }

    default public void cacheContextParam(ExcelOpenReportParams openReportParams, AbstractReportPlugin plugin) {
        plugin.getPageCache().put("current_org", openReportParams.getBaseInfo().getOrgId() + "");
        plugin.getPageCache().put("CURRENT_ORG_VIEW", openReportParams.getBaseInfo().getOrgViewId() + "");
        plugin.getPageCache().put("current_rpt", openReportParams.getBaseInfo().getTemplateId() + "");
        plugin.getPageCache().put("current_rpt_type", openReportParams.getBaseInfo().getReportType());
        plugin.getPageCache().put("current_processid", openReportParams.getBaseInfo().getTaskProcessId() + "");
        plugin.getPageCache().put("current_processtype", openReportParams.getBaseInfo().getProcessType() + "");
        plugin.getPageCache().put("current_report_id", openReportParams.getBaseInfo().getProcessId() + "");
        plugin.getPageCache().put("CURRENT_PERIOD", openReportParams.getDimFilterParams().get("BudgetPeriod") + "");
        plugin.getPageCache().put("KEY_MODEL_ID", openReportParams.getBaseInfo().getModelId() + "");
    }

    default public SpreadSelector getSpreadSelector(ExcelOpenReportParams openReportParams) {
        return new SpreadSelector(openReportParams.getStartrow(), openReportParams.getStartcol(), openReportParams.getStartrow(), openReportParams.getStartcol());
    }

    default public IFormView iniFormView(ExcelOpenReportParams openReportParams, String formId) {
        FormShowParameter params = new FormShowParameter();
        params.setPageId(openReportParams.getPageCacheId());
        params.setAppId("bgm");
        FormConfig cfg = new FormConfig();
        cfg.setEntityTypeId(formId);
        params.setFormConfig(cfg);
        ExcelFormView fv = new ExcelFormView(this.getSpreadContainer(this.getReportPlugin(openReportParams)));
        fv.addService(IPageCache.class, new PageCache(openReportParams.getPageCacheId()));
        fv.initialize(params);
        return fv;
    }

    default public void setReportPlugin(AbstractReportPlugin plugin, ExcelOpenReportParams openReportParams) {
        plugin.setProcessId(Long.valueOf(openReportParams.getBaseInfo().getProcessId()));
        plugin.setTaskProcessId(Long.valueOf(openReportParams.getBaseInfo().getTaskProcessId()));
        plugin.setProcessType(openReportParams.getBaseInfo().getProcessType());
    }

    default public void setReportPlugin(AbstractReportPlugin plugin, ExcelOpenReportParams openReportParams, ITemplateModel templateModel) {
        this.setReportPlugin(plugin, openReportParams);
        plugin.setCurrentEntityViewId(openReportParams.getBaseInfo().getOrgViewId() + "");
        plugin.setTemplateModel(templateModel);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)openReportParams.getBaseInfo().getModelId());
        Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(openReportParams.getBaseInfo().getOrgViewId()), Long.valueOf(openReportParams.getBaseInfo().getOrgId()));
        plugin.setCurrentEntityNumber(orgMember.getNumber());
        plugin.setTemplatePageEntity(templateModel);
        plugin.setDefaultDimMember(this.getDefaultDimMember(openReportParams));
        plugin.setExtraQfilter(this.getExtraQfilter(templateModel, openReportParams));
    }

    default public void cacheCurTemplateModel(AbstractReportPlugin plugin) {
    }

    default public void setReportPluginAndTemplateModel(AbstractReportPlugin plugin, ExcelOpenReportParams openReportParams, ITemplateModel templateModel) {
        boolean isFixReport = BgTemplateTypeEnum.EBFIX.getNumber().equals(openReportParams.getBaseInfo().getReportType());
        if (isFixReport) {
            this.setReportPlugin(plugin, openReportParams, templateModel);
        } else {
            ITemplateModel iTemplateModel = plugin.getTemplateModel();
            iTemplateModel.setTemplateBaseInfo(templateModel.getTemplateBaseInfo());
            this.setReportPlugin(plugin, openReportParams, iTemplateModel);
            templateModel.getPagemembentry().clear();
            templateModel.getPagemembentry().addAll(iTemplateModel.getPagemembentry());
        }
        if (plugin.getSpreadManager() != null) {
            templateModel.setDimemsionViews(plugin.getSpreadManager().getDimemsionViews());
        }
    }

    default public void openReport(AbstractReportPlugin plugin, ExcelOpenReportParams openReportParams, ITemplateModel templateModel) {
        this.setReportPluginAndTemplateModel(plugin, openReportParams, templateModel);
        this.cacheCurTemplateModel(plugin);
        plugin.getPageCache().put("excelDefaultDimMember", ObjectSerialUtil.toByteSerialized((Object)plugin.getDefaultDimMember()));
        plugin.getPageCache().put("extraQfilter", ObjectSerialUtil.toByteSerialized((Object)plugin.getExtraQfilter()));
        plugin.afterCreateNewData(null);
    }

    default public Map<String, Long> getDefaultDimMember(ExcelOpenReportParams openReportParams) {
        return openReportParams.getDimFilterParams();
    }

    default public Map<String, QFilter> getExtraQfilter(ITemplateModel templateModel, ExcelOpenReportParams openReportParams) {
        HashMap<String, QFilter> extraFilters = new HashMap<String, QFilter>(16);
        extraFilters.put(SysDimensionEnum.Entity.getNumber(), this.getEntityFilter(openReportParams));
        extraFilters.put(SysDimensionEnum.Account.getNumber(), new QFilter("dataset", "=", (Object)templateModel.getTemplateBaseInfo().getDatasetID()));
        return extraFilters;
    }

    default public QFilter getEntityFilter(ExcelOpenReportParams openReportParams) {
        Long current_org = openReportParams.getBaseInfo().getOrgId();
        Long templateId = openReportParams.getBaseInfo().getTemplateId();
        Long processId = openReportParams.getBaseInfo().getTaskProcessId();
        Long modelId = openReportParams.getBaseInfo().getModelId();
        QFilter qFilter = null;
        if (IDUtils.isNotNull((Long)current_org) && IDUtils.isNotNull((Long)templateId)) {
            qFilter = new QFilter("model", "=", (Object)modelId);
            Set tmplOrgs = TemplateModelHelper.parseOrgNumberRange((Long)modelId, (Long)templateId, (Long)processId, (ProcessTypeEnum)ProcessTypeEnum.TASK);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)tmplOrgs)) {
                QFilter qFilter2 = new QFilter("id", "=", (Object)current_org).or(new QFilter("number", "in", (Object)tmplOrgs));
                qFilter = qFilter.and(qFilter2);
            }
        }
        return qFilter;
    }

    default public void getAreaInfos(AbstractReportPlugin plugin) {
        IEbSpreadManager ebSpreadManager = plugin.getSpreadManager();
        if (ebSpreadManager == null || ebSpreadManager.getMultiAreaManager() == null) {
            return;
        }
        ArrayList<String> areaInfos = new ArrayList<String>(ebSpreadManager.getMultiAreaManager().size());
        for (MultiAreaManager area : ebSpreadManager.getMultiAreaManager()) {
            areaInfos.add(area.getAreaRange().toString());
        }
        this.getSpreadContainer(plugin).getOperateMaps().put(ExcelApiCommon.KEY_AREAINFOS, areaInfos);
    }

    default public void getPageDims(ExcelOpenReportParams openReportParams, ITemplateModel templateModel, AbstractReportPlugin plugin) {
        this.getPageFilter(openReportParams, templateModel, plugin);
        this.getPageDefault(plugin);
    }

    default public void getViewInfos(ITemplateModel templateModel, AbstractReportPlugin plugin) {
        this.getSpreadContainer(plugin).getOperateMaps().put(ExcelApiCommon.KEY_DIMENSTIONVIEWINFOS, templateModel.getDimensionView());
    }

    default public void getPageFilter(ExcelOpenReportParams openReportParams, ITemplateModel templateModel, AbstractReportPlugin plugin) {
        Map pagedim_boundary;
        plugin.getSpreadManager().setNeedCheckPerm(true);
        Optional<IPageDimensionEntry> optional = templateModel.getPagemembentry().stream().filter(entry -> SysDimensionEnum.Entity.getNumber().equals(entry.getDimension().getNumber())).findFirst();
        if (optional.isPresent()) {
            templateModel.getDimemsionViews().put(SysDimensionEnum.Entity.getNumber(), openReportParams.getBaseInfo().getOrgViewId());
        }
        if ((pagedim_boundary = plugin.getSpreadManager().resolvePageMemberScope(templateModel)) == null) {
            return;
        }
        long reportProcessId = openReportParams.getBaseInfo().getProcessId();
        IFormView view = plugin.getView();
        List dimRelationList = ReportHelper.getDimRelation((IFormView)view, (Long)reportProcessId);
        Map dimRelationMap = ReportHelper.getDimRelationMap((IFormView)view, (Long)reportProcessId);
        List hideDimEntry = templateModel.getViewpointmembentry();
        LinkedHashMap<String, String> hideDimMap = new LinkedHashMap<String, String>(hideDimEntry.size());
        for (IViewPointDimensionEntry hideMem : hideDimEntry) {
            String dimNum = hideMem.getDimension().getNumber();
            String memNum = hideMem.getMember().getNumber();
            hideDimMap.put(dimNum, memNum);
        }
        Long modelId = templateModel.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(templateModel.getTemplateBaseInfo().getDatasetID());
        Long periodId = IDUtils.toLong((Object)view.getPageCache().get("CURRENT_PERIOD"));
        HashMap pageFilters = new HashMap(pagedim_boundary.size());
        for (IPageDimensionEntry pagemem : templateModel.getPagemembentry()) {
            String dimnumber = pagemem.getDimension().getNumber();
            Set members = (Set)pagedim_boundary.get(dimnumber);
            if (members == null || members.size() <= 0) continue;
            ArrayList filterNumbers = new ArrayList();
            members.forEach(mem -> filterNumbers.add(mem.getNumber()));
            if (dimRelationMap.containsKey(dimnumber)) {
                Set dimRelMemSet = DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCache, (Long)bizModelId, (String)dimnumber, (Long)periodId, hideDimMap, (Map)dimRelationMap, (List)dimRelationList);
                Sets.SetView validNumSet = Sets.intersection((Set)Sets.newHashSet(filterNumbers), (Set)dimRelMemSet);
                filterNumbers.clear();
                filterNumbers.addAll(validNumSet);
            }
            pageFilters.put(dimnumber, filterNumbers);
        }
        this.getSpreadContainer(plugin).getOperateMaps().put(ExcelApiCommon.KEY_PAGEDIMFILTERS, pageFilters);
    }

    default public LinkedHashMap<String, Object> getPageRelation(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return new LinkedHashMap<String, Object>(1);
        }
        long reportProcessId = openReportParams.getBaseInfo().getProcessId();
        IFormView view = plugin.getView();
        List dimRelationList = ReportHelper.getDimRelation((IFormView)view, (Long)reportProcessId);
        Map dimRelationMap = ReportHelper.getDimRelationMap((IFormView)view, (Long)reportProcessId);
        ITemplateModel templateModel = plugin.getTemplateModel();
        List hideDimEntry = templateModel.getViewpointmembentry();
        LinkedHashMap<String, String> preDimMap = new LinkedHashMap<String, String>(hideDimEntry.size());
        for (IViewPointDimensionEntry hideMem : hideDimEntry) {
            String dimNum = hideMem.getDimension().getNumber();
            String memNum = hideMem.getMember().getNumber();
            preDimMap.put(dimNum, memNum);
        }
        Long modelId = templateModel.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(templateModel.getTemplateBaseInfo().getDatasetID());
        Long periodId = IDUtils.toLong((Object)view.getPageCache().get("CURRENT_PERIOD"));
        String targetDim = openReportParams.getTargetDim();
        preDimMap.putAll(openReportParams.getDimMember());
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("filter", false);
        if (dimRelationMap.containsKey(targetDim)) {
            Set relationMembers = DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCache, (Long)bizModelId, (String)targetDim, (Long)periodId, preDimMap, (Map)dimRelationMap, (List)dimRelationList);
            result.put("filter", true);
            result.put("members", relationMembers);
        }
        LinkedHashMap<String, Object> operateMaps = this.getSpreadContainer(plugin).getOperateMaps();
        operateMaps.put(ExcelApiCommon.KEY_RELATION_DIM_MEM, result);
        return operateMaps;
    }

    default public void getPageDefault(AbstractReportPlugin plugin) {
        this.getSpreadContainer(plugin).getOperateMaps().put(ExcelApiCommon.KEY_PAGEDIMDEFAULTS, plugin.getSpreadManager().getPageViewDims());
    }

    default public DynamicObject queryTemplateDynamicObj(Long templateId) {
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,isreadonly,isrelation,dimrelationinfo,dimrelationinfo2,data,varbaseforeb";
        return BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
    }

    default public ITemplateModel buildTemplateModel(DynamicObject dyna, IPageCache pageCache) {
        if (dyna == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7b97\u6a21\u677f\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"IExcelOpenReportBaseService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model.id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog.id")));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset.id")));
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        DynamicObjectCollection dimrelationinfos = dyna.getDynamicObjectCollection("dimrelationinfo2");
        List dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        templateBaseInfo.setDimRelations(dimRelations);
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        pageCache.put("varbaseforeb", dyna.getString("varbaseforeb"));
        Long busModelId = dyna.getLong("dataset.businessmodel.id");
        templateBaseInfo.setBizModel(busModelId);
        ITemplateModel templateModel = null;
        String data = dyna.getString("data");
        templateModel = !StringUtils.isEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel((String)String.valueOf(templateBaseInfo.getTemplatetype()));
        if (templateModel != null) {
            templateModel.setTemplateBaseInfo(templateBaseInfo);
            if (templateModel.getAreaRanges() != null) {
                boolean isUserStyle = "1".equals(CommonUtils.getReportColorType((Long)templateBaseInfo.getModelID()));
                templateModel.getAreaRanges().forEach(multiAreaSetting -> multiAreaSetting.setUserStyle(isUserStyle));
            }
        }
        pageCache.put("TemplateModel", data);
        return templateModel;
    }

    default public ExcelSpreadContainer getSpreadContainer(AbstractReportPlugin plugin) {
        return (ExcelSpreadContainer)plugin.getspreadContainer();
    }

    default public LinkedHashMap<String, Object> pluginExcelFirstRefreshData(ExcelOpenReportParams openReportParams) {
        this.reSetExcelOpenReportParams(openReportParams);
        AbstractReportPlugin plugin = this.loadReport(openReportParams);
        if (plugin == null) {
            return null;
        }
        this.cacheMutexKey(openReportParams, plugin);
        this.getView().getPageCache().remove("excellock");
        this.processMutex();
        LinkedHashMap<String, Object> operateMaps = this.getSpreadContainer(plugin).getOperateMaps();
        operateMaps.put("excellock", this.getView().getPageCache().get("excellock"));
        operateMaps.put("runexaminewhenopen", CacheUtils.getBoolean((IPageCache)this.getView().getPageCache(), (String)"runexaminewhenopen"));
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public LinkedHashMap<String, Object> pluginExcelRefresh(ExcelOpenReportParams openReportParams) {
        this.reSetExcelOpenReportParams(openReportParams);
        AbstractReportPlugin plugin = this.loadReport(openReportParams);
        if (plugin == null) {
            return null;
        }
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public LinkedHashMap<String, Object> pluginExcelVirtualModelCallBack(ExcelOpenReportParams openReportParams) {
        this.reSetExcelOpenReportParams(openReportParams);
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        this.setReportPluginAndTemplateModel(plugin, openReportParams, plugin.getTemplateModel());
        plugin.virtualModelCallBack(this.getVirtualParams(openReportParams));
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public LinkedHashMap<String, Object> pluginCellValueUpdate(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        plugin.getPageCache().remove("floatPasteInfoMap");
        new ExcelSpreadJsAction((AbstractFormPlugin)plugin, plugin.getSpreadKey()).cellValueUpdate(openReportParams);
        this.getSpreadContainer(plugin).getOperateMaps().put("floatPasteInfoMap", plugin.getPageCache().get("floatPasteInfoMap"));
        this.getSpreadContainer(plugin).getOperateMaps().put("isValueUpdate", plugin.getPageCache().get("isValueUpdate"));
        this.getSpreadContainer(plugin).getOperateMaps().put("newValue", openReportParams.getValue());
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public LinkedHashMap<String, Object> convertJsonMap2LinkedHashMap(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        return new ExcelSpreadJsAction((AbstractFormPlugin)plugin, plugin.getSpreadKey()).convertJsonMap2LinkedHashMap(openReportParams);
    }

    default public LinkedHashMap<String, Object> pluginItemClick(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        if ("btn_save".equals(openReportParams.getValue()) && openReportParams.getBaseInfo() != null && IDUtils.isNotNull((long)openReportParams.getBaseInfo().getProcessId())) {
            Long taskProcessId;
            QFilter qFilter;
            DynamicObject taskProcess;
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)openReportParams.getBaseInfo().getProcessId())});
            if (dynamicObject != null) {
                String status = dynamicObject.getString("status");
                if (BgTaskStateEnum.COMPLETED.getNumber().equals(status) || BgTaskStateEnum.UNDERWAY.getNumber().equals(status)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"IExcelOpenReportBaseService_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return this.getSpreadContainer(plugin).getOperateMaps();
                }
            }
            if (ProcessTypeEnum.TASK.getNumber().equals(openReportParams.getBaseInfo().getProcessType()) && (taskProcess = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"task.name", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(taskProcessId = Long.valueOf(openReportParams.getBaseInfo().getTaskProcessId())))).toArray())) != null) {
                String taskName = taskProcess.getString("task.name");
                Long reportId = openReportParams.getBaseInfo().getProcessId();
                Map lockedOrgRptMap = TaskFlowServiceHelper.getLockedOrgIds(Collections.singleton(reportId));
                if (CollectionUtils.isNotEmpty((Map)lockedOrgRptMap)) {
                    StringBuilder message = new StringBuilder();
                    message.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u7684\u4efb\u52a1\u672a\u542f\u52a8\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u4efb\u52a1\u662f\u5426\u5df2\u5b8c\u6210\u3002", (String)"BgTaskExecutePlugin_113", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                    DynamicObjectCollection orgList = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", lockedOrgRptMap.keySet())});
                    for (int i = 0; i < orgList.size(); ++i) {
                        DynamicObject org = (DynamicObject)orgList.get(i);
                        String orgName = org.getString("name");
                        message.append(ResManager.loadResFormat((String)"%1.\u7ec4\u7ec7\uff1a\u201c%2\u201d\uff0c\u5b50\u4efb\u52a1:\u201c%3\u201d\u3002", (String)"BgTaskExecutePlugin_111", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, orgName, taskName}));
                        message.append("\n\r");
                    }
                    this.getView().showErrorNotification(message.toString());
                    return this.getSpreadContainer(plugin).getOperateMaps();
                }
            }
        }
        plugin.getPageCache().put("isFromItemClickSave", "true");
        plugin.getPageCache().put(ExcelApiCommon.CACHE_CALLBACKMETHOD, null);
        ItemClickEvent event = new ItemClickEvent((Object)plugin, openReportParams.getValue().toString(), "");
        plugin.itemClick(event);
        this.afterItemClick(event, plugin);
        this.subAfterItemClick(event);
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public void subAfterItemClick(ItemClickEvent event) {
    }

    default public void afterItemClick(ItemClickEvent event, AbstractReportPlugin plugin) {
        switch (event.getItemKey()) {
            case "btn_close": {
                this.pageRelease(plugin);
            }
        }
    }

    default public void reSetExcelOpenReportParams(ExcelOpenReportParams openReportParams) {
        Map<String, Long> filterParams = openReportParams.getDimFilterParams();
        if (filterParams == null) {
            // empty if block
        }
    }

    default public Map<String, Map<String, Integer>> getVirtualParams(ExcelOpenReportParams openReportParams) {
        LinkedHashMap<String, Map<String, Integer>> dataInfo = new LinkedHashMap<String, Map<String, Integer>>(16);
        LinkedHashMap<String, Integer> dataMap = new LinkedHashMap<String, Integer>();
        dataMap.put("topRow", openReportParams.getStartrow());
        dataMap.put("bottomRow", openReportParams.getEndrow());
        dataMap.put("leftCol", openReportParams.getStartcol());
        dataMap.put("rightCol", openReportParams.getEndcol());
        dataInfo.put("data", dataMap);
        return dataInfo;
    }

    default public LinkedHashMap<String, Object> pluginGetCellDimInfo(ExcelOpenReportParams openReportParams) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        plugin.cellClick(this.getSpreadSelector(openReportParams));
        return this.getSpreadContainer(plugin).getOperateMaps();
    }

    default public LinkedHashMap<String, Object> invokePluginMethod(ExcelOpenReportParams openReportParams, String methodName) {
        AbstractReportPlugin plugin = this.getReportPlugin(openReportParams);
        if (plugin == null) {
            return null;
        }
        plugin.cellClick(this.getSpreadSelector(openReportParams));
        if (plugin instanceof ExcelFixReportProcess) {
            if (this.getSpreadContainer(plugin).getOperateMaps() == null || this.getSpreadContainer(plugin).getOperateMaps().size() == 0) {
                this.getSpreadContainer(plugin).getOperateMaps().put("Error", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u6570\u503c\u7684\u5355\u5143\u683c\u3002", (String)"FixDrillThroughHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return this.getSpreadContainer(plugin).getOperateMaps();
            }
        } else {
            int realCol = plugin.getSpreadManager().getEbook().getSheet(0).getRealMaxCols();
            int realRow = plugin.getSpreadManager().getEbook().getSheet(0).getRealMaxRows();
            if (openReportParams.getStartcol() > realCol - 1 || openReportParams.getStartrow() > realRow - 1) {
                this.getSpreadContainer(plugin).getOperateMaps().put("Error", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u6570\u503c\u7684\u5355\u5143\u683c\u3002", (String)"FixDrillThroughHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return this.getSpreadContainer(plugin).getOperateMaps();
            }
        }
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("invokemethod", methodName);
        new SpreadJsAction((AbstractFormPlugin)plugin, plugin.getSpreadKey()).callPluginMethod(methodName, param);
        return this.getSpreadContainer(plugin).getOperateMaps();
    }
}

