/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.reportQuery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.template.entity.TemplateTaskDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryCommon;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.QueryRequest;

public class ExcelQueryOlap {
    public Map<String, Object> queryOlapValue(Map<String, Object> params) {
        Long modelId = IDUtils.toLong((Object)params.get(ExcelReportQueryCommon.KEY_MODELID));
        Long datasetId = IDUtils.toLong((Object)params.get(ExcelReportQueryCommon.KEY_DATASETID));
        Map dimMembers = (Map)params.get("DimensionMembers");
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        for (Map.Entry entry : dimMembers.entrySet()) {
            if (entry.getValue() != null) {
                Set queryMembers = memberInfo.computeIfAbsent((String)entry.getKey(), (Function<String, Set<String>>)((Function<String, Set>)k -> new HashSet(16)));
                queryMembers.addAll((Collection)entry.getValue());
                continue;
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{entry.getKey()}));
        }
        LinkedList<QueryRequest> queryRequests = new LinkedList<QueryRequest>();
        queryRequests.add(new QueryRequest(modelId, datasetId, null, memberInfo, new LinkedList(memberInfo.keySet())));
        List resCells = OlapReportService.getInstance().reportQuery(this.getBizRules(datasetId, memberInfo, modelId), queryRequests);
        return this.arrangeResultMapForCells(params, resCells);
    }

    private Set<Long> getBizRules(Long datasetId, Map<String, Set<String>> memberInfo, Long modelId) {
        if (memberInfo == null || memberInfo.size() == 0) {
            return null;
        }
        TemplateTaskDto templateTaskDto = new TemplateTaskDto(Long.valueOf(0L), "", memberInfo);
        RuleRelationService.getInstance().bindRuleToOneTemplate(templateTaskDto, datasetId.longValue(), false, modelId);
        return templateTaskDto.getRuleIds();
    }

    private Map<String, Object> arrangeResultMapForCells(Map<String, Object> params, List<BGCell> resCells) {
        if (resCells == null) {
            return null;
        }
        HashMap<String, Object> returns = new HashMap<String, Object>(16);
        for (BGCell resCell : resCells) {
            String dimensionStr = StringUtils.join(AdjustServiceHelper.mapSort((Map)resCell.getMemberMap()).values(), (String)"!");
            returns.put(dimensionStr, resCell.getValue());
        }
        return returns;
    }

    public List<String> getDimSeq(Map<String, Object> params) {
        Long modelId = IDUtils.toLong((Object)params.get(ExcelReportQueryCommon.KEY_MODELID));
        Long datasetId = IDUtils.toLong((Object)params.get(ExcelReportQueryCommon.KEY_DATASETID));
        ArrayList<String> returns = new ArrayList<String>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String[] dims = modelCache.getDimensionNums(datasetId);
        if (dims == null || dims.length == 0) {
            return returns;
        }
        HashMap<String, String> dimMap = new HashMap<String, String>(dims.length);
        for (String dim : dims) {
            dimMap.put(dim, "");
        }
        return AdjustServiceHelper.mapSort(dimMap).entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }
}

