/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.reportQuery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryCommon;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryDesigner;

public class ExcelReportQuery {
    public List<String> getReportQueryF7Scope(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_MODELID));
        Long dataSetId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_DATASETID));
        String F7Key = param.get(ExcelReportQueryCommon.KEY_F7Key).toString();
        HashMap<String, Long> out_params = new HashMap<String, Long>(16);
        BeforeF7SelectEvent event = new ExcelReportQueryDesigner().getF7Select(modelId, dataSetId, F7Key, out_params);
        return this.queryScope(modelId, F7Key, event, out_params);
    }

    public List<Long> getDimenstionsByDataSet(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_MODELID));
        Long dataSetId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_DATASETID));
        IModelCacheHelper mocalCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (mocalCache == null) {
            return null;
        }
        List dimens = mocalCache.getDimensionList(dataSetId);
        if (dimens == null) {
            return null;
        }
        ArrayList<Long> returns = new ArrayList<Long>(16);
        dimens.forEach(e -> returns.add(e.getId()));
        return returns;
    }

    private boolean queryDimensions(Long modelId, Set<String> dimensions, Map<String, Long> params) {
        Long viewId = 0L;
        if (params == null || params.size() == 0) {
            return true;
        }
        viewId = params.get("viewId");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("source", "=", (Object)"0");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,usage,dimension.number", (QFilter[])qFilter.toArray());
        if (query == null) {
            return true;
        }
        for (DynamicObject q : query) {
            dimensions.add(q.getString("dimension.number"));
            if (viewId.compareTo(q.getLong("id")) != 0 || q.getString("usage").compareTo("0") != 0) continue;
            return false;
        }
        return true;
    }

    private List<String> queryScope(Long modelId, String F7Key, BeforeF7SelectEvent event, Map<String, Long> params) {
        if (event == null || event.getFormShowParameter() == null) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>(16);
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        if (listShowParameter.getListFilterParameter() == null) {
            return null;
        }
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (next.getProperty().toUpperCase().compareTo("VIEW") == 0) {
                iterator.remove();
                continue;
            }
            if (next.getProperty().toUpperCase().compareTo("OFFSETSOURCE") == 0) {
                iterator.remove();
                continue;
            }
            if (next.getProperty().toUpperCase().compareTo("SHOWSELF") != 0) continue;
            iterator.remove();
        }
        String formId = SysDimensionEnum.getMemberTreemodelByNumberIgnoreCase((String)F7Key);
        if (!View.NoViewDimNums.contains(F7Key)) {
            formId = "eb_viewmember";
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)formId, (String)"id,number ", (QFilter[])filters.toArray(new QFilter[0]), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String number = row.getString("number");
                    if (returns.contains(number)) continue;
                    returns.add(number);
                }
            }
        }
        return returns;
    }
}

