/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.reportQuery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolutionDimMember;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.report.IExcelOpenReportBaseService;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelDimTypeEnum;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryCommon;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesigner;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesignerHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;

public class ExcelReportQueryDesigner
extends ReportQueryDesigner
implements IExcelOpenReportBaseService {
    private static String pageCacheId = "Excel_ReportQueryDesigner_F7";

    public ExcelReportQueryDesigner() {
        this.setView(this.iniFormView());
    }

    public ExcelReportQueryDesigner(String modelId, String dataSetId, String templateModel) {
        this.setView(this.iniFormView());
        this.getPageCache().put("model", modelId);
        this.getPageCache().put("dataset", dataSetId);
        this.getPageCache().put("TemplateModel", templateModel);
        this.getPageCache().put("allPoint", null);
    }

    @Override
    public ExcelSpreadContainer getSpreadContainer(AbstractReportPlugin plugin) {
        return new ExcelSpreadContainer();
    }

    private IFormView iniFormView() {
        ExcelOpenReportParams openReportParams = new ExcelOpenReportParams();
        openReportParams.setPageCacheId(pageCacheId);
        return this.iniFormView(openReportParams, "eb_reportqueryprocess");
    }

    public List<AdHocSolutionDimMember> getSolutionDimMembers(Map<String, Object> param) {
        this.getPageCache().put("model", StringUtil.toString((Object)param.get(ExcelReportQueryCommon.KEY_MODELID)));
        String dataSetId = StringUtil.toString((Object)param.get(ExcelReportQueryCommon.KEY_DATASETID));
        this.getPageCache().put("dataset", dataSetId);
        this.getPageCache().put("cache_tab", "tab_dimset");
        this.getPageCache().put(this.getCurNodeCacheName(), dataSetId);
        this.loadDatasetDimData();
        List<Object> returns = new ArrayList(16);
        if (StringUtils.isEmpty((String)this.getPageCache().get("excelSchema"))) {
            returns = this.getSolutionDimObjFromCache();
        } else {
            returns = JSONObject.parseArray((String)this.getPageCache().get("excelSchema"), AdHocSolutionDimMember.class);
            this.getPageCache().remove("excelSchema");
        }
        return returns;
    }

    public List<AdHocSolutionDimMember> loadDimsInfoByTemplateModel(ITemplateModel templateModel) {
        this.loadPageInfoByTemplateModel(templateModel);
        return this.getSolutionDimObjFromCache();
    }

    @Override
    protected void toAddNewTab() {
    }

    private List<AdHocSolutionDimMember> getSolutionDimObjFromCache() {
        ArrayList<AdHocSolutionDimMember> returns = new ArrayList<AdHocSolutionDimMember>(16);
        Map<String, Map<String, String>> dimensionValueMaps = this.getPointEntry();
        returns.addAll(this.getSolutionDimObjFromCache(dimensionValueMaps, true));
        returns.addAll(this.getSolutionDimObjFromCache(dimensionValueMaps, false));
        returns.addAll(this.getSolutionDimObjFromPage(dimensionValueMaps));
        return returns;
    }

    private List<AdHocSolutionDimMember> getSolutionDimObjFromPage(Map<String, Map<String, String>> dimensionValueMaps) {
        ArrayList<AdHocSolutionDimMember> returns = new ArrayList<AdHocSolutionDimMember>(16);
        if (dimensionValueMaps == null) {
            return returns;
        }
        int i = 0;
        ArrayList<Map<String, Object>> memberValueMaps = null;
        for (Map.Entry<String, Map<String, String>> dimensionValueMap : dimensionValueMaps.entrySet()) {
            AdHocSolutionDimMember dimMember;
            String dimenstionKey = dimensionValueMap.getKey();
            if (!dimensionValueMap.getKey().contains("_page")) continue;
            String cache = this.getCache(dimenstionKey);
            if (StringUtils.isNotEmpty((String)cache)) {
                memberValueMaps = new ArrayList<Map<String, Object>>(1);
                memberValueMaps.add((Map<String, Object>)SerializationUtils.fromJsonString((String)cache, Map.class));
            }
            if ((dimMember = this.getSingleDimMember(i, this.getType(ExcelDimTypeEnum.PAGE), dimensionValueMaps.get(dimenstionKey), memberValueMaps)) != null) {
                returns.add(dimMember);
            }
            ++i;
        }
        return returns;
    }

    private List<AdHocSolutionDimMember> getSolutionDimObjFromCache(Map<String, Map<String, String>> dimensionValueMaps, boolean isRow) {
        ArrayList<AdHocSolutionDimMember> returns = new ArrayList<AdHocSolutionDimMember>(16);
        List<String> rowParts = this.getRowColPartTabKeys(isRow);
        if (rowParts == null || dimensionValueMaps == null) {
            return returns;
        }
        int i = 0;
        for (String rowPart : rowParts) {
            List<String> f7Keys = this.getCurPartF7Keys(rowPart);
            if (rowParts == null) continue;
            for (String f7Key : f7Keys) {
                AdHocSolutionDimMember dimMember;
                String cache = this.getCache(f7Key);
                if (cache == null) continue;
                List memberValueMaps = null;
                if (StringUtils.isNotEmpty((String)cache)) {
                    memberValueMaps = (List)SerializationUtils.fromJsonString((String)cache, List.class);
                }
                if ((dimMember = this.getSingleDimMember(i, this.getType(isRow ? ExcelDimTypeEnum.ROW : ExcelDimTypeEnum.COL), dimensionValueMaps.get(this.getCacheDimenstionKey(f7Key)), memberValueMaps)) != null) {
                    returns.add(dimMember);
                }
                ++i;
            }
        }
        return returns;
    }

    private AdHocSolutionDimMember getSingleDimMember(int i, int type, Map<String, String> dimensionValueMap, List<Map<String, Object>> memberValueMaps) {
        if (dimensionValueMap == null) {
            return null;
        }
        AdHocSolutionDimMember dimMember = new AdHocSolutionDimMember();
        Long schemId = IDUtils.toLong((Object)this.getCache("excelSchemaId"));
        dimMember.setType(type);
        dimMember.setId(schemId);
        dimMember.setSolutionId(schemId);
        dimMember.setDimensionId(IDUtils.toLong((Object)dimensionValueMap.get("id")));
        dimMember.setDimensionIndex(IDUtils.toLong((Object)i));
        if (memberValueMaps != null && memberValueMaps.size() > 0) {
            StringBuilder members = new StringBuilder();
            for (Map<String, Object> memberValueMap : memberValueMaps) {
                members.append(kd.bos.dataentity.utils.StringUtils.join((Object[])new Object[]{memberValueMap.get("id"), ";", memberValueMap.get("scope"), ","}));
            }
            dimMember.setMember(members.substring(0, members.length() - 1));
        }
        return dimMember;
    }

    private String getCacheDimenstionKey(String cacheKey) {
        if (cacheKey.contains("part")) {
            return cacheKey.substring(0, cacheKey.lastIndexOf("_"));
        }
        return cacheKey;
    }

    private int getType(ExcelDimTypeEnum dimType) {
        switch (dimType) {
            case HIDE: 
            case PAGE: {
                return 4;
            }
            case ROW: {
                return 2;
            }
            case COL: {
                return 1;
            }
        }
        return 4;
    }

    @Override
    protected boolean isWebScheme(DynamicObject querySchemeDy) {
        boolean isExcelScheme;
        boolean bl = isExcelScheme = querySchemeDy.getString("paramtype") == "2";
        if (isExcelScheme) {
            this.getPageCache().put("excelSchema", querySchemeDy.getString("templatemodel"));
        }
        this.getPageCache().put("excelSchemaId", querySchemeDy.getString("id"));
        return !isExcelScheme;
    }

    public BeforeF7SelectEvent getF7Select(Long modelId, Long dataSetId, String F7Key, Map<String, Long> out_params) {
        this.getPageCache().put("model", modelId.toString());
        this.getPageCache().put("dataset", dataSetId.toString());
        Map<String, String> baseKeyMap = ReportQueryDesignerHelper.getInstance().getAllF7Map(this.getModelId(), this.getDataSetId(), true);
        String f7Name = this.formDimKey(F7Key, baseKeyMap);
        this.getPageCache().put(ExcelReportQueryCommon.KEY_F7Key, f7Name);
        out_params.put("viewId", this.getDimViewId(f7Name, F7Key, dataSetId));
        ListShowParameter param = new ListShowParameter();
        BeforeF7SelectEvent event = new BeforeF7SelectEvent((FieldEdit)new BasedataEdit(), 0, null);
        event.setFormShowParameter((FormShowParameter)param);
        this.beforeF7Select(event);
        return event;
    }

    private String formDimKey(String F7Key, Map<String, String> baseKeyMap) {
        if (baseKeyMap == null || baseKeyMap.size() == 0) {
            return F7Key;
        }
        for (Map.Entry<String, String> entry : baseKeyMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(F7Key)) continue;
            return entry.getKey();
        }
        return F7Key;
    }

    @Override
    protected String getBeforeF7Key(BeforeF7SelectEvent e) {
        return this.getPageCache().get(ExcelReportQueryCommon.KEY_F7Key);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public void registerListener(EventObject e) {
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
    }

    @Override
    public String getMutexKey() {
        return null;
    }
}

