/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.reportQuery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTreeBuilder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolution;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.ExcelReportTypeEntity;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.ExcelViewSolution;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryCommon;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQuerySchema;

public class ExcelReportQueryHelper {
    public List<ExcelViewSolution> getSolutionList(Map<String, Object> param) {
        TemplateCataLogTree root = null;
        Long modelId = IDUtils.toLong((Object)param.get("modelId"));
        String type = param.get("type").toString();
        if (StringUtil.equals((String)type, (String)"0")) {
            root = TemplateCataLogTreeBuilder.getDimSetCataTree((Long)modelId, (String)this.getClass().getName());
            TemplateCataLogTreeBuilder.addDimSetNodes((TemplateCataLogTree)root);
        } else if (StringUtil.equals((String)type, (String)"1")) {
            Long userid = UserUtils.getUserId();
            root = TemplateCataLogTreeBuilder.getReportCataTree((Long)modelId, (Long)userid, (String)this.getClass().getName());
            TemplateCataLogTreeBuilder.addRptNodes((TemplateCataLogTree)root, (Long)userid, (Long)modelId);
        }
        if (root == null) {
            return null;
        }
        ArrayList<ExcelViewSolution> viewSolutions = new ArrayList<ExcelViewSolution>(16);
        ExcelViewSolution viewSolution = new ExcelViewSolution();
        viewSolution.setId(root.getId());
        viewSolution.setNumber(root.getNumber());
        viewSolution.setLongNumber(root.getNumber());
        viewSolution.setName(root.getName());
        viewSolution.setParentId(0L);
        viewSolution.setDesq(0);
        viewSolution.setLevel(1);
        viewSolution.setType(type);
        viewSolutions.add(viewSolution);
        viewSolutions.addAll(this.getChildrenSolutions(viewSolution, root.getChildren(), modelId));
        if (StringUtil.equals((String)type, (String)"1")) {
            param.put(ExcelReportQueryCommon.KEY_CATALOGID, ExcelReportQueryCommon.reportCatalogId);
            param.put("share", false);
            new ExcelReportQuerySchema();
            List<AdHocSolution> adHocSolutions = ExcelReportQuerySchema.getSolutionList(param);
            viewSolutions.addAll(this.getClientSolutions(adHocSolutions, modelId));
        }
        return viewSolutions;
    }

    private List<ExcelViewSolution> getClientSolutions(List<AdHocSolution> adHocSolutions, Long modelId) {
        ArrayList<ExcelViewSolution> viewSolutions = new ArrayList<ExcelViewSolution>(16);
        new ExcelReportQuerySchema();
        ExcelReportTypeEntity reportType = ExcelReportQuerySchema.getClientReportType();
        ExcelViewSolution viewSolution = new ExcelViewSolution();
        viewSolution.setId(reportType.getCatalogId());
        viewSolution.setNumber(reportType.getCatalogNumber());
        viewSolution.setLongNumber(reportType.getCatalogNumber());
        viewSolution.setName(reportType.getCatalogName());
        viewSolution.setParentId(0L);
        viewSolution.setDesq(1);
        viewSolution.setLevel(1);
        viewSolution.setType("2");
        viewSolutions.add(viewSolution);
        if (adHocSolutions == null || adHocSolutions.size() == 0) {
            return viewSolutions;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (AdHocSolution adHocSolution : adHocSolutions) {
            viewSolution = new ExcelViewSolution();
            viewSolution.setId(adHocSolution.getId());
            viewSolution.setNumber(adHocSolution.getNumber());
            viewSolution.setLongNumber(String.format("%s!%s", reportType.getCatalogNumber(), adHocSolution.getNumber()));
            viewSolution.setName(adHocSolution.getName());
            viewSolution.setParentId(reportType.getCatalogId());
            viewSolution.setLevel(2);
            viewSolution.setType("2");
            viewSolution.setDataSetId(adHocSolution.getDataSetId());
            viewSolution.setBizScopeId(this.getBizModelByDataSet(modelCache, adHocSolution.getDataSetId()));
            viewSolutions.add(viewSolution);
        }
        return viewSolutions;
    }

    private List<ExcelViewSolution> getChildrenSolutions(ExcelViewSolution parentViewSolution, Set<TemplateCataLogTree> childs, Long modelId) {
        ArrayList<ExcelViewSolution> viewSolutions = new ArrayList<ExcelViewSolution>(16);
        if (childs == null || childs.size() == 0) {
            return viewSolutions;
        }
        long parentId = parentViewSolution.getId();
        String parentLongNumber = parentViewSolution.getLongNumber();
        int level = parentViewSolution.getLevel() + 1;
        String type = parentViewSolution.getType();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (TemplateCataLogTree child : childs) {
            ExcelViewSolution viewSolution = new ExcelViewSolution();
            viewSolution.setId(child.getId());
            viewSolution.setNumber(child.getNumber());
            viewSolution.setLongNumber(String.format("%s!%s", parentLongNumber, child.getNumber()));
            viewSolution.setName(child.getName());
            viewSolution.setParentId(parentId);
            viewSolution.setLevel(level);
            viewSolution.setType(type);
            if (child.getData() != null) {
                if (type.compareTo("0") == 0) {
                    viewSolution.setDataSetId(child.getId());
                    viewSolution.setBizScopeId(this.getBizModelByDataSet(modelCache, child.getId()));
                } else {
                    Map data = (Map)child.getData();
                    long datasetId = IDUtils.toLong(data.get("dataset"));
                    viewSolution.setDataSetId(datasetId);
                    viewSolution.setBizScopeId(this.getBizModelByDataSet(modelCache, datasetId));
                }
            }
            viewSolutions.add(viewSolution);
            if (child.getChildren() == null) continue;
            viewSolutions.addAll(this.getChildrenSolutions(viewSolution, child.getChildren(), modelId));
        }
        return viewSolutions;
    }

    private Long getBizModelByDataSet(IModelCacheHelper modelCache, Long dataSetId) {
        return modelCache.getBusModelByDataSet(dataSetId);
    }
}

