/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.reportQuery;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolution;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.AdHocSolutionDimMember;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.ExcelApiOutput;
import kd.epm.eb.formplugin.excel.excelEntity.reportQuery.ExcelReportTypeEntity;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryCommon;
import kd.epm.eb.formplugin.excel.reportQuery.ExcelReportQueryDesigner;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.cache.TemplateCache;

public class ExcelReportQuerySchema {
    private static String FORM_EB_REPORTNOTE = "eb_reportquery";
    private static String FORM_EB_REPORTSHARE = "eb_reportshare";
    private static String FORM_EB_REPORTCATALOG = "eb_reportcatalog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AdHocSolution> getSolutionList(Map<String, Object> param) {
        Long modelId = (Long)param.get(ExcelReportQueryCommon.KEY_MODELID);
        Long solutionId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_SOLUTIONIDS));
        Long reportCatalogId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_CATALOGID));
        boolean isShare = (Boolean)param.get("share");
        String formId = FORM_EB_REPORTNOTE;
        String selectFields = "id,number solutionnumber,name solutionname,dataset.id,reportcatalog.id,description,data";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        if (isShare) {
            formId = FORM_EB_REPORTSHARE;
            selectFields = "id,number solutionnumber,name solutionname,dataset.id,reportcatalog,description,data";
            qFilters.add(new QFilter("modelid_id", "=", (Object)modelId));
            if (reportCatalogId.compareTo(0L) > 0) {
                qFilters.add(new QFilter("reportcatalog", "=", (Object)reportCatalogId));
            }
        } else {
            qFilters.add(new QFilter("model_id", "=", (Object)modelId));
            if (reportCatalogId.compareTo(0L) > 0) {
                qFilters.add(new QFilter("reportcatalog_id", "=", (Object)reportCatalogId));
            }
            qFilters.add(new QFilter("creator_id", "=", (Object)RequestContext.get().getCurrUserId()));
        }
        if (solutionId.compareTo(0L) > 0) {
            qFilters.add(new QFilter("id", "=", (Object)solutionId));
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        ArrayList<AdHocSolution> solutions = new ArrayList<AdHocSolution>(16);
        if (doc.size() == 0) {
            return solutions;
        }
        Map<Long, ExcelReportTypeEntity> reportType = ExcelReportQuerySchema.getReportType(modelId);
        int i = 1;
        Long reportcatalogid = 0L;
        try {
            for (DynamicObject dyObject : doc) {
                AdHocSolution solution = new AdHocSolution();
                reportcatalogid = isShare ? Long.valueOf(dyObject.getLong("reportcatalog")) : Long.valueOf(dyObject.getLong("reportcatalog.id"));
                String type = reportcatalogid.compareTo(ExcelReportQueryCommon.reportCatalogId) == 0 ? "2" : "0";
                solution.setModelId(modelId);
                solution.setId(dyObject.getLong("id"));
                solution.setNumber(dyObject.getString("solutionnumber"));
                solution.setName(dyObject.getString("solutionname"));
                solution.setDseq(i++);
                solution.setScope(0);
                solution.setExplanation(dyObject.getString("description"));
                solution.setType(type);
                solution.setDataSetId(dyObject.getLong("dataset.id"));
                solution.setExcelReportType(reportType == null ? new ExcelReportTypeEntity() : reportType.get(reportcatalogid));
                if (solutionId.compareTo(0L) > 0) {
                    solution.setDimMembers(ExcelReportQuerySchema.getRowColPageMembers(modelId, solution.getId(), solution.getDataSetId(), solution.getType(), dyObject.getString("data")));
                }
                solutions.add(solution);
            }
        }
        finally {
            TemplateCache.remove();
        }
        return solutions;
    }

    private static Map<Long, ExcelReportTypeEntity> getReportType(Long modelId) {
        HashMap<Long, ExcelReportTypeEntity> returns = new HashMap<Long, ExcelReportTypeEntity>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)FORM_EB_REPORTCATALOG, (String)"id,number,name,sequence,parent.id,parent.number,parent.name ", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence");
        for (DynamicObject dyObject : doc) {
            ExcelReportTypeEntity reportType = new ExcelReportTypeEntity();
            reportType.setCatalogId(dyObject.getLong("id"));
            reportType.setCatalogNumber(dyObject.getString("number"));
            reportType.setCatalogName(dyObject.getString("name"));
            reportType.setCatalogParentId(dyObject.getLong("parent.id"));
            reportType.setSequence(dyObject.getInt("sequence"));
            returns.put(dyObject.getLong("id"), reportType);
        }
        returns.put(ExcelReportQueryCommon.reportCatalogId, ExcelReportQuerySchema.getClientReportType());
        return returns;
    }

    public static ExcelReportTypeEntity getClientReportType() {
        ExcelReportTypeEntity reportType = new ExcelReportTypeEntity();
        reportType.setCatalogId(ExcelReportQueryCommon.reportCatalogId);
        reportType.setCatalogNumber(ExcelReportQueryCommon.KEY_EXCELREPORTTYPE);
        reportType.setCatalogName(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef", (String)"ExcelReportQuerySchema_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        reportType.setCatalogParentId(0L);
        reportType.setSequence(1);
        return reportType;
    }

    private static List<AdHocSolutionDimMember> getRowColPageMembers(Long modelId, Long schemId, Long dataSetId, String type, String templatemodelStr) {
        switch (type) {
            case "0": {
                return ExcelReportQuerySchema.parseTempateModel(modelId, schemId, dataSetId, templatemodelStr);
            }
            case "2": {
                return JSONObject.parseArray((String)templatemodelStr, AdHocSolutionDimMember.class);
            }
        }
        return null;
    }

    private static List<AdHocSolutionDimMember> parseTempateModel(Long modelId, Long schemId, Long dataSetId, String templatemodelStr) {
        ArrayList<AdHocSolutionDimMember> rowColPageMembers = new ArrayList<AdHocSolutionDimMember>(16);
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templatemodelStr);
        if (templateModel == null) {
            return rowColPageMembers;
        }
        return new ExcelReportQueryDesigner(modelId.toString(), dataSetId.toString(), templatemodelStr).loadDimsInfoByTemplateModel(templateModel);
    }

    public static List<AdHocSolutionDimMember> getSolutionDimMembers(Map<String, Object> param) {
        return new ExcelReportQueryDesigner().getSolutionDimMembers(param);
    }

    private static void setSolutionObj(DynamicObject solutionDyobj, Map<String, Object> solution) {
        Long modelId = IDUtils.toLong((Object)solution.get(ExcelReportQueryCommon.KEY_MODELID));
        String solutionNumber = solution.get(ExcelReportQueryCommon.KEY_SOLUTIONNUMBER).toString();
        String solutionName = solution.get(ExcelReportQueryCommon.KEY_SOLUTIONNAME).toString();
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        if (solutionDyobj.getLong("id") == 0L) {
            solutionDyobj.set("model", (Object)modelId);
            solutionDyobj.set("name", (Object)solutionName);
            solutionDyobj.set("number", (Object)solutionNumber);
            solutionDyobj.set("creator", (Object)userId);
            solutionDyobj.set("createtime", (Object)now);
            solutionDyobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            solutionDyobj.set("description", (Object)solution.get(ExcelReportQueryCommon.KEY_EXPLANATION).toString());
            solutionDyobj.set("dataset", (Object)IDUtils.toLong((Object)solution.get(ExcelReportQueryCommon.KEY_DATASETID)));
            solutionDyobj.set("reportcatalog", (Object)ExcelReportQueryCommon.reportCatalogId);
        }
        solutionDyobj.set("data", solution.get(ExcelReportQueryCommon.KEY_DIMMEMBERS));
        solutionDyobj.set("modifier", (Object)userId);
        solutionDyobj.set("modifytime", (Object)now);
    }

    public static ExcelApiOutput saveSolution(Map<String, Object> solution) {
        Long modelId = IDUtils.toLong((Object)solution.get(ExcelReportQueryCommon.KEY_MODELID));
        Long solutionId = IDUtils.toLong((Object)solution.get(ExcelReportQueryCommon.KEY_SOLUTIONIDS));
        String solutionName = solution.get(ExcelReportQueryCommon.KEY_SOLUTIONNAME).toString();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (solutionId == 0L) {
            qf.and("name", "=", (Object)solutionName);
            qf.and("creator_id", "=", (Object)RequestContext.get().getCurrUserId());
            if (QueryServiceHelper.exists((String)FORM_EB_REPORTNOTE, (QFilter[])qf.toArray())) {
                return new ExcelApiOutput(false, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ExcelReportQuerySchema_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject solutionDyobj = BusinessDataServiceHelper.newDynamicObject((String)FORM_EB_REPORTNOTE);
            ExcelReportQuerySchema.setSolutionObj(solutionDyobj, solution);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{solutionDyobj});
            solutionId = solutionDyobj.getLong("id");
        } else {
            DynamicObject solutionDyobj = BusinessDataServiceHelper.loadSingle((Object)solutionId, (String)FORM_EB_REPORTNOTE);
            ExcelReportQuerySchema.setSolutionObj(solutionDyobj, solution);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{solutionDyobj});
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58\u65b9\u6848", "ExcelReportQuerySchema_2", "epm-eb-formplugin");
        MultiLangEnumBridge opDescribe = new MultiLangEnumBridge("%1$s\u4fdd\u5b58\u6210\u529f", "ExcelReportQuerySchema_3", "epm-eb-formplugin");
        ExcelReportQuerySchema.writeLog(modelId, "save", opName, opDescribe, new String[]{solutionName});
        return new ExcelApiOutput(solutionId);
    }

    public static ExcelApiOutput deleteSolution(Map<String, Object> param) {
        Long modelId = IDUtils.toLong((Object)param.get(ExcelReportQueryCommon.KEY_MODELID));
        List solutionIds = (List)param.get(ExcelReportQueryCommon.KEY_SOLUTIONIDS);
        QFilter qFilter1 = new QFilter("model_id", "=", (Object)modelId);
        QFilter qFilter2 = new QFilter("id", "in", (Object)solutionIds);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)FORM_EB_REPORTNOTE, (String)"id, number,name", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_EB_REPORTNOTE), (Object[])solutionIds.toArray());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u65b9\u6848", "ExcelReportQuerySchema_0", "epm-eb-formplugin");
        MultiLangEnumBridge description = new MultiLangEnumBridge("%1$s\u5220\u9664\u6210\u529f", "ExcelReportQuerySchema_1", "epm-eb-formplugin");
        for (DynamicObject dy : dos) {
            ExcelReportQuerySchema.writeLog(modelId, "delete", opName, description, new String[]{dy.getString("name")});
        }
        return new ExcelApiOutput(true);
    }

    private static void writeLog(long modelId, String opKey, MultiLangEnumBridge opName, MultiLangEnumBridge opDescription, String[] opArgs) {
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)"EPM", (String)FORM_EB_REPORTNOTE, null, (String)opKey, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])opArgs);
        OperationLogUtil.log((AppLogInfo)logInfo);
    }
}

