/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.submit;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.excelEntity.submit.ExcelReportSubMitParams;
import kd.epm.eb.formplugin.excel.report.ExcelDynamicReportProcess;
import kd.epm.eb.formplugin.excel.report.ExcelFixReportProcess;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.submit.ExcelCommitCommandBGMTask;
import kd.epm.eb.formplugin.excel.submit.ExcelCommitCommandBGMTaskOrg;
import kd.epm.eb.formplugin.excel.submit.ExcelReportSubMitCommon;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;

public class ExcelBgTaskExecutePlugin
extends BgTaskExecutePlugin {
    private ExcelSpreadContainer spreadContainer;
    private ExcelReportSubMitParams reportSubmitParams;
    private ExcelOpenReportParams openReportParams;
    private static final Log log = LogFactory.getLog(ExcelBgTaskExecutePlugin.class);

    public ExcelReportSubMitParams getReportSubmitParams() {
        return this.reportSubmitParams;
    }

    public void setReportSubmitParams(ExcelReportSubMitParams reportSubmitParams) {
        this.reportSubmitParams = reportSubmitParams;
    }

    public ExcelBgTaskExecutePlugin(ExcelSpreadContainer spreadContainer, ExcelReportSubMitParams reportSubmitParams, ExcelOpenReportParams openReportParams) {
        this.spreadContainer = spreadContainer;
        this.reportSubmitParams = reportSubmitParams;
        this.openReportParams = openReportParams;
    }

    @Override
    public ITemplateModel getTemplateModel() {
        ITemplateModel templateModel = super.getTemplateModel();
        templateModel.setModelId(this.openReportParams == null ? null : Long.valueOf(this.openReportParams.getBaseInfo().getModelId()));
        return templateModel;
    }

    @Override
    public AbstractReportPlugin getReportProcessPlugin() {
        if (this.abstractReportPlugin == null) {
            String rpt_type = null;
            rpt_type = this.getPageCache().get("current_rpt_type");
            if (rpt_type == null) {
                return null;
            }
            if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(rpt_type)) {
                this.abstractReportPlugin = new ExcelDynamicReportProcess(this.openReportParams, this.spreadContainer);
            } else if (BgTemplateTypeEnum.EBFIX.getNumber().equals(rpt_type)) {
                this.abstractReportPlugin = new ExcelFixReportProcess(this.openReportParams, this.spreadContainer);
            }
        }
        this.abstractReportPlugin.getPageCache().put("sourceFrom", "excel");
        return this.abstractReportPlugin;
    }

    @Override
    public void fireCurrTreeNodeClick() {
    }

    @Override
    protected void showExamineReportListPanel(boolean isShowExamineReportListPanel) {
    }

    @Override
    protected void afterCancelCommit() {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BgApplySplitBillPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected Set<Long> getTaskIds() {
        HashSet<Long> returns = new HashSet<Long>(16);
        HashSet taskListIds = new HashSet(16);
        HashSet subTaskNumbers = new HashSet(16);
        if (this.reportSubmitParams != null) {
            List<ExcelReportList> reportLists = this.reportSubmitParams.getExcelReportLists();
            if (reportLists != null) {
                reportLists.forEach(e -> taskListIds.add(e.getBaseInfo().getParentId()));
                reportLists.forEach(e -> {
                    if (e.getBaseInfo().getSubTaskNumber() != null) {
                        subTaskNumbers.add(e.getBaseInfo().getSubTaskNumber());
                    }
                });
            }
            log.info("submitReport_ExcelsubTask_number:" + JSON.toJSONString(subTaskNumbers));
            QFBuilder qfBuilder = new QFBuilder("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
            if (taskListIds != null && taskListIds.size() > 0) {
                qfBuilder.add(new QFilter("tasklist.id", "in", taskListIds));
            }
            if (subTaskNumbers != null && subTaskNumbers.size() > 0) {
                qfBuilder.add(new QFilter("number", "in", subTaskNumbers));
            }
            if (qfBuilder.size() > 0) {
                Map tasks = BusinessDataServiceHelper.loadFromCache((String)"eb_task", (String)"id", (QFilter[])qfBuilder.toArray());
                tasks.values().forEach(obj -> returns.add(obj.getLong("id")));
            }
        }
        log.info("submitReport_ExcelsubTask:" + JSON.toJSONString(returns));
        return returns;
    }

    @Override
    protected ExcelCommitCommandBGMTask getCommitPlugin(String key) {
        return new ExcelCommitCommandBGMTask(this.reportSubmitParams);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        this.getPageCache().remove("isexcelkip");
        this.getPageCache().put("sourceFrom", "excel");
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "orgcommit": {
                if (!this.orgCommitCheck()) break;
                ExcelReportSubMitCommon.getOrgCommitAuditName(this.getModelId(), this.spreadContainer);
                new ExcelCommitCommandBGMTaskOrg(this.reportSubmitParams).execute(this);
            }
        }
        if ("1".equals(this.getPageCache().get("isexcelkip"))) {
            this.spreadContainer.getOperateMaps().put("isexcelkip", this.getPageCache().get("isexcelkip"));
        }
    }

    private boolean orgCommitCheck() {
        return true;
    }
}

