/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.submit;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.excelEntity.submit.ExcelReportSubMitParams;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.submit.ExcelReportSubmitEnum;
import kd.epm.eb.formplugin.excel.submit.ExcelSubMitFormView;

public class ExcelReportSubMitCommon {
    public static IFormView iniFormView(String pageCacheId, String formId, ExcelSpreadContainer spreadContainer) {
        FormShowParameter params = new FormShowParameter();
        params.setPageId(pageCacheId);
        params.setAppId("bgm");
        FormConfig cfg = new FormConfig();
        cfg.setEntityTypeId(formId);
        params.setFormConfig(cfg);
        ExcelSubMitFormView fv = new ExcelSubMitFormView(spreadContainer);
        fv.addService(IPageCache.class, new PageCache(pageCacheId));
        fv.initialize(params);
        return fv;
    }

    public Collection<ApproveBillRptTemp> getBGMSelectedTempRPTFromViewBatch(ExcelReportSubMitParams reportSubmitParams) {
        ArrayList<ApproveBillRptTemp> returns = new ArrayList<ApproveBillRptTemp>(16);
        List<ExcelReportList> excelReportLists = reportSubmitParams == null ? null : reportSubmitParams.getExcelReportLists();
        Map<String, Long> subTaskIds = this.getSubTaskIds(excelReportLists);
        if (excelReportLists != null && excelReportLists.size() > 0) {
            for (ExcelReportList excelReportList : excelReportLists) {
                Long subTaskId = subTaskIds.get(excelReportList.getBaseInfo().getSubTaskNumber());
                ApproveBillRptTemp rptTemp = new ApproveBillRptTemp();
                rptTemp.setOrgId(Long.valueOf(excelReportList.getBaseInfo().getOrgId()));
                rptTemp.setRptId(Long.valueOf(excelReportList.getBaseInfo().getProcessId()));
                rptTemp.setRptType(excelReportList.getBaseInfo().getReportType());
                rptTemp.setSubTaskId(subTaskId);
                rptTemp.setTaskListId(Long.valueOf(excelReportList.getBaseInfo().getParentId()));
                rptTemp.setTempId(Long.valueOf(excelReportList.getBaseInfo().getTemplateId()));
                rptTemp.setTempName(excelReportList.getBaseInfo().getTemplateName());
                rptTemp.setTempNumber(excelReportList.getBaseInfo().getTemplateNumber());
                returns.add(rptTemp);
            }
        }
        return returns;
    }

    private Map<String, Long> getSubTaskIds(List<ExcelReportList> excelReportLists) {
        Set taskProcessIds;
        QFilter qFilterT;
        DynamicObjectCollection query;
        HashMap<String, Long> returns = new HashMap<String, Long>(16);
        HashSet<String> subTaskNums = new HashSet<String>(16);
        if (excelReportLists != null && excelReportLists.size() > 0) {
            for (ExcelReportList reportList : excelReportLists) {
                String subTaskNum = reportList.getBaseInfo().getSubTaskNumber();
                if (subTaskNum == null) continue;
                subTaskNums.add(subTaskNum);
            }
        }
        if (excelReportLists != null && subTaskNums.size() > 0 && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"task,task.number", (QFilter[])(qFilterT = new QFilter("id", "in", taskProcessIds = excelReportLists.stream().map(e -> e.getBaseInfo().getTaskProcessId()).collect(Collectors.toSet()))).toArray())))) {
            for (DynamicObject object : query) {
                returns.put(object.getString("task.number"), object.getLong("task"));
            }
        }
        return returns;
    }

    public Map<String, Object> getSelectNodes(List<ExcelReportList> excelReportLists, ExcelReportSubmitEnum submitType) {
        HashMap<String, Object> returns = new HashMap<String, Object>(5);
        if (excelReportLists != null && excelReportLists.size() > 0) {
            ExcelReportList excelReportList = excelReportLists.get(0);
            returns.put("id", submitType == ExcelReportSubmitEnum.TASKORG ? StringUtils.join((Object[])new Serializable[]{Long.valueOf(excelReportList.getBaseInfo().getParentId()), "_", Long.valueOf(excelReportList.getBaseInfo().getOrgId()), "_2"}) : Long.valueOf(excelReportList.getBaseInfo().getOrgId()));
            returns.put("text", excelReportList.getBaseInfo().getOrgNumber());
        }
        return returns;
    }

    public static void getOrgCommitAuditName(Long modelId, ExcelSpreadContainer spreadContainer) {
        String auditName = "";
        JSONObject paramMap = ParamQueryServiceHelper.getJSON((long)modelId, (ParamEnum)ParamEnum.BG011);
        if (Objects.nonNull(paramMap) && paramMap.getBoolean("datalockswitch").booleanValue()) {
            Long audittrail = paramMap.getLong("audittrail");
            Member member = ModelCacheContext.getOrCreate((Long)modelId).getMember("AuditTrail", Long.valueOf(0L), audittrail);
            if (member != null) {
                auditName = member.getName();
            }
            spreadContainer.getOperateMaps().put("orgCommitAuditName", auditName);
        }
    }
}

