/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.submit;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelOpenReportParams;
import kd.epm.eb.formplugin.excel.excelEntity.report.ExcelReportList;
import kd.epm.eb.formplugin.excel.excelEntity.submit.ExcelDimRangeUserInfo;
import kd.epm.eb.formplugin.excel.excelEntity.submit.ExcelReportSubMitParams;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.excel.submit.ExcelBgTaskExecutePlugin;
import kd.epm.eb.formplugin.excel.submit.ExcelDimRangeSelect;
import kd.epm.eb.formplugin.excel.submit.ExcelReportPreparationListPlugin;
import kd.epm.eb.formplugin.excel.submit.ExcelReportSubMitCommon;
import kd.epm.eb.formplugin.excel.submit.ExcelReportSubmitEnum;
import kd.epm.eb.formplugin.excel.submit.ExcelSubMitIDataModel;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;

public class ExcelReportSubMitHelper
implements BgTaskExecuteConstant {
    protected static final Log log = LogFactory.getLog(ExcelReportSubMitHelper.class);

    public LinkedHashMap<String, Object> doOperate(ExcelReportSubMitParams reportSubmitParams, ExcelOpenReportParams excelOpenReportParams) {
        if (reportSubmitParams == null) {
            return null;
        }
        ExcelSpreadContainer spreadContainer = new ExcelSpreadContainer();
        ExcelReportSubmitEnum submitEnum = ExcelReportSubmitEnum.getEnumByIndex(reportSubmitParams.getSubmitType());
        IBgTaskExecutePlugin plugin = this.getIniPlugin(submitEnum, spreadContainer, reportSubmitParams, excelOpenReportParams);
        log.info("submitReport_doOperate_reportSubmitParams:" + JSON.toJSONString((Object)reportSubmitParams));
        log.info("submitReport_doOperate_excelOpenReportParams:" + JSON.toJSONString((Object)excelOpenReportParams));
        if (plugin != null) {
            ItemClickEvent event = new ItemClickEvent((Object)plugin, reportSubmitParams.getBtnName(), "");
            String btnName = reportSubmitParams.getBtnName();
            if ("commit".equals(btnName)) {
                plugin.getReportProcessPlugin().setModified(false);
            }
            plugin.itemClick(event);
            if ("commit".equals(btnName) || "cancelcommit".equals(btnName) || "orgcommit".equals(btnName) || "btn_batchcommit".equals(btnName)) {
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u63d0\u4ea4", "ApproveBillListPlugin_21", "epm-eb-formplugin");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6210\u529f", "ApproveBillListPlugin_32", "epm-eb-formplugin");
                if ("cancelcommit".equals(btnName)) {
                    opName = new MultiLangEnumBridge("\u64a4\u9500", "ApproveBillListPlugin_24", "epm-eb-formplugin");
                } else if ("orgcommit".equals(btnName)) {
                    opName = new MultiLangEnumBridge("\u6309\u7ec4\u7ec7\u63d0\u4ea4", "ApproveBillListPlugin_31", "epm-eb-formplugin");
                }
                if ("btn_batchcommit".equals(btnName) && reportSubmitParams.getExcelReportLists() != null) {
                    opDescription = new MultiLangEnumBridge();
                    opDescription.setDescription(reportSubmitParams.getExcelReportLists().stream().map(e -> e.getBaseInfo().getTemplateName()).collect(Collectors.toSet()) + "");
                } else if ("orgcommit".equals(btnName) && reportSubmitParams.getExcelReportLists() != null) {
                    opDescription = new MultiLangEnumBridge();
                    opDescription.setDescription(reportSubmitParams.getExcelReportLists().stream().map(e -> e.getBaseInfo().getOrgNumber()).collect(Collectors.toSet()) + "");
                } else if (excelOpenReportParams != null && excelOpenReportParams.getBaseInfo() != null) {
                    opDescription = new MultiLangEnumBridge();
                    opDescription.setDescription(excelOpenReportParams.getBaseInfo().getTemplateName());
                }
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)ApplicationTypeEnum.BGM.getAppnum(), (String)"eb_approvebill", null, null, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
                OperationLogUtil.log((AppLogInfo)logInfo);
            }
        }
        return spreadContainer.getOperateMaps();
    }

    public LinkedHashMap<String, Object> doSubMit(ApproveBillSubMitInfo rptinfo) {
        return new ExcelDimRangeSelect().doSubMit(rptinfo).getOperateMaps();
    }

    public ExcelDimRangeUserInfo getSubmitUserInfo(IFormView view, boolean mainJob) {
        ExcelSubMitIDataModel model = new ExcelSubMitIDataModel();
        DynamicObject companyInfos = this.getSubmitUserInfo();
        if (companyInfos == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7533\u8bf7\u4eba\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"BasicInfoHelper_5", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Map userInfos = BasicInfoHelper.setFormInfo((IDataModel)model, (IFormView)view, (boolean)mainJob, (DynamicObject)companyInfos);
        ExcelDimRangeUserInfo returns = new ExcelDimRangeUserInfo();
        ArrayList<ExcelDimRangeUserInfo.ExcelDimRangeUserInfoEntry> userInfoEntrys = new ArrayList<ExcelDimRangeUserInfo.ExcelDimRangeUserInfoEntry>(6);
        returns.setUserInfoEntry(userInfoEntrys);
        if (userInfos != null) {
            for (Map.Entry userInfo : userInfos.entrySet()) {
                Object entryValue = userInfo.getValue();
                switch ((String)userInfo.getKey()) {
                    case "department": {
                        DynamicObject departMent = (DynamicObject)entryValue;
                        returns.setDeptId(departMent.getLong("id"));
                        returns.setDeptNumber(departMent.getString("number"));
                        returns.setDeptName(departMent.getString("name"));
                        break;
                    }
                    case "position": {
                        returns.setPosition((String)entryValue);
                        break;
                    }
                    case "company": {
                        Map company = (Map)entryValue;
                        returns.setCompId((Long)company.get("id"));
                        returns.setCompNumber((String)company.get("number"));
                        returns.setCompName((String)company.get("name"));
                    }
                }
            }
        }
        Map userPics = UserServiceHelper.getUserAvatarPath(Collections.singletonList(UserUtils.getUserId()), (boolean)true);
        returns.setUserPicsUrl((String)userPics.get(UserUtils.getUserId()));
        DynamicObjectCollection userEntrys = companyInfos.getDynamicObjectCollection("entryentity");
        if (userEntrys != null && userEntrys.size() > 0) {
            DynamicObject department = null;
            DynamicObject orgstructure = null;
            for (DynamicObject userEntry : userEntrys) {
                ExcelDimRangeUserInfo.ExcelDimRangeUserInfoEntry userInfoEntry = new ExcelDimRangeUserInfo.ExcelDimRangeUserInfoEntry();
                department = userEntry.getDynamicObject("dpt");
                orgstructure = userEntry.getDynamicObject("orgstructure");
                userInfoEntry.setCompanyId(orgstructure == null ? 0L : orgstructure.getLong("id"));
                userInfoEntry.setCompanyName(orgstructure == null ? "" : orgstructure.getString("name"));
                userInfoEntry.setCompanyNummber(orgstructure == null ? "" : orgstructure.getString("number"));
                userInfoEntry.setDepartmentId(department == null ? 0L : department.getLong("id"));
                userInfoEntry.setDepartmentName(department == null ? "" : department.getString("name"));
                userInfoEntry.setDepartmentNummber(department == null ? "" : department.getString("number"));
                userInfoEntry.setDepartmentFullName(orgstructure == null ? "" : orgstructure.getString("fullname"));
                userInfoEntry.setIspartjob(userEntry.getBoolean("ispartjob") ? 1 : 0);
                userInfoEntry.setPosition(userEntry.getString("position"));
                userInfoEntry.setIsIncharge(userEntry.getBoolean("isincharge") ? 1 : 0);
                userInfoEntry.setIsChecked(IDUtils.equals((Object)userInfoEntry.getDepartmentId(), (Object)returns.getDeptId()) ? 1 : 0);
                userInfoEntrys.add(userInfoEntry);
            }
        }
        return returns;
    }

    private DynamicObject getSubmitUserInfo() {
        String selectFields = "id,number,name,phone,entryentity.dpt,entryentity.orgstructure,entryentity.fullname,entryentity.position,entryentity.ispartjob,entryentity.isincharge";
        return BusinessDataServiceHelper.loadSingleFromCache((Object)UserUtils.getUserId(), (String)"bos_user", (String)selectFields);
    }

    private IBgTaskExecutePlugin getIniPlugin(ExcelReportSubmitEnum submitType, ExcelSpreadContainer spreadContainer, ExcelReportSubMitParams reportSubmitParams, ExcelOpenReportParams excelOpenReportParams) {
        AbstractListPlugin plugin = null;
        String formId = null;
        switch (submitType) {
            case TASK: 
            case TASKORG: {
                plugin = new ExcelBgTaskExecutePlugin(spreadContainer, reportSubmitParams, excelOpenReportParams);
                formId = "eb_executetask";
                break;
            }
            case REPORT: 
            case REPORTORG: {
                plugin = new ExcelReportPreparationListPlugin(spreadContainer, reportSubmitParams, excelOpenReportParams);
                formId = "bgm_rptpreparation";
                break;
            }
            default: {
                return null;
            }
        }
        plugin.setView(ExcelReportSubMitCommon.iniFormView(StringUtils.isNotNull((String)reportSubmitParams.getPageCacheId()) ? reportSubmitParams.getPageCacheId() : ExcelApiCommon.getPageCacheId(formId), formId, spreadContainer));
        this.initPageCache((IBgTaskExecutePlugin)((Object)plugin), reportSubmitParams);
        return plugin;
    }

    private void initPageCache(IBgTaskExecutePlugin plugin, ExcelReportSubMitParams reportSubmitParams) {
        IPageCache pageCache = plugin.getView().getPageCache();
        List<ExcelReportList> excelReportLists = reportSubmitParams.getExcelReportLists();
        if (excelReportLists != null && excelReportLists.size() > 0) {
            ExcelReportList excelReportList = excelReportLists.get(0);
            pageCache.put("KEY_MODEL_ID", Long.toString(excelReportList.getBaseInfo().getModelId()));
            pageCache.put("current_task", "");
            pageCache.put("current_taskp", Long.toString(excelReportList.getBaseInfo().getParentId()));
            pageCache.put("subtaskid", "");
            pageCache.put("current_report_id", Long.toString(excelReportList.getBaseInfo().getProcessId()));
            pageCache.put("current_org", Long.toString(excelReportList.getBaseInfo().getOrgId()));
            pageCache.put("current_rpt", Long.toString(excelReportList.getBaseInfo().getTemplateId()));
            pageCache.put("current_processid", Long.toString(excelReportList.getBaseInfo().getTaskProcessId()));
            pageCache.put("current_rpt_type", excelReportList.getBaseInfo().getReportType());
            pageCache.put("CURRENT_ORG_VIEW", Long.toString(excelReportList.getBaseInfo().getOrgViewId()));
            pageCache.put("currentOrgViewId", Long.toString(excelReportList.getBaseInfo().getOrgViewId()));
            Map<String, String> dimFilterParams = reportSubmitParams.getDimFilterParams();
            if (dimFilterParams != null) {
                pageCache.put("CURRENT_DATATYPE", dimFilterParams.get("CURRENT_DATATYPE"));
                pageCache.put("CURRENT_PERIOD", dimFilterParams.get("CURRENT_PERIOD"));
                pageCache.put("CURRENT_VERSION", dimFilterParams.get("CURRENT_VERSION"));
                pageCache.put("CURRENT_DATATYPE_NUMBER", dimFilterParams.get("CURRENT_DATATYPE_NUMBER"));
                pageCache.put("CURRENT_PERIOD_NUMBER", dimFilterParams.get("CURRENT_PERIOD_NUMBER"));
                pageCache.put("CURRENT_VERSION_NUMBER", dimFilterParams.get("CURRENT_VERSION_NUMBER"));
            }
            pageCache.put("select_org", excelReportList.getBaseInfo().getOrgNumber());
            pageCache.put("filterCache", "notsubmittednum");
            pageCache.put("schemeId", Long.toString(excelReportList.getBaseInfo().getParentId()));
        }
    }
}

