/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.excel.submit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.approveBill.MetricNotNullCheckUtils;
import kd.epm.eb.formplugin.excel.ExcelApiCommon;
import kd.epm.eb.formplugin.excel.ExcelFormView;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;

public class ExcelSubMitFormView
extends ExcelFormView {
    public ExcelSubMitFormView(ExcelSpreadContainer spreadContainer) {
        super(spreadContainer);
    }

    public void showOperationResult(OperationResult result) {
        this.putMessage(ExcelApiCommon.KEY_ERROR, this.getErrorInfo(result));
    }

    private String getErrorInfo(OperationResult result) {
        ValidateResultCollection errInfos2;
        StringBuilder str = new StringBuilder();
        str.append(result.getMessage() == null ? "" : result.getMessage());
        List errInfos = result.getAllErrorInfo();
        if (errInfos.size() > 0) {
            for (OperateErrorInfo errInfo : errInfos) {
                str.append(errInfo.getMessage()).append("\n");
            }
        }
        if ((errInfos2 = result.getValidateResult()) != null && errInfos2.getValidateErrors() != null) {
            for (ValidateResult errInfo : errInfos2.getValidateErrors()) {
                List _errinfos2 = errInfo.getAllErrorInfo();
                if (_errinfos2 == null || _errinfos2.size() <= 0) continue;
                _errinfos2.forEach(e -> str.append(e.getMessage()).append("\n"));
            }
        }
        return str.toString();
    }

    public void showForm(FormShowParameter param) {
        String formid = param.getFormId().toLowerCase(Locale.getDefault());
        this.spreadContainer.getOperateMaps().put("formid", formid);
        switch (formid) {
            case "bos_operationresult": {
                this.spreadContainer.getOperateMaps().put("pkNumbers", param.getCustomParam("pkNumbers"));
                this.spreadContainer.getOperateMaps().put("errorMsg", param.getCustomParam("errorMsg"));
                break;
            }
            case "bgm_dimrangeselect": {
                this.spreadContainer.getOperateMaps().put("selectOrg", param.getCustomParam("select_org"));
                this.spreadContainer.getOperateMaps().put("submitType", param.getCustomParam("submitType"));
                this.spreadContainer.getOperateMaps().put("rptinfo", ObjectSerialUtil.deSerializedBytes((String)((String)param.getCustomParam("rptinfo"))));
                break;
            }
            case "eb_metric_notmullcheck": {
                List<Map<String, Object>> result = MetricNotNullCheckUtils.getExcelCheckResult(param);
                this.spreadContainer.getOperateMaps().put("checkResult", result);
            }
        }
    }

    public void showMessage(String arg0) {
        this.spreadContainer.getOperateMaps().put("Error", arg0);
    }

    public void returnDataToParent(Object obj) {
        this.spreadContainer.getOperateMaps().put("Suc", "sucs");
    }

    public void close() {
    }
}

