/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.dataSet.BusinessModel;
import kd.epm.eb.common.execanalyse.AnalyseType;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.formplugin.executeanalyse.entity.BizModel;

public interface AnalyseCommonMethod {
    default public TreeNode getRootNode(Long modelId, IFormView view) {
        TreeNode root = new TreeNode();
        AnalyseType all = AnalyseType.ALL;
        root.setId(all.getValue());
        root.setParentid("");
        root.setText(all.getDesc());
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        root.setChildren(children);
        this.addAnalyseNodes(children);
        if (NewEbAppUtil.isNewEbApp((IFormView)view) || NewEbAppUtil.isNewEbModel((Long)modelId)) {
            return root;
        }
        List<BizModel> bizModels = this.getBizModels(null, modelId);
        children.forEach(e -> bizModels.forEach(k -> {
            List<BusinessModel> busModels = this.getExistDataBusModels(k.getBusModels(), e.getId());
            if (busModels.size() != 0) {
                this.addNodeToChild((TreeNode)e, (BizModel)k, busModels);
            }
        }));
        return root;
    }

    default public void addNodeToChild(TreeNode node, BizModel bizModel, List<BusinessModel> busModels) {
        String parentId = node.getId();
        ArrayList<TreeNode> children = node.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>(16);
            node.setChildren(children);
        }
        TreeNode bizModelNode = new TreeNode();
        String bizModelNodeId = parentId + "_" + bizModel.getId();
        bizModelNode.setId(bizModelNodeId);
        bizModelNode.setParentid(parentId);
        bizModelNode.setText(bizModel.getName());
        children.add(bizModelNode);
        ArrayList bizChildren = new ArrayList(16);
        bizModelNode.setChildren(bizChildren);
        busModels.forEach(e -> {
            TreeNode busModelNode = new TreeNode();
            busModelNode.setId(bizModelNodeId + "_" + e.getId());
            busModelNode.setParentid(bizModelNodeId);
            busModelNode.setText(e.getName());
            bizChildren.add(busModelNode);
        });
    }

    default public List<BusinessModel> getExistDataBusModels(List<BusinessModel> busModels, String nodeId) {
        ArrayList<BusinessModel> existBusModels = new ArrayList<BusinessModel>(busModels);
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        AnalyseType analyseType = AnalyseType.getEnumByValue((String)nodeId);
        if (AnalyseType.MULTI_DIM == analyseType) {
            busModelIds.addAll(this.getBusModelIdsByMultiDim());
        } else if (AnalyseType.EXECUTE == analyseType) {
            busModelIds.addAll(this.getBusModelIdsByExecute());
        }
        busModels.forEach(e -> {
            long id = e.getId();
            if (!busModelIds.contains(id)) {
                existBusModels.remove(e);
            }
        });
        return existBusModels;
    }

    public List<Long> getBusModelIdsByExecute();

    public List<Long> getBusModelIdsByMultiDim();

    default public void addAnalyseNodes(List<TreeNode> children) {
        TreeNode multiNode = new TreeNode();
        multiNode.setId(AnalyseType.MULTI_DIM.getValue());
        multiNode.setParentid(AnalyseType.ALL.getValue());
        multiNode.setText(AnalyseType.MULTI_DIM.getDesc());
        children.add(multiNode);
        TreeNode executeNode = new TreeNode();
        executeNode.setId(AnalyseType.EXECUTE.getValue());
        executeNode.setParentid(AnalyseType.ALL.getValue());
        executeNode.setText(AnalyseType.EXECUTE.getDesc());
        children.add(executeNode);
    }

    default public List<BizModel> getBizModels(List<Long> bizModelIds, Long modelId) {
        DynamicObjectCollection query;
        ArrayList<BizModel> bizModels = new ArrayList<BizModel>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (bizModelIds != null) {
            qFilter.and("businessmodel", "in", bizModelIds);
        }
        if ((query = QueryServiceHelper.query((String)"eb_dataset", (String)"id, name, number, businessmodel.id, businessmodel.name, businessmodel.number", (QFilter[])new QFilter[]{qFilter})) == null || query.size() == 0) {
            return bizModels;
        }
        query.forEach(e -> {
            Long bizModelId = e.getLong("businessmodel.id");
            BizModel bizModel = this.getBizModel(bizModels, bizModelId);
            if (bizModel == null) {
                bizModel = new BizModel();
                bizModel.setId(bizModelId);
                bizModel.setName(e.getString("businessmodel.name"));
                bizModel.setNumber(e.getString("businessmodel.number"));
                bizModels.add(bizModel);
            }
            BusinessModel businessModel = new BusinessModel();
            businessModel.setId(e.getLong("id"));
            businessModel.setName(e.getString("name"));
            businessModel.setNumber(e.getString("number"));
            bizModel.addBusModel(businessModel);
        });
        return bizModels;
    }

    default public BizModel getBizModel(List<BizModel> bizModels, Long bizModelId) {
        BizModel bizModel = null;
        for (BizModel bizModelIter : bizModels) {
            Long id = bizModelIter.getId();
            if (!bizModelId.equals(id)) continue;
            bizModel = bizModelIter;
            break;
        }
        return bizModel;
    }
}

