/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.executeanalyse.ReportShareHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;

public class DiffAnalyzeSchemePlugin
extends DiffAnalyzePlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        this.handleFormShowParam();
        Long modelId = IDUtils.toLong((Object)this.getCache("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenuap"});
        boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)modelId);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"maincontentpanel"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DiffAnalyzePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("model", (Object)modelId);
            this.setCache("KEY_MODEL_ID", modelId.toString());
            Object analyzeScheme = this.getModel().getValue("analyzescheme");
            if (analyzeScheme != null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
                this.onOffEditSchemeMode(true);
                this.refreshPageViewPanel(true);
                this.refreshSpread();
                this.initBaseData();
            } else {
                if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || newEbModel) {
                    List datasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
                    if (datasets.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u96c6\u4fe1\u606f\u3002", (String)"DiffAnalyzeSchemePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("dataset", (Object)((Dataset)datasets.get(0)).getId());
                }
                this.setControlVisible(true);
                Object dataset = this.getModel().getValue("dataset");
                if (dataset == null) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "btn_bywhichdim"});
                } else {
                    Set<String> schemeDims = this.displaySchemeConfig(this.getDefaultDynamic());
                    this.initSchemeDimpool(schemeDims);
                }
                this.getPageCache().put("isNew", "true");
                this.setControlDraggable();
            }
            if (!CentralAppBillService.getInstance().isModelAdmin(modelId) && !this.checkSharePerm()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"model"});
            this.getView().updateView();
        }
        this.getPageCache().put("isScheme", "true");
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || newEbModel) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataset"});
        }
    }

    private void initBaseData() {
        Object analyzeScheme = this.getModel().getValue("analyzescheme");
        if (analyzeScheme != null) {
            DynamicObject scheme = (DynamicObject)analyzeScheme;
            this.getModel().setValue("name", (Object)scheme.getString("name"));
            this.getModel().setValue("number", (Object)scheme.getString("number"));
            this.getModel().setValue("type", (Object)scheme.getString("type"));
            this.getModel().setValue("status", (Object)scheme.getBoolean("status"));
            this.getModel().setValue("desc", (Object)scheme.getString("desc"));
        }
    }

    @Override
    public void virtualModelCallBack(Object dataInfo) {
        if (this.isEditSchemeMode()) {
            return;
        }
        try {
            if (dataInfo instanceof LinkedHashMap) {
                LinkedHashMap data = (LinkedHashMap)((LinkedHashMap)dataInfo).get("data");
                OlapQuerySync.ViewArea viewArea = new OlapQuerySync.ViewArea(((Integer)data.get("topRow")).intValue(), ((Integer)data.get("bottomRow")).intValue(), ((Integer)data.get("leftCol")).intValue(), ((Integer)data.get("rightCol")).intValue());
                DiffAnalyzeScheme scheme = this.refreshMetas(this.getSchemeConfig());
                if (this.canRefreshCellData(scheme)) {
                    IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
                    spreadManager.getDimemsionViews().putAll(this.getDimensionViews());
                    new RefreshCellDataCommand(viewArea.getStartrow(), viewArea.getEndrow(), scheme, spreadManager).execute(this);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                KDBizException _ex = (KDBizException)((Object)ex);
                String errorCode = _ex.getErrorCode().getCode();
                if (errorCode != null && errorCode.startsWith("EB04")) {
                    this.getView().showErrorNotification(ex.getMessage());
                } else {
                    this.getView().showErrorNotification(ThrowableHelper.getMessage((Exception)ex));
                }
            }
            this.getView().showErrorNotification(ThrowableHelper.toString((Exception)ex));
        }
    }

    @Override
    public boolean isEditSchemeMode() {
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_save".equals(itemKey)) {
            if ("2".equals(this.getModel().getValue("type"))) {
                this.checkPermission("eb_diffanalysis", "share");
            }
            this.saveCurScheme(true);
        } else if ("btn_view".equals(itemKey)) {
            this.viewDiffAnalyse();
        } else if ("btn_exit".equals(itemKey)) {
            Object dataset = this.getValue("dataset", null);
            if (dataset == null) {
                this.getView().close();
            }
        } else if ("btn_share".equals(itemKey)) {
            this.checkPermission("eb_diffanalysis", "btn_share");
        }
    }

    @Override
    protected boolean validescheme() {
        return false;
    }

    private void viewDiffAnalyse() {
        Object analyzeScheme = this.getModel().getValue("analyzescheme");
        if (analyzeScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848", (String)"DiffAnalyzeSchemePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean status = ((DynamicObject)analyzeScheme).getBoolean("status");
        if (!status) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u67e5\u770b\u542f\u7528\u65b9\u6848\u4e0b\u7684\u62a5\u8868\u3002", (String)"ExecuteAnalyseSchemeListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = "eb_diffanalysis";
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam(formShowParameter);
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam("eb_diffanalyzescheme", (Object)((DynamicObject)analyzeScheme).getString("id"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
        formShowParameter.setCustomParam("eb_dataset", (Object)String.valueOf(this.getDatasetId()));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewDiffAnalyse"));
        this.getView().showForm(formShowParameter);
    }

    private void saveCurScheme(Boolean needCheck) {
        long id;
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        DynamicObject ob = this.getModel().getDataEntity();
        DynamicObject dynamicObject = null;
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Object analyzeScheme = this.getModel().getValue("analyzescheme");
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (analyzeScheme == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
            id = DBServiceHelper.genGlobalLongId();
            dynamicObject.set("id", (Object)id);
            HashMap<String, String> oldAndNewIds = new HashMap<String, String>(16);
            for (int i = 0; i < cols.size(); ++i) {
                String colId = ((DynamicObject)cols.get(i)).getString("id");
                oldAndNewIds.put("A" + colId, "A" + colId);
                ((DynamicObject)cols.get(i)).set("id", (Object)colId);
            }
            for (Object col : cols) {
                if (DataRowEnum.CUSTOM.getIndex() != col.getInt("col_type")) continue;
                String expr = col.getString("col_expr");
                if (StringUtils.isNotEmpty((String)expr)) {
                    for (Map.Entry entry : oldAndNewIds.entrySet()) {
                        expr = expr.replaceAll((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                col.set("col_expr", (Object)expr);
            }
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createtime", (Object)now);
        } else {
            id = ((DynamicObject)analyzeScheme).getLong("id");
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_diffanalyzescheme");
            qFilter.and("id", "!=", (Object)id);
        }
        String number = this.getModel().getValue("number").toString();
        String name = this.getModel().getValue("name").toString();
        if (this.checkBeforeSave(analyzeScheme, number, name, needCheck)) {
            return;
        }
        dynamicObject.set("number", (Object)number);
        qFilter.and("number", "=", (Object)number);
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("type", this.getModel().getValue("type"));
        Long modelId = ob.getLong("model.id");
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("dataset", (Object)ob.getLong("dataset.id"));
        dynamicObject.set("status", (Object)ob.getBoolean("status"));
        dynamicObject.set("desc", (Object)ob.getString("desc"));
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        dynamicObject.set("configjson", (Object)DiffAnalyzeHelper.getSchemeConfigJson(this));
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (DynamicObject col : cols) {
            DynamicObject entry = entryentity.addNew();
            Object entryId = col.get("id");
            entry.set("id", entryId);
            entry.set("seq", col.get("seq"));
            entry.set("coltype", col.get("col_type"));
            entry.set("colname", col.get("col_name"));
            entry.set("colconfigjson", (Object)this.getColConfigJson(col));
        }
        DiffAnalyzeHelper.validateSchemeEntity(dynamicObject);
        if (QueryServiceHelper.exists((String)"eb_diffanalyzescheme", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5b58\u5728\u76f8\u540c\u7f16\u7801\u65b9\u6848\u3002", (String)"DiffAnalyzeSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.getModel().setValue("analyzescheme", (Object)dynamicObject.getLong("id"));
        this.getView().updateView("analyzescheme");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DiffAnalyzeSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "DiffAnalyzeSchemePlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "DiffAnalyzeSchemePlugin_3", "epm-eb-formplugin"));
        this.clearCachedSchemeConfig();
        this.resetSpreadManager();
        this.initDimensionViewsFromDataSet();
        this.refreshPageViewPanel(false);
        this.refreshSpread();
        String model = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (!modelId.equals(Long.parseLong(model))) {
            this.getPageCache().put("changeModel", "true");
        } else {
            this.getPageCache().remove("changeModel");
        }
        this.getPageCache().remove("isNew");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
        Set dimNumbers = this.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        for (String dimNumber : dimNumbers) {
            this.getPageCache().remove(dimNumber + "viewId");
        }
    }

    private boolean checkEnjoy(Object analyzeScheme) {
        if (this.getPageCache().get("isNew") == null && analyzeScheme != null) {
            String schemeId = ((DynamicObject)analyzeScheme).getString("id");
            if (schemeId == null) {
                return false;
            }
            if (ReportShareHelper.checkSingleEnjoyed((String)schemeId)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u65b9\u6848\u5c06\u5f71\u54cd\u5df2\u5206\u4eab\u62a5\u8868\u7684\u5c55\u793a\u6837\u5f0f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DiffAnalyzeSchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("modifyConfirm", (IFormPlugin)this));
                return true;
            }
        }
        return false;
    }

    private boolean checkBeforeSave(Object analyzeScheme, String number, String name, Boolean needCheck) {
        if (!needCheck.booleanValue()) {
            return false;
        }
        String result = NumberCheckUtils.checkNumberRule((String)number);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)result)) {
            this.getView().showTipNotification(result);
            return true;
        }
        if (this.checkEnjoy(analyzeScheme)) {
            return true;
        }
        if (name == null || StringUtils.isEmpty((String)name.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7eaf\u7a7a\u683c\u3002", (String)"DiffAnalyzeSchemePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private String getColConfigJson(DynamicObject col) {
        if (col == null) {
            return null;
        }
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        Set<String> schemeDims = this.getSchemeDims();
        Map<String, String> dimCtrlKeyMap = this.getDimCtrlKeyMap();
        Map<String, Long> entryDimensionViews = this.getEntryDimensionViews();
        if (DataRowEnum.DATA.getIndex() == col.getInt("col_type")) {
            for (String key : DiffAnalyzePlugin.getF7KeysCard()) {
                String memNumber;
                String dimNumber = dimCtrlKeyMap.get(key.replaceAll("col_", ""));
                DynamicObject dynamicObject = col.getDynamicObject(key);
                if (dynamicObject != null && (memNumber = dynamicObject.getString("number")) != null) {
                    configMap.put(dimNumber, memNumber);
                    Long viewId = entryDimensionViews.get(dimNumber + "_" + col.getString("id"));
                    if (!IDUtils.isNotNull((Long)viewId)) continue;
                    configMap.put("_DIMVIEW_" + dimNumber, String.valueOf(viewId));
                    continue;
                }
                if (schemeDims == null || !schemeDims.contains(dimNumber)) continue;
                configMap.put(dimNumber, "_SECOND_PAGE");
            }
            if (!StringUtils.isEmpty((String)col.getString("col_periodoffset"))) {
                configMap.put("_PERIOD_OFFSET", col.getString("col_periodoffset").trim().toUpperCase());
            }
        } else if (DataRowEnum.CUSTOM.getIndex() == col.getInt("col_type")) {
            configMap.put("_EXPRESSION", col.getString("col_expr"));
            configMap.put("_EXPRESSION_DISP", col.getString("col_exprdisplay"));
            configMap.put("_DISP_FORMAT", col.getString("col_fm"));
        }
        return SerializationUtils.toJsonString(configMap);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if ("dataset".equals(key) && newVal != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            Set<String> schemeDims = this.displaySchemeConfig(this.getDefaultDynamic());
            this.initSchemeDimpool(schemeDims);
            ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(0)).set("id", (Object)GlobalIdUtil.genGlobalLongId());
        } else if (newVal == null && ("dataset".equals(key) || "model".equals(key))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            if ("model".equals(key)) {
                this.getView().setVisible(Boolean.valueOf(!NewEbAppUtil.isNewEbModel((Long)this.getModelId())), new String[]{"dataset"});
            }
        }
    }

    @Override
    public DiffAnalyzeScheme getSchemeConfig() {
        DiffAnalyzeScheme scheme = null;
        String str = this.getCache("scheme_config_cache_key");
        if (StringUtils.isNotEmpty((String)str)) {
            scheme = (DiffAnalyzeScheme)SerializationUtils.deSerializeFromBase64((String)str);
        }
        if (scheme == null) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("analyzescheme");
            DynamicObject object = null;
            if (dynamicObject == null) {
                object = this.getDefaultDynamic();
            } else {
                object = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"eb_diffanalyzescheme");
                if (object == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5206\u6790\u65b9\u6848%1\u672a\u627e\u5230\u3002", (String)"DiffAnalyzePlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
                }
            }
            scheme = DiffAnalyzeHelper.dynamicObject2SchemeObject(object);
            if (scheme == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setCache("scheme_config_cache_key", SerializationUtils.serializeToBase64((Object)scheme));
        }
        return scheme;
    }

    private DynamicObject getDefaultDynamic() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
        dynamicObject.set("model", (Object)this.getModelId());
        dynamicObject.set("dataset", (Object)this.getDatasetId());
        dynamicObject.set("creator", (Object)this.getUserId());
        dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject entry = col.addNew();
        entry.set("coltype", (Object)DataRowEnum.DATA.getIndex());
        entry.set("colname", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5217", (String)"DiffAnalyzePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return dynamicObject;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("changeModel") != null) {
            this.getView().returnDataToParent((Object)this.getModelId());
        }
        if (this.getPageCache().get("isNew") != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u591a\u7ef4\u65b9\u6848\u4e2d\u6709\u672a\u4fdd\u5b58\u7684\u4fee\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"DiffAnalyzeSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = event.getCallBackId();
        if ("closeConfirm".equals(callBackId)) {
            this.getPageCache().remove("isNew");
            this.getView().close();
        } else if ("modifyConfirm".equals(callBackId)) {
            this.saveCurScheme(false);
        }
    }

    @Override
    protected String getCheckPermEntityId() {
        return this.getView().getParentView().getEntityId();
    }

    @Override
    protected IFormView getCheckPermView() {
        return this.getView().getParentView();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String controlKey = e.getProperty().getName();
        if ("dataset".equals(controlKey)) {
            Long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyseSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            List customQFilters = e.getCustomQFilters();
            Object bizModel = this.getView().getFormShowParameter().getCustomParam("bizModel");
            Long bizModelId = ConvertUtils.toLong((Object)bizModel);
            if (bizModelId != 0L && modelId.equals(this.getModelByFormShow())) {
                customQFilters.add(new QFilter("businessmodel", "=", (Object)bizModelId));
            }
        }
    }

    private Long getModelByFormShow() {
        Object model = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (model instanceof Long) {
            return ConvertUtils.toLong((Object)model);
        }
        if (model instanceof String) {
            return Long.parseLong(model.toString());
        }
        return 0L;
    }

    private boolean checkSharePerm() {
        String appId = this.getBizAppId();
        Long modelId = this.getModelId();
        String formId = "eb_diffanalysis";
        return FunPermissionHelper.checkPageModelFunPerm((long)this.getUserId(), (long)modelId, (String)appId, (String)formId, (String)"16/IQBV3L=/T", (IFormView)this.getView(), (boolean)true);
    }
}

