/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.epm.eb.business.executeanalyse.AnalyseBudgetQueryService;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.analysereport.constants.UnitEnum;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.AnalyseExportParameter;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.AnalyseQueryParameter;
import kd.epm.eb.common.execanalyse.ExportRow;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.execanalyse.SplitDimRange;
import kd.epm.eb.common.execanalyse.SplitMemberRange;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class ExecAnalyseExportTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExecAnalyseExportTask.class);
    private final List<String> queryDimOrder = Arrays.asList("Entity", "Account", "BudgetPeriod", "custom", "Version", "DataType", "Currency", "ChangeType", "AuditTrail", "Metric", "InternalCompany");
    private SXSSFWorkbook workBook = null;
    private final Map<Integer, CellStyle> numberCellStyleMap = new HashMap<Integer, CellStyle>(16);
    private static final ExecuteAnalyseUtil executeAnalyseUtil = ExecuteAnalyseUtil.getInstance();

    public MessageHandler getMessageHandle() {
        return null;
    }

    private void feedbackProgress(int progress, String desc, boolean notNeedFeedBack) {
        if (notNeedFeedBack) {
            return;
        }
        this.feedbackProgress(progress, desc, null);
    }

    private void feedbackProgress(int progress, boolean notNeedFeedBack) {
        if (notNeedFeedBack) {
            return;
        }
        this.feedbackProgress(progress);
    }

    private void feedbackCustomdata(Map<String, Object> customData, boolean notNeedFeedBack) {
        if (notNeedFeedBack) {
            return;
        }
        this.feedbackCustomdata(customData);
    }

    private boolean isStop(boolean notNeedFeedBack) {
        if (notNeedFeedBack) {
            return false;
        }
        return this.isStop();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        AnalyseExportParameter exportParameter = new AnalyseExportParameter(map);
        this.preDealQueryParameter(exportParameter);
        boolean notNeedFeedBack = map.get("notNeedFeedBack") != null;
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u6570\u636e\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"ExecAnalyseExportTask_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), notNeedFeedBack);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            this.export(exportParameter, result, notNeedFeedBack);
            if (exportParameter.isStop()) {
                return;
            }
            this.feedbackCustomdata(result, notNeedFeedBack);
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5b8c\u6210", (String)"ExecAnalyseExportTask_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), notNeedFeedBack);
            AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
            if (queryParameter.getAppId() != null && queryParameter.getFormId() != null) {
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "RelQueryExecuteRecordPlugin_46", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f\u3002", "RelQueryExecuteRecordPlugin_45", "epm-eb-formplugin");
                OperationLogUtil.log((String)queryParameter.getAppId(), (String)queryParameter.getFormId(), (String)"", (String)"", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
            }
        }
        catch (Exception ex) {
            log.error("execute export error:" + ThrowableHelper.toString((Exception)ex));
            exportParameter.addTipMessage(ex.getMessage());
            result.put("success", false);
            result.put("tipMessage", SerializationUtils.toJsonString((Object)exportParameter.getTipMessages()));
            this.feedbackCustomdata(result, notNeedFeedBack);
        }
    }

    private void preDealQueryParameter(AnalyseExportParameter exportParameter) {
        SchemeDimension schemeDimension = exportParameter.getSchemeDimension();
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        List rowDimKeys = schemeDimension.getRowDimensions().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList());
        List pageDimKeys = schemeDimension.getPageDimensions().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList());
        List colDimKeys = schemeDimension.getColDimensions().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList());
        queryParameter.setRowDimKeys(rowDimKeys);
        queryParameter.setPageDimKeys(pageDimKeys);
        queryParameter.setColDimKey((String)colDimKeys.get(0));
        queryParameter.setBizModelId(queryParameter.getModelCacheHelper().getBusModelByDataSet(queryParameter.getDatasetId()));
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        queryParameter.setRowDimControlKeys(instance.getRowDimControlKeys(rowDimKeys, queryParameter.getColKeys()));
        AnalyseBudgetQueryService.getInstance().queryAuditTrail(queryParameter);
    }

    public void export(AnalyseExportParameter exportParameter, Map<String, Object> result, boolean notNeedFeedBack) {
        boolean exportDataSuccessful = true;
        this.workBook = new SXSSFWorkbook(exportParameter.getMaxWindowRow());
        CellStyle style = this.workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        SXSSFSheet sheet = this.workBook.createSheet(exportParameter.getSchemeName());
        sheet.setDefaultColumnWidth(30);
        this.createFirstSheetRow(sheet);
        this.createPageDimRows(sheet, exportParameter);
        sheet.groupRow(1, 2);
        sheet.setRowGroupCollapsed(1, true);
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        List schemeColSettings = queryParameter.getColSettings();
        List<SchemeColSetting> schemeCol_afterFilter = schemeColSettings.stream().filter(e -> e.getShow() != false || SchemeColType.PRESET == e.getColType() && !AnalysePreColType.BUD_ACT_RATE.getNumber().equals(e.getNumber()) && !AnalysePreColType.BALANCE.getNumber().equals(e.getNumber())).collect(Collectors.toList());
        this.createTitleRows(sheet, exportParameter, schemeCol_afterFilter);
        exportDataSuccessful = exportParameter.isSelExport() ? this.exportSelRow(sheet, exportParameter) : this.exportAll(exportParameter, result, notNeedFeedBack, sheet, queryParameter, schemeCol_afterFilter);
        if (exportParameter.isStop()) {
            executeAnalyseUtil.deleteSXSSFTempFiles(this.workBook);
            log.info("ExecAnalyseExportTask --- stop");
            this.stop();
            return;
        }
        if (exportDataSuccessful) {
            String fileName = ResManager.loadKDString((String)"\u9884\u7b97\u6267\u884c\u5206\u6790\u62a5\u8868\u5bfc\u51fa\u6570\u636e", (String)"ExecAnalyseExportTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            try {
                String url = ImportAndExportUtil.writeFile((Workbook)this.workBook, (String)fileName);
                result.put("success", true);
                result.put("fileUrl", url);
            }
            catch (IOException ex) {
                log.error("writeFile error" + ThrowableHelper.toString((Exception)ex));
                exportParameter.addTipMessage(ex.getMessage());
                result.put("success", false);
            }
        }
        executeAnalyseUtil.deleteSXSSFTempFiles(this.workBook);
        result.put("tipMessage", SerializationUtils.toJsonString((Object)exportParameter.getTipMessages()));
    }

    private boolean exportSelRow(SXSSFSheet sheet, AnalyseExportParameter exportParameter) {
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        Map dataColMapping = exportParameter.getDataColMapping();
        MemberShowType showType = exportParameter.getShowType();
        List colKeyList = queryParameter.getColKeyList();
        Map colKeys = queryParameter.getColKeys();
        List rowDimKeys = queryParameter.getRowDimKeys();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)queryParameter.getModelId());
        Map dimProperties = exportParameter.getSchemeDimension().getDimProperties();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        int metricScale = exportParameter.getMetricScale();
        UnitEnum unitEnum = exportParameter.getUnitEnum();
        int lastRowNum = sheet.getLastRowNum();
        List selExportData = exportParameter.getSelExportData();
        for (Object[] exportDatum : selExportData) {
            SXSSFRow row = sheet.createRow(++lastRowNum);
            for (int i = 0; i < colKeyList.size(); ++i) {
                String key;
                Integer cellIndex;
                if (exportDatum[i] == null || (cellIndex = (Integer)dataColMapping.get(key = (String)colKeyList.get(i))) == null) continue;
                String realKey = (String)colKeys.get(key);
                AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)realKey);
                SXSSFCell cell = row.createCell(cellIndex.intValue(), CellType.STRING);
                String value = String.valueOf(exportDatum[i]);
                if (AnalyseBudgetQueryService.getInstance().isDimensionCol(realKey, modelCacheHelper)) {
                    String[] split = value.split("_");
                    if (split.length != 2) continue;
                    String prefix = split[0];
                    Long memberId = IDUtils.toLong((Object)split[1]);
                    Member member = modelCacheHelper.getMember(realKey, (Long)viewMap.get(realKey), memberId);
                    if (member == null) continue;
                    StringBuilder _prefix = new StringBuilder();
                    int baseLevel = Convert.toInt((Object)prefix, (Integer)0);
                    for (int j = 0; j < baseLevel; ++j) {
                        _prefix.insert(0, "  ");
                    }
                    this.setDimColCellValue(_prefix.toString(), row, rowDimKeys, showType, cellIndex, cell, realKey, member, (Long)viewMap.get(realKey));
                    this.createDimPropValueCell(dataColMapping, row, dimProperties, memberPropCache, showType, realKey, member);
                    continue;
                }
                this.fillNumberCellValue(cell, value, preColType, metricScale, unitEnum);
            }
        }
        return true;
    }

    private void fillNumberCellValue(SXSSFCell cell, Object value, AnalysePreColType preColType, int metricScale, UnitEnum unitEnum) {
        BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)String.valueOf(value).replace(",", ""));
        if (bigDecimal == null) {
            if (value != null && !"notPermCell".equals(value)) {
                cell.setCellValue(value.toString());
            }
        } else {
            int scale = preColType != null ? metricScale : bigDecimal.scale();
            bigDecimal = bigDecimal.divide(BigDecimal.TEN.pow(unitEnum.getUnit()), scale, 4);
            CellStyle numberStyle = this.getNumberStyle(scale);
            cell.setCellStyle(numberStyle);
            cell.setCellValue(bigDecimal.doubleValue());
            cell.setCellType(CellType.NUMERIC);
        }
    }

    private CellStyle getNumberStyle(int scale) {
        CellStyle cellStyle = this.numberCellStyleMap.computeIfAbsent(scale, e -> this.workBook.createCellStyle());
        CreationHelper creationHelper = this.workBook.getCreationHelper();
        StringBuilder builder = new StringBuilder("#,##0");
        if (scale != 0) {
            builder = new StringBuilder("#,##0.");
            for (int i = 0; i < scale; ++i) {
                builder.append("0");
            }
        }
        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(builder.toString()));
        return cellStyle;
    }

    private boolean exportAll(AnalyseExportParameter exportParameter, Map<String, Object> result, boolean notNeedFeedBack, SXSSFSheet sheet, AnalyseQueryParameter queryParameter, List<SchemeColSetting> schemeCol_afterFilter) {
        boolean notNeedExport;
        List<Dataset> datasets = Collections.singletonList(Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)queryParameter.getDatasetId())));
        this.replaceDetailMembers(exportParameter, datasets);
        Map viewIds = queryParameter.getModelCacheHelper().getViewsByDataSet(queryParameter.getDatasetId());
        this.filterRefPeriod(queryParameter.getRefPeriods(), queryParameter.getModelCacheHelper(), viewIds, datasets);
        this.filterRangeData(queryParameter, datasets);
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        boolean bl = notNeedExport = !instance.isAllDimExistMember(queryParameter) && (queryParameter.getRefPeriods() == null || queryParameter.getRefPeriods().size() == 0);
        if (!notNeedExport) {
            if (!instance.filterPageDimPerm(queryParameter)) {
                instance.filterColDimPerm(queryParameter, exportParameter.getPeriodRange().size() != 0);
            }
            boolean bl2 = notNeedExport = instance.isAllColNotHasPerm("#", queryParameter) || ((List)queryParameter.getQueryParam().get(queryParameter.getColDimKey())).size() == 0;
        }
        if (!notNeedExport) {
            exportParameter.setToReplaceQueryMembers(this.getToReplaceQueryMembers(exportParameter));
            exportParameter.setAllRowCount(this.getAllRowCount(queryParameter));
            if (queryParameter.isNeedSplit()) {
                queryParameter.setSplitDimRanges(this.getSplitDimRanges(exportParameter));
            }
            if (StringUtils.isEmpty((String)exportParameter.getSchemeName())) {
                exportParameter.setSchemeName(ResManager.loadKDString((String)"\u5206\u6790\u62a5\u8868", (String)"ExecAnalyseExportTask_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            ArrayList<Set<String>> dataKeyList = new ArrayList<Set<String>>(16);
            HashMap<MembersKey, IKDCell> olapDataMap = new HashMap<MembersKey, IKDCell>(16);
            if (!queryParameter.isNeedSplit()) {
                instance.reQueryOlap(queryParameter, exportParameter, olapDataMap, dataKeyList);
            }
            instance.getControlDimensions(queryParameter);
            this.fillMemberData(sheet, exportParameter, null, schemeCol_afterFilter, olapDataMap, dataKeyList, 0, notNeedFeedBack);
            try {
                AnalyseBudgetQueryService.getInstance().dealControlCols(queryParameter, AnalyseBudgetQueryService.getInstance().getAllBalances(queryParameter), exportParameter);
                this.fillCurDataToSheet(exportParameter, exportParameter.getExportRows(), sheet, 0);
                exportParameter.getExportRows().clear();
                exportParameter.setExportRowIndex(0);
                exportParameter.getEnableRowIndex().clear();
                queryParameter.getAnalyseData().clear();
            }
            catch (Exception ex) {
                log.error("fillBudgetBalance error:" + ThrowableHelper.toString((Exception)ex));
                exportParameter.addTipMessage(ex.getMessage());
                result.put("success", false);
                return false;
            }
        }
        return true;
    }

    private void filterRefPeriod(List<String> refPeriods, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<Dataset> datasets) {
        if (refPeriods == null) {
            return;
        }
        Set<String> existMembers = this.getExistDataMembers(modelCacheHelper, viewIds, datasets, refPeriods, SysDimensionEnum.BudgetPeriod.getNumber());
        refPeriods.retainAll(existMembers);
    }

    private Set<String> getExistDataMembers(IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<Dataset> datasets, List<String> memberList, String dimNumber) {
        Model model = modelCacheHelper.getModelobj();
        HashSet<String> existDataMembers = new HashSet<String>(16);
        if (memberList.isEmpty()) {
            return existDataMembers;
        }
        HashSet<String> detailMembers = new HashSet<String>(16);
        for (String memberNumber : memberList) {
            Member member = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberNumber);
            if (member.isLeaf()) {
                detailMembers.add(member.getNumber());
                continue;
            }
            List members = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberNumber, RangeEnum.ALL_DETAIL.getIndex());
            Set collect = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            if (!ShrekOlapServiceHelper.existCubeData((Model)model, datasets, (String)dimNumber, collect)) continue;
            existDataMembers.add(memberNumber);
        }
        if (detailMembers.size() != 0) {
            existDataMembers.addAll(ShrekOlapServiceHelper.getExistDataMember((Model)model, datasets, (String)dimNumber, detailMembers));
        }
        return existDataMembers;
    }

    private void filterRangeData(AnalyseQueryParameter queryParameter, List<Dataset> datasets) {
        Set amountPeriods = queryParameter.getAmountPeriods();
        if (amountPeriods == null) {
            return;
        }
        if (queryParameter.getReferAmountPeriods() != null && queryParameter.getReferAmountPeriods().size() != 0) {
            return;
        }
        Set existDataMember = ShrekOlapServiceHelper.getExistDataMember((Model)queryParameter.getModelCacheHelper().getModelobj(), datasets, (String)queryParameter.getColDimKey(), (Set)amountPeriods);
        queryParameter.setAmountPeriods(existDataMember);
    }

    private int getAllRowCount(AnalyseQueryParameter queryParameter) {
        Map queryParam = queryParameter.getQueryParam();
        List rowDimKeys = queryParameter.getRowDimKeys();
        int maxSize = 1;
        for (String rowDimKey : rowDimKeys) {
            maxSize *= ((List)queryParam.get(rowDimKey)).size();
        }
        return maxSize;
    }

    private List<SplitDimRange> getSplitDimRanges(AnalyseExportParameter exportParameter) {
        long start = System.currentTimeMillis();
        ArrayList<SplitDimRange> splitDimRanges = new ArrayList<SplitDimRange>(16);
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        Map queryParam = queryParameter.getQueryParam();
        List rowDimKeys = queryParameter.getRowDimKeys();
        List firstDimMemberList = (List)queryParam.get(exportParameter.getMainDimKey());
        int maxSize = this.getPreMemberSum(exportParameter, firstDimMemberList, firstDimMemberList.size() - 1) * AnalyseBudgetQueryService.getInstance().getNextAllDimMemberSize(queryParameter, 1);
        int firstDimSize = firstDimMemberList.size();
        int curSize = 0;
        SplitDimRange preRange = null;
        Stack<SplitMemberRange> stack = new Stack<SplitMemberRange>();
        SplitMemberRange firstSplitRange = new SplitMemberRange(0, 0, false);
        int retainSize = this.getRetainSize(firstDimMemberList, firstSplitRange, exportParameter, queryParameter.getMaxQueryData());
        while (curSize < maxSize) {
            for (int i = rowDimKeys.size() - 1; i > 0; --i) {
                String dimKey = (String)rowDimKeys.get(i);
                List memberList = (List)queryParam.get(dimKey);
                int memberListSize = memberList.size();
                int curDimRetainSize = retainSize % memberListSize;
                retainSize /= memberListSize;
                int preSize = 0;
                int rangeIndex = rowDimKeys.size() - i - 1;
                if ((stack.size() == 0 || stack.size() <= rangeIndex) && preRange != null) {
                    preSize = preRange.getMemberRange(i).getEnd();
                }
                if ((curDimRetainSize += preSize) >= memberListSize) {
                    ++retainSize;
                    curDimRetainSize -= memberListSize;
                }
                if (curDimRetainSize >= memberListSize) {
                    curDimRetainSize = memberListSize - 1;
                }
                if (stack.size() == 0 || stack.size() <= rangeIndex) {
                    boolean isContainsAll = AnalyseBudgetQueryService.getInstance().checkIsContainsAll(retainSize, preSize, curDimRetainSize);
                    stack.push(new SplitMemberRange(preSize, curDimRetainSize, isContainsAll));
                } else {
                    SplitMemberRange splitMemberRange = (SplitMemberRange)stack.get(rangeIndex);
                    splitMemberRange.setEnd(curDimRetainSize);
                }
                if (retainSize == 0) break;
            }
            if (retainSize != 0) {
                int end = firstSplitRange.getEnd();
                if (end >= firstDimSize - 1) {
                    if (end - firstSplitRange.getStart() >= firstDimSize - 1) {
                        firstSplitRange.setContainAll(true);
                    }
                } else {
                    retainSize = this.getPreMemberSum(exportParameter, firstDimMemberList, firstSplitRange.getEnd()) * AnalyseBudgetQueryService.getInstance().getNextAllDimMemberSize(queryParameter, 1) - curSize;
                    firstSplitRange.setEnd(++end);
                    if (queryParameter.getMaxQueryData() <= retainSize) {
                        int curRangeSize = 0;
                        int index = rowDimKeys.size();
                        for (int i = stack.size() - 1; i >= 0; --i) {
                            int nextAllDimMemberSize = AnalyseBudgetQueryService.getInstance().getNextAllDimMemberSize(queryParameter, index);
                            int curAllDimMemberSize = ((List)queryParam.get(rowDimKeys.get(index - 1))).size();
                            SplitMemberRange splitMemberRange = (SplitMemberRange)stack.elementAt(i);
                            curRangeSize = splitMemberRange.getEnd() < splitMemberRange.getStart() ? (curRangeSize += nextAllDimMemberSize * (splitMemberRange.getEnd() + curAllDimMemberSize - splitMemberRange.getStart())) : (curRangeSize += nextAllDimMemberSize * (splitMemberRange.getEnd() - splitMemberRange.getStart()));
                            --index;
                        }
                        retainSize = curRangeSize;
                    }
                    retainSize = this.getRetainSize(firstDimMemberList, firstSplitRange, exportParameter, queryParameter.getMaxQueryData() - retainSize);
                    continue;
                }
            }
            SplitDimRange range = new SplitDimRange();
            range.addMemberRange(firstSplitRange);
            for (int i = rowDimKeys.size() - 1; i > 0; --i) {
                if (i > stack.size()) {
                    if (preRange == null) {
                        range.addMemberRange(new SplitMemberRange(0, 0, false));
                        continue;
                    }
                    range.addMemberRange(preRange.getMemberRange(rowDimKeys.size() - i));
                    continue;
                }
                range.addMemberRange((SplitMemberRange)stack.pop());
            }
            if (splitDimRanges.contains(range)) {
                return splitDimRanges;
            }
            splitDimRanges.add(range);
            preRange = range;
            curSize = AnalyseBudgetQueryService.getInstance().getRangeSize(queryParameter, range, 0, exportParameter.getFirstRowMemberSum(), firstDimMemberList);
            retainSize = this.getRetainSize(firstDimMemberList, firstSplitRange, exportParameter, queryParameter.getMaxQueryData());
            firstSplitRange = new SplitMemberRange(firstSplitRange.getStart(), firstSplitRange.getEnd(), false);
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - start < 20000L) continue;
            log.info("ExecAnalyseExportTask_getSplitDimRanges_inDeadLoop: " + (currentTimeMillis - start));
            throw new KDBizException("ExecAnalyseExportTask_getSplitDimRanges_inDeadLoop");
        }
        return splitDimRanges;
    }

    private int getPreMemberSum(AnalyseExportParameter exportParameter, List<String> firstDimMemberList, int endIndex) {
        int sum = 0;
        for (int i = 0; i <= endIndex; ++i) {
            sum += ((Integer)exportParameter.getFirstRowMemberSum().get(firstDimMemberList.get(i))).intValue();
        }
        return sum;
    }

    private int getRetainSize(List<String> memberList, SplitMemberRange firstSplitRange, AnalyseExportParameter exportParameter, int queryDataSize) {
        int curMemberIndex = firstSplitRange.getEnd();
        String curMember = memberList.get(curMemberIndex);
        int refMemberSize = (Integer)exportParameter.getFirstRowMemberSum().get(curMember);
        int retain = queryDataSize % refMemberSize;
        int divide = queryDataSize / refMemberSize;
        if (retain != 0) {
            ++divide;
        }
        return divide;
    }

    private List<String> getToReplaceQueryMembers(AnalyseExportParameter exportParameter) {
        ArrayList<String> toReplaceQueryMembers = new ArrayList<String>(16);
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        Map queryParam = queryParameter.getQueryParam();
        List memberList = (List)queryParam.get(exportParameter.getMainDimKey());
        for (String member : memberList) {
            ArrayList<String> child = new ArrayList<String>(16);
            child.add(member);
            this.addMaxMonthMap(exportParameter, member);
            this.collectAllChild(child, exportParameter.getDetailMemberMap(), member, exportParameter);
            if (!queryParameter.isNeedSplit()) {
                toReplaceQueryMembers.addAll(child);
            }
            exportParameter.getFirstRowMemberSum().put(member, child.size());
            exportParameter.getFirstRowMemberMap().put(member, child);
        }
        return toReplaceQueryMembers;
    }

    private void addMaxMonthMap(AnalyseExportParameter exportParameter, String member) {
        String mainDimKey = exportParameter.getMainDimKey();
        if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(mainDimKey)) {
            return;
        }
        exportParameter.getQueryParameter().getMaxMonthMap().put(member, AnalyseBudgetQueryService.getInstance().getMinOrMaxPeriodNumber((Object)member, exportParameter.getQueryParameter().getModelCacheHelper(), false));
    }

    private void collectAllChild(List<String> child, Map<String, List<String>> detailMemberMap, String member, AnalyseExportParameter exportParameter) {
        List<String> members = detailMemberMap.get(member);
        if (members == null) {
            return;
        }
        for (String mem : members) {
            child.add(mem);
            this.addMaxMonthMap(exportParameter, mem);
            this.collectAllChild(child, detailMemberMap, mem, exportParameter);
        }
    }

    private void createFirstSheetRow(SXSSFSheet sheet) {
        SXSSFRow row = ExcelWriter.getRow((SXSSFSheet)sheet, (int)0);
        SXSSFCell cell = row.createCell(0, CellType.STRING);
        cell.setCellStyle(this.getTopCellStyle());
        cell.setCellValue(ResManager.loadKDString((String)"kingdee#\u6267\u884c\u5206\u6790\u62a5\u8868", (String)"ExecAnalyseExportTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void createPageDimRows(SXSSFSheet sheet, AnalyseExportParameter exportParameter) {
        SXSSFRow dimRow = ExcelWriter.getRow((SXSSFSheet)sheet, (int)1);
        SXSSFRow memberRow = ExcelWriter.getRow((SXSSFSheet)sheet, (int)2);
        AtomicInteger index = new AtomicInteger();
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        List pageDimensions = exportParameter.getSchemeDimension().getPageDimensions();
        this.queryDimOrder.forEach(e -> {
            List dimensions = executeAnalyseUtil.getDimensions(pageDimensions, e);
            if (dimensions.size() != 0) {
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    SXSSFCell dimCell = dimRow.createCell(index.get(), CellType.STRING);
                    SXSSFCell memberCell = memberRow.createCell(index.getAndIncrement(), CellType.STRING);
                    String number = dimension.getNumber();
                    String name = dimension.getName();
                    dimCell.setCellValue(name + "#" + number);
                    List memberList = (List)queryParameter.getQueryParam().get(number);
                    memberCell.setCellValue(this.getMemberStr(modelCacheHelper, (String)memberList.get(0), number, (Long)viewMap.get(number)));
                }
            }
        });
        this.addTotalCols(dimRow, memberRow, index.get(), exportParameter.getPeriodRange(), modelCacheHelper);
    }

    private void addTotalCols(SXSSFRow dimRow, SXSSFRow memberRow, int index, Map<String, String> periodRange, IModelCacheHelper modelCacheHelper) {
        if (periodRange.size() == 0) {
            return;
        }
        SXSSFCell dimCell = dimRow.createCell(index, CellType.STRING);
        SXSSFCell memberCell = memberRow.createCell(index, CellType.STRING);
        dimCell.setCellValue(ResManager.loadKDString((String)"\u7d2f\u8ba1\u671f\u95f4#BudgetPeriod", (String)"ExecAnalyseExportTask_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<String> rangeList = new ArrayList<String>(16);
        rangeList.add(this.getMemberStr(modelCacheHelper, periodRange.get("range_pre"), SysDimensionEnum.BudgetPeriod.getNumber(), 0L));
        rangeList.add(this.getMemberStr(modelCacheHelper, periodRange.get("range_after"), SysDimensionEnum.BudgetPeriod.getNumber(), 0L));
        memberCell.setCellValue(String.join((CharSequence)" - ", rangeList));
    }

    private String getMemberStr(IModelCacheHelper modelCacheHelper, String memberNum, String number, Long viewId) {
        Member member = modelCacheHelper.getMember(number, viewId, memberNum);
        if (member == null) {
            return "";
        }
        return member.getName() + "#" + member.getNumber();
    }

    private void createTitleRows(SXSSFSheet sheet, AnalyseExportParameter exportParameter, List<SchemeColSetting> schemeColSettings) {
        SXSSFRow groupRow = ExcelWriter.getRow((SXSSFSheet)sheet, (int)3);
        SXSSFRow titleRow = ExcelWriter.getRow((SXSSFSheet)sheet, (int)4);
        CellStyle groupSettingStyle = this.getGroupSettingStyle();
        Map dataColMapping = exportParameter.getDataColMapping();
        int index = 0;
        boolean isShowTotal = true;
        String name = ResManager.loadKDString((String)"\u7d2f\u8ba1\u671f\u95f4", (String)"ExecAnalyseExportTask_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Optional<SchemeColSetting> first = schemeColSettings.stream().filter(arg_0 -> ((ExecuteAnalyseUtil)executeAnalyseUtil).isAmountTotalColType(arg_0)).findFirst();
        if (first.isPresent()) {
            SchemeColSetting schemeColSetting = first.get();
            name = schemeColSetting.getShowName();
            isShowTotal = schemeColSetting.getShow();
        }
        index = this.fillRowDimInfos(sheet, exportParameter, groupRow, groupSettingStyle, titleRow, index);
        index = this.fillColSettingInfos(sheet, exportParameter, schemeColSettings, groupRow, titleRow, groupSettingStyle, index);
        if (exportParameter.isShowTotal() && isShowTotal && exportParameter.getPeriodRange().size() != 0) {
            this.addTotalCol(sheet, schemeColSettings, name, groupRow, titleRow, groupSettingStyle, dataColMapping, index);
        }
    }

    private void addTotalCol(SXSSFSheet sheet, List<SchemeColSetting> schemeColSettings, String name, SXSSFRow groupRow, SXSSFRow titleRow, CellStyle groupSettingStyle, Map<String, Integer> dataMap, int index) {
        int beginIndex = index;
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            if (!schemeColSetting.getShow().booleanValue() || executeAnalyseUtil.isAmountTotalColType(schemeColSetting)) continue;
            SXSSFCell groupCell = groupRow.createCell(index, CellType.STRING);
            groupCell.setCellValue(name);
            groupCell.setCellStyle(groupSettingStyle);
            dataMap.put("entryentity_amountrange_" + schemeColSetting.getNumber(), index);
            SXSSFCell titleCell = titleRow.createCell(index++, CellType.STRING);
            titleCell.setCellValue(schemeColSetting.getShowName());
            titleCell.setCellStyle(groupSettingStyle);
        }
        if (beginIndex != index - 1) {
            CellRangeAddress titleRegion = new CellRangeAddress(3, 3, beginIndex, index - 1);
            sheet.addMergedRegion(titleRegion);
        }
    }

    private int fillColSettingInfos(SXSSFSheet sheet, AnalyseExportParameter exportParameter, List<SchemeColSetting> schemeColSettings, SXSSFRow groupRow, SXSSFRow titleRow, CellStyle groupSettingStyle, int index) {
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        String number = queryParameter.getColDimKey();
        List colMembers = (List)queryParameter.getQueryParam().get(number);
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        for (String colMember : colMembers) {
            Member member = modelCacheHelper.getMember(number, (Long)viewMap.get(number), colMember);
            if (member == null) continue;
            String name = this.getShowValue(member, exportParameter.getShowType());
            int beginIndex = index;
            for (SchemeColSetting schemeColSetting : schemeColSettings) {
                if (!schemeColSetting.getShow().booleanValue() || executeAnalyseUtil.isAmountTotalColType(schemeColSetting)) continue;
                SXSSFCell groupCell = groupRow.createCell(index, CellType.STRING);
                groupCell.setCellValue(name);
                groupCell.setCellStyle(groupSettingStyle);
                exportParameter.getDataColMapping().put("entryentity_" + colMember.toLowerCase().replaceAll("\\.", "_") + "_" + schemeColSetting.getNumber(), index);
                SXSSFCell titleCell = titleRow.createCell(index++, CellType.STRING);
                titleCell.setCellValue(schemeColSetting.getShowName());
                titleCell.setCellStyle(groupSettingStyle);
            }
            if (beginIndex == index - 1) continue;
            CellRangeAddress titleRegion = new CellRangeAddress(3, 3, beginIndex, index - 1);
            sheet.addMergedRegion(titleRegion);
        }
        return index;
    }

    private String getShowValue(Member member, MemberShowType showType) {
        String value = null;
        switch (showType) {
            case NAME: {
                value = member.getName();
                break;
            }
            case NUMBER: {
                value = member.getNumber();
                break;
            }
            case NAME_NUMBER: {
                value = member.getName() + "#" + member.getNumber();
                break;
            }
        }
        return value;
    }

    private int fillRowDimInfos(SXSSFSheet sheet, AnalyseExportParameter exportParameter, SXSSFRow groupRow, CellStyle groupSettingStyle, SXSSFRow titleRow, int index) {
        SchemeDimension schemeDimension = exportParameter.getSchemeDimension();
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        Map dataColMapping = exportParameter.getDataColMapping();
        MemberShowType showType = exportParameter.getShowType();
        List dimColOrder = schemeDimension.getDimColOrder();
        if (CollectionUtils.isEmpty((Collection)dimColOrder)) {
            dimColOrder = executeAnalyseUtil.getSchemeDefaultDimColOrder(schemeDimension);
        }
        List rowDimensions = schemeDimension.getRowDimensions();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)queryParameter.getModelId());
        Map rowDimOrPropGroupTitle = executeAnalyseUtil.getRowDimOrPropGroupTitle(rowDimensions, dimColOrder, memberPropCache, modelCacheHelper);
        CellStyle cellStyle = this.getDimTitleStyle();
        for (String dimOrder : dimColOrder) {
            String groupTitle = (String)rowDimOrPropGroupTitle.get(dimOrder);
            boolean isProp = dimOrder.startsWith("rowdimprop_");
            String colName = null;
            if (isProp) {
                kd.epm.eb.common.model.Dimension dimension;
                Long propId = IDUtils.toLong((Object)dimOrder.split("_")[1]);
                CustomProperty property = memberPropCache.getProperty(propId);
                if (property != null && (dimension = executeAnalyseUtil.getDimension(rowDimensions, property.getDimId())) != null) {
                    dataColMapping.put("rowdimprop_" + property.getId(), index);
                    colName = StringUtils.isEmpty((String)groupTitle) ? dimension.getName() + "_" + property.getName() : property.getName();
                }
            } else {
                kd.epm.eb.common.model.Dimension dimension = executeAnalyseUtil.getDimension(rowDimensions, dimOrder);
                if (dimension != null) {
                    dataColMapping.put("entryentity_" + dimension.getNumber().toLowerCase(), index);
                    String string = colName = StringUtils.isEmpty((String)groupTitle) ? dimension.getName() : ResManager.loadKDString((String)"\u6210\u5458", (String)"ExecuteAnalyseSchemeEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
            if (!StringUtils.isNotEmpty(colName)) continue;
            if (MemberShowType.NAME == showType || MemberShowType.NAME_NUMBER == showType) {
                index = this.addDimCol(sheet, groupRow, groupTitle, titleRow, cellStyle, colName, index);
            }
            if (MemberShowType.NUMBER != showType && MemberShowType.NAME_NUMBER != showType) continue;
            String dimNumberName = ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"ExecAnalyseExportTask_6", (String)"epm-eb-formplugin", (Object[])new Object[]{colName});
            index = this.addDimCol(sheet, groupRow, groupTitle, titleRow, cellStyle, dimNumberName, index);
        }
        Map groupTitleToColKeysMap = rowDimOrPropGroupTitle.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        for (Map.Entry entry : groupTitleToColKeysMap.entrySet()) {
            String groupTitle = entry.getKey();
            List colKeys = entry.getValue();
            if (CollectionUtils.isEmpty(colKeys)) continue;
            HashSet<Integer> colIndexs = new HashSet<Integer>(colKeys.size());
            for (String colKey : colKeys) {
                boolean isProp = colKey.startsWith("rowdimprop_");
                Integer colIndex = isProp ? (Integer)dataColMapping.get(colKey) : (Integer)dataColMapping.get("entryentity_" + colKey.toLowerCase());
                if (colIndex == null) continue;
                colIndexs.add(colIndex);
            }
            if (colIndexs.size() < 2) continue;
            int mergerStartColIndex = (Integer)colIndexs.stream().min(Integer::compareTo).get();
            int mergerEndColIndex = (Integer)colIndexs.stream().max(Integer::compareTo).get();
            if (MemberShowType.NAME_NUMBER == showType) {
                ++mergerEndColIndex;
            }
            SXSSFCell groupCell = groupRow.createCell(mergerStartColIndex, CellType.STRING);
            groupCell.setCellStyle(groupSettingStyle);
            groupCell.setCellValue(groupTitle);
            CellRangeAddress titleRegion = new CellRangeAddress(3, 3, mergerStartColIndex, mergerEndColIndex);
            sheet.addMergedRegion(titleRegion);
        }
        return index;
    }

    private int addDimCol(SXSSFSheet sheet, SXSSFRow groupRow, String groupName, SXSSFRow titleRow, CellStyle cellStyle, String name, int index) {
        SXSSFCell titleCell = titleRow.createCell(index, CellType.STRING);
        titleCell.setCellStyle(cellStyle);
        titleCell.setCellValue(name);
        if (StringUtils.isEmpty((String)groupName)) {
            SXSSFCell groupCell = groupRow.createCell(index, CellType.STRING);
            groupCell.setCellStyle(cellStyle);
            groupCell.setCellValue(StringUtils.isNotEmpty((String)groupName) ? groupName : name);
            CellRangeAddress titleRegion = new CellRangeAddress(3, 4, index, index);
            sheet.addMergedRegion(titleRegion);
        }
        return ++index;
    }

    private void fillMemberData(SXSSFSheet sheet, AnalyseExportParameter exportParameter, Object[] curData, List<SchemeColSetting> schemeColSettings, Map<MembersKey, IKDCell> olapDataMap, List<Set<String>> dataKeyList, int dimSize, boolean notNeedFeedBack) {
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        List rowDimKeys = queryParameter.getRowDimKeys();
        int size = rowDimKeys.size() - 1;
        String rowDimKey = (String)rowDimKeys.get(dimSize);
        List memberList = (List)queryParameter.getQueryParam().get(rowDimKey);
        List rowDimControlKeys = queryParameter.getRowDimControlKeys();
        List colKeyList = queryParameter.getColKeyList();
        String controlKey = (String)rowDimControlKeys.get(dimSize);
        int dimIndex = colKeyList.indexOf(controlKey);
        StringBuilder memberKey = new StringBuilder();
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        Map<Long, SchemeColSetting> colSettingMap = schemeColSettings.stream().collect(Collectors.toMap(SchemeColSetting::getId, e -> e, (n1, n2) -> n2));
        List dataRows = instance.convertToDataRows(schemeColSettings, queryParameter);
        Object[] tmp = new Object[colKeyList.size()];
        for (String memberNumber : memberList) {
            if (exportParameter.isStop() || this.isStop(notNeedFeedBack)) {
                exportParameter.setStop(true);
                return;
            }
            if (curData != null) {
                System.arraycopy(curData, 0, tmp, 0, colKeyList.size());
            } else {
                Arrays.fill(tmp, null);
            }
            tmp[dimIndex] = memberNumber;
            this.updatePercent(sheet, exportParameter, notNeedFeedBack);
            try {
                if (!instance.existOlapData(tmp, queryParameter, rowDimControlKeys, colKeyList, dataKeyList, memberKey, true, dimSize) && instance.isNotNextSplitExistData(queryParameter, exportParameter, olapDataMap, dataKeyList, tmp, memberKey, dimSize)) {
                    continue;
                }
            }
            catch (Exception ex) {
                log.error("existOlapData or isNotNextSplitExistData check error:" + ThrowableHelper.toString((Exception)ex));
                throw ex;
            }
            if (dimSize < size) {
                this.fillMemberData(sheet, exportParameter, tmp, schemeColSettings, olapDataMap, dataKeyList, dimSize + 1, notNeedFeedBack);
                if (!exportParameter.isOverLimit()) continue;
                return;
            }
            if (dimSize != size) continue;
            queryParameter.increaseRangeCount();
            instance.fillOtherData(queryParameter, tmp, olapDataMap, colSettingMap, dataRows, Boolean.valueOf(false));
            List tmpData = queryParameter.getTmpData();
            ExportRow row = new ExportRow(exportParameter.getExportRowIndex(), (Object[])tmpData.get(tmpData.size() - 1), "", Boolean.valueOf(false));
            exportParameter.addExportRow(row);
            exportParameter.increaseExportRowIndex();
            if (curData != null) {
                System.arraycopy(curData, 0, tmp, 0, curData.length);
            } else {
                Arrays.fill(tmp, null);
            }
            tmp[dimIndex] = memberNumber;
            this.fillChildDataToSheet(sheet, exportParameter, tmp, tmp[colKeyList.indexOf(rowDimControlKeys.get(0))].toString(), olapDataMap, colSettingMap, dataRows, " ", false, row);
            int count = this.getExportRowCount(exportParameter.getExportRows());
            if (count < 5000) continue;
            AnalyseBudgetQueryService.getInstance().dealControlCols(queryParameter, AnalyseBudgetQueryService.getInstance().getAllBalances(queryParameter), exportParameter);
            this.fillCurDataToSheet(exportParameter, exportParameter.getExportRows(), sheet, 0);
            exportParameter.getExportRows().clear();
            exportParameter.setExportRowIndex(0);
            exportParameter.getEnableRowIndex().clear();
            queryParameter.getAnalyseData().clear();
        }
    }

    private int getExportRowCount(List<ExportRow> exportRows) {
        int count = 0;
        for (ExportRow exportRow : exportRows) {
            ++count;
            List children = exportRow.getChildren();
            count += this.getExportRowCount(children);
        }
        return count;
    }

    private int fillCurDataToSheet(AnalyseExportParameter exportParameter, List<ExportRow> exportRows, SXSSFSheet sheet, int index) {
        List enableRowIndex = exportParameter.getEnableRowIndex();
        if (exportRows.size() == 0) {
            return index;
        }
        for (ExportRow exportRow : exportRows) {
            int rowIndex = exportRow.getRowIndex();
            if (!enableRowIndex.contains(rowIndex)) continue;
            List analyseData = exportParameter.getQueryParameter().getAnalyseData();
            if (analyseData.size() <= index) {
                return index;
            }
            this.fillDataToSheet(sheet, (Object[])analyseData.get(index), exportParameter, exportRow.getPrefix());
            ++index;
            if (exportParameter.isOverLimit()) {
                return index;
            }
            exportParameter.increaseRowIndex();
            index = this.fillCurDataToSheet(exportParameter, exportRow.getChildren(), sheet, index);
        }
        return index;
    }

    private void updatePercent(SXSSFSheet sheet, AnalyseExportParameter exportParameter, boolean notNeedFeedBack) {
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        int curRangeCount = queryParameter.getCurRangeCount();
        int allRowCount = exportParameter.getAllRowCount();
        int curPercent = this.getPercent(curRangeCount, allRowCount);
        int lastRowNum = sheet.getLastRowNum();
        int curPercent_sheet = this.getPercent(lastRowNum, exportParameter.getMaxExportRow());
        if (curPercent_sheet > curPercent) {
            curPercent = curPercent_sheet;
        }
        if (exportParameter.getExportTaskPercent() != curPercent) {
            this.feedbackProgress(curPercent, notNeedFeedBack);
            exportParameter.setExportTaskPercent(curPercent);
        }
    }

    private int getPercent(int divider, int toDivider) {
        BigDecimal bigDecimal = new BigDecimal(divider);
        BigDecimal toDivide = new BigDecimal(toDivider);
        BigDecimal divide = bigDecimal.divide(toDivide, 2, 4);
        return divide.multiply(BigDecimal.TEN.pow(2)).intValue();
    }

    private void fillChildDataToSheet(SXSSFSheet sheet, AnalyseExportParameter exportParameter, Object[] curData, String memberNumber, Map<MembersKey, IKDCell> olapDataMap, Map<Long, SchemeColSetting> colSettingMap, List<IDataRow> dataRows, String prefix, boolean needGroupCollapsed, ExportRow row) {
        Long viewId;
        String mainDimKey;
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        List rowDimControlKeys = queryParameter.getRowDimControlKeys();
        List colKeyList = queryParameter.getColKeyList();
        String controlKey = (String)rowDimControlKeys.get(0);
        int dimIndex = colKeyList.indexOf(controlKey);
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Member member = modelCacheHelper.getMember(mainDimKey = exportParameter.getMainDimKey(), viewId = modelCacheHelper.getViewByDataSetAndDimNumber(queryParameter.getDatasetId(), mainDimKey), memberNumber);
        if (member == null || member.isLeaf()) {
            return;
        }
        List childMembers = (List)exportParameter.getDetailMemberMap().get(memberNumber);
        List children = member.getChildren(true);
        Object[] tmp = new Object[colKeyList.size()];
        for (Member child : children) {
            if (!childMembers.contains(child.getNumber())) continue;
            if (curData != null) {
                System.arraycopy(curData, 0, tmp, 0, curData.length);
            } else {
                Arrays.fill(tmp, null);
            }
            tmp[dimIndex] = child.getNumber();
            instance.fillOtherData(queryParameter, tmp, olapDataMap, colSettingMap, dataRows, Boolean.valueOf(false));
            List tmpData = queryParameter.getTmpData();
            ExportRow exportRow = new ExportRow(exportParameter.getExportRowIndex(), (Object[])tmpData.get(tmpData.size() - 1), prefix, Boolean.valueOf(needGroupCollapsed));
            row.addChild(exportRow);
            exportParameter.increaseExportRowIndex();
            this.fillChildDataToSheet(sheet, exportParameter, curData, child.getNumber(), olapDataMap, colSettingMap, dataRows, " " + prefix, true, exportRow);
        }
    }

    private void replaceDetailMembers(AnalyseExportParameter exportParameter, List<Dataset> datasets) {
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        Long modelId = queryParameter.getModelId();
        Long bizModelId = queryParameter.getBizModelId();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewsMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        List rowDimKeys = queryParameter.getRowDimKeys();
        Model model = modelCacheHelper.getModelobj();
        for (int i = 0; i < rowDimKeys.size(); ++i) {
            Object memberNumber2;
            String rowDimKey = (String)rowDimKeys.get(i);
            List membersList = (List)queryParameter.getQueryParam().get(rowDimKey);
            Long viewId = (Long)viewsMap.get(rowDimKey);
            if (i == 0) {
                ArrayList tmp = new ArrayList(membersList);
                membersList.clear();
                for (Object memberNumber2 : tmp) {
                    if (!this.isNotDetailExistDataMember(model, datasets, rowDimKey, exportParameter.getDetailMemberMap(), viewId, (String)memberNumber2)) continue;
                    membersList.add(memberNumber2);
                }
                continue;
            }
            ArrayList member = new ArrayList(16);
            for (Object memberNumber2 : membersList) {
                member.addAll(modelCacheHelper.getMemberSort(rowDimKey, viewId, (String)memberNumber2, RangeEnum.ALL_DETAIL.getIndex()));
            }
            membersList.clear();
            Set readPermMemIds = DimMembPermHelper.getReadPermMembIds((String)rowDimKey, (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true);
            memberNumber2 = member.iterator();
            while (memberNumber2.hasNext()) {
                Member e2 = (Member)memberNumber2.next();
                if (readPermMemIds != null && !readPermMemIds.contains(e2.getId())) continue;
                membersList.add(e2.getNumber());
            }
            Set existDataMember = ShrekOlapServiceHelper.getExistDataMember((Model)model, datasets, (String)rowDimKey, new HashSet(membersList));
            membersList.retainAll(existDataMember);
            if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(rowDimKey)) continue;
            Map maxMonthMap = queryParameter.getMaxMonthMap();
            membersList.forEach(e -> maxMonthMap.put(e, e));
        }
    }

    private boolean isNotDetailExistDataMember(Model model, List<Dataset> datasets, String rowDimKey, Map<String, List<String>> detailMemberMap, Long viewId, String memberNumber) {
        Dimension dimension = model.getDimension(rowDimKey);
        Member member = dimension.getMember(viewId, memberNumber);
        if (member == null) {
            return false;
        }
        if (member.isLeaf()) {
            HashSet<String> memberList = new HashSet<String>(16);
            memberList.add(memberNumber);
            Set existDataMember = ShrekOlapServiceHelper.getExistDataMember((Model)model, datasets, (String)rowDimKey, memberList);
            return existDataMember.size() != 0;
        }
        HashSet<String> existDataMember = new HashSet<String>(16);
        HashSet<String> detailMembers = new HashSet<String>(16);
        List children = member.getChildren(true);
        for (Member child : children) {
            String number = child.getNumber();
            if (child.isLeaf()) {
                detailMembers.add(number);
                continue;
            }
            if (!this.isNotDetailExistDataMember(model, datasets, rowDimKey, detailMemberMap, viewId, number)) continue;
            existDataMember.add(number);
        }
        existDataMember.addAll(ShrekOlapServiceHelper.getExistDataMember((Model)model, datasets, (String)rowDimKey, detailMembers));
        List collect = children.stream().map(BaseCache::getNumber).filter(existDataMember::contains).collect(Collectors.toList());
        if (collect.size() != 0) {
            detailMemberMap.put(memberNumber, collect);
            return true;
        }
        return false;
    }

    private void fillDataToSheet(SXSSFSheet sheet, Object[] entryRow, AnalyseExportParameter exportParameter, String prefix) {
        if (exportParameter.getRowIndex() >= exportParameter.getMaxExportRow()) {
            if (!exportParameter.isOverLimit()) {
                exportParameter.setOverLimit(true);
                exportParameter.addTipMessage(ResManager.loadResFormat((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51fa\u6700\u5927\u884c\u6570\u9650\u5236\uff1a %s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExecAnalyseExportTask_9", (String)"epm-eb-formplugin", (Object[])new Object[]{exportParameter.getMaxExportRow()}));
            }
            return;
        }
        SXSSFRow row = ExcelWriter.getRow((SXSSFSheet)sheet, (int)exportParameter.getRowIndex());
        AnalyseQueryParameter queryParameter = exportParameter.getQueryParameter();
        List rowDimKeys = queryParameter.getRowDimKeys();
        List colKeyList = queryParameter.getColKeyList();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)queryParameter.getModelId());
        Map dimProperties = exportParameter.getSchemeDimension().getDimProperties();
        Map dataColMapping = exportParameter.getDataColMapping();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        int metricScale = exportParameter.getMetricScale();
        UnitEnum unitEnum = exportParameter.getUnitEnum();
        MemberShowType showType = exportParameter.getShowType();
        for (int i = 0; i < colKeyList.size(); ++i) {
            String key = (String)colKeyList.get(i);
            Integer cellIndex = (Integer)dataColMapping.get(key);
            if (cellIndex == null) continue;
            SXSSFCell cell = row.createCell(cellIndex.intValue());
            String realKey = (String)queryParameter.getColKeys().get(key);
            AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)realKey);
            Long viewId = (Long)viewMap.get(realKey);
            if (AnalyseBudgetQueryService.getInstance().isDimensionCol(realKey, modelCacheHelper)) {
                Member member = modelCacheHelper.getMember(realKey, viewId, entryRow[i].toString());
                if (member == null) continue;
                this.setDimColCellValue(prefix, row, rowDimKeys, showType, cellIndex, cell, realKey, member, viewId);
                this.createDimPropValueCell(dataColMapping, row, dimProperties, memberPropCache, showType, realKey, member);
                continue;
            }
            Object cellValue = entryRow[i];
            if (cellValue != null && cellValue.toString().endsWith("%")) {
                cell.setCellValue(cellValue.toString());
                continue;
            }
            this.fillNumberCellValue(cell, cellValue, preColType, metricScale, unitEnum);
        }
    }

    private void createDimPropValueCell(Map<String, Integer> dataColMapping, SXSSFRow row, Map<String, List<PropertyObj>> dimProperties, MemberPropCache memberPropCache, MemberShowType showType, String dimNumber, Member dimMember) {
        if (dimProperties == null) {
            return;
        }
        List<PropertyObj> propertyObjs = dimProperties.get(dimNumber);
        if (CollectionUtils.isEmpty(propertyObjs)) {
            return;
        }
        for (PropertyObj propertyObj : propertyObjs) {
            SXSSFCell cell;
            CustomPropertyValue propertyValue;
            Integer propCellIndex = dataColMapping.get("rowdimprop_" + propertyObj.getId());
            if (propCellIndex == null || (propertyValue = memberPropCache.getPropertyValueByMemNumber(dimNumber, propertyObj.getNumber(), dimMember.getNumber())) == null) continue;
            if (MemberShowType.NAME == showType || MemberShowType.NAME_NUMBER == showType) {
                Integer n = propCellIndex;
                Integer n2 = propCellIndex = Integer.valueOf(propCellIndex + 1);
                cell = row.createCell(n.intValue(), CellType.STRING);
                cell.setCellValue(propertyValue.getName());
            }
            if (MemberShowType.NUMBER != showType && MemberShowType.NAME_NUMBER != showType) continue;
            cell = row.createCell(propCellIndex.intValue(), CellType.STRING);
            cell.setCellValue(propertyValue.getNumber());
        }
    }

    private void setDimColCellValue(String prefix, SXSSFRow row, List<String> rowDimKeys, MemberShowType showType, Integer cellIndex, SXSSFCell cell, String realKey, Member member, Long viewId) {
        if (rowDimKeys.get(0).equals(realKey)) {
            cell.setCellValue(prefix + (MemberShowType.NUMBER == showType ? member.getNumber() : member.getName()));
        } else {
            cell.setCellValue(this.getMemberLongValue(member, showType, viewId));
        }
        if (MemberShowType.NAME_NUMBER == showType) {
            cell = row.createCell(cellIndex + 1);
            if (rowDimKeys.get(0).equals(realKey)) {
                cell.setCellValue(prefix + member.getNumber());
            } else {
                cell.setCellValue(this.getMemberLongValue(member, MemberShowType.NUMBER, viewId));
            }
        }
    }

    private String getMemberLongValue(Member member, MemberShowType showType, Long viewId) {
        ArrayList<String> parentNames = new ArrayList<String>(16);
        String longNumber = member.getLongNumber();
        String[] parents = longNumber.split("!");
        Dimension dimension = member.getDimension();
        for (String parent : parents) {
            Member parentMember = dimension.getMember(viewId, parent);
            if (parentMember == null) continue;
            if (MemberShowType.NUMBER == showType) {
                parentNames.add(parentMember.getNumber());
                continue;
            }
            parentNames.add(parentMember.getName());
        }
        return String.join((CharSequence)"-", parentNames);
    }

    private CellStyle getTopCellStyle() {
        CellStyle cellStyle = this.workBook.createCellStyle();
        XSSFColor xssfColor = new XSSFColor(new Color(0, 176, 240), (IndexedColorMap)new DefaultIndexedColorMap());
        ((XSSFCellStyle)cellStyle).setFillForegroundColor(xssfColor);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private CellStyle getDimTitleStyle() {
        CellStyle cellStyle = this.workBook.createCellStyle();
        Font font = this.workBook.createFont();
        font.setFontHeight((short)280);
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private CellStyle getGroupSettingStyle() {
        CellStyle cellStyle = this.workBook.createCellStyle();
        Font font = this.workBook.createFont();
        font.setFontHeight((short)280);
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }
}

