/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ExecColSettingPlugin
extends AbstractFormPlugin {
    private final List<SchemeColSetting> schemeColSettings = new ArrayList<SchemeColSetting>(16);
    private final List<Long> removeIds = new ArrayList<Long>(16);
    private boolean needDealPropertyChange = true;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        this.initColData(schemeColSettings);
    }

    private void initColData(List<SchemeColSetting> schemeColSettings) {
        this.getModel().deleteEntryData("entryentity");
        if (schemeColSettings == null) {
            return;
        }
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("number", (Object)schemeColSetting.getNumber(), newEntryRow);
            this.getModel().setValue("analyseinfo", (Object)schemeColSetting.getAnalyseInfo(), newEntryRow);
            this.getModel().setValue("showname", (Object)schemeColSetting.getShowName(), newEntryRow);
            this.getModel().setValue("isshow", (Object)schemeColSetting.getShow(), newEntryRow);
            this.getModel().setValue("desc", (Object)schemeColSetting.getDesc(), newEntryRow);
            SchemeColType colType = schemeColSetting.getColType();
            if (SchemeColType.PRESET != colType) continue;
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"desc"});
        }
        this.getView().updateView("entryentity");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "addcol": {
                this.openFormulaPage(true);
                break;
            }
            case "editcol": {
                this.openFormulaPage(false);
                break;
            }
            case "delcol": {
                this.deleteFormulaCol();
                break;
            }
            case "move_up": 
            case "move_down": 
            case "move_top": 
            case "move_bottom": {
                this.movePosition(operateKey);
                break;
            }
        }
    }

    private void deleteFormulaCol() {
        Long id;
        List<Long> removeIds;
        int selectRow = this.getSelectRow();
        if (selectRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c", (String)"ExecColSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        SchemeColSetting schemeColSetting = schemeColSettings.get(selectRow);
        if (SchemeColType.FORMULA != schemeColSetting.getColType()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5217\u4e0d\u5141\u8bb8\u5220\u9664\u6216\u7f16\u8f91\u3002", (String)"ExecColSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int lastRow = schemeColSettings.size() - 1;
        if (selectRow != lastRow) {
            this.changeToBottom(schemeColSettings, selectRow);
        }
        schemeColSettings.remove(lastRow);
        if (!schemeColSetting.getNew().booleanValue() && !(removeIds = this.getCacheRemoveList()).contains(id = schemeColSetting.getId())) {
            removeIds.add(id);
            this.cacheRemoveList(removeIds);
        }
        this.setDealPropertyChange(false);
        this.initColData(schemeColSettings);
        this.setDealPropertyChange(true);
        this.cacheSchemeColSetting(schemeColSettings);
    }

    private List<Long> getCacheRemoveList() {
        String result;
        if (this.removeIds.size() == 0 && (result = this.getPageCache().get("removeList")) != null) {
            this.removeIds.addAll((Collection)SerializationUtils.fromJsonString((String)result, List.class));
        }
        return this.removeIds;
    }

    private void cacheRemoveList(List<Long> removeIds) {
        this.getPageCache().put("removeList", SerializationUtils.toJsonString(removeIds));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ok".equals(key)) {
            this.saveSchemeSetting();
        }
    }

    private void saveSchemeSetting() {
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        if (this.checkBeforeSave(schemeColSettings)) {
            return;
        }
        List schemeSetting = ExecuteAnalyseUtil.getInstance().convertSchemeSettingToDyn(schemeColSettings);
        SaveServiceHelper.save((DynamicObject[])schemeSetting.toArray(new DynamicObject[0]));
        List<Long> cacheRemoveList = this.getCacheRemoveList();
        if (cacheRemoveList.size() != 0) {
            QFilter qFilter = new QFilter("id", "in", cacheRemoveList);
            DeleteServiceHelper.delete((String)"eb_execcolentity", (QFilter[])new QFilter[]{qFilter});
        }
        this.getPageCache().remove("isModify");
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private boolean checkBeforeSave(List<SchemeColSetting> schemeColSettings) {
        if (schemeColSettings.size() == 0) {
            return false;
        }
        HashSet<String> showColNumbers = new HashSet<String>(16);
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            if (!schemeColSetting.getShow().booleanValue()) continue;
            showColNumbers.add(schemeColSetting.getNumber());
        }
        if (showColNumbers.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5c55\u793a\u7684\u5217\u3002", (String)"ExecColSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (showColNumbers.size() == 1 && showColNumbers.contains(AnalysePreColType.AMOUNT_TOTAL.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53ea\u8bbe\u7f6e\u7d2f\u8ba1\u6570\u5217\u5c55\u793a\u3002", (String)"ExecColSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.needDealPropertyChange().booleanValue()) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int selectRow = changeData.getRowIndex();
        if (newValue == null || selectRow < 0) {
            return;
        }
        String name = e.getProperty().getName();
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        SchemeColSetting schemeColSetting = schemeColSettings.get(selectRow);
        if ("showname".equals(name)) {
            schemeColSetting.setShowName(newValue.toString());
        } else if ("desc".equals(name)) {
            schemeColSetting.setDesc(newValue.toString());
        } else if ("isshow".equals(name)) {
            schemeColSetting.setShow(Convert.toBool((Object)newValue));
        }
        this.updateSchemeId(schemeColSetting, schemeColSettings);
        this.cacheSchemeColSetting(schemeColSettings);
        this.getPageCache().put("isModify", "true");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if ("new".equals(actionId) || "modify".equals(actionId)) {
            int rowIndex;
            if (!(returnData instanceof Map)) {
                return;
            }
            Map retData = (Map)returnData;
            List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
            SchemeColSetting schemeColSetting = null;
            if ("new".equals(actionId)) {
                rowIndex = this.getModel().createNewEntryRow("entryentity");
                schemeColSetting = new SchemeColSetting();
                long id = DB.genGlobalLongId();
                schemeColSetting.setId(Long.valueOf(id));
                schemeColSetting.setNumber("formula" + id);
                schemeColSetting.setNew(Boolean.valueOf(true));
                schemeColSetting.setColType(SchemeColType.FORMULA);
                Long schemeId = this.getSchemeId();
                int maxOrder = this.getMaxOrder(schemeId);
                schemeColSetting.setOrder(maxOrder + 1);
                schemeColSetting.setSchemeId(schemeId);
                schemeColSetting.setShow(Boolean.valueOf(true));
            } else {
                rowIndex = this.getSelectRow();
                schemeColSetting = schemeColSettings.get(rowIndex);
            }
            String exprDisplay = (String)retData.get("exprdisplay");
            schemeColSetting.setShowName(exprDisplay);
            schemeColSetting.setAnalyseInfo(exprDisplay);
            HashMap formulaMap = new HashMap(16);
            formulaMap.put("expr", retData.get("expr"));
            formulaMap.put("fm", retData.get("fm"));
            schemeColSetting.setFormula(SerializationUtils.toJsonString(formulaMap));
            this.setDealPropertyChange(false);
            this.getModel().setValue("analyseinfo", (Object)exprDisplay, rowIndex);
            this.getModel().setValue("showname", (Object)exprDisplay, rowIndex);
            this.setDealPropertyChange(true);
            if (rowIndex >= schemeColSettings.size()) {
                schemeColSettings.add(schemeColSetting);
            }
            this.cacheSchemeColSetting(schemeColSettings);
            this.getPageCache().put("isModify", "true");
        }
    }

    private int getMaxOrder(Long schemeId) {
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        int max = 1;
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            int order = schemeColSetting.getOrder();
            if (order <= max) continue;
            max = order;
        }
        return max;
    }

    private List<SchemeColSetting> getSchemeColSettings() {
        if (this.schemeColSettings.size() == 0) {
            String schemeColSetting = this.getPageCache().get("schemeColSetting");
            if (StringUtils.isEmpty((String)schemeColSetting)) {
                this.schemeColSettings.addAll(ExecuteAnalyseUtil.getInstance().getSchemeColSettingsById(this.getSchemeId()));
                this.cacheSchemeColSetting(this.schemeColSettings);
            } else {
                this.schemeColSettings.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)schemeColSetting));
            }
        }
        return this.schemeColSettings;
    }

    private Long getSchemeId() {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        return ConvertUtils.toLong((Object)schemeId);
    }

    private void cacheSchemeColSetting(List<SchemeColSetting> schemeColSettings) {
        this.getPageCache().put("schemeColSetting", SerializationUtils.serializeToBase64(schemeColSettings));
    }

    private void openFormulaPage(boolean isNew) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_diffeditexpr");
        if (!isNew) {
            int selectRow = this.getSelectRow();
            if (selectRow == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c", (String)"ExecColSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
            SchemeColSetting schemeColSetting = schemeColSettings.get(selectRow);
            if (SchemeColType.FORMULA != schemeColSetting.getColType()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5217\u4e0d\u5141\u8bb8\u5220\u9664\u6216\u7f16\u8f91\u3002", (String)"ExecColSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String formula = schemeColSetting.getFormula();
            if (StringUtils.isNotEmpty((String)formula)) {
                Map formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
                formShowParameter.setCustomParam("expr", formulaMap.get("expr"));
                formShowParameter.setCustomParam("fm", formulaMap.get("fm"));
            }
        }
        formShowParameter.setCustomParam("colIndexNameMap", (Object)SerializationUtils.toJsonString(this.getColNameMap()));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isNew ? "new" : "modify"));
        this.getView().showForm(formShowParameter);
    }

    private Map<String, String> getColNameMap() {
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        LinkedHashMap<String, String> colNameMap = new LinkedHashMap<String, String>(16);
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            AnalysePreColType colByNumber;
            if (SchemeColType.PRESET != schemeColSetting.getColType() || (colByNumber = AnalysePreColType.getColByNumber((String)schemeColSetting.getNumber())) == null || !colByNumber.getCanCalculate().booleanValue()) continue;
            colNameMap.put(String.valueOf(schemeColSetting.getId()), schemeColSetting.getAnalyseInfo());
        }
        return colNameMap;
    }

    private int getSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        return entryGrid.getEntryState().getFocusRow();
    }

    private void movePosition(String operateKey) {
        int selectRow = this.getSelectRow();
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        if ("move_up".equals(operateKey) || "move_down".equals(operateKey)) {
            int exchangeRow = "move_up".equals(operateKey) ? selectRow - 1 : selectRow + 1;
            if (exchangeRow < 0 || exchangeRow >= schemeColSettings.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u884c\u6216\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecColSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.exchangePosition(schemeColSettings, selectRow, exchangeRow);
        } else if ("move_top".equals(operateKey)) {
            if (selectRow == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecColSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.changeToTop(schemeColSettings, selectRow);
        } else {
            if (selectRow == schemeColSettings.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecColSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.changeToBottom(schemeColSettings, selectRow);
        }
        this.setDealPropertyChange(false);
        this.initColData(schemeColSettings);
        this.setDealPropertyChange(true);
        this.cacheSchemeColSetting(schemeColSettings);
    }

    private void exchangePosition(List<SchemeColSetting> schemeColSettings, int selectRow, int exchangeRow) {
        SchemeColSetting selectSetting = schemeColSettings.get(selectRow);
        SchemeColSetting exchangeSetting = schemeColSettings.get(exchangeRow);
        if (selectSetting != null && exchangeSetting != null) {
            int order = exchangeSetting.getOrder();
            exchangeSetting.setOrder(selectSetting.getOrder());
            selectSetting.setOrder(order);
            this.updateSchemeId(exchangeSetting, schemeColSettings);
            this.updateSchemeId(selectSetting, schemeColSettings);
        }
        ExecuteAnalyseUtil.getInstance().sortByOrder(schemeColSettings);
    }

    private void updateSchemeId(SchemeColSetting schemeColSetting, List<SchemeColSetting> schemeColSettings) {
        if (schemeColSetting.getSchemeId() == 0L) {
            schemeColSetting.setSchemeId(this.getSchemeId());
            Long pkId = DB.genGlobalLongId();
            this.updateFormula(schemeColSetting.getId(), pkId, schemeColSettings);
            schemeColSetting.setId(pkId);
        }
    }

    private void updateFormula(Long pkId_bef, Long pkId, List<SchemeColSetting> schemeColSettings) {
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            String formula;
            Map formulaMap;
            String expr;
            SchemeColType colType = schemeColSetting.getColType();
            if (SchemeColType.PRESET == colType || !(expr = (String)(formulaMap = (Map)SerializationUtils.fromJsonString((String)(formula = schemeColSetting.getFormula()), Map.class)).get("expr")).contains(pkId_bef.toString())) continue;
            String replace = expr.replace(pkId_bef.toString(), pkId.toString());
            formulaMap.put("expr", replace);
            schemeColSetting.setFormula(SerializationUtils.toJsonString((Object)formulaMap));
        }
    }

    private void changeToTop(List<SchemeColSetting> schemeColSettings, int selectRow) {
        SchemeColSetting schemeColSetting = schemeColSettings.get(selectRow);
        schemeColSetting.setOrder(1);
        this.updateSchemeId(schemeColSetting, schemeColSettings);
        for (int i = 0; i < schemeColSettings.size(); ++i) {
            if (i == selectRow) continue;
            SchemeColSetting schemeSetting = schemeColSettings.get(i);
            if (i >= selectRow) continue;
            schemeSetting.setOrder(schemeSetting.getOrder() + 1);
            this.updateSchemeId(schemeSetting, schemeColSettings);
        }
        ExecuteAnalyseUtil.getInstance().sortByOrder(schemeColSettings);
    }

    private void changeToBottom(List<SchemeColSetting> schemeColSettings, int selectRow) {
        for (int i = 0; i < schemeColSettings.size(); ++i) {
            if (i == selectRow) continue;
            SchemeColSetting schemeSetting = schemeColSettings.get(i);
            if (i <= selectRow) continue;
            schemeSetting.setOrder(schemeSetting.getOrder() - 1);
            this.updateSchemeId(schemeSetting, schemeColSettings);
        }
        SchemeColSetting schemeColSetting = schemeColSettings.get(selectRow);
        schemeColSetting.setOrder(schemeColSettings.get(schemeColSettings.size() - 1).getOrder());
        this.updateSchemeId(schemeColSetting, schemeColSettings);
        ExecuteAnalyseUtil.getInstance().sortByOrder(schemeColSettings);
    }

    private void setDealPropertyChange(Boolean propertyChange) {
        this.needDealPropertyChange = propertyChange;
    }

    private Boolean needDealPropertyChange() {
        return this.needDealPropertyChange;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isModify = this.getPageCache().get("isModify");
        if (isModify != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u6790\u5217\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4fee\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"ExecColSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (!"closeConfirm".equals(callBackId)) {
            return;
        }
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        this.getPageCache().remove("isModify");
        this.getView().close();
    }
}

