/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ExecDimColOrderPlugin
extends AbstractFormPlugin {
    private static Long model = 0L;
    private static List<String> dimColOrders = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        List<String> dimColOrders = this.getDimColOrders();
        if (dimColOrders.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u987a\u5e8f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExecDimColOrderPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExecDimColOrderPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.initEntryData(dimColOrders);
    }

    private void initEntryData(List<String> dimColOrders) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        this.getModel().deleteEntryData("entryentity");
        for (String dimColOrder : dimColOrders) {
            boolean isProp = dimColOrder.startsWith("rowdimprop_");
            if (isProp) {
                Long propId = IDUtils.toLong((Object)dimColOrder.split("_")[1]);
                CustomProperty property = memberPropCache.getProperty(propId);
                if (property == null) continue;
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("dimkey", (Object)dimColOrder, newEntryRow);
                this.getModel().setValue("dimension", (Object)property.getName(), newEntryRow);
                continue;
            }
            Dimension dimension = modelCacheHelper.getDimension(dimColOrder);
            if (dimension == null) continue;
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("dimkey", (Object)dimColOrder, newEntryRow);
            this.getModel().setValue("dimension", (Object)dimension.getName(), newEntryRow);
        }
    }

    private List<String> getDimColOrders() {
        if (dimColOrders == null) {
            String dimColOrderCache = this.getPageCache().get("dimColOrders");
            if (StringUtils.isNotEmpty((String)dimColOrderCache)) {
                dimColOrders = (List)SerializationUtils.fromJsonString((String)dimColOrderCache, ArrayList.class);
            } else {
                String dimColOrderJson = (String)this.getView().getFormShowParameter().getCustomParam("dimColOrders");
                if (StringUtils.isNotEmpty((String)dimColOrderJson)) {
                    dimColOrders = (List)SerializationUtils.fromJsonString((String)dimColOrderJson, ArrayList.class);
                    this.cacheDimOrders(dimColOrders);
                } else {
                    dimColOrders = new ArrayList<String>(16);
                }
            }
        }
        return dimColOrders;
    }

    private void cacheDimOrders(List<String> dimColOrders) {
        ExecDimColOrderPlugin.dimColOrders = dimColOrders;
        this.getPageCache().put("dimColOrders", SerializationUtils.toJsonString(dimColOrders));
    }

    @Override
    public Long getModelId() {
        Object modelObj;
        if (model == 0L && (modelObj = this.getView().getFormShowParameter().getCustomParam("model")) != null) {
            model = ConvertUtils.toLong((Object)modelObj);
        }
        return model;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "moveentryup": 
            case "moveentrydown": 
            case "settop": 
            case "setbottom": {
                this.movePosition(operateKey);
                break;
            }
        }
    }

    private void movePosition(String operateKey) {
        int selectRow = this.getSelectRow();
        List<String> dimColOrders = this.getDimColOrders();
        if ("moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) {
            int exchangeRow = "moveentryup".equals(operateKey) ? selectRow - 1 : selectRow + 1;
            if (exchangeRow < 0 || exchangeRow >= dimColOrders.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u884c\u6216\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecDimColOrderPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.exchangePosition(dimColOrders, selectRow, exchangeRow);
        } else if ("settop".equals(operateKey)) {
            if (selectRow == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecDimColOrderPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            dimColOrders = this.changeToTop(dimColOrders, selectRow);
        } else {
            if (selectRow == dimColOrders.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ExecDimColOrderPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            dimColOrders = this.changeToBottom(dimColOrders, selectRow);
        }
        this.initEntryData(dimColOrders);
        this.cacheDimOrders(dimColOrders);
    }

    private void exchangePosition(List<String> dimColOrders, int selectRow, int exchangeRow) {
        String selectOrder = dimColOrders.get(selectRow);
        String exchangeOrder = dimColOrders.get(exchangeRow);
        dimColOrders.set(selectRow, exchangeOrder);
        dimColOrders.set(exchangeRow, selectOrder);
    }

    private List<String> changeToTop(List<String> dimColOrders, int selectRow) {
        ArrayList<String> retOrder = new ArrayList<String>(16);
        retOrder.add(dimColOrders.get(selectRow));
        for (int i = 0; i < dimColOrders.size(); ++i) {
            if (i == selectRow) continue;
            retOrder.add(dimColOrders.get(i));
        }
        return retOrder;
    }

    private List<String> changeToBottom(List<String> dimColOrders, int selectRow) {
        ArrayList<String> retOrder = new ArrayList<String>(16);
        for (int i = 0; i < dimColOrders.size(); ++i) {
            if (i == selectRow) continue;
            retOrder.add(dimColOrders.get(i));
        }
        retOrder.add(dimColOrders.get(selectRow));
        return retOrder;
    }

    private int getSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        return entryGrid.getEntryState().getFocusRow();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String dimColOrdersCache = this.getPageCache().get("dimColOrders");
        this.getView().returnDataToParent((Object)dimColOrdersCache);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        dimColOrders = null;
        model = 0L;
    }
}

