/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.execanalyse.AnalyseType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.executeanalyse.AnalyseCommonMethod;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class ExecuteAnalyseReportShareListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener,
SetFilterListener,
SearchEnterListener,
AnalyseCommonMethod {
    protected static final String MODEL = "model";
    private static final String RECEIVE_SHARE_TAB = "receive_share_tab";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String BILLLISTAP = "billlistap";
    private static final String LEFT_TAB = "lefttab";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_CANCEL_SHARE = "btn_cancelshare";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String DELETE = "delete";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab leftTab = (Tab)this.getControl(LEFT_TAB);
        leftTab.addTabSelectListener((TabSelectListener)this);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        this.addF7SelectListener(this::beforeF7Select, new String[]{MODEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object modelObj = this.getView().getFormShowParameter().getCustomParam(MODEL);
        Long modelId = ConvertUtils.toLong((Object)modelObj);
        if (modelId == 0L) {
            this.showListData("");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyseReportShareListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCEL_SHARE, BTN_DELETE});
        this.initTree();
        this.refreshShareState();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put("nodeId", nodeId);
        this.showListData(nodeId);
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.deleteAllNodes();
        TreeNode root = this.getRootNode(this.getModelId(), this.getView());
        treeView.addNode(root);
        this.expandAll(root, treeView);
        List children = root.getChildren();
        if (children != null && children.size() != 0) {
            TreeNode child = (TreeNode)children.get(0);
            TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)child.getParentid(), (Object)child.getId());
            this.treeNodeClick(evt);
            treeView.focusNode(child);
            this.getPageCache().put("nodeId", child.getId());
        }
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        this.getPageCache().remove("searchInfo");
        Search search = (Search)this.getView().getControl("searchap");
        search.setSearchKey("");
    }

    private void expandAll(TreeNode node, TreeView treeView) {
        List children = node.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        treeView.expand(node.getId());
        children.forEach(e -> this.expandAll((TreeNode)e, treeView));
    }

    @Override
    public Long getModelId() {
        Object modelObj = this.getModel().getValue(MODEL);
        if (modelObj instanceof DynamicObject) {
            return ((DynamicObject)modelObj).getLong("id");
        }
        return 0L;
    }

    @Override
    public List<Long> getBusModelIdsByExecute() {
        return this.getBusModelIds(AnalyseType.EXECUTE);
    }

    @Override
    public List<Long> getBusModelIdsByMultiDim() {
        return this.getBusModelIds(AnalyseType.MULTI_DIM);
    }

    private List<Long> getBusModelIds(AnalyseType analyseType) {
        HashSet busModelIds = new HashSet(16);
        QFilter qFilter = new QFilter("modelid", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("templatetype", "=", (Object)(analyseType == AnalyseType.MULTI_DIM ? "M" : "E")));
        Long userId = UserUtils.getUserId();
        String currentTab = ((Tab)this.getControl(LEFT_TAB)).getCurrentTab();
        if (RECEIVE_SHARE_TAB.equals(currentTab)) {
            qFilter.and(new QFilter("receiver", "=", (Object)userId));
            qFilter.and("sharestatus", "=", (Object)"A");
        } else {
            qFilter.and(new QFilter("sharers", "=", (Object)userId));
        }
        DynamicObjectCollection multiSchemes = QueryServiceHelper.query((String)"eb_reportshare", (String)"dataset", (QFilter[])new QFilter[]{qFilter});
        if (multiSchemes != null) {
            multiSchemes.forEach(e -> busModelIds.add(e.getLong("dataset")));
        }
        return new ArrayList<Long>(busModelIds);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject newModel = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newModel != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)newModel.getLong("id"));
            }
            this.getPageCache().remove("nodeId");
            this.getPageCache().remove("root");
            this.initTree();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (RECEIVE_SHARE_TAB.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCEL_SHARE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_DELETE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CANCEL_SHARE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_DELETE});
        }
        this.initTree();
    }

    private void showListData(String nodeId) {
        QFilter qFilter = this.getQFilter(nodeId);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(qFilter);
        billList.setClearSelection(true);
        billList.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "btn_cancelshare": {
                this.cancelShare();
                break;
            }
            case "btn_refresh": {
                this.refreshShareState();
                break;
            }
        }
    }

    private void cancelShare() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c", (String)"ExecuteAnalyseReportShareListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
        boolean hasSharedRecord = QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkArray), new QFilter("sharestatus", "=", (Object)"B")});
        if (hasSharedRecord) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u4e2d\u542b\u5df2\u53d6\u6d88\u72b6\u6001", (String)"ExecuteAnalyseReportShareListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u53d6\u6d88\u5206\u4eab", (String)"ExecuteAnalyseReportShareListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cancel_share", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Cancel.equals((Object)evt.getResult())) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if ("cancel_share".equals(callBackId)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            HashSet<Long> messageIds = new HashSet<Long>(16);
            Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_reportshare").getDynamicObjectType());
            HashMap<String, Set> userShardRecord = new HashMap<String, Set>(16);
            for (DynamicObject billObj : bills) {
                billObj.set("sharestatus", (Object)"B");
                messageIds.add(billObj.getLong("messageid"));
                String userName = billObj.getString("receiver.name");
                Set set = userShardRecord.computeIfAbsent(userName, k -> new HashSet());
                set.add(billObj.getString("name"));
            }
            SaveServiceHelper.save((DynamicObject[])bills);
            String nodeId = this.getPageCache().get("nodeId");
            this.showListData(nodeId);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(pkArray.length);
            filters.add(new QFilter("messageid", "in", messageIds));
            DeleteServiceHelper.delete((String)"wf_msg_receiver", (QFilter[])filters.toArray(new QFilter[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u4eab", "ExecuteAnalyseReportShareListPlugin_15", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53d6\u6d88\u5bf9%1$s\u7684\u62a5\u8868%2$s\u5206\u4eab\u3002", "ExecuteAnalyseReportShareListPlugin_16", "epm-eb-formplugin");
            for (Map.Entry entry : userShardRecord.entrySet()) {
                this.writeLog(null, "cacnelShare", opName, opDesc, new String[]{(String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue())});
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u4eab\u6210\u529f\u3002", (String)"ExecuteAnalyseReportShareListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if ("deleteEnjoys".equals(callBackId)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_reportshare").getDynamicObjectType());
            HashMap<String, Set> userShardRecord = new HashMap<String, Set>(16);
            boolean hasSharedRecord = false;
            for (DynamicObject billObj : bills) {
                String shareStatus = billObj.getString("sharestatus");
                if ("A".equals(shareStatus)) {
                    hasSharedRecord = true;
                    break;
                }
                String string = billObj.getString("receiver.name");
                Set reportName = userShardRecord.computeIfAbsent(string, k -> new HashSet());
                reportName.add(billObj.getString("name"));
            }
            if (hasSharedRecord) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u4e2d\u542b\u5df2\u5206\u4eab\u72b6\u6001\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u4eab\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"ExecuteAnalyseReportShareListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(pkArray.length);
                filters.add(new QFilter("id", "in", (Object)pkArray));
                DeleteServiceHelper.delete((String)"eb_reportshare", (QFilter[])filters.toArray(new QFilter[0]));
                this.refreshShareState();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u5206\u4eab\u8bb0\u5f55", "ExecuteAnalyseReportShareListPlugin_17", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u5bf9%1$s\u7684\u62a5\u8868%2$s\u5206\u4eab\u3002", "ExecuteAnalyseReportShareListPlugin_18", "epm-eb-formplugin");
                for (Map.Entry map : userShardRecord.entrySet()) {
                    this.writeLog(null, DELETE, opName, opDesc, new String[]{(String)map.getKey(), String.join((CharSequence)",", (Iterable)map.getValue())});
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExecuteAnalyseReportShareListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void refreshShareState() {
        Map analysisReportShareMap;
        int i;
        QFilter qFilter = new QFilter("modelid", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("islook", "=", (Object)"B"));
        Map reportShareMap = BusinessDataServiceHelper.loadFromCache((String)"eb_reportshare", (String)"id,messageid,templatetype", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Map)reportShareMap)) {
            String nodeId = this.getPageCache().get("nodeId");
            this.showListData(nodeId);
            return;
        }
        HashSet<Long> msgIds = new HashSet<Long>(reportShareMap.size());
        for (DynamicObject dynamicObject : reportShareMap.values()) {
            msgIds.add(dynamicObject.getLong("messageid"));
        }
        QFilter msgFilter = new QFilter("messageid", "in", msgIds);
        DynamicObjectCollection msgList = QueryServiceHelper.query((String)"wf_msg_receiver", (String)"id,readstate,messageid,receiverid", (QFilter[])new QFilter[]{msgFilter});
        if (CollectionUtils.isEmpty((Collection)msgList)) {
            String nodeId = this.getPageCache().get("nodeId");
            this.showListData(nodeId);
            return;
        }
        HashSet<Long> analysisShareId = new HashSet<Long>(msgList.size());
        HashSet<Long> execAnalysisShareId = new HashSet<Long>(msgList.size());
        for (DynamicObject msgObject : msgList) {
            if (!"read".equals(msgObject.get("readstate").toString())) continue;
            long messageId = msgObject.getLong("messageid");
            for (DynamicObject dynamicObject : reportShareMap.values()) {
                long schemeMessageId = dynamicObject.getLong("messageid");
                if (messageId != schemeMessageId) continue;
                String templateType = dynamicObject.getString("templatetype");
                if ("M".equals(templateType)) {
                    analysisShareId.add(dynamicObject.getLong("id"));
                    continue;
                }
                execAnalysisShareId.add(dynamicObject.getLong("id"));
            }
        }
        if (analysisShareId.size() > 0 && (i = this.checkHasViewPermission("eb_diffanalysis")) == 1) {
            analysisReportShareMap = BusinessDataServiceHelper.loadFromCache((Object[])analysisShareId.toArray(), (String)"eb_reportshare");
            for (DynamicObject dynamicObject : analysisReportShareMap.values()) {
                dynamicObject.set("islook", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])analysisReportShareMap.values().toArray(new DynamicObject[0]));
        }
        if (execAnalysisShareId.size() > 0 && (i = this.checkHasViewPermission("eb_execanalysereport")) == 1) {
            analysisReportShareMap = BusinessDataServiceHelper.loadFromCache((Object[])execAnalysisShareId.toArray(), (String)"eb_reportshare");
            for (DynamicObject dynamicObject : analysisReportShareMap.values()) {
                dynamicObject.set("islook", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])analysisReportShareMap.values().toArray(new DynamicObject[0]));
        }
        String nodeId = this.getPageCache().get("nodeId");
        this.showListData(nodeId);
    }

    private int checkHasViewPermission(String eb_execanalysereport) {
        String formId = eb_execanalysereport;
        Long userId = UserUtils.getUserId();
        return this.checkItemPermission(userId, this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), formId, "47150e89000000ac");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if (DELETE.equals(type)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
            if (pkArray != null && pkArray.length > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5206\u4eab\u8bb0\u5f55", (String)"ExecuteAnalyseReportShareListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteEnjoys", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c", (String)"ExecuteAnalyseReportShareListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Long userId;
        int i;
        String isLook;
        String shareStatus;
        super.hyperLinkClick(evt);
        BillList list = (BillList)evt.getSource();
        Long pkId = (Long)list.getFocusRowPkId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportshare", (String)"id,reportid,templatetype,dataset,data,islook,sharestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        if (dynamicObject == null) {
            return;
        }
        String currentTab = ((Tab)this.getControl(LEFT_TAB)).getCurrentTab();
        if (RECEIVE_SHARE_TAB.equals(currentTab) && "B".equals(shareStatus = dynamicObject.getString("sharestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u53d6\u6d88\u5206\u4eab", (String)"ExecuteAnalyseReportShareListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long schemeId = dynamicObject.getLong("reportid");
        String templateType = dynamicObject.getString("templatetype");
        String entityName = "";
        String formId = "";
        FormShowParameter formShowParameter = null;
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("schemeId", dynamicObject.get("reportid"));
        customMap.put(MODEL, this.getModelId());
        customMap.put("dataset", dynamicObject.get("dataset"));
        customMap.put("isFormEnjoy", "true");
        if ("M".equals(templateType)) {
            formShowParameter = new FormShowParameter();
            entityName = "eb_diffanalyzescheme";
            formId = "eb_diffanalysis";
            this.replaceParamKey(customMap);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u591a\u7ef4\u5206\u6790\u65b9\u6848", (String)"ExecuteAnalyseReportShareListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter = new ReportShowParameter();
            entityName = "eb_execschemeentity";
            formId = "eb_execanalysereport";
            customMap.put("data", dynamicObject.getString("data"));
            customMap.put("shareId", dynamicObject.getString("id"));
        }
        formShowParameter.setCustomParams(customMap);
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam(formShowParameter);
        formShowParameter.setFormId(formId);
        if (!QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u5220\u9664", (String)"ExecuteAnalyseReportShareListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openReport"));
        this.getView().showForm(formShowParameter);
        if (RECEIVE_SHARE_TAB.equals(currentTab) && "B".equals(isLook = dynamicObject.getString("islook")) && (i = this.checkItemPermission(userId = UserUtils.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), formId, "47150e89000000ac")) == 1) {
            String sql = "update t_eb_reportshare set fislook = 'A' where fid = ?";
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{pkId});
        }
    }

    private void replaceParamKey(Map<String, Object> customParams) {
        this.replaceParamKey(customParams, MODEL, "KEY_MODEL_ID");
        this.replaceParamKey(customParams, "dataset", "eb_dataset");
        this.replaceParamKey(customParams, "schemeId", "eb_diffanalyzescheme");
    }

    private void replaceParamKey(Map<String, Object> customParams, String preKey, String nextKey) {
        Object value = customParams.remove(preKey);
        if (value != null) {
            customParams.put(nextKey, String.valueOf(value));
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        String nodeId = this.getPageCache().get("nodeId");
        QFilter qFilter = this.getQFilter(nodeId);
        setFilterEvent.getQFilters().add(qFilter);
    }

    private QFilter getQFilter(String nodeId) {
        String currentTab;
        QFilter qFilter = new QFilter("modelid", "=", (Object)this.getModelId());
        if (StringUtils.isEmpty((String)nodeId)) {
            return qFilter;
        }
        ArrayList<Long> datasetIds = null;
        String[] nodeValueArr = nodeId.split("_");
        int length = nodeValueArr.length;
        if (length == 2) {
            Long bizModelId = Long.valueOf(nodeValueArr[1]);
            datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(bizModelId);
        } else if (length == 3) {
            Long datasetId = Long.valueOf(nodeValueArr[2]);
            datasetIds = new ArrayList<Long>(16);
            datasetIds.add(datasetId);
        }
        Long userId = UserUtils.getUserId();
        if (datasetIds != null && datasetIds.size() > 0) {
            qFilter.and(new QFilter("dataset", "in", datasetIds));
        }
        if (RECEIVE_SHARE_TAB.equals(currentTab = ((Tab)this.getControl(LEFT_TAB)).getCurrentTab())) {
            qFilter.and(new QFilter("receiver", "=", (Object)userId));
            qFilter.and(new QFilter("sharestatus", "=", (Object)"A"));
        } else {
            qFilter.and(new QFilter("sharers", "=", (Object)userId));
        }
        if (!"0".equals(nodeId)) {
            if (nodeId.startsWith("multidim")) {
                qFilter.and(new QFilter("templatetype", "=", (Object)"M"));
            } else {
                qFilter.and(new QFilter("templatetype", "=", (Object)"E"));
            }
        } else {
            ArrayList<String> templateTypeList = new ArrayList<String>(2);
            templateTypeList.add("M");
            templateTypeList.add("E");
            qFilter.and(new QFilter("templatetype", "in", templateTypeList));
        }
        return qFilter;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "searchbefore": {
                this.searchMove(true);
                break;
            }
            case "searchnext": {
                this.searchMove(false);
                break;
            }
        }
    }

    private void searchMove(boolean isBefore) {
        String curNodeId = this.getPageCache().get("nodeId");
        String searchInfo = this.getPageCache().get("searchInfo");
        if (StringUtils.isEmpty((String)searchInfo)) {
            return;
        }
        List searchList = (List)SerializationUtils.fromJsonString((String)searchInfo, List.class);
        if (searchList.size() == 0) {
            return;
        }
        int index = this.getCurSearchIndex(searchList, curNodeId);
        if (index == -1) {
            this.focusNode((String)searchList.get(0));
        } else {
            index = isBefore ? --index : ++index;
            if (index < 0 || index >= searchList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\u6216\u8005\u6700\u540e\u4e00\u4e2a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u627e", (String)"ExecuteAnalyseReportShareListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.focusNode((String)searchList.get(index));
        }
    }

    private int getCurSearchIndex(List<String> searchList, String curNodeId) {
        for (int i = 0; i < searchList.size(); ++i) {
            String searchInfo = searchList.get(i);
            if (!searchInfo.equals(curNodeId)) continue;
            return i;
        }
        return -1;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        List<String> searInfos = this.getSearchInfo(root, text);
        if (searInfos.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"ExecuteAnalyseReportShareListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("searchInfo", SerializationUtils.toJsonString(searInfos));
        String curNodeId = this.getPageCache().get("nodeId");
        String result = searInfos.get(0);
        if (!result.equals(curNodeId)) {
            this.focusNode(result);
        }
    }

    private TreeNode getRoot() {
        String rootJson = this.getPageCache().get("root");
        if (StringUtils.isEmpty((String)rootJson)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6839\u8282\u70b9\u4fe1\u606f\u5931\u8d25", (String)"ExecuteAnalyseReportShareListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)rootJson, TreeNode.class);
    }

    private List<String> getSearchInfo(TreeNode node, String text) {
        List children;
        ArrayList<String> searchInfos = new ArrayList<String>(16);
        String nodeText = node.getText();
        if (nodeText.contains(text)) {
            searchInfos.add(node.getId());
        }
        if ((children = node.getChildren()) == null || children.size() == 0) {
            return searchInfos;
        }
        children.forEach(e -> searchInfos.addAll(this.getSearchInfo((TreeNode)e, text)));
        return searchInfos;
    }

    private void focusNode(String nodeId) {
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        TreeNode treeNode = root.getTreeNode(nodeId, 5);
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId());
        this.treeNodeClick(evt);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.focusNode(treeNode);
    }

    @Override
    public boolean isCheckModel() {
        return true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit basedataEdit;
        String name = event.getProperty().getName();
        if (!MODEL.equals(name)) {
            return;
        }
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        this.addSpecialParam((FormShowParameter)showP);
        Object source = event.getSource();
        if (source instanceof BasedataEdit && !(basedataEdit = (BasedataEdit)source).isF7Click()) {
            Set ids = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            qs.add(new QFilter("id", "in", (Object)ids));
            qs.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
            event.setFormShowParameter((FormShowParameter)showP);
        }
    }

    public String getBGRPSpecialEntity() {
        return null;
    }

    public String getAppIdFromMsgCentral(String appId, Long modelId) {
        return this.getAppIdFromMsgCentral4BGRP(appId, modelId);
    }
}

