/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.executeanalyse.ReportShareHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.execanalyse.SchemeOrderDimension;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.model.utils.ModelUtil;

public class ExecuteAnalyseSchemeEditPlugin
extends AbstractFormPlugin {
    private final List<String> pageDim = Arrays.asList("datatype", "version", "audittrail", "changetype", "currency", "metric", "internalcompany");
    private final List<String> commonDim = Arrays.asList("entity", "account", "budgetperiod", "custom1", "custom2", "custom3", "custom4", "custom5", "custom6", "custom7", "custom8", "custom9");
    private DynamicObject curScheme = null;
    private SchemeDimension schemeDimension = null;
    private final List<SchemeColSetting> schemeColSettings = new ArrayList<SchemeColSetting>(16);
    private static final ExecuteAnalyseUtil executeAnalyseUtil = ExecuteAnalyseUtil.getInstance();
    private IModelCacheHelper modelCacheHelper = null;

    private IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = this.getIModelCacheHelper();
        }
        return this.modelCacheHelper;
    }

    private void filterByControlDimension(List<kd.epm.eb.common.model.Dimension> dimensionList, Long bizModelId) {
        List controlDimension = executeAnalyseUtil.getControlDimension(bizModelId);
        if (controlDimension.size() == 0) {
            return;
        }
        ArrayList<kd.epm.eb.common.model.Dimension> tmp = new ArrayList<kd.epm.eb.common.model.Dimension>(dimensionList);
        dimensionList.clear();
        for (kd.epm.eb.common.model.Dimension dimension : tmp) {
            Long pkId = dimension.getId();
            if (!controlDimension.contains(pkId)) continue;
            dimensionList.add(dimension);
        }
    }

    private SchemeDimension getDefaultDimension(List<kd.epm.eb.common.model.Dimension> dimensionList) {
        SchemeOrderDimension schemeDimension = new SchemeOrderDimension();
        dimensionList.forEach(arg_0 -> ExecuteAnalyseSchemeEditPlugin.lambda$getDefaultDimension$0((SchemeDimension)schemeDimension, arg_0));
        return schemeDimension;
    }

    private SchemeDimension getSchemeDimension(String memberJson, Long dataSetId) {
        SchemeDimension schemeDimension = (SchemeDimension)SerializationUtils.deSerializeFromBase64((String)memberJson);
        if (schemeDimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dataSetId);
        schemeDimension.getRowDimensions().forEach(e -> e.setViewId(modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, e.getNumber())));
        schemeDimension.getColDimensions().forEach(e -> e.setViewId(modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, e.getNumber())));
        schemeDimension.getPageDimensions().forEach(e -> e.setViewId(modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, e.getNumber())));
        return schemeDimension;
    }

    private EntryAp createEntryAp(SchemeDimension schemeDimension, List<SchemeColSetting> schemeColSettings) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setPageRow(10000);
        this.addRowDimColFieldAps(schemeDimension, entryAp);
        List colDimensions = schemeDimension.getColDimensions();
        if (colDimensions.size() == 0) {
            return entryAp;
        }
        HashMap colKeyMap = new HashMap(16);
        List dataCols = executeAnalyseUtil.convertSettingToCols(schemeColSettings, (kd.epm.eb.common.model.Dimension)colDimensions.get(0), colKeyMap, new ArrayList(16), this.getView());
        ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, new HashMap(16), (Collection)dataCols, (boolean)true, null);
        executeAnalyseUtil.addCtrlTip(entryAp, colKeyMap);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    private void addRowDimColFieldAps(SchemeDimension schemeDimension, EntryAp entryAp) {
        List rowDimCols = executeAnalyseUtil.createRowDimRelCols(this.getModelId(), schemeDimension);
        if (rowDimCols.size() > 0) {
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, new HashMap(16), (Collection)rowDimCols, (boolean)false, null);
            for (ControlAp item : entryAp.getItems()) {
                if (!(item instanceof EntryFieldGroupAp)) continue;
                ((EntryFieldGroupAp)item).setFreeze(true);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"dataset", "model"});
        this.addClickListeners(this.getAllDims().toArray(new String[0]));
        this.addClickListeners(new String[]{"rowdimprop_setting"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setAllDimUnVisible();
        this.initData();
        this.setLabelVisible();
        this.setControlDraggable();
        this.getModel().deleteEntryData("entryentity");
    }

    private void setLabelVisible() {
        boolean newEbApp = NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId());
        this.getView().setVisible(Boolean.valueOf(newEbApp), new String[]{"newebpagedimlable"});
        this.getView().setVisible(Boolean.valueOf(!newEbApp), new String[]{"bgmdpagedimlable"});
    }

    private void setAllDimUnVisible() {
        this.getView().setVisible(Boolean.valueOf(false), this.getAllDims().toArray(new String[0]));
    }

    private void initData() {
        this.initBaseData();
        this.initBusModelData();
    }

    private void initBaseData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        DynamicObject scheme = this.getCurScheme();
        if (scheme != null) {
            this.getModel().setValue("name", (Object)scheme.getString("name"));
            this.getModel().setValue("number", (Object)scheme.getString("number"));
            this.getModel().setValue("type", (Object)scheme.getString("type"));
            this.getModel().setValue("status", (Object)scheme.getString("status"));
            this.getModel().setValue("desc", (Object)scheme.getString("desc"));
            if (this.getPageCache().get("isNew") == null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
            }
        } else {
            this.getPageCache().put("isNew", "true");
        }
        if (!CentralAppBillService.getInstance().isModelAdmin(this.getModelId()) && !this.checkSharePerm()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
        }
    }

    private DynamicObject getCurScheme() {
        if (this.curScheme == null) {
            String curSchemeJson = this.getView().getPageCache().get("curScheme");
            if (StringUtils.isEmpty((String)curSchemeJson)) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object pkId = formShowParameter.getCustomParam("id");
                if (pkId == null) {
                    String curSchemeDynamicJson = (String)formShowParameter.getCustomParam("curScheme");
                    if (curSchemeDynamicJson == null) {
                        return null;
                    }
                    this.getPageCache().put("isNew", "true");
                    this.getPageCache().put("isOtherSave", "true");
                    this.curScheme = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)curSchemeDynamicJson);
                } else {
                    this.curScheme = BusinessDataServiceHelper.loadSingle((Object)ConvertUtils.toLong((Object)pkId), (String)"eb_execschemeentity");
                }
                this.cacheCurScheme(this.curScheme);
            } else {
                this.curScheme = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)curSchemeJson);
            }
        }
        return this.curScheme;
    }

    private List<SchemeColSetting> getSchemeColSettings() {
        if (this.schemeColSettings.size() == 0) {
            if (this.getPageCache().get("isOtherSave") != null) {
                List<SchemeColSetting> schemeColSettings = this.getSchemeSettingFromParam();
                if (schemeColSettings.size() == 0) {
                    this.schemeColSettings.addAll(executeAnalyseUtil.getSchemeColSettingsById(Long.valueOf(0L)));
                } else {
                    this.schemeColSettings.addAll(schemeColSettings);
                }
            } else {
                DynamicObject curScheme = this.getCurScheme();
                long schemeId = 0L;
                if (curScheme != null) {
                    schemeId = curScheme.getLong("id");
                }
                this.schemeColSettings.addAll(executeAnalyseUtil.getSchemeColSettingsById(Long.valueOf(schemeId)));
            }
        }
        return this.schemeColSettings;
    }

    private List<SchemeColSetting> getSchemeSettingFromParam() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String schemeSettings = (String)formShowParameter.getCustomParam("schemeSettings");
        if (StringUtils.isEmpty((String)schemeSettings)) {
            return new ArrayList<SchemeColSetting>(16);
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)schemeSettings);
    }

    private void initBusModelData() {
        DynamicObject scheme = this.getCurScheme();
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)modelId);
        if (scheme == null) {
            Long busModelId = 0L;
            if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || newEbModel) {
                List allDatasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
                if (allDatasets.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u96c6\u4fe1\u606f\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                busModelId = ((Dataset)allDatasets.get(0)).getId();
            } else {
                Object busModel = this.getView().getFormShowParameter().getCustomParam("busModel");
                if (busModel == null) {
                    return;
                }
                busModelId = ConvertUtils.toLong((Object)busModel);
            }
            this.getModel().setValue("dataset", (Object)busModelId);
            if (!this.dealBusModelChange(busModelId).booleanValue()) {
                return;
            }
        } else {
            long busModelId = scheme.getLong("bizmodel.id");
            this.getModel().setValue("dataset", (Object)busModelId);
            this.schemeDimension = this.getSchemeDimension(scheme.getString("memberjson"), busModelId);
            this.addNewCustomDim(this.schemeDimension, busModelId);
            executeAnalyseUtil.dealNoExistPropertyObjs(this.schemeDimension, modelId);
            this.cacheAllMemberInfos(this.schemeDimension, modelCacheHelper);
        }
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || newEbModel) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataset"});
        }
        this.cacheSchemeDimension(this.schemeDimension);
        this.initDimInfos(this.schemeDimension);
    }

    private void addNewCustomDim(SchemeDimension schemeDimension, Long busModelId) {
        List<kd.epm.eb.common.model.Dimension> dimensionList = this.getDimensionByDataSet(busModelId);
        Long bizModelId = this.getBizModelId(busModelId);
        this.filterByControlDimension(dimensionList, bizModelId);
        Map<String, kd.epm.eb.common.model.Dimension> dimensionMap = dimensionList.stream().collect(Collectors.toMap(kd.epm.eb.common.model.Dimension::getNumber, e -> e));
        Set<String> dimKeys = dimensionMap.keySet();
        HashSet schemeDimKeys = new HashSet(16);
        schemeDimension.getPageDimensions().forEach(e -> schemeDimKeys.add(e.getNumber()));
        schemeDimension.getRowDimensions().forEach(e -> schemeDimKeys.add(e.getNumber()));
        schemeDimension.getColDimensions().forEach(e -> schemeDimKeys.add(e.getNumber()));
        if (dimKeys.size() == schemeDimKeys.size()) {
            return;
        }
        dimKeys.removeAll(schemeDimKeys);
        ArrayList<kd.epm.eb.common.model.Dimension> toAddDimensions = new ArrayList<kd.epm.eb.common.model.Dimension>(16);
        dimKeys.forEach(e -> toAddDimensions.add((kd.epm.eb.common.model.Dimension)dimensionMap.get(e)));
        this.setDefaultMembers(toAddDimensions, bizModelId);
        this.replaceDimensionName(dimensionList);
        schemeDimension.getPageDimensions().addAll(toAddDimensions);
        this.getPageCache().put("needAutoSave", "true");
    }

    private Boolean dealBusModelChange(Long busModelId) {
        List<kd.epm.eb.common.model.Dimension> dimensionList = this.getDimensionByDataSet(busModelId);
        if (dimensionList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long bizModelId = this.getBizModelId(busModelId);
        this.filterByControlDimension(dimensionList, bizModelId);
        this.setDefaultMembers(dimensionList, bizModelId);
        this.replaceDimensionName(dimensionList);
        this.schemeDimension = this.getDefaultDimension(dimensionList);
        return true;
    }

    private void replaceDimensionName(List<kd.epm.eb.common.model.Dimension> dimensionList) {
        String replaceNameMapJson = this.getPageCache().get("replaceNameMap");
        if (StringUtils.isEmpty((String)replaceNameMapJson)) {
            return;
        }
        Map replaceNameMap = (Map)SerializationUtils.fromJsonString((String)replaceNameMapJson, HashMap.class);
        for (kd.epm.eb.common.model.Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            if (!replaceNameMap.containsKey(number)) continue;
            dimension.setName((String)replaceNameMap.get(number));
        }
    }

    private Long getBizModelId(Long busModelId) {
        return DatasetServiceHelper.getInstance().queryBizmodelByDatasetId(busModelId);
    }

    private Long getDataSetId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("dataset");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    private void setDefaultMembers(List<kd.epm.eb.common.model.Dimension> dimensionList, Long bizModelId) {
        Long modelId = this.getModelId();
        Map<String, List<String>> controlVersions = this.getControlVersions(bizModelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (kd.epm.eb.common.model.Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)number);
            if (dimensionEnum == null) {
                this.setAllMember(modelCacheHelper, dimension, true);
                continue;
            }
            switch (dimensionEnum) {
                case Entity: 
                case Account: 
                case BudgetPeriod: {
                    this.setAllMember(modelCacheHelper, dimension, false);
                    break;
                }
                case DataType: 
                case Version: 
                case AuditTrail: {
                    this.setControlVersionMember(modelCacheHelper, dimension, controlVersions, number);
                    break;
                }
                case ChangeType: {
                    this.setSpecialMember(modelCacheHelper, dimension, number, "CurrentPeriod");
                    break;
                }
                case Currency: {
                    this.setSpecialMember(modelCacheHelper, dimension, number, "CNY");
                    break;
                }
                case Metric: {
                    this.setSpecialMember(modelCacheHelper, dimension, number, "Money");
                    break;
                }
                case InternalCompany: {
                    this.setSpecialMember(modelCacheHelper, dimension, number, "ICNone");
                    break;
                }
            }
        }
    }

    private Map<String, List<String>> getControlVersions(Long bizModelId) {
        HashMap<String, List<String>> controlVersionMap = new HashMap<String, List<String>>(16);
        QFilter qFilter = new QFilter("bussmodel", "=", (Object)bizModelId);
        DynamicObjectCollection controlVersions = QueryServiceHelper.query((String)"eb_controlversion", (String)"version.number, invalidtime, datatype.number, audittrail.number", (QFilter[])new QFilter[]{qFilter});
        if (controlVersions == null || controlVersions.size() == 0) {
            return controlVersionMap;
        }
        Date now = TimeServiceHelper.now();
        ArrayList<String> versions = new ArrayList<String>(16);
        ArrayList<String> dataTypes = new ArrayList<String>(16);
        ArrayList<String> auditTrails = new ArrayList<String>(16);
        for (DynamicObject controlVersion : controlVersions) {
            String auditNumber;
            String dataTypeNumber;
            Date invalidTime = controlVersion.getDate("invalidtime");
            if (invalidTime != null && invalidTime.before(now)) continue;
            String versionNumber = controlVersion.getString("version.number");
            if (StringUtils.isNotEmpty((String)versionNumber)) {
                versions.add(versionNumber);
            }
            if (StringUtils.isNotEmpty((String)(dataTypeNumber = controlVersion.getString("datatype.number")))) {
                dataTypes.add(dataTypeNumber);
            }
            if (!StringUtils.isNotEmpty((String)(auditNumber = controlVersion.getString("audittrail.number")))) continue;
            auditTrails.add(auditNumber);
        }
        controlVersionMap.put(SysDimensionEnum.Version.getNumber(), versions);
        controlVersionMap.put(SysDimensionEnum.DataType.getNumber(), dataTypes);
        controlVersionMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrails);
        return controlVersionMap;
    }

    private void setSpecialMember(IModelCacheHelper modelCacheHelper, kd.epm.eb.common.model.Dimension dimension, String number, String memberNumber) {
        Member cacheHelperMember = modelCacheHelper.getMember(number, dimension.getViewId(), memberNumber);
        kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFormCache((Member)cacheHelperMember);
        if (member == null) {
            return;
        }
        List<kd.epm.eb.common.model.Member> members = Collections.singletonList(member);
        dimension.setMembers(members);
        executeAnalyseUtil.cacheMemberInfo(modelCacheHelper, dimension.getViewId(), this.getPageCache(), number, members);
    }

    private void setControlVersionMember(IModelCacheHelper modelCacheHelper, kd.epm.eb.common.model.Dimension dimension, Map<String, List<String>> controlVersions, String number) {
        List<String> members = controlVersions.get(number);
        if (members == null || members.size() == 0) {
            this.setAllMember(modelCacheHelper, dimension, false);
            return;
        }
        List memberList = modelCacheHelper.getMembers(number, dimension.getViewId(), members);
        if (memberList == null) {
            return;
        }
        ArrayList memberList_new = new ArrayList(16);
        memberList.forEach(e -> memberList_new.add(kd.epm.eb.common.model.Member.loadFormCache((Member)e)));
        dimension.setMembers(memberList_new);
        executeAnalyseUtil.cacheMemberInfo(modelCacheHelper, dimension.getViewId(), this.getPageCache(), number, memberList_new);
    }

    private void setAllMember(IModelCacheHelper modelCacheHelper, kd.epm.eb.common.model.Dimension dimension, boolean containSelf) {
        String number = dimension.getNumber();
        kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFormCache((Member)modelCacheHelper.getRootMember(number, dimension.getViewId()));
        if (member == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RangeEnum rangeEnum = RangeEnum.ALL_EXCLUDE;
        if (containSelf) {
            rangeEnum = RangeEnum.ALL;
        }
        member.setRange(rangeEnum.getIndex());
        List<kd.epm.eb.common.model.Member> members = Collections.singletonList(member);
        dimension.setMembers(members);
        executeAnalyseUtil.cacheMemberInfo(modelCacheHelper, dimension.getViewId(), this.getPageCache(), number, members);
    }

    private List<kd.epm.eb.common.model.Dimension> getDimensionByDataSet(Long busModelId) {
        List dimensions = DatasetServiceHelper.getInstance().listDimensionByDatasetId_Exec(busModelId);
        if (dimensions.isEmpty()) {
            return dimensions;
        }
        kd.epm.eb.common.model.Dimension dimension = DimensionServiceHelper.getDimension((Long)this.getModelId(), (String)SysDimensionEnum.Account.getNumber());
        dimensions.add(dimension);
        return dimensions;
    }

    private void cacheSchemeDimension(SchemeDimension schemeDimension) {
        this.getPageCache().put("schemeDimension", SerializationUtils.serializeToBase64((Object)schemeDimension));
    }

    public SchemeDimension getSchemeDimension() {
        String schemeDimensionJson;
        if (this.schemeDimension == null && StringUtils.isNotEmpty((String)(schemeDimensionJson = this.getPageCache().get("schemeDimension")))) {
            this.schemeDimension = (SchemeDimension)SerializationUtils.deSerializeFromBase64((String)schemeDimensionJson);
        }
        return this.schemeDimension;
    }

    private void initDimInfos(SchemeDimension schemeDimension) {
        ArrayList<String> visibleDims = new ArrayList<String>(16);
        this.initDimPanelData(schemeDimension.getPageDimensions(), visibleDims, "page");
        this.initDimPanelData(schemeDimension.getRowDimensions(), visibleDims, "row");
        this.initDimPanelData(schemeDimension.getColDimensions(), visibleDims, "col");
        this.reloadRowDimPanelProp(schemeDimension.getDimProperties());
        this.getView().setVisible(Boolean.valueOf(true), visibleDims.toArray(new String[0]));
        this.updateGridColumns(schemeDimension);
    }

    private void initDimPanelData(List<kd.epm.eb.common.model.Dimension> dimensions, List<String> visibleDims, String panelKey) {
        Map<String, String> customKeyMap = this.getCustomKeyMap();
        int customIndex = this.getMaxIndex(customKeyMap);
        boolean needUpdateKeyMap = false;
        boolean newEbForm = this.isNewEbForm();
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            String number = dimension.getNumber();
            if (newEbForm && SysDimensionEnum.InternalCompany.getNumber().equals(number)) continue;
            String controlKey = null;
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)number);
            if (dimensionEnum != null) {
                controlKey = panelKey + "_" + number.toLowerCase();
            } else {
                String customKey = "custom" + ++customIndex;
                controlKey = panelKey + "_" + customKey;
                String dimNum = customKeyMap.get(customKey);
                if (!number.equals(dimNum)) {
                    customKeyMap.put(customKey, number);
                    needUpdateKeyMap = true;
                }
            }
            visibleDims.add(controlKey);
            this.setDimMemberValue(dimension, controlKey);
        }
        if (needUpdateKeyMap) {
            this.getPageCache().put("customKeyMap", SerializationUtils.toJsonString(customKeyMap));
        }
    }

    private int getMaxIndex(Map<String, String> customKeyMap) {
        if (customKeyMap.size() == 0) {
            return 0;
        }
        int index = 0;
        for (String customKey : customKeyMap.keySet()) {
            String indexStr = customKey.replace("custom", "");
            index = Math.max(index, Integer.parseInt(indexStr));
        }
        return index;
    }

    private void setDimMemberValue(kd.epm.eb.common.model.Dimension dimension, String controlKey) {
        Set<Object> allMemNums = new HashSet(16);
        Dimension cacheDimension = this.getModelCacheHelper().getDimension(dimension.getNumber());
        if (cacheDimension != null) {
            allMemNums = cacheDimension.getAllMembers(dimension.getViewId()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        }
        ArrayList<String> showMembers = new ArrayList<String>(16);
        for (kd.epm.eb.common.model.Member member : dimension.getMembers()) {
            if (!allMemNums.contains(member.getNumber())) continue;
            showMembers.add(member.getName() + "_" + RangeEnum.getRangeByVal((int)member.getRange()).getName());
        }
        this.getModel().setValue(controlKey, (Object)String.join((CharSequence)";", showMembers));
        this.setControlProps(controlKey, dimension.getName());
    }

    private void setControlProps(String controlKey, String emptyText) {
        HashMap<String, Serializable> prop = new HashMap<String, Serializable>(1);
        HashMap<String, LocaleString> itemprop = new HashMap<String, LocaleString>(1);
        itemprop.put("emptytip", new LocaleString(emptyText));
        prop.put("draggable", Boolean.valueOf(true));
        prop.put("droppable", Boolean.valueOf(true));
        prop.put("item", itemprop);
        this.getView().updateControlMetadata(controlKey, prop);
    }

    private Map<String, String> getCustomKeyMap() {
        String customKeyMap = this.getPageCache().get("customKeyMap");
        if (StringUtils.isEmpty((String)customKeyMap)) {
            return new HashMap<String, String>(16);
        }
        return (Map)SerializationUtils.fromJsonString((String)customKeyMap, Map.class);
    }

    private List<String> getAllDims() {
        ArrayList<String> allDims = new ArrayList<String>(16);
        allDims.addAll(this.getDimKeys("page", true));
        allDims.addAll(this.getDimKeys("row", false));
        allDims.addAll(this.getDimKeys("col", false));
        return allDims;
    }

    private List<String> getDimKeys(String panelKey, boolean isPage) {
        ArrayList<String> dimKeys = new ArrayList<String>(16);
        if (isPage) {
            this.pageDim.forEach(e -> dimKeys.add(panelKey + "_" + e));
        }
        this.commonDim.forEach(e -> dimKeys.add(panelKey + "_" + e));
        return dimKeys;
    }

    private void updateGridColumns(SchemeDimension schemeDimension) {
        if (schemeDimension == null) {
            schemeDimension = this.getSchemeDimension();
        }
        List<SchemeColSetting> schemeColSettings = this.getSchemeColSettings();
        EntryAp entryAp = this.createEntryAp(schemeDimension, schemeColSettings);
        executeAnalyseUtil.updateGridColumns(entryAp, this.getView(), "entryentity");
    }

    private void setControlDraggable() {
        this.getControl("pagepanel").setDroppable(true);
        this.getControl("rowpanel").setDroppable(true);
        this.getControl("colpanel").setDroppable(true);
        ((Container)this.getControl("pagepanel")).getItems().forEach(item -> item.setDraggable(item.getKey().startsWith("page_")));
        ((Container)this.getControl("rowpanel")).getItems().forEach(item -> item.setDraggable(item.getKey().startsWith("row_")));
        ((Container)this.getControl("colpanel")).getItems().forEach(item -> item.setDraggable(item.getKey().startsWith("col_")));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (this.checkSchemeNotExist(itemKey)) {
            this.openTipPage();
            return;
        }
        if ("btn_save".equals(itemKey)) {
            this.saveScheme();
        } else if ("btn_view".equals(itemKey)) {
            this.viewReportPage();
        } else if ("metricdisplay".equals(itemKey)) {
            this.showFormMetricDisplay();
        } else if ("displaysetting".equals(itemKey)) {
            if (this.getModel().getValue("dataset") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long dataset = ((DynamicObject)this.getModel().getValue("dataset")).getLong("id");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
            formShowParameter.setCustomParam("datasetid", (Object)dataset);
            formShowParameter.setCustomParam("diffdisplaysettings", (Object)SerializationUtils.toJsonString(this.getDiffDisplaySettings()));
            SchemeDimension schemeDimension = this.getSchemeDimension();
            List<kd.epm.eb.common.model.Dimension> pageDimensions = this.getDimensionList(schemeDimension, "pagepanel");
            List<kd.epm.eb.common.model.Dimension> sortPageDimensionList = this.sortPageDimension(pageDimensions);
            formShowParameter.setCustomParam("dimensionList", (Object)SerializationUtils.serializeToBase64(sortPageDimensionList));
            formShowParameter.setFormId("eb_diffdisplaysetting");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "displaysetting"));
            this.getView().showForm(formShowParameter);
        }
    }

    private List<kd.epm.eb.common.model.Dimension> sortPageDimension(List<kd.epm.eb.common.model.Dimension> pageDimensions) {
        if (pageDimensions == null || pageDimensions.size() == 0) {
            return new ArrayList<kd.epm.eb.common.model.Dimension>(0);
        }
        Map<String, kd.epm.eb.common.model.Dimension> pageDimensionMap = pageDimensions.stream().collect(Collectors.toMap(kd.epm.eb.common.model.Dimension::getNumber, e -> e));
        ArrayList<String> pagePanelControlKeys = new ArrayList<String>(Arrays.asList("page_datatype", "page_version", "page_audittrail", "page_changetype", "page_currency", "page_metric", "page_internalcompany", "page_entity", "page_account", "page_budgetperiod"));
        for (int i = 1; i < 10; ++i) {
            pagePanelControlKeys.add("page_custom" + i);
        }
        ArrayList<kd.epm.eb.common.model.Dimension> sortList = new ArrayList<kd.epm.eb.common.model.Dimension>(pageDimensions.size());
        for (String key : pagePanelControlKeys) {
            kd.epm.eb.common.model.Dimension dimension = this.getDimension(key);
            if (dimension == null || !pageDimensionMap.containsKey(dimension.getNumber())) continue;
            sortList.add(pageDimensionMap.get(dimension.getNumber()));
        }
        return sortList;
    }

    public Map<String, Object> getDiffDisplaySettings() {
        String defUnitDisplay;
        String defEmptyrowDisplay;
        String defMemberDisplay;
        Set set;
        Object map;
        HashMap displaySettings = Maps.newHashMapWithExpectedSize((int)4);
        HashMap<String, Integer> metricDisplays = new HashMap<String, Integer>(16);
        HashSet metricDisplays_no_sep = new HashSet(16);
        HashSet hideDimensions = new HashSet(16);
        HashMap<String, Object> configMap = new HashMap(16);
        DynamicObject schemeObject = this.getCurScheme();
        if (schemeObject != null && kd.bos.util.StringUtils.isNotEmpty((String)schemeObject.getString("configjson"))) {
            configMap = (Map)SerializationUtils.fromJsonString((String)schemeObject.getString("configjson"), Map.class);
        }
        DynamicObjectCollection metrics = MetricUtils.getMetricsByDataType((Long)this.getModelId(), (Set)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}));
        String cachedValue = this.getPageCache().get("metricdisplay");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cachedValue)) {
            map = (Map)SerializationUtils.fromJsonString((String)cachedValue, Map.class);
            metricDisplays.putAll((Map<String, Integer>)map);
        } else {
            map = DiffAnalyzeHelper.getConfigMapByKey(configMap, "metricdisplay");
            if (map != null) {
                metricDisplays.putAll((Map<String, Integer>)map);
            }
        }
        for (DynamicObject dynamicObject : metrics) {
            metricDisplays.putIfAbsent(dynamicObject.getString("number"), dynamicObject.getInt("decimalnum"));
        }
        cachedValue = this.getPageCache().get("metricdisplay_no_sep");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cachedValue)) {
            set = (Set)SerializationUtils.fromJsonString((String)cachedValue, Set.class);
            metricDisplays_no_sep.addAll(set);
        } else {
            set = DiffAnalyzeHelper.getSetValueByConfigKey(configMap, "metricdisplay_no_sep");
            if (set != null) {
                metricDisplays_no_sep.addAll(set);
            }
        }
        cachedValue = this.getPageCache().get("hide_dimensions");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cachedValue)) {
            set = (Set)SerializationUtils.fromJsonString((String)cachedValue, Set.class);
            hideDimensions.addAll(set);
        } else {
            set = DiffAnalyzeHelper.getSetValueByConfigKey(configMap, "hide_dimensions");
            if (set != null) {
                hideDimensions.addAll(set);
            }
        }
        Map defMemberMap = null;
        if (this.getPageCache().get("defmember") != null) {
            defMemberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("defmember"), Map.class);
        }
        if (defMemberMap == null && configMap.get("defmember") != null) {
            defMemberMap = (Map)SerializationUtils.fromJsonString((String)((String)configMap.get("defmember")), Map.class);
        }
        if ((defMemberDisplay = this.getPageCache().get("defmemberdisplay")) == null) {
            defMemberDisplay = (String)configMap.get("defmemberdisplay");
        }
        if ((defEmptyrowDisplay = this.getPageCache().get("defemptyrowdisplay")) == null) {
            defEmptyrowDisplay = (String)configMap.get("defemptyrowdisplay");
        }
        if ((defUnitDisplay = this.getPageCache().get("defunitdisplay")) == null) {
            defUnitDisplay = (String)configMap.get("defunitdisplay");
        }
        displaySettings.put("defmemberdisplay", defMemberDisplay);
        displaySettings.put("defemptyrowdisplay", defEmptyrowDisplay);
        displaySettings.put("defunitdisplay", defUnitDisplay);
        displaySettings.put("metricdisplay", metricDisplays);
        displaySettings.put("metricdisplay_no_sep", metricDisplays_no_sep);
        displaySettings.put("hide_dimensions", hideDimensions);
        displaySettings.put("defmember", defMemberMap);
        return displaySettings;
    }

    private String getSchemeConfigJson(DynamicObject dynamicObject) {
        Map<String, Object> configMap = new HashMap(8);
        if (dynamicObject != null && StringUtils.isNotEmpty((String)dynamicObject.getString("configJson"))) {
            String configJson = dynamicObject.getString("configJson");
            configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        }
        SchemeDimension schemeDimension = this.getSchemeDimension();
        List rowDimensions = schemeDimension.getRowDimensions();
        List colDimensions = schemeDimension.getColDimensions();
        Map cacheMap = this.getView().getPageCache().getAll();
        String value = null;
        value = (String)cacheMap.get("def_col_dimension");
        if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
            configMap.put("def_col_dimension", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defmemberdisplay")))) {
            configMap.put("defmemberdisplay", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defemptyrowdisplay")))) {
            configMap.put("defemptyrowdisplay", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defunitdisplay")))) {
            configMap.put("defunitdisplay", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("metricdisplay")))) {
            configMap.put("metricdisplay", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("metricdisplay_no_sep")))) {
            configMap.put("metricdisplay_no_sep", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("hide_dimensions")))) {
            configMap.put("hide_dimensions", value);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defmember")))) {
            configMap.put("defmember", value);
        }
        ExecuteAnalyseSchemeEditPlugin.getConfigParam(configMap, cacheMap, "account_range", "TOP_ITEMS");
        return SerializationUtils.toJsonString(configMap);
    }

    public static Map<String, Object> getConfigParam(Map<String, Object> configMap, Map<String, String> cacheMap, String ctrlKey, String configKey) {
        String value;
        String string = value = cacheMap == null ? null : cacheMap.get(ctrlKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
            List list = (List)SerializationUtils.fromJsonString((String)value, List.class);
            ArrayList valList = new ArrayList(8);
            if (list != null && list.size() > 0) {
                for (Map map : list) {
                    HashMap valMap = new HashMap(1);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)((String)map.get("number")))) {
                        valMap.put("number", map.get("number"));
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)((String)map.get("scope")))) {
                        valMap.put("scope", map.get("scope"));
                    }
                    valList.add(valMap);
                }
                configMap.put(configKey, SerializationUtils.toJsonString(valList));
            }
        } else {
            configMap.remove(configKey);
        }
        return configMap;
    }

    private void showFormMetricDisplay() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        formShowParameter.setCustomParam("metricdisplay", (Object)SerializationUtils.toJsonString(this.getMetricDisplays()));
        formShowParameter.setFormId("eb_metricdisplay");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "metricdisplay"));
        this.getView().showForm(formShowParameter);
    }

    private Map<String, Object> getMetricDisplays() {
        HashMap<String, Object> metricDisplays = new HashMap<String, Object>(16);
        DynamicObjectCollection metrics = MetricUtils.getMetricsByDataType((Long)this.getModelId(), (Set)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}));
        String cachedMetricDisplay = this.getPageCache().get("metricdisplay");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cachedMetricDisplay)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)cachedMetricDisplay, Map.class);
            metricDisplays.putAll(map);
        } else {
            Map<String, Object> map;
            DynamicObject dynamicObject = this.getCurScheme();
            if (dynamicObject != null && (map = DiffAnalyzeHelper.getMetricDisplay(dynamicObject.getString("configjson"))) != null) {
                metricDisplays.putAll(map);
            }
        }
        for (DynamicObject dynamicObject : metrics) {
            metricDisplays.putIfAbsent(dynamicObject.getString("number"), dynamicObject.getInt("decimalnum"));
        }
        return metricDisplays;
    }

    private void viewReportPage() {
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme == null || curScheme.getLong("id") == 0L || this.getPageCache().get("isNew") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848", (String)"ExecuteAnalyseSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean enable = curScheme.getBoolean("status");
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u67e5\u770b\u542f\u7528\u65b9\u6848\u4e0b\u7684\u62a5\u8868\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        long schemeId = curScheme.getLong("id");
        this.autoSaveScheme(schemeId);
        ReportShowParameter formShowParameter = new ReportShowParameter();
        String formId = "eb_execanalysereport";
        formShowParameter.setCustomParam("schemeId", (Object)schemeId);
        formShowParameter.setCustomParam("model", (Object)modelId);
        long bizModel = curScheme.getLong("bizmodel.id");
        if (bizModel == 0L) {
            bizModel = curScheme.getLong("bizmodel");
        }
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)modelId)) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam((FormShowParameter)formShowParameter);
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam("dataset", (Object)bizModel);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openReport"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void autoSaveScheme(long schemeId) {
        if (this.getPageCache().get("needAutoSave") == null) {
            return;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_execschemeentity");
        SchemeDimension schemeDimension = this.getSchemeDimension();
        this.updateSchemeDimension(schemeDimension);
        this.cacheSchemeDimension(schemeDimension);
        scheme.set("memberjson", (Object)SerializationUtils.serializeToBase64((Object)schemeDimension));
        this.updateConfigJson(scheme);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        this.getPageCache().remove("needAutoSave");
    }

    private void saveScheme() {
        String name = this.getModel().getValue("name").toString();
        String number = this.getModel().getValue("number").toString();
        if (this.checkBeforeSave(number, name)) {
            return;
        }
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme == null) {
            curScheme = BusinessDataServiceHelper.newDynamicObject((String)"eb_execschemeentity");
            curScheme.set("id", (Object)DB.genGlobalLongId());
            curScheme.set("ispreset", (Object)false);
        }
        curScheme.set("name", (Object)name);
        curScheme.set("number", (Object)number);
        Long modelId = this.getModelId();
        curScheme.set("model", (Object)modelId);
        curScheme.set("bizmodel", (Object)((DynamicObject)this.getModel().getValue("dataset")).getLong("id"));
        curScheme.set("type", this.getModel().getValue("type"));
        curScheme.set("status", this.getModel().getValue("status"));
        curScheme.set("desc", this.getModel().getValue("desc"));
        SchemeDimension schemeDimension = this.getSchemeDimension();
        this.updateSchemeDimension(schemeDimension);
        this.cacheSchemeDimension(schemeDimension);
        curScheme.set("memberjson", (Object)SerializationUtils.serializeToBase64((Object)schemeDimension));
        Long userId = this.getUserId();
        curScheme.set("creater", (Object)userId);
        curScheme.set("creater_id", (Object)userId);
        curScheme.set("modifier", (Object)userId);
        curScheme.set("modifier_id", (Object)userId);
        curScheme.set("configjson", (Object)this.getSchemeConfigJson(curScheme));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curScheme});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.afterSave(curScheme, schemeDimension, modelId);
    }

    private void updateConfigJson(DynamicObject curScheme) {
        String metricDisplayStr = this.getPageCache().get("metricdisplay");
        if (StringUtils.isNotEmpty((String)metricDisplayStr)) {
            HashMap<String, String> configMap = new HashMap<String, String>(1);
            configMap.put("metricdisplay", metricDisplayStr);
            curScheme.set("configjson", (Object)SerializationUtils.toJsonString(configMap));
        }
    }

    private void afterSave(DynamicObject curScheme, SchemeDimension schemeDimension, Long modelId) {
        this.updateCache(curScheme, modelId);
        this.setControlEnable();
        this.writeLog(curScheme.getString("number"), "save", new MultiLangEnumBridge("\u4fdd\u5b58", "ExecuteAnalyseSchemeEditPlugin_38", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b9\u6848\uff1a%1$s\u4fdd\u5b58\u6210\u529f\u3002", "ExecuteAnalyseSchemeEditPlugin_39", "epm-eb-formplugin"), new String[]{curScheme.getString("number")});
    }

    private void updateCache(DynamicObject curScheme, Long modelId) {
        this.cacheCurScheme(curScheme);
        if (!modelId.equals(this.getModelByFormShow())) {
            this.getPageCache().put("changeModel", "true");
        } else {
            this.getPageCache().remove("changeModel");
        }
        this.getPageCache().remove("isNew");
        if (this.getPageCache().get("isOtherSave") != null) {
            this.saveSchemeSettings(curScheme.getLong("id"));
            this.getPageCache().remove("isOtherSave");
        }
        this.getPageCache().remove("needAutoSave");
    }

    private void setControlEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
    }

    private void saveSchemeSettings(Long schemeId) {
        List<SchemeColSetting> schemeSettings = this.getSchemeSettingFromParam();
        if (schemeSettings.size() == 0) {
            return;
        }
        long[] pkIds = DB.genGlobalLongIds((int)schemeSettings.size());
        int index = 0;
        for (SchemeColSetting schemeSetting : schemeSettings) {
            Long schemeId1 = schemeSetting.getSchemeId();
            if (schemeId1 == 0L) continue;
            schemeSetting.setSchemeId(schemeId);
            long pkId = pkIds[index++];
            SchemeColType colType = schemeSetting.getColType();
            if (SchemeColType.FORMULA == colType) {
                String settingNumber = schemeSetting.getNumber();
                schemeSetting.setNumber(settingNumber.replace(String.valueOf(schemeSetting.getId()), String.valueOf(pkId)));
            }
            schemeSetting.setId(Long.valueOf(pkId));
            schemeSetting.setNew(Boolean.valueOf(true));
        }
        List dynamicObjects = executeAnalyseUtil.convertSchemeSettingToDyn(schemeSettings);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
    }

    private void updateSchemeDimension(SchemeDimension schemeDimension) {
        this.updateDimensionMembers(schemeDimension.getPageDimensions(), "page");
        this.updateDimensionMembers(schemeDimension.getRowDimensions(), "row");
        this.updateDimensionMembers(schemeDimension.getColDimensions(), "col");
    }

    private void updateDimensionMembers(List<kd.epm.eb.common.model.Dimension> dimensions, String panel) {
        Map<String, String> customKeyMap = this.getCustomKeyMap();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            Object memberInfo;
            String number = dimension.getNumber();
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)number);
            String fieldKey = null;
            if (dimensionEnum != null) {
                fieldKey = panel + "_" + number;
            } else {
                String customKey = this.getCustomKey(customKeyMap, number);
                if (customKey == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6620\u5c04\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                fieldKey = panel + "_" + customKey;
            }
            if ((memberInfo = this.getModel().getValue(fieldKey)) != null && !StringUtils.isEmpty((String)memberInfo.toString())) continue;
            ArrayList members = new ArrayList(16);
            dimension.setMembers(members);
            executeAnalyseUtil.cacheMemberInfo(modelCacheHelper, dimension.getViewId(), this.getPageCache(), number, members);
        }
    }

    private String getCustomKey(Map<String, String> customKeyMap, String number) {
        for (Map.Entry<String, String> entry : customKeyMap.entrySet()) {
            String value = entry.getValue();
            if (!number.equals(value)) continue;
            return entry.getKey();
        }
        return number;
    }

    private void cacheCurScheme(DynamicObject scheme) {
        this.curScheme = scheme;
        this.getPageCache().put("curScheme", SerializationUtils.serializeToBase64((Object)scheme));
    }

    private boolean checkBeforeSave(String number, String name) {
        String result = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((String)result)) {
            this.getView().showTipNotification(result);
            return true;
        }
        if (name == null || StringUtils.isEmpty((String)name.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7eaf\u7a7a\u683c\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        SchemeDimension schemeDimension = this.getSchemeDimension();
        List rowDimensions = schemeDimension.getRowDimensions();
        List colDimensions = schemeDimension.getColDimensions();
        if (rowDimensions.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u8bbe\u7f6e\u884c\u7ef4\u5ea6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (colDimensions.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u5217\u7ef4\u5ea6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme != null && curScheme.get("id") != null) {
            qFilter.and("id", "!=", (Object)curScheme.getLong("id"));
        }
        qFilter.and("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"eb_execschemeentity", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5b58\u5728\u76f8\u540c\u7f16\u7801\u65b9\u6848\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        String checkResult = this.checkHideDefaultMember(schemeDimension);
        if (StringUtils.isNotEmpty((String)checkResult)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u663e\u793a\u8bbe\u7f6e\u4e2d\uff0c\u7ef4\u5ea6\u201c%1\u201d\u9690\u85cf\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u503c\u4e0d\u5728\u65b9\u6848\u7684\u6210\u5458\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{checkResult}));
            return true;
        }
        return false;
    }

    private String checkHideDefaultMember(SchemeDimension schemeDimension) {
        IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
        Map viewMap = cacheHelper.getViewsByDataSet(this.getDataSetId());
        String hideDimMemMapJson = this.getPageCache().get("defmember");
        if (StringUtils.isNotEmpty((String)hideDimMemMapJson)) {
            Map hideDimMemMap = (Map)SerializationUtils.fromJsonString((String)hideDimMemMapJson, Map.class);
            List pageDimensions = schemeDimension.getPageDimensions();
            for (kd.epm.eb.common.model.Dimension pageDimension : pageDimensions) {
                List members;
                String dimensionNumber = pageDimension.getNumber();
                if (hideDimMemMap.get(dimensionNumber) == null || CollectionUtils.isEmpty((Collection)(members = pageDimension.getMembers()))) continue;
                HashSet nums = new HashSet(16);
                for (kd.epm.eb.common.model.Member member : members) {
                    List memberList = cacheHelper.getMember(dimensionNumber, (Long)viewMap.get(dimensionNumber), member.getNumber(), member.getRange());
                    if (!CollectionUtils.isNotEmpty((Collection)memberList)) continue;
                    memberList.forEach(e -> nums.add(e.getNumber()));
                }
                if (nums.contains(hideDimMemMap.get(dimensionNumber))) continue;
                return pageDimension.getName();
            }
        }
        return null;
    }

    public void click(EventObject evt) {
        long schemeId;
        super.click(evt);
        if (this.checkSchemeNotExist(null)) {
            this.openTipPage();
            return;
        }
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme != null && curScheme.getLong("id") != 0L && this.getPageCache().get("isOtherSave") == null && ReportShareHelper.checkSingleEnjoyed((Long)(schemeId = curScheme.getLong("id")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5206\u4eab\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7ef4\u5ea6\u8bbe\u7f6e", (String)"ExecuteAnalyseSchemeEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String key = ((Control)evt.getSource()).getKey();
        if ("rowdimprop_setting".equals(key)) {
            this.setDimProperty();
        } else {
            this.dimMemberSelect(evt);
        }
    }

    private void dimMemberSelect(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        kd.epm.eb.common.model.Dimension dimension = this.getDimension(key);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object dataset = this.getModel().getValue("dataset");
        if (!(dataset instanceof DynamicObject)) {
            return;
        }
        String number = dimension.getNumber();
        long datasetId = ((DynamicObject)dataset).getLong("id");
        Long bizModelId = this.getBizModelId(datasetId);
        Long viewId = DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)bizModelId, (String)number);
        Long modelId = this.getModelId();
        RangeF7Param param = new RangeF7Param();
        param.setEnableView(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setBizModelId(bizModelId);
        param.setSign(number);
        if (SysDimensionEnum.Entity.getNumber().equals(number) || SysDimensionEnum.Account.getNumber().equals(number) || "epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)number))) {
            param.setShowExclude(true);
            List allMembers = dimension.getMembers();
            Set excludeMemberIds = allMembers.stream().filter(m -> m.isExclude()).map(kd.epm.eb.common.model.Member::getId).collect(Collectors.toSet());
            param.setExcludeMemberIds(excludeMemberIds);
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
            param.setqFilters(Collections.singletonList(new QFilter("dataset", "=", (Object)datasetId)));
        } else if (SysDimensionEnum.Metric.getNumber().equals(number)) {
            param.setqFilters(Collections.singletonList(new QFilter("datatype", "in", (Object)AnalyseReportUtil.dataTypes)));
        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(number)) {
            param.setQueryDecompose(true);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)number, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private kd.epm.eb.common.model.Dimension getDimension(String key) {
        String[] split = key.split("_");
        SchemeDimension schemeDimension = this.getSchemeDimension();
        List<kd.epm.eb.common.model.Dimension> dimensionList = this.getDimensionList(schemeDimension, this.getPanelKey(split[0]));
        if (dimensionList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.getDimension(dimensionList, this.getCustomKeyMap(), split[1]);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("drop".equals(e.getEventName())) {
            DynamicObject curScheme;
            List colDimensions;
            String eventArgs = e.getEventArgs();
            String[] msg = DiffAnalyzeHelper.translateMessage(eventArgs);
            String target = msg[0];
            if (target.startsWith("row_")) {
                target = "rowpanel";
            } else if (target.startsWith("col_")) {
                target = "colpanel";
            } else if (target.startsWith("page_")) {
                target = "pagepanel";
            }
            String source = msg[1];
            if (StringUtils.isEmpty((String)source)) {
                return;
            }
            String[] split = source.split("_");
            if (split.length != 2) {
                return;
            }
            String panelKey = this.getPanelKey(split[0]);
            if (target.equals(panelKey)) {
                return;
            }
            String dimControlKey = split[1];
            if (this.pageDim.contains(dimControlKey)) {
                if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u3001\u7248\u672c\u3001\u7ebf\u7d22\u3001\u53d8\u52a8\u7c7b\u578b\u3001\u5ea6\u91cf\u3001\u5e01\u79cd\u53ea\u80fd\u5728\u9875\u9762\u7ef4\u62a4\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u3001\u7248\u672c\u3001\u7ebf\u7d22\u3001\u53d8\u52a8\u7c7b\u578b\u3001\u5ea6\u91cf\u3001\u5e01\u79cd\u3001\u5f80\u6765\u7ec4\u7ec7\u4ec5\u53ef\u5728\u9875\u9762\u7ef4\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            SchemeDimension schemeDimension = this.getSchemeDimension();
            if ("rowpanel".equals(target)) {
                List rowDimensions = schemeDimension.getRowDimensions();
                if (rowDimensions.size() >= 5) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u4e0d\u80fd\u591a\u4e8e5\u4e2a", (String)"ExecuteAnalyseSchemeEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("colpanel".equals(target) && (colDimensions = schemeDimension.getColDimensions()).size() >= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u6700\u591a\u53ea\u80fd\u67091\u4e2a\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if ((curScheme = this.getCurScheme()) != null && curScheme.getLong("id") != 0L && this.getPageCache().get("isOtherSave") == null) {
                long schemeId = curScheme.getLong("id");
                if (ReportShareHelper.checkSingleEnjoyed((Long)schemeId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5206\u4eab\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7ef4\u5ea6\u8bbe\u7f6e", (String)"ExecuteAnalyseSchemeEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                FilterModel filterModel = new FilterModel();
                filterModel.setFormId("eb_execanalysereport");
                List filterSchemes = filterModel.getSchemeList();
                List curFilterSchemes = executeAnalyseUtil.filterSchemeByPkId(filterSchemes, Long.valueOf(schemeId));
                if (curFilterSchemes.size() == 0) {
                    this.changeDimAndUpdate(schemeDimension, panelKey, dimControlKey, target);
                    return;
                }
                String callBackId = "clearFilter" + panelKey + "_" + dimControlKey + "_" + target;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u7ef4\u5ea6\u8bbe\u7f6e\u5c06\u4f1a\u91cd\u7f6e\u62a5\u8868\u8fc7\u6ee4\u65b9\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExecuteAnalyseSchemeEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                return;
            }
            this.changeDimAndUpdate(schemeDimension, panelKey, dimControlKey, target);
        }
    }

    private void changeDimAndUpdate(SchemeDimension schemeDimension, String panelKey, String dimControlKey, String target) {
        Map<String, String> customKeyMap = this.getCustomKeyMap();
        List dimColOrder = schemeDimension.getDimColOrder();
        this.clearDimOrders(schemeDimension);
        kd.epm.eb.common.model.Dimension dimension = this.removePanelControl(schemeDimension, panelKey, customKeyMap, dimControlKey, dimColOrder);
        this.addNewPanelControl(schemeDimension, target, dimension, dimControlKey, dimColOrder);
        schemeDimension.setDimColOrder(dimColOrder);
        this.cacheSchemeDimension(schemeDimension);
        this.updateGridColumns(schemeDimension);
    }

    private kd.epm.eb.common.model.Dimension removePanelControl(SchemeDimension schemeDimension, String panelKey, Map<String, String> customKeyMap, String dimControlKey, List<String> dimColOrder) {
        List<kd.epm.eb.common.model.Dimension> dimensionList = this.getDimensionList(schemeDimension, panelKey);
        if (dimensionList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u5217\u8868\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        kd.epm.eb.common.model.Dimension dimension = this.getDimension(dimensionList, customKeyMap, dimControlKey);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        dimensionList.remove(dimension);
        String controlKey = this.getControlPreKey(panelKey) + "_" + dimControlKey;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{controlKey});
        this.getModel().setValue(controlKey, (Object)"");
        if ("rowpanel".equals(panelKey)) {
            this.removeDimRelPropertiesAndOrder(schemeDimension, dimension, dimColOrder);
        }
        return dimension;
    }

    private kd.epm.eb.common.model.Dimension getDimension(List<kd.epm.eb.common.model.Dimension> dimensionList, Map<String, String> customKeyMap, String dimControlKey) {
        String dimKey = null;
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)dimControlKey);
        if (dimensionEnum == null) {
            dimKey = customKeyMap.get(dimControlKey);
            if (StringUtils.isEmpty((String)dimKey)) {
                return null;
            }
        } else {
            dimKey = dimensionEnum.getNumber();
        }
        kd.epm.eb.common.model.Dimension retDimension = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            if (!number.equals(dimKey)) continue;
            retDimension = dimension;
            break;
        }
        return retDimension;
    }

    private List<kd.epm.eb.common.model.Dimension> getDimensionList(SchemeDimension schemeDimension, String panelKey) {
        if (StringUtils.isEmpty((String)panelKey)) {
            return null;
        }
        if ("pagepanel".equals(panelKey)) {
            return schemeDimension.getPageDimensions();
        }
        if ("rowpanel".equals(panelKey)) {
            return schemeDimension.getRowDimensions();
        }
        if ("colpanel".equals(panelKey)) {
            return schemeDimension.getColDimensions();
        }
        return null;
    }

    private void addNewPanelControl(SchemeDimension schemeDimension, String panelKey, kd.epm.eb.common.model.Dimension dimension, String dimControlKey, List<String> dimColOrder) {
        List<kd.epm.eb.common.model.Dimension> dimensionList = this.getDimensionList(schemeDimension, panelKey);
        if (dimensionList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u5217\u8868\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        dimensionList.add(dimension);
        String controlKey = this.getControlPreKey(panelKey) + "_" + dimControlKey;
        this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
        this.setDimMemberValue(dimension, controlKey);
        if ("rowpanel".equals(panelKey) && dimColOrder != null) {
            dimColOrder.add(dimension.getNumber());
        }
    }

    private String getPanelKey(String controlPreKey) {
        if (controlPreKey == null) {
            return null;
        }
        String panelKey = null;
        switch (controlPreKey) {
            case "page": {
                panelKey = "pagepanel";
                break;
            }
            case "row": {
                panelKey = "rowpanel";
                break;
            }
            case "col": {
                panelKey = "colpanel";
                break;
            }
        }
        return panelKey;
    }

    private String getControlPreKey(String panelKey) {
        if (panelKey == null) {
            return null;
        }
        String controlPreKey = null;
        switch (panelKey) {
            case "pagepanel": {
                controlPreKey = "page";
                break;
            }
            case "rowpanel": {
                controlPreKey = "row";
                break;
            }
            case "colpanel": {
                controlPreKey = "col";
                break;
            }
        }
        return controlPreKey;
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        return 0L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("dataset".equals(name)) {
            this.setAllDimUnVisible();
            if (newValue instanceof DynamicObject) {
                boolean success = this.dealBusModelChange(((DynamicObject)newValue).getLong("id"));
                if (!success) {
                    return;
                }
                SchemeDimension schemeDimension = this.getSchemeDimension();
                this.cacheSchemeDimension(schemeDimension);
                this.getPageCache().remove("customKeyMap");
                this.initDimInfos(schemeDimension);
            } else {
                this.removeCurSchemeDimension();
                EntryAp entryAp = new EntryAp();
                entryAp.setKey("entryentity");
                entryAp.setPageRow(10000);
                executeAnalyseUtil.updateGridColumns(entryAp, this.getView(), "entryentity");
            }
        } else if ("model".equals(name)) {
            if (!NewEbAppUtil.isNewEbApp((IFormView)this.getView()) && !NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
                this.getModel().setValue("dataset", null);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"dataset"});
            } else {
                if (newValue instanceof DynamicObject) {
                    List datasets = DatasetServiceHelper.getAllDatasets((Long)((DynamicObject)newValue).getLong("id"));
                    if (datasets.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u96c6\u4fe1\u606f\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("dataset", (Object)((Dataset)datasets.get(0)).getId());
                } else {
                    this.getModel().setValue("dataset", null);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataset"});
            }
        }
        this.getPageCache().put("isNew", "true");
    }

    private void removeCurSchemeDimension() {
        this.schemeDimension = null;
        this.getPageCache().remove("schemeDimension");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        if ("dataset".equals(name)) {
            Long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyseSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            qs.add(new QFilter("model", "=", (Object)modelId));
            Object bizModel = this.getView().getFormShowParameter().getCustomParam("bizModel");
            Long bizModelId = ConvertUtils.toLong((Object)bizModel);
            if (bizModelId != 0L && modelId.equals(this.getModelByFormShow())) {
                qs.add(new QFilter("businessmodel", "=", (Object)bizModelId));
            }
        } else if ("model".equals(name)) {
            ApplicationTypeEnum application;
            IFormView parentView = this.getView().getParentView();
            this.addSpecialParam((FormShowParameter)showP);
            String entityId = parentView.getEntityId();
            if (this.existSpecialParam()) {
                application = ModelUtil.queryApp((IFormView)parentView);
            } else {
                String curBizAppIndex = executeAnalyseUtil.getCurBizAppIndex(this.getView());
                showP.setCustomParam("special_appId", (Object)curBizAppIndex);
                application = ApplicationTypeEnum.getEnumByIndex((String)curBizAppIndex);
            }
            Set ids = ModelUtil.getModelIdsWithPerm((String)entityId, (ApplicationTypeEnum)application);
            qs.add(new QFilter("id", "in", (Object)ids));
        }
        event.setFormShowParameter((FormShowParameter)showP);
    }

    private Long getModelByFormShow() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (model instanceof Long) {
            return ConvertUtils.toLong((Object)model);
        }
        if (model instanceof String) {
            return Long.parseLong(model.toString());
        }
        return 0L;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (this.getAllDims().contains(actionId)) {
            kd.epm.eb.common.model.Dimension dimension = this.getDimension(actionId);
            if (dimension == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof DynamicObjectCollection) {
                DynamicObjectCollection retData = (DynamicObjectCollection)returnData;
                if (retData.size() == 0) {
                    dimension.setMembers(new ArrayList(16));
                } else {
                    ArrayList members = new ArrayList(16);
                    retData.forEach(e -> {
                        kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFromDynamicObject((DynamicObject)e);
                        this.updateMemberInfo(member, (DynamicObject)e);
                        members.add(member);
                    });
                    dimension.setMembers(members);
                }
                this.setDimMemberValue(dimension, actionId);
                this.cacheSchemeDimension(this.getSchemeDimension());
                executeAnalyseUtil.cacheMemberInfo(this.getIModelCacheHelper(), dimension.getViewId(), this.getPageCache(), dimension.getNumber(), dimension.getMembers());
            }
        } else if ("openColSetting".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.updateGridColumns(null);
            this.getPageCache().put("isNew", "true");
        } else if ("closeTip".equals(actionId)) {
            this.getPageCache().remove("isNew");
            this.getView().close();
        } else if ("openDimOrder".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            List dimOrders = (List)SerializationUtils.fromJsonString((String)returnData.toString(), ArrayList.class);
            SchemeDimension schemeDimension = this.getSchemeDimension();
            if (!(schemeDimension instanceof SchemeOrderDimension)) {
                schemeDimension = new SchemeOrderDimension(schemeDimension);
            }
            schemeDimension.setDimColOrder(dimOrders);
            this.updateGridColumns(schemeDimension);
            this.cacheSchemeDimension(schemeDimension);
            this.getPageCache().put("isNew", "true");
        } else if ("metricdisplay".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() instanceof String) {
                this.getPageCache().put("metricdisplay", (String)closedCallBackEvent.getReturnData());
            }
        } else if ("callback_propertysetting".equals(actionId)) {
            this.propertySettingCloseCallBack(closedCallBackEvent.getReturnData());
        } else if ("displaysetting".equals(actionId) && closedCallBackEvent.getReturnData() instanceof String) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)((String)closedCallBackEvent.getReturnData()));
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof String) {
                    this.getPageCache().put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                this.getPageCache().put((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
            }
        }
    }

    private void updateMemberInfo(kd.epm.eb.common.model.Member member, DynamicObject memberDyn) {
        String mid = memberDyn.getString("mid");
        member.setId(ConvertUtils.toLong((Object)mid));
        String longNumber = memberDyn.getString("longnumber");
        String[] split = longNumber.split("!");
        member.setLevel(split.length);
        int scope = memberDyn.getInt("scope");
        member.setRange(scope);
        member.setExclude(memberDyn.getBoolean("exclude"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.checkSchemeNotExist(null)) {
            this.openTipPage();
            args.setCancel(true);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("colsetting".equals(formOperate.getOperateKey())) {
            this.openColSettingPage();
        } else if ("colorder".equals(formOperate.getOperateKey())) {
            this.openColOrderPage();
        }
    }

    private void openColOrderPage() {
        Object dataset = this.getModel().getValue("dataset");
        if (dataset == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_dimcolorder");
        SchemeDimension schemeDimension = this.getSchemeDimension();
        List dimColOrder = schemeDimension.getDimColOrder();
        if (CollectionUtils.isEmpty((Collection)dimColOrder)) {
            dimColOrder = executeAnalyseUtil.getSchemeDefaultDimColOrder(schemeDimension);
        }
        formShowParameter.setCustomParam("dimColOrders", (Object)SerializationUtils.toJsonString((Object)dimColOrder));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openDimOrder"));
        this.getView().showForm(formShowParameter);
    }

    private void clearDimOrders(SchemeDimension schemeDimension) {
        List dimColOrder = schemeDimension.getDimColOrder();
        if (dimColOrder != null) {
            schemeDimension.setDimColOrder(null);
        }
    }

    private void openColSettingPage() {
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme == null || curScheme.getLong("id") == 0L || this.getPageCache().get("isNew") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848", (String)"ExecuteAnalyseSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object dataset = this.getModel().getValue("dataset");
        if (dataset == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_execcolsetting");
        formShowParameter.setCustomParam("schemeId", (Object)curScheme.getLong("id"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openColSetting"));
        this.getView().showForm(formShowParameter);
    }

    private void cacheAllMemberInfos(SchemeDimension schemeDimension, IModelCacheHelper modelCacheHelper) {
        this.cacheDimMemberInfos(schemeDimension.getRowDimensions(), modelCacheHelper);
        this.cacheDimMemberInfos(schemeDimension.getColDimensions(), modelCacheHelper);
        this.cacheDimMemberInfos(schemeDimension.getPageDimensions(), modelCacheHelper);
    }

    private void cacheDimMemberInfos(List<kd.epm.eb.common.model.Dimension> dimensions, IModelCacheHelper modelCacheHelper) {
        dimensions.forEach(e -> executeAnalyseUtil.cacheMemberInfo(modelCacheHelper, e.getViewId(), this.getPageCache(), e.getNumber(), e.getMembers()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("changeModel") != null) {
            this.getView().returnDataToParent((Object)this.getModelId());
        }
        if (this.getPageCache().get("isNew") != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u6790\u65b9\u6848\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4fee\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"ExecuteAnalyseSchemeEditPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = event.getCallBackId();
        if ("closeConfirm".equals(callBackId)) {
            this.getPageCache().remove("isNew");
            this.getView().close();
        } else if (callBackId.startsWith("clearFilter")) {
            this.clearAllFilterSchemes();
            String[] split = callBackId.replace("clearFilter", "").split("_");
            if (split.length != 3) {
                return;
            }
            this.changeDimAndUpdate(this.getSchemeDimension(), split[0], split[1], split[2]);
        }
    }

    private void clearAllFilterSchemes() {
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme == null) {
            return;
        }
        FilterModel filterModel = new FilterModel();
        filterModel.setFormId("eb_execanalysereport");
        List filterSchemes = filterModel.getSchemeList();
        long schemeId = curScheme.getLong("id");
        List curFilterSchemes = executeAnalyseUtil.filterSchemeByPkId(filterSchemes, Long.valueOf(schemeId));
        StringBuilder errMessage = new StringBuilder();
        curFilterSchemes.forEach(e -> filterModel.deleteScheme(e.getId(), errMessage));
        if (errMessage.length() != 0) {
            throw new KDBizException(errMessage.toString());
        }
        this.updateShareRecord(schemeId);
    }

    private void updateShareRecord(long schemeId) {
        QFilter qf = new QFilter("reportid", "=", (Object)String.valueOf(schemeId));
        ArrayList updateRecords = new ArrayList(16);
        Map records = BusinessDataServiceHelper.loadFromCache((String)"eb_reportshare", (QFilter[])new QFilter[]{qf});
        if (records.size() == 0) {
            return;
        }
        records.values().forEach(e -> {
            e.set("data", (Object)"");
            updateRecords.add(e);
        });
        SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
    }

    private boolean checkSchemeNotExist(String itemKey) {
        if ("btn_close".equals(itemKey)) {
            return false;
        }
        DynamicObject curScheme = this.getCurScheme();
        if (curScheme != null && curScheme.getLong("id") != 0L && this.getPageCache().get("isOtherSave") == null) {
            return !QueryServiceHelper.exists((String)"eb_execschemeentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curScheme.getLong("id"))});
        }
        return false;
    }

    private void openTipPage() {
        String tipInfo = ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u5220\u9664\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeTip");
        executeAnalyseUtil.openTipPage(tipInfo, this.getView(), closeCallBack);
    }

    private void removeDimRelPropertiesAndOrder(SchemeDimension schemeDimension, kd.epm.eb.common.model.Dimension dimension, List<String> dimColOrder) {
        HashSet orderSigns = Sets.newHashSet((Object[])new String[]{dimension.getNumber()});
        List dimProperties = (List)schemeDimension.getDimProperties().get(dimension.getNumber());
        if (CollectionUtils.isNotEmpty((Collection)dimProperties)) {
            Map<String, String> propToControlKeys = this.getPropToControlKeys();
            ArrayList<String> propControlKeys = new ArrayList<String>(dimProperties.size());
            for (PropertyObj dimProperty : dimProperties) {
                orderSigns.add("rowdimprop_" + dimProperty.getId());
                String controlKey = propToControlKeys.get("rowdimprop_" + dimProperty.getId());
                if (!StringUtils.isNotEmpty((String)controlKey) || this.getControl(controlKey) == null) continue;
                propControlKeys.add(controlKey);
                this.getModel().setValue(controlKey, null);
            }
            dimProperties.clear();
            this.getView().setVisible(Boolean.valueOf(false), propControlKeys.toArray(new String[0]));
        }
        if (dimColOrder != null) {
            dimColOrder.removeAll(orderSigns);
        }
    }

    private void setDimProperty() {
        SchemeDimension schemeDimension = this.getSchemeDimension();
        if (schemeDimension == null) {
            return;
        }
        List rowDimensions = schemeDimension.getRowDimensions();
        List<Map<String, String>> dimMaps = this.getDimMapsUseOfSetProperty(rowDimensions);
        if (CollectionUtils.isEmpty(dimMaps)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u8bbe\u7f6e\u5c5e\u6027\u7684\u884c\u7ef4\u5ea6\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Map<String, String>> selectedPropertyMap = this.getSelectedPropertyMap(schemeDimension);
        FormShowParameter showParam = new FormShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId("eb_dimpropertysetting");
        showParam.setCustomParam("model", (Object)this.getModelId());
        showParam.setCustomParam("dimMaps", (Object)SerializationUtils.toJsonString(dimMaps));
        showParam.setCustomParam("propertyMaps", (Object)SerializationUtils.toJsonString(selectedPropertyMap));
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_propertysetting"));
        showParam.setCaption(ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6\u5c5e\u6027\u8bbe\u7f6e", (String)"ExecuteAnalyseSchemeEditPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParam);
    }

    private List<Map<String, String>> getDimMapsUseOfSetProperty(List<kd.epm.eb.common.model.Dimension> rowDimensions) {
        if (CollectionUtils.isEmpty(rowDimensions)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> dimMaps = new ArrayList<Map<String, String>>(rowDimensions.size());
        for (kd.epm.eb.common.model.Dimension rowDimension : rowDimensions) {
            String dimensionNumber = rowDimension.getNumber();
            if (!"Entity".equals(dimensionNumber) && !"Account".equals(dimensionNumber) && SysDimensionEnum.include((String)dimensionNumber, (Boolean)true)) continue;
            HashMap<String, String> dimMap = new HashMap<String, String>(3);
            dimMap.put("id", String.valueOf(rowDimension.getId()));
            dimMap.put("number", String.valueOf(dimensionNumber));
            dimMap.put("name", String.valueOf(rowDimension.getName()));
            dimMaps.add(dimMap);
        }
        return dimMaps;
    }

    private List<Map<String, String>> getSelectedPropertyMap(SchemeDimension schemeDimension) {
        List rowDimensions = schemeDimension.getRowDimensions();
        Map dimProperties = schemeDimension.getDimProperties();
        if (CollectionUtils.isEmpty((Map)dimProperties)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> propItemsMap = new ArrayList<Map<String, String>>(10);
        for (kd.epm.eb.common.model.Dimension rowDimension : rowDimensions) {
            List propertyObjs = (List)dimProperties.get(rowDimension.getNumber());
            if (CollectionUtils.isEmpty((Collection)propertyObjs)) continue;
            for (PropertyObj propertyObj : propertyObjs) {
                String keyStr = rowDimension.getId() + "#" + propertyObj.getId();
                String id = String.valueOf(propertyObj.getId());
                String name = propertyObj.getName();
                String number = propertyObj.getNumber();
                String dseq = String.valueOf(propertyObj.getDseq());
                String dimId = String.valueOf(rowDimension.getId());
                String dimName = rowDimension.getName();
                String dimNum = rowDimension.getNumber();
                propItemsMap.add(TemplateHelper.getF7ItemMap(keyStr, id, name, number, dimId, dimName, dimNum, dseq));
            }
        }
        return propItemsMap;
    }

    private void propertySettingCloseCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            List f7items = (List)data.get("f7items");
            if (f7items == null) {
                return;
            }
            int limitCount = 10;
            if (f7items.size() > limitCount) {
                f7items = f7items.subList(0, limitCount);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u884c\u7ef4\u5ea6\u6700\u5927\u8bbe\u7f6e%1\u4e2a\u7ef4\u5ea6\u5c5e\u6027\uff0c\u9ed8\u8ba4\u53d6\u524d%1\u4e2a\u3002", (String)"ExecuteAnalyseSchemeEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{limitCount}));
            }
            HashMap<String, List<PropertyObj>> dimProperties = new HashMap<String, List<PropertyObj>>(16);
            for (Map f7item : f7items) {
                List propertyObjs = dimProperties.computeIfAbsent((String)f7item.get("dimnum"), (Function<String, List<PropertyObj>>)((Function<String, List>)e -> new ArrayList(10)));
                PropertyObj propertyObj = new PropertyObj(IDUtils.toLong(f7item.get("id")), (String)f7item.get("name"), (String)f7item.get("number"));
                propertyObjs.add(propertyObj);
            }
            SchemeDimension schemeDimension = this.getSchemeDimension();
            this.reloadRowDimPanelProp(dimProperties);
            schemeDimension.setDimProperties(dimProperties);
            this.adjustDimOrders(schemeDimension);
            this.updateGridColumns(schemeDimension);
            this.cacheSchemeDimension(schemeDimension);
        }
    }

    private void adjustDimOrders(SchemeDimension schemeDimension) {
        List dimColOrder = schemeDimension.getDimColOrder();
        if (dimColOrder == null) {
            return;
        }
        HashSet orderSet = new HashSet(dimColOrder);
        Map dimProperties = schemeDimension.getDimProperties();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        HashSet<String> newPropertySigns = new HashSet<String>(16);
        for (Map.Entry entry : dimProperties.entrySet()) {
            Dimension dimension;
            String dimNumber = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)value) || (dimension = modelCacheHelper.getDimension(dimNumber)) == null) continue;
            for (PropertyObj propertyObj : value) {
                int insetIndex;
                String propSign = "rowdimprop_" + propertyObj.getId();
                newPropertySigns.add(propSign);
                if (orderSet.contains(propSign) || (insetIndex = this.findInsertIndex(dimColOrder, dimension, memberPropCache)) < 0 || insetIndex >= dimColOrder.size()) continue;
                dimColOrder.add(insetIndex + 1, propSign);
            }
        }
        dimColOrder.removeIf(e -> e.startsWith("rowdimprop_") && !newPropertySigns.contains(e));
    }

    private int findInsertIndex(List<String> dimColOrder, Dimension dimension, MemberPropCache memberPropCache) {
        int index = 0;
        for (int i = 0; i < dimColOrder.size(); ++i) {
            String order = dimColOrder.get(i);
            if (!StringUtils.equals((String)order, (String)dimension.getNumber())) continue;
            index = i;
            int i1 = i + 1;
            while (i1 < dimColOrder.size()) {
                String _order = dimColOrder.get(i1);
                if (_order.startsWith("rowdimprop_")) {
                    CustomProperty _property = memberPropCache.getProperty(IDUtils.toLong((Object)_order.split("_")[1]));
                    if (_property == null || !IDUtils.equals((Object)_property.getDimId(), (Object)dimension.getId())) {
                        return index;
                    }
                } else {
                    return index;
                }
                index = i1++;
            }
        }
        return index;
    }

    private void reloadRowDimPanelProp(Map<String, List<PropertyObj>> dimProperties) {
        ArrayList<String> dimPropControlKeys = new ArrayList<String>(0);
        for (int i = 0; i < 10; ++i) {
            dimPropControlKeys.add("rowdimprop_" + i);
        }
        this.getView().setVisible(Boolean.valueOf(false), dimPropControlKeys.toArray(new String[0]));
        HashMap<String, String> propToControlKeyMap = new HashMap<String, String>(16);
        if (CollectionUtils.isNotEmpty(dimProperties)) {
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            int i = 0;
            ArrayList<String> propControlKeys = new ArrayList<String>(10);
            for (Map.Entry<String, List<PropertyObj>> entry : dimProperties.entrySet()) {
                if (i >= 10) break;
                String dimNumber = entry.getKey();
                List<PropertyObj> propertyObjs = entry.getValue();
                Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                if (dimension == null || CollectionUtils.isEmpty(propertyObjs)) continue;
                for (PropertyObj propertyObj : propertyObjs) {
                    String controlKey = "rowdimprop_" + i;
                    if (this.getControl(controlKey) == null) continue;
                    propControlKeys.add(controlKey);
                    propToControlKeyMap.put("rowdimprop_" + propertyObj.getId(), controlKey);
                    String propShowValue = dimension.getName() + "_" + propertyObj.getName();
                    this.getModel().setValue(controlKey, (Object)propShowValue);
                    ++i;
                }
            }
            this.getView().setVisible(Boolean.valueOf(true), propControlKeys.toArray(new String[0]));
        }
        this.cachePropToControlKeys(propToControlKeyMap);
        String value = (String)this.getModel().getValue((String)dimPropControlKeys.get(0));
        if (StringUtils.isNotEmpty((String)value) && CollectionUtils.isEmpty(dimProperties)) {
            this.getPageCache().put("isNew", "true");
        }
    }

    private void cachePropToControlKeys(Map<String, String> propToControlKeyMap) {
        this.putCache("propToControlKeyMap", SerializationUtils.toJsonString(propToControlKeyMap));
    }

    private Map<String, String> getPropToControlKeys() {
        String cache = (String)this.getCache("propToControlKeyMap", String.class);
        if (StringUtils.isNotEmpty((String)cache)) {
            return (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        return new HashMap<String, String>(0);
    }

    private boolean checkSharePerm() {
        String appId = this.getBizAppId();
        Long modelId = this.getModelId();
        String formId = "eb_execanalysereport";
        return FunPermissionHelper.checkPageModelFunPerm((long)this.getUserId(), (long)modelId, (String)appId, (String)formId, (String)"16/IQBV3L=/T", (IFormView)this.getView(), (boolean)true);
    }

    private static /* synthetic */ void lambda$getDefaultDimension$0(SchemeDimension schemeDimension, kd.epm.eb.common.model.Dimension e) {
        if (SysDimensionEnum.Account.getNumber().equals(e.getNumber())) {
            schemeDimension.getRowDimensions().add(e);
        } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(e.getNumber())) {
            schemeDimension.getColDimensions().add(e);
        } else {
            schemeDimension.getPageDimensions().add(e);
        }
    }
}

