/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.executeanalyse.ReportShareHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dataSet.BusinessModel;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.AnalyseType;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.executeanalyse.AnalyseCommonMethod;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class ExecuteAnalyseSchemeListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
AnalyseCommonMethod {
    private final List<String> unableKeys = Arrays.asList("analysetype", "rowdim", "accountrange", "coldim", "desc");
    private final Set<String> ignoreKeys = Sets.newHashSet((Object[])new String[]{"number", "name", "creater", "creater_id", "createdate", "modifier", "modifier_id", "modifydate", "creator", "creator_id", "createtime", "modifytime"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"itemap"});
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(this::search);
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "edit", "enjoy", "unable", "enable", "view"});
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addF7SelectListener(this::beforeF7Select, new String[]{"model"});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (modelId == null || modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExecuteAnalyseSchemeListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.initTree();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addnew": {
                this.openSchemeEditPage(0L);
                break;
            }
            case "btn_copy": {
                this.copyScheme();
                break;
            }
            case "btn_del": {
                this.delete();
                break;
            }
            case "btn_enjoyrecord": {
                this.openEnjoyRecordList();
                break;
            }
            case "btn_enable": {
                this.enableSchemes(true);
                break;
            }
            case "btn_unable": {
                this.enableSchemes(false);
                break;
            }
            case "btn_refresh": {
                this.initTree();
                break;
            }
        }
    }

    private void delete() {
        int[] selectRows = this.getSelectedRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ExecuteAnalyseSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> allPkIds = this.getAllPkIds(selectRows);
        if (this.checkBeforeDelete(allPkIds, selectRows)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u6570\u636e\uff1f", (String)"ExecuteAnalyseSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteSchemes", (IFormPlugin)this));
    }

    private void openSchemeEditPage(Long schemeId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        AnalyseType analyseType = null;
        if (schemeId != 0L) {
            formShowParameter.setCustomParam("id", (Object)schemeId);
            int focusRow = this.getFocusRow();
            String isPreset = this.getModel().getValue("ispreset", focusRow).toString();
            boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(this.getModelId());
            if (Convert.toBool((Object)isPreset, (Boolean)false).booleanValue() && !modelAdmin) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ExecuteAnalyseSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String type = this.getModel().getValue("analysetype", focusRow).toString();
            analyseType = AnalyseType.getEnumByValue((String)type);
            boolean isShare = "2".equals(this.getModel().getValue("schemetype", focusRow));
            if (isShare && !modelAdmin) {
                String fromId;
                String string = fromId = analyseType == AnalyseType.EXECUTE ? "eb_execanalysereport" : "eb_diffanalysis";
                if (!this.checkSharePerm(fromId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u6743\u9650\uff0c\u4e0d\u53ef\u7f16\u8f91\u5171\u4eab\u65b9\u6848\u3002", (String)"ExecuteAnalyseSchemeListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            formShowParameter.setCustomParam("busModel", this.getModel().getValue("dataset"));
        } else {
            String curNode = this.getPageCache().get("curNode");
            String[] split = curNode.split("_");
            analyseType = AnalyseType.getEnumByValue((String)split[0]);
            int length = split.length;
            if (length >= 2) {
                formShowParameter.setCustomParam("bizModel", (Object)split[1]);
                if (length == 3) {
                    formShowParameter.setCustomParam("busModel", (Object)split[2]);
                }
            }
        }
        if (analyseType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u65b9\u6848\u7c7b\u578b", (String)"ExecuteAnalyseSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (AnalyseType.ALL == analyseType && schemeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u6839\u8282\u70b9\u65b0\u589e\u65b9\u6848\u3002", (String)"ExecuteAnalyseSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        if (AnalyseType.EXECUTE == analyseType) {
            formShowParameter.setFormId("eb_execanalysescheme");
        } else {
            formShowParameter.setFormId("eb_diffanalysis_scheme");
            this.replaceParamKey(formShowParameter.getCustomParams());
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u591a\u7ef4\u5206\u6790\u65b9\u6848", (String)"ExecuteAnalyseSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView())) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam(formShowParameter);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openSchemePage"));
        this.getView().showForm(formShowParameter);
    }

    private void replaceParamKey(Map<String, Object> customParams) {
        this.replaceParamKey(customParams, "model", "KEY_MODEL_ID");
        this.replaceParamKey(customParams, "busModel", "eb_dataset");
        this.replaceParamKey(customParams, "dataset", "eb_dataset");
        this.replaceParamKey(customParams, "id", "eb_diffanalyzescheme");
        this.replaceParamKey(customParams, "schemeId", "eb_diffanalyzescheme");
    }

    private void replaceParamKey(Map<String, Object> customParams, String preKey, String nextKey) {
        Object value = customParams.remove(preKey);
        if (value != null) {
            customParams.put(nextKey, String.valueOf(value));
        }
    }

    private void copyScheme() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"ExecuteAnalyseSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> copySchemes_exec = new ArrayList<DynamicObject>(16);
        HashMap<Long, DynamicObject> copySchemes_diff = new HashMap<Long, DynamicObject>(16);
        ArrayList<SchemeColSetting> colSettings = new ArrayList<SchemeColSetting>(16);
        HashMap<String, String> copySchemeMap = new HashMap<String, String>(16);
        for (int selectedRow : selectedRows) {
            this.getCopyScheme(selectedRow, colSettings, copySchemes_exec, copySchemes_diff, copySchemeMap);
        }
        SaveServiceHelper.save((DynamicObject[])copySchemes_exec.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])copySchemes_diff.values().toArray(new DynamicObject[0]));
        List dynamicObjects = ExecuteAnalyseUtil.getInstance().convertSchemeSettingToDyn(colSettings);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        dynamicObjects = ExecuteAnalyseUtil.getInstance().convertDiffToDyn(copySchemes_diff);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ExecuteAnalyseSchemeListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (Map.Entry entry : copySchemeMap.entrySet()) {
            this.writeLog((String)entry.getValue(), "copy", new MultiLangEnumBridge("\u590d\u5236", "ExecuteAnalyseSchemeListPlugin_38", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u65b9\u6848\uff1a%1$s\u6210\u529f\uff0c\u65b0\u65b9\u6848\uff1a%2$s\u3002", "ExecuteAnalyseSchemeListPlugin_42", "epm-eb-formplugin"), new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
    }

    private void getCopyScheme(int selectedRow, List<SchemeColSetting> colSettings, List<DynamicObject> copySchemes_exec, Map<Long, DynamicObject> copySchemes_diff, Map<String, String> copySchemeMap) {
        String entityKey;
        Long pkId = ConvertUtils.toLong((Object)this.getModel().getValue("pkid", selectedRow));
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(entityKey = this.getSelectEntityKey(selectedRow)));
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u65b9\u6848\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long userId = this.getUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject scheme_copy = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
        DynamicObjectUtils.copy((DynamicObject)scheme, (DynamicObject)scheme_copy, this.ignoreKeys);
        long schemeId = DB.genGlobalLongId();
        String number = scheme.getString("number");
        String indexStr = ExecuteAnalyseUtil.getInstance().getCopyIndex(number, entityKey, this.getModelId());
        String number_copy = number + indexStr;
        this.checkNumberLength(number_copy);
        String name_copy = scheme.getString("name") + indexStr;
        this.checkNameLength(name_copy);
        scheme_copy.set("number", (Object)number_copy);
        copySchemeMap.put(number, number_copy);
        scheme_copy.set("name", (Object)name_copy);
        scheme_copy.set("id", (Object)schemeId);
        scheme_copy.set("type", (Object)"1");
        if ("eb_execschemeentity".equals(entityKey)) {
            scheme_copy.set("ispreset", (Object)false);
            List schemeColSettings = ExecuteAnalyseUtil.getInstance().getSchemeColSettingsById(pkId, false);
            long[] pkIds = DB.genGlobalLongIds((int)schemeColSettings.size());
            int index = 0;
            for (SchemeColSetting schemeSetting : schemeColSettings) {
                schemeSetting.setSchemeId(Long.valueOf(schemeId));
                long replace_id = pkIds[index++];
                schemeSetting.setNew(Boolean.valueOf(true));
                SchemeColType colType = schemeSetting.getColType();
                if (SchemeColType.FORMULA == colType) {
                    String settingNumber = schemeSetting.getNumber();
                    schemeSetting.setNumber(settingNumber.replace(String.valueOf(schemeSetting.getId()), String.valueOf(replace_id)));
                }
                schemeSetting.setId(Long.valueOf(replace_id));
                colSettings.add(schemeSetting);
            }
            scheme_copy.set("creater", (Object)userId);
            scheme_copy.set("createdate", (Object)now);
            scheme_copy.set("modifier", (Object)userId);
            scheme_copy.set("modifydate", (Object)now);
            copySchemes_exec.add(scheme_copy);
        } else {
            scheme_copy.set("creator", (Object)userId);
            scheme_copy.set("createtime", (Object)now);
            scheme_copy.set("modifier", (Object)userId);
            scheme_copy.set("modifytime", (Object)now);
            copySchemes_diff.put(pkId, scheme_copy);
        }
    }

    private void checkNumberLength(String propertyString) {
        if (propertyString.length() > 75) {
            throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u65b9\u6848\u540e\uff0c\u7f16\u7801\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc775\u4e2a\u5b57\u7b26\u3002", (String)"ExecuteAnalyseSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkNameLength(String propertyString) {
        if (propertyString.length() > 250) {
            throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u65b9\u6848\u540e\uff0c\u540d\u79f0\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7250\u4e2a\u5b57\u7b26\u3002", (String)"ExecuteAnalyseSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String getSelectEntityKey(int selectedRow) {
        String entityKey = null;
        AnalyseType type = this.getCurSchemeAnalyseType(selectedRow);
        if (AnalyseType.EXECUTE == type) {
            entityKey = "eb_execschemeentity";
        } else if (AnalyseType.MULTI_DIM == type) {
            entityKey = "eb_diffanalyzescheme";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u65b9\u6848\u7c7b\u578b", (String)"ExecuteAnalyseSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return entityKey;
    }

    private AnalyseType getCurSchemeAnalyseType(int selectedRow) {
        if (selectedRow == -1) {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ExecuteAnalyseSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            selectedRow = selectedRows[0];
        }
        String analyseType = this.getModel().getValue("analysetype", selectedRow).toString();
        return AnalyseType.getEnumByValue((String)analyseType);
    }

    private void refreshBillList() {
        String curNodeId = this.getPageCache().get("curNode");
        TreeNode root = this.getRoot();
        if (root == null || StringUtils.isEmpty((String)curNodeId)) {
            return;
        }
        TreeNode focusNode = root.getTreeNode(curNodeId, 5);
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
        this.treeNodeClick(evt);
    }

    private int[] getSelectedRows() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        return cardEntry.getEntryState().getSelectedRows();
    }

    private void deleteScheme() {
        int[] selectRows = this.getSelectedRows();
        List<Long> allPkIds = this.getAllPkIds(selectRows);
        QFilter qFilter = new QFilter("id", "in", allPkIds);
        HashSet<String> deleteSchemes = new HashSet<String>(16);
        this.getSchemes("eb_execschemeentity", qFilter, deleteSchemes);
        int deleteSize = DeleteServiceHelper.delete((String)"eb_execschemeentity", (QFilter[])new QFilter[]{qFilter});
        this.deleteSchemeCols(allPkIds);
        this.getSchemes("eb_diffanalyzescheme", qFilter, deleteSchemes);
        DeleteServiceHelper.delete((String)"eb_diffanalyzescheme", (QFilter[])new QFilter[]{qFilter});
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ExecuteAnalyseSchemeListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (deleteSize != 0) {
            this.deleteFilterSchemes(allPkIds);
        }
        this.writeLog(null, "delete", new MultiLangEnumBridge("\u5220\u9664", "ExecuteAnalyseSchemeListPlugin_39", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b9\u6848\uff1a%1$s\u5df2\u5220\u9664\u3002", "ExecuteAnalyseSchemeListPlugin_43", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", deleteSchemes)});
    }

    private void getSchemes(String entityKey, QFilter qFilter, Set<String> schemes) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityKey, (String)"number", (QFilter[])new QFilter[]{qFilter});
        query.forEach(e -> schemes.add(e.getString("number")));
    }

    private void deleteFilterSchemes(List<Long> allPkIds) {
        FilterModel filterModel = new FilterModel();
        filterModel.setFormId("eb_execanalysereport");
        List filterSchemes = filterModel.getSchemeList();
        ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
        List curFilterSchemes = instance.filterSchemeByPkIds(filterSchemes, allPkIds);
        StringBuilder errMessage = new StringBuilder();
        curFilterSchemes.forEach(e -> filterModel.deleteScheme(e.getId(), errMessage));
        if (errMessage.length() != 0) {
            throw new KDBizException(errMessage.toString());
        }
    }

    private List<Long> getAllPkIds(int[] selectRows) {
        ArrayList<Long> allPkIds = new ArrayList<Long>(16);
        for (int selectedRow : selectRows) {
            Object pkId = this.getModel().getValue("pkid", selectedRow);
            allPkIds.add(ConvertUtils.toLong((Object)pkId));
        }
        return allPkIds;
    }

    private boolean checkBeforeDelete(List<Long> pkIds, int[] selectRows) {
        boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(this.getModelId());
        for (int selectRow : selectRows) {
            AnalyseType analyseTypeEnum;
            String analyseType = this.getModel().getValue("analysetype", selectRow).toString();
            String isPreset = this.getModel().getValue("ispreset", selectRow).toString();
            if (!Convert.toBool((Object)isPreset, (Boolean)false).booleanValue() || AnalyseType.MULTI_DIM != (analyseTypeEnum = AnalyseType.getEnumByValue((String)analyseType)) && modelAdmin) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExecuteAnalyseSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        List schemeIds = pkIds.stream().map(Object::toString).collect(Collectors.toList());
        if (ReportShareHelper.checkEnjoyed(schemeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5b58\u5728\u6709\u6548\u7684\u5206\u4eab\u8bb0\u5f55\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u4eab\u3002", (String)"ExecuteAnalyseSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void deleteSchemeCols(List<Long> pkIds) {
        pkIds.remove(0L);
        if (pkIds.size() != 0) {
            QFilter qFilter = new QFilter("exescheme", "in", pkIds);
            DeleteServiceHelper.delete((String)"eb_execcolentity", (QFilter[])new QFilter[]{qFilter});
        }
    }

    private void openEnjoyRecordList() {
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("model", this.getModelId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParams(customParams);
        String formId = "bgm_report_share_list";
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            parameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam(parameter);
        parameter.setFormId(formId);
        parameter.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u62a5\u8868\u5206\u4eab\u5217\u8868", (String)"ExecuteAnalyseSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void enableSchemes(boolean enable) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528/\u7981\u7528\u7684\u6570\u636e\u3002", (String)"ExecuteAnalyseSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(this.getModelId());
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        for (int selectedRow : selectedRows) {
            String isPreset = this.getModel().getValue("ispreset", selectedRow).toString();
            if (Convert.toBool((Object)isPreset, (Boolean)false).booleanValue() && !modelAdmin) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u542f\u7528/\u7981\u7528\u9884\u7f6e\u65b9\u6848\u3002", (String)"ExecuteAnalyseSchemeListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pkId = this.getModel().getValue("pkid", selectedRow);
            pkIds.add(ConvertUtils.toLong((Object)pkId));
        }
        this.updateSchemeStatus(pkIds, "eb_execschemeentity", enable);
        this.updateSchemeStatus(pkIds, "eb_diffanalyzescheme", enable);
        this.refreshBillList();
        HashSet<String> enableSchemes = new HashSet<String>(16);
        QFilter qFilter = new QFilter("id", "in", pkIds);
        this.getSchemes("eb_execschemeentity", qFilter, enableSchemes);
        this.getSchemes("eb_diffanalyzescheme", qFilter, enableSchemes);
        this.enableLog(enableSchemes, enable);
    }

    private void updateSchemeStatus(List<Long> pkIds, String entityKey, boolean enable) {
        DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityKey).getDynamicObjectType());
        if (schemes == null) {
            return;
        }
        for (DynamicObject scheme : schemes) {
            scheme.set("status", (Object)enable);
        }
        SaveServiceHelper.save((DynamicObject[])schemes);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        String[] split = nodeId.toString().split("_");
        AnalyseType analyseType = AnalyseType.getEnumByValue((String)split[0]);
        if (analyseType == null) {
            return;
        }
        int length = split.length;
        switch (length) {
            case 1: {
                this.rootOrTypeNodeClick(analyseType);
                break;
            }
            case 2: {
                this.bizModelNodeClick(analyseType, split[1]);
                break;
            }
            case 3: {
                this.busModelNodeClick(analyseType, split[2]);
                break;
            }
        }
        this.getPageCache().put("curNode", nodeId.toString());
    }

    private void rootOrTypeNodeClick(AnalyseType analyseType) {
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        List bizModels = this.getBizModels(null, this.getModelId());
        bizModels.forEach(e -> busModelIds.addAll(e.getBusModels().stream().map(BusinessModel::getId).collect(Collectors.toList())));
        if (AnalyseType.ALL == analyseType) {
            this.loadAllSchemes(busModelIds);
        } else if (AnalyseType.MULTI_DIM == analyseType) {
            this.loadMultiDimSchemes(busModelIds);
        } else {
            this.loadExecuteSchemes(busModelIds, true);
        }
    }

    private void loadAllSchemes(List<Long> busModelIds) {
        this.loadMultiDimSchemes(busModelIds);
        this.loadExecuteSchemes(busModelIds, false);
    }

    private void loadMultiDimSchemes(List<Long> busModelIds) {
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection schemes = this.getMultiSchemes(busModelIds);
        if (schemes == null) {
            return;
        }
        for (int i = schemes.size() - 1; i >= 0; --i) {
            DynamicObject scheme = (DynamicObject)schemes.get(i);
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("pkid", (Object)scheme.getString("id"), newEntryRow);
            this.getModel().setValue("dataset", (Object)scheme.getString("dataset"), newEntryRow);
            this.getModel().setValue("analysetype", (Object)AnalyseType.MULTI_DIM.getValue(), newEntryRow);
            this.getModel().setValue("analysetype_text", (Object)ResManager.loadResFormat((String)"\u65b9\u6848\u7c7b\u578b\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{AnalyseType.MULTI_DIM.getDesc()}), newEntryRow);
            this.getModel().setValue("name", (Object)scheme.getString("name"), newEntryRow);
            this.getModel().setValue("schemetype", (Object)scheme.getString("type"), newEntryRow);
            List<kd.epm.eb.common.model.Member> members = this.getAccountMembers(scheme);
            String accountRange = members.stream().map(e -> e.getName() + "_" + RangeEnum.getRangeByVal((int)e.getRange()).getName()).collect(Collectors.joining("\u3001"));
            this.getModel().setValue("accountrange", (Object)accountRange, newEntryRow);
            this.getModel().setValue("accountrange_text", (Object)ResManager.loadResFormat((String)"\u79d1\u76ee\u8303\u56f4\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{accountRange}), newEntryRow);
            String chineseName = SysDimensionEnum.BudgetPeriod.getChineseName();
            this.getModel().setValue("coldim", (Object)chineseName, newEntryRow);
            this.getModel().setValue("coldim_text", (Object)ResManager.loadResFormat((String)"\u5217\u7ef4\u5ea6\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{chineseName}), newEntryRow);
            String schemeDesc = scheme.getString("desc");
            this.getModel().setValue("desc", (Object)schemeDesc, newEntryRow);
            this.getModel().setValue("desc_text", (Object)ResManager.loadResFormat((String)"\u8bf4\u660e\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDesc}), newEntryRow);
            this.getModel().setValue("ispreset", (Object)"false", newEntryRow);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            cardEntry.setChildVisible(false, newEntryRow, this.getUnVisibleKeys(scheme, true));
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, this.unableKeys.toArray(new String[0]));
        }
        this.getView().updateView("entryentity");
    }

    private void loadExecuteSchemes(List<Long> busModelIds, boolean deleteSchemes) {
        DynamicObjectCollection schemes;
        if (deleteSchemes) {
            this.getModel().deleteEntryData("entryentity");
        }
        if ((schemes = this.getExecSchemes(busModelIds)) == null) {
            return;
        }
        for (int i = schemes.size() - 1; i >= 0; --i) {
            DynamicObject scheme = (DynamicObject)schemes.get(i);
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("pkid", (Object)scheme.getString("id"), newEntryRow);
            this.getModel().setValue("dataset", (Object)scheme.getString("bizmodel"), newEntryRow);
            this.getModel().setValue("analysetype", (Object)AnalyseType.EXECUTE.getValue(), newEntryRow);
            this.getModel().setValue("analysetype_text", (Object)ResManager.loadResFormat((String)"\u65b9\u6848\u7c7b\u578b\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{AnalyseType.EXECUTE.getDesc()}), newEntryRow);
            this.getModel().setValue("name", (Object)scheme.getString("name"), newEntryRow);
            this.getModel().setValue("schemetype", (Object)scheme.getString("type"), newEntryRow);
            Map<String, List<String>> dimMap = this.getDimMap(scheme);
            String row = String.join((CharSequence)"\u3001", (Iterable<? extends CharSequence>)dimMap.get("row"));
            this.getModel().setValue("rowdim", (Object)row, newEntryRow);
            this.getModel().setValue("rowdim_text", (Object)ResManager.loadResFormat((String)"\u884c\u7ef4\u5ea6\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[]{row}), newEntryRow);
            String col = String.join((CharSequence)"\u3001", (Iterable<? extends CharSequence>)dimMap.get("col"));
            this.getModel().setValue("coldim", (Object)col, newEntryRow);
            this.getModel().setValue("coldim_text", (Object)ResManager.loadResFormat((String)"\u5217\u7ef4\u5ea6\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{col}), newEntryRow);
            String schemeDesc = scheme.getString("desc");
            this.getModel().setValue("desc", (Object)schemeDesc, newEntryRow);
            this.getModel().setValue("desc_text", (Object)ResManager.loadResFormat((String)"\u8bf4\u660e\uff1a%1", (String)"ExecuteAnalyseSchemeListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDesc}), newEntryRow);
            this.getModel().setValue("ispreset", (Object)String.valueOf(scheme.getBoolean("ispreset")), newEntryRow);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            cardEntry.setChildVisible(false, newEntryRow, this.getUnVisibleKeys(scheme, false));
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, this.getExecuteUnableKeys(scheme));
        }
        this.getView().updateView("entryentity");
    }

    private Map<String, List<String>> getDimMap(DynamicObject scheme) {
        HashMap<String, List<String>> dimMap = new HashMap<String, List<String>>(16);
        SchemeDimension schemeDimension = this.getSchemeDimension(scheme.getString("memberjson"));
        List rowDimensions = schemeDimension.getRowDimensions();
        dimMap.put("row", rowDimensions.stream().map(Dimension::getName).collect(Collectors.toList()));
        List colDimensions = schemeDimension.getColDimensions();
        dimMap.put("col", colDimensions.stream().map(Dimension::getName).collect(Collectors.toList()));
        return dimMap;
    }

    private List<kd.epm.eb.common.model.Member> getAccountMembers(DynamicObject scheme) {
        Map configJson;
        String topItems;
        ArrayList<kd.epm.eb.common.model.Member> members = new ArrayList<kd.epm.eb.common.model.Member>(16);
        String schemeConfigJson = scheme.getString("configjson");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (StringUtils.isNotEmpty((String)schemeConfigJson) && StringUtils.isNotEmpty((String)(topItems = (String)(configJson = (Map)SerializationUtils.fromJsonString((String)schemeConfigJson, Map.class)).get("TOP_ITEMS")))) {
            String[] topItem_split;
            for (String item : topItem_split = topItems.split(",")) {
                Member cacheMember;
                if (!StringUtils.isNotEmpty((String)item) || (cacheMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, item)) == null) continue;
                members.add(kd.epm.eb.common.model.Member.loadFormCache((Member)cacheMember));
            }
        }
        if (members.size() == 0) {
            String accountNumber = SysDimensionEnum.Account.getNumber();
            kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFormCache((Member)modelCacheHelper.getMember(accountNumber, null, accountNumber));
            if (member == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            member.setRange(RangeEnum.ALL.getIndex());
            members.add(member);
        }
        return members;
    }

    private SchemeDimension getSchemeDimension(String memberJson) {
        SchemeDimension schemeDimension = (SchemeDimension)SerializationUtils.deSerializeFromBase64((String)memberJson);
        if (schemeDimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return schemeDimension;
    }

    private String[] getExecuteUnableKeys(DynamicObject scheme) {
        boolean status;
        ArrayList<String> unableKeyList = new ArrayList<String>(16);
        unableKeyList.addAll(this.unableKeys);
        boolean isPreset = scheme.getBoolean("ispreset");
        if (isPreset) {
            unableKeyList.add("enjoy");
            unableKeyList.add("unable");
        }
        if (!(status = scheme.getBoolean("status"))) {
            unableKeyList.add("enjoy");
        }
        return unableKeyList.toArray(new String[0]);
    }

    private String[] getUnVisibleKeys(DynamicObject scheme, boolean isMulti) {
        ArrayList<String> unVisibleKeys = new ArrayList<String>(16);
        if (isMulti) {
            unVisibleKeys.add("btn_preset");
            unVisibleKeys.add("rowdim");
            unVisibleKeys.add("rowdim_text");
        } else {
            if (!scheme.getBoolean("ispreset")) {
                unVisibleKeys.add("btn_preset");
            }
            unVisibleKeys.add("accountrange");
            unVisibleKeys.add("accountrange_text");
        }
        boolean status = scheme.getBoolean("status");
        if (status) {
            unVisibleKeys.add("btn_unablestatus");
            unVisibleKeys.add("enable");
        } else {
            unVisibleKeys.add("btn_enablestatus");
            unVisibleKeys.add("unable");
        }
        String type = scheme.getString("type");
        if ("2".equals(type)) {
            unVisibleKeys.add("type_self_vector");
            unVisibleKeys.add("type_self");
        } else {
            unVisibleKeys.add("type_enjoy_vector");
            unVisibleKeys.add("type_enjoy");
        }
        return unVisibleKeys.toArray(new String[0]);
    }

    private DynamicObjectCollection getExecSchemes(List<Long> busModelIds) {
        QFilter qFilter = this.getExecQFilter(busModelIds);
        return QueryServiceHelper.query((String)"eb_execschemeentity", (String)"id, name, type, desc, memberjson, ispreset, status, bizmodel", (QFilter[])new QFilter[]{qFilter}, (String)"modifydate");
    }

    private QFilter getExecQFilter(List<Long> busModelIds) {
        QFilter qFilter = ExecuteAnalyseUtil.getInstance().getQFilter(busModelIds, "bizmodel", "creater", this.getModelId(), false, false);
        boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(this.getModelId());
        if (!modelAdmin) {
            QFilter qFilter1 = new QFilter("ispreset", "=", (Object)true);
            qFilter1.and("status", "=", (Object)true);
            QFilter qFilter2 = new QFilter("ispreset", "=", (Object)false);
            QFilter qFilter3 = qFilter1.or(qFilter2);
            qFilter.and(qFilter3);
        }
        return qFilter;
    }

    private DynamicObjectCollection getMultiSchemes(List<Long> busModelIds) {
        QFilter qFilter = this.getMultiQFilter(busModelIds);
        return QueryServiceHelper.query((String)"eb_diffanalyzescheme", (String)"id, name, type, desc, configjson, status, dataset", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime");
    }

    private QFilter getMultiQFilter(List<Long> busModelIds) {
        return ExecuteAnalyseUtil.getInstance().getQFilter(busModelIds, "dataset", "creator", this.getModelId(), false, false);
    }

    private void bizModelNodeClick(AnalyseType analyseType, String bizModelId) {
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        List bizModels = this.getBizModels(Collections.singletonList(ConvertUtils.toLong((Object)bizModelId)), this.getModelId());
        bizModels.forEach(e -> busModelIds.addAll(e.getBusModels().stream().map(BusinessModel::getId).collect(Collectors.toList())));
        if (AnalyseType.MULTI_DIM == analyseType) {
            this.loadMultiDimSchemes(busModelIds);
        } else if (AnalyseType.EXECUTE == analyseType) {
            this.loadExecuteSchemes(busModelIds, true);
        }
    }

    private void busModelNodeClick(AnalyseType analyseType, String busModelId) {
        List<Long> busModelIdList = Collections.singletonList(ConvertUtils.toLong((Object)busModelId));
        if (AnalyseType.MULTI_DIM == analyseType) {
            this.loadMultiDimSchemes(busModelIdList);
        } else if (AnalyseType.EXECUTE == analyseType) {
            this.loadExecuteSchemes(busModelIdList, true);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        List<String> searInfos = this.getSearchInfo(root, text);
        if (searInfos.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"ExecuteAnalyseSchemeListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.cacheSearchInfo(searInfos);
        String curNodeId = this.getPageCache().get("curNode");
        String result = searInfos.get(0);
        if (!result.equals(curNodeId)) {
            this.focusNode(result);
        }
    }

    private void focusNode(String nodeId) {
        TreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        TreeNode treeNode = root.getTreeNode(nodeId, 5);
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId());
        this.treeNodeClick(evt);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.focusNode(treeNode);
    }

    private void cacheSearchInfo(List<String> searInfos) {
        this.getPageCache().put("searchInfo", SerializationUtils.toJsonString(searInfos));
    }

    private List<String> getSearchInfo(TreeNode node, String text) {
        List children;
        ArrayList<String> searchInfos = new ArrayList<String>(16);
        String nodeText = node.getText();
        if (nodeText.contains(text)) {
            searchInfos.add(node.getId());
        }
        if ((children = node.getChildren()) == null || children.size() == 0) {
            return searchInfos;
        }
        children.forEach(e -> searchInfos.addAll(this.getSearchInfo((TreeNode)e, text)));
        return searchInfos;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Long schemeId = this.getCurSelectedSchemeId();
        switch (key) {
            case "edit": {
                this.openSchemeEditPage(schemeId);
                break;
            }
            case "enable": {
                this.setSchemeStatus(schemeId, true);
                break;
            }
            case "unable": {
                this.setSchemeStatus(schemeId, false);
                break;
            }
            case "searchbefore": {
                this.searchMove(true);
                break;
            }
            case "searchnext": {
                this.searchMove(false);
                break;
            }
            case "view": {
                this.viewReport(this.getFocusRow());
                break;
            }
        }
    }

    private void searchMove(boolean isBefore) {
        String curNodeId = this.getPageCache().get("curNode");
        String searchInfo = this.getPageCache().get("searchInfo");
        if (searchInfo == null) {
            return;
        }
        List searchList = (List)SerializationUtils.fromJsonString((String)searchInfo, List.class);
        if (searchList.size() == 0) {
            return;
        }
        int index = this.getCurSearchIndex(searchList, curNodeId);
        if (index == -1) {
            this.focusNode((String)searchList.get(0));
        } else {
            index = isBefore ? --index : ++index;
            if (index < 0 || index >= searchList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u4e2a\u6216\u6700\u540e\u4e00\u4e2a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u627e\u3002", (String)"ExecuteAnalyseSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.focusNode((String)searchList.get(index));
        }
    }

    private int getCurSearchIndex(List<String> searchList, String curNodeId) {
        for (int i = 0; i < searchList.size(); ++i) {
            String searchInfo = searchList.get(i);
            if (!searchInfo.equals(curNodeId)) continue;
            return i;
        }
        return -1;
    }

    private void setSchemeStatus(Long schemeId, boolean enable) {
        int focusRow = this.getFocusRow();
        String isPreset = this.getModel().getValue("ispreset", focusRow).toString();
        if (Convert.toBool((Object)isPreset, (Boolean)false).booleanValue() && !CentralAppBillService.getInstance().isModelAdmin(this.getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u542f\u7528/\u7981\u7528\u9884\u7f6e\u65b9\u6848\u3002", (String)"ExecuteAnalyseSchemeListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectEntityKey = this.getSelectEntityKey(focusRow);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)selectEntityKey);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u65b9\u6848\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean status = scheme.getBoolean("status");
        if (enable && status || !enable && !status) {
            return;
        }
        scheme.set("status", (Object)enable);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        ArrayList<String> unVisibleKeys = new ArrayList<String>(16);
        ArrayList<String> visibleKeys = new ArrayList<String>(16);
        if (enable) {
            unVisibleKeys.add("btn_unablestatus");
            unVisibleKeys.add("enable");
            visibleKeys.add("btn_enablestatus");
            visibleKeys.add("unable");
        } else {
            visibleKeys.add("btn_unablestatus");
            visibleKeys.add("enable");
            unVisibleKeys.add("btn_enablestatus");
            unVisibleKeys.add("unable");
        }
        cardEntry.setChildVisible(false, focusRow, unVisibleKeys.toArray(new String[0]));
        cardEntry.setChildVisible(true, focusRow, visibleKeys.toArray(new String[0]));
        HashSet<String> enableSchemes = new HashSet<String>(1);
        enableSchemes.add(scheme.getString("number"));
        this.enableLog(enableSchemes, enable);
    }

    private void enableLog(Set<String> enableSchemes, boolean enable) {
        if (enable) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ExecuteAnalyseSchemeListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog(null, "enable", new MultiLangEnumBridge("\u542f\u7528", "ExecuteAnalyseSchemeListPlugin_40", "epm-eb-formplugin"), new MultiLangEnumBridge("%1$s\u5df2\u542f\u7528\u3002", "ExecuteAnalyseSchemeListPlugin_44", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", enableSchemes)});
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExecuteAnalyseSchemeListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog(null, "disable", new MultiLangEnumBridge("\u7981\u7528", "ExecuteAnalyseSchemeListPlugin_41", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7981\u7528%1$s\u6210\u529f\u3002", "ExecuteAnalyseSchemeListPlugin_45", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", enableSchemes)});
        }
    }

    private Long getCurSelectedSchemeId() {
        int focusRow = this.getFocusRow();
        Object pkId = this.getModel().getValue("pkid", focusRow);
        return ConvertUtils.toLong((Object)pkId);
    }

    private int getFocusRow() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        return cardEntry.getEntryState().getFocusRow();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!"model".equals(name)) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            this.getModel().setValue("model", e.getChangeSet()[0].getOldValue());
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)((DynamicObject)newValue).getLong("id"));
        this.afterChangeModel();
    }

    private void afterChangeModel() {
        this.getPageCache().remove("curNode");
        this.getPageCache().remove("root");
        this.initTree();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.deleteAllNodes();
        TreeNode root = this.getRootNode(this.getModelId(), this.getView());
        treeView.addNode(root);
        this.expandAll(root, treeView);
        TreeNode focusNode = root;
        String curNodeId = this.getPageCache().get("curNode");
        if (StringUtils.isNotEmpty((String)curNodeId) && (focusNode = root.getTreeNode(curNodeId, 5)) == null) {
            focusNode = root;
        }
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
        this.treeNodeClick(evt);
        treeView.focusNode(focusNode);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        this.getPageCache().remove("searchInfo");
    }

    private void expandAll(TreeNode node, TreeView treeView) {
        List children = node.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        treeView.expand(node.getId());
        children.forEach(e -> this.expandAll((TreeNode)e, treeView));
    }

    private TreeNode getRoot() {
        String rootJson = this.getPageCache().get("root");
        if (StringUtils.isEmpty((String)rootJson)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6839\u8282\u70b9\u4fe1\u606f\u3002", (String)"ExecuteAnalyseSchemeListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)rootJson, TreeNode.class);
    }

    @Override
    public List<Long> getBusModelIdsByMultiDim() {
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        QFilter qFilter = this.getMultiQFilter(null);
        DynamicObjectCollection multiSchemes = QueryServiceHelper.query((String)"eb_diffanalyzescheme", (String)"dataset.id", (QFilter[])new QFilter[]{qFilter});
        if (multiSchemes != null) {
            multiSchemes.forEach(e -> busModelIds.add(e.getLong("dataset.id")));
        }
        return busModelIds;
    }

    @Override
    public List<Long> getBusModelIdsByExecute() {
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        QFilter qFilter = this.getExecQFilter(null);
        DynamicObjectCollection execSchemes = QueryServiceHelper.query((String)"eb_execschemeentity", (String)"bizmodel.id", (QFilter[])new QFilter[]{qFilter});
        if (execSchemes != null) {
            execSchemes.forEach(e -> busModelIds.add(e.getLong("bizmodel.id")));
        }
        return busModelIds;
    }

    @Override
    public Long getModelId() {
        Object modelObj = this.getModel().getValue("model");
        if (modelObj instanceof DynamicObject) {
            return ((DynamicObject)modelObj).getLong("id");
        }
        return 0L;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        int rowIndex = event.getRowIndex();
        this.viewReport(rowIndex);
    }

    private void viewReport(int rowIndex) {
        Object pkId = this.getModel().getValue("pkid", rowIndex);
        Object dataset = this.getModel().getValue("dataset", rowIndex);
        ReportShowParameter formShowParameter = null;
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("schemeId", pkId);
        customMap.put("model", this.getModelId());
        customMap.put("dataset", dataset);
        AnalyseType curSchemeAnalyseType = this.getCurSchemeAnalyseType(rowIndex);
        String tableModel = null;
        String formId = null;
        if (AnalyseType.EXECUTE == curSchemeAnalyseType) {
            formShowParameter = new ReportShowParameter();
            formId = "eb_execanalysereport";
            tableModel = "eb_execschemeentity";
        } else {
            formShowParameter = new FormShowParameter();
            formId = "eb_diffanalysis";
            this.replaceParamKey(customMap);
            tableModel = "eb_diffanalyzescheme";
        }
        formShowParameter.setCustomParams(customMap);
        if (this.checkUnable(pkId, tableModel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u67e5\u770b\u542f\u7528\u65b9\u6848\u4e0b\u7684\u62a5\u8868\u3002", (String)"ExecuteAnalyseSchemeListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam((FormShowParameter)formShowParameter);
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openReport"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private boolean checkUnable(Object pkId, String tableModel) {
        QFilter qFilter = new QFilter("id", "=", (Object)ConvertUtils.toLong((Object)pkId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)tableModel, (String)"status", (QFilter[])new QFilter[]{qFilter});
        return !dynamicObject.getBoolean("status");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("openSchemePage".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData instanceof Long) {
                Long modelId = ConvertUtils.toLong((Object)returnData);
                this.getModel().setValue("model", (Object)modelId);
            } else {
                this.initTree();
            }
        } else if ("share".equals(actionId)) {
            this.shareRecord(event);
        } else if ("openReport".equals(actionId)) {
            this.refreshBillList();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("enjoy".equals(operateKey)) {
            int focusRow = this.getFocusRow();
            String entityKey = this.getSelectEntityKey(focusRow);
            String reportName = (String)this.getModel().getValue("name", focusRow);
            String datasetId = (String)this.getModel().getValue("dataset", focusRow);
            String reportId = (String)this.getModel().getValue("pkid", focusRow);
            String reportType = (String)this.getModel().getValue("analysetype", focusRow);
            if (this.checkUnable(reportId, entityKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u7684\u65b9\u6848\u65e0\u6cd5\u5206\u4eab\u3002", (String)"ExecuteAnalyseSchemeListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> cardMap = new HashMap<String, String>(4);
            cardMap.put("reportName", reportName);
            cardMap.put("datasetId", datasetId);
            cardMap.put("reportId", reportId);
            cardMap.put("reportType", reportType);
            this.getPageCache().put("shareCache", SerializationUtils.toJsonString(cardMap));
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", "!=", (Object)this.getUserId()));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "share"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void shareRecord(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ArrayList<Long> receivers = new ArrayList<Long>(returnData.size());
        for (int i = 0; i < returnData.size(); ++i) {
            ListSelectedRow selectedRow = returnData.get(i);
            Long userId = (Long)selectedRow.getPrimaryKeyValue();
            receivers.add(userId);
        }
        String shareCache = this.getPageCache().get("shareCache");
        Map shareMap = (Map)SerializationUtils.fromJsonString((String)shareCache, HashMap.class);
        Long reportId = Long.valueOf((String)shareMap.get("reportId"));
        String reportType = (String)shareMap.get("reportType");
        Long datasetId = Long.valueOf((String)shareMap.get("datasetId"));
        Map userIdToPairMsgIdShareId = ReportShareHelper.sendMessageToReceivers(receivers, (Long)reportId, (String)reportType, (Long)this.getModelId(), (Long)datasetId, (boolean)this.isNewEbForm());
        if (userIdToPairMsgIdShareId.size() > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u6210\u529f\u3002", (String)"ExecuteAnalyseSchemeListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            String traceId = RequestContext.getOrCreate().getTraceId();
            int curUserDefaultUnit = ExecuteAnalyseUtil.getInstance().getCurUserDefaultUnit(reportId);
            EpmThreadPools.CommPools.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                ReportShareHelper.saveReportShare((Map)userIdToPairMsgIdShareId, (Long)this.getModelId(), (String)shareCache, (String)"", (int)curUserDefaultUnit);
            });
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u4eab", "ExecuteAnalyseReportPlugin_37", "epm-eb-formplugin");
            String reportName = (String)shareMap.get("reportName");
            Set set = userIdToPairMsgIdShareId.keySet();
            String userInfo = JSONUtils.toString(set);
            MultiLangEnumBridge msg = new MultiLangEnumBridge("\u5206\u4eab\u62a5\u8868%1$s\u7ed9\u7528\u6237%2$s\u3002", "ExecuteAnalyseReportPlugin_38", "epm-eb-formplugin");
            this.writeLog(null, "share", opName, msg, new String[]{reportName, userInfo});
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u5931\u8d25\u3002", (String)"ExecuteAnalyseSchemeListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit basedataEdit;
        String name = event.getProperty().getName();
        if (!"model".equals(name)) {
            return;
        }
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        Object source = event.getSource();
        this.addSpecialParam((FormShowParameter)showP);
        if (source instanceof BasedataEdit && !(basedataEdit = (BasedataEdit)source).isF7Click()) {
            Set ids = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            qs.add(new QFilter("id", "in", (Object)ids));
            qs.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
            event.setFormShowParameter((FormShowParameter)showP);
        }
        event.setFormShowParameter((FormShowParameter)showP);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbcx) {
        super.confirmCallBack(mbcx);
        MessageBoxResult result = mbcx.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = mbcx.getCallBackId();
        if ("deleteSchemes".equals(callBackId)) {
            this.deleteScheme();
        }
    }

    public String getBGRPSpecialEntity() {
        return null;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        AdminModelUtil.checkAdminModeBeforeClick(evt, this.getModelId(), this.getView());
    }

    private boolean checkSharePerm(String formId) {
        String appId = this.getBizAppId();
        Long modelId = this.getModelId();
        return FunPermissionHelper.checkPageModelFunPerm((long)this.getUserId(), (long)modelId, (String)appId, (String)formId, (String)"16/IQBV3L=/T", (IFormView)this.getView(), (boolean)true);
    }
}

